/*
 * Decompiled with CFR 0.152.
 */
package io.kubernetes.client.models;

import com.google.gson.annotations.SerializedName;
import io.kubernetes.client.models.V1beta1NetworkPolicyPeer;
import io.kubernetes.client.models.V1beta1NetworkPolicyPort;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;

@ApiModel(description="This NetworkPolicyIngressRule matches traffic if and only if the traffic matches both ports AND from.")
public class V1beta1NetworkPolicyIngressRule {
    @SerializedName(value="from")
    private List<V1beta1NetworkPolicyPeer> from = null;
    @SerializedName(value="ports")
    private List<V1beta1NetworkPolicyPort> ports = null;

    public V1beta1NetworkPolicyIngressRule from(List<V1beta1NetworkPolicyPeer> from) {
        this.from = from;
        return this;
    }

    public V1beta1NetworkPolicyIngressRule addFromItem(V1beta1NetworkPolicyPeer fromItem) {
        if (this.from == null) {
            this.from = new ArrayList<V1beta1NetworkPolicyPeer>();
        }
        this.from.add(fromItem);
        return this;
    }

    @ApiModelProperty(value="List of sources which should be able to access the pods selected for this rule. Items in this list are combined using a logical OR operation. If this field is not provided, this rule matches all sources (traffic not restricted by source). If this field is empty, this rule matches no sources (no traffic matches). If this field is present and contains at least on item, this rule allows traffic only if the traffic matches at least one item in the from list.")
    public List<V1beta1NetworkPolicyPeer> getFrom() {
        return this.from;
    }

    public void setFrom(List<V1beta1NetworkPolicyPeer> from) {
        this.from = from;
    }

    public V1beta1NetworkPolicyIngressRule ports(List<V1beta1NetworkPolicyPort> ports) {
        this.ports = ports;
        return this;
    }

    public V1beta1NetworkPolicyIngressRule addPortsItem(V1beta1NetworkPolicyPort portsItem) {
        if (this.ports == null) {
            this.ports = new ArrayList<V1beta1NetworkPolicyPort>();
        }
        this.ports.add(portsItem);
        return this;
    }

    @ApiModelProperty(value="List of ports which should be made accessible on the pods selected for this rule. Each item in this list is combined using a logical OR. If this field is not provided, this rule matches all ports (traffic not restricted by port). If this field is empty, this rule matches no ports (no traffic matches). If this field is present and contains at least one item, then this rule allows traffic only if the traffic matches at least one port in the list.")
    public List<V1beta1NetworkPolicyPort> getPorts() {
        return this.ports;
    }

    public void setPorts(List<V1beta1NetworkPolicyPort> ports) {
        this.ports = ports;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        V1beta1NetworkPolicyIngressRule v1beta1NetworkPolicyIngressRule = (V1beta1NetworkPolicyIngressRule)o;
        return Objects.equals(this.from, v1beta1NetworkPolicyIngressRule.from) && Objects.equals(this.ports, v1beta1NetworkPolicyIngressRule.ports);
    }

    public int hashCode() {
        return Objects.hash(this.from, this.ports);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class V1beta1NetworkPolicyIngressRule {\n");
        sb.append("    from: ").append(this.toIndentedString(this.from)).append("\n");
        sb.append("    ports: ").append(this.toIndentedString(this.ports)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

