/*
 * Decompiled with CFR 0.152.
 */
package io.kubernetes.client.apis;

import com.google.gson.reflect.TypeToken;
import com.squareup.okhttp.Call;
import com.squareup.okhttp.Interceptor;
import com.squareup.okhttp.Response;
import com.squareup.okhttp.ResponseBody;
import io.kubernetes.client.ApiCallback;
import io.kubernetes.client.ApiClient;
import io.kubernetes.client.ApiException;
import io.kubernetes.client.ApiResponse;
import io.kubernetes.client.Configuration;
import io.kubernetes.client.Pair;
import io.kubernetes.client.ProgressRequestBody;
import io.kubernetes.client.ProgressResponseBody;
import io.kubernetes.client.models.V1APIResourceList;
import io.kubernetes.client.models.V1DeleteOptions;
import io.kubernetes.client.models.V1Status;
import io.kubernetes.client.models.V2alpha1CronJob;
import io.kubernetes.client.models.V2alpha1CronJobList;
import java.io.IOException;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.HashMap;

public class BatchV2alpha1Api {
    private ApiClient apiClient;

    public BatchV2alpha1Api() {
        this(Configuration.getDefaultApiClient());
    }

    public BatchV2alpha1Api(ApiClient apiClient) {
        this.apiClient = apiClient;
    }

    public ApiClient getApiClient() {
        return this.apiClient;
    }

    public void setApiClient(ApiClient apiClient) {
        this.apiClient = apiClient;
    }

    public Call createNamespacedCronJobCall(String namespace, V2alpha1CronJob body, String pretty, final ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        V2alpha1CronJob localVarPostBody = body;
        String localVarPath = "/apis/batch/v2alpha1/namespaces/{namespace}/cronjobs".replaceAll("\\{namespace\\}", this.apiClient.escapeString(namespace.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        if (pretty != null) {
            localVarQueryParams.addAll(this.apiClient.parameterToPair("pretty", pretty));
        }
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json", "application/yaml", "application/vnd.kubernetes.protobuf"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{"*/*"};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        if (progressListener != null) {
            this.apiClient.getHttpClient().networkInterceptors().add(new Interceptor(){

                public Response intercept(Interceptor.Chain chain) throws IOException {
                    Response originalResponse = chain.proceed(chain.request());
                    return originalResponse.newBuilder().body((ResponseBody)new ProgressResponseBody(originalResponse.body(), progressListener)).build();
                }
            });
        }
        String[] localVarAuthNames = new String[]{"BearerToken"};
        return this.apiClient.buildCall(localVarPath, "POST", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAuthNames, progressRequestListener);
    }

    private Call createNamespacedCronJobValidateBeforeCall(String namespace, V2alpha1CronJob body, String pretty, ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        if (namespace == null) {
            throw new ApiException("Missing the required parameter 'namespace' when calling createNamespacedCronJob(Async)");
        }
        if (body == null) {
            throw new ApiException("Missing the required parameter 'body' when calling createNamespacedCronJob(Async)");
        }
        Call call = this.createNamespacedCronJobCall(namespace, body, pretty, progressListener, progressRequestListener);
        return call;
    }

    public V2alpha1CronJob createNamespacedCronJob(String namespace, V2alpha1CronJob body, String pretty) throws ApiException {
        ApiResponse<V2alpha1CronJob> resp = this.createNamespacedCronJobWithHttpInfo(namespace, body, pretty);
        return resp.getData();
    }

    public ApiResponse<V2alpha1CronJob> createNamespacedCronJobWithHttpInfo(String namespace, V2alpha1CronJob body, String pretty) throws ApiException {
        Call call = this.createNamespacedCronJobValidateBeforeCall(namespace, body, pretty, null, null);
        Type localVarReturnType = new TypeToken<V2alpha1CronJob>(){}.getType();
        return this.apiClient.execute(call, localVarReturnType);
    }

    public Call createNamespacedCronJobAsync(String namespace, V2alpha1CronJob body, String pretty, final ApiCallback<V2alpha1CronJob> callback) throws ApiException {
        ProgressResponseBody.ProgressListener progressListener = null;
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;
        if (callback != null) {
            progressListener = new ProgressResponseBody.ProgressListener(){

                @Override
                public void update(long bytesRead, long contentLength, boolean done) {
                    callback.onDownloadProgress(bytesRead, contentLength, done);
                }
            };
            progressRequestListener = new ProgressRequestBody.ProgressRequestListener(){

                @Override
                public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                    callback.onUploadProgress(bytesWritten, contentLength, done);
                }
            };
        }
        Call call = this.createNamespacedCronJobValidateBeforeCall(namespace, body, pretty, progressListener, progressRequestListener);
        Type localVarReturnType = new TypeToken<V2alpha1CronJob>(){}.getType();
        this.apiClient.executeAsync(call, localVarReturnType, callback);
        return call;
    }

    public Call createNamespacedScheduledJobCall(String namespace, V2alpha1CronJob body, String pretty, final ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        V2alpha1CronJob localVarPostBody = body;
        String localVarPath = "/apis/batch/v2alpha1/namespaces/{namespace}/scheduledjobs".replaceAll("\\{namespace\\}", this.apiClient.escapeString(namespace.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        if (pretty != null) {
            localVarQueryParams.addAll(this.apiClient.parameterToPair("pretty", pretty));
        }
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json", "application/yaml", "application/vnd.kubernetes.protobuf"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{"*/*"};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        if (progressListener != null) {
            this.apiClient.getHttpClient().networkInterceptors().add(new Interceptor(){

                public Response intercept(Interceptor.Chain chain) throws IOException {
                    Response originalResponse = chain.proceed(chain.request());
                    return originalResponse.newBuilder().body((ResponseBody)new ProgressResponseBody(originalResponse.body(), progressListener)).build();
                }
            });
        }
        String[] localVarAuthNames = new String[]{"BearerToken"};
        return this.apiClient.buildCall(localVarPath, "POST", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAuthNames, progressRequestListener);
    }

    private Call createNamespacedScheduledJobValidateBeforeCall(String namespace, V2alpha1CronJob body, String pretty, ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        if (namespace == null) {
            throw new ApiException("Missing the required parameter 'namespace' when calling createNamespacedScheduledJob(Async)");
        }
        if (body == null) {
            throw new ApiException("Missing the required parameter 'body' when calling createNamespacedScheduledJob(Async)");
        }
        Call call = this.createNamespacedScheduledJobCall(namespace, body, pretty, progressListener, progressRequestListener);
        return call;
    }

    public V2alpha1CronJob createNamespacedScheduledJob(String namespace, V2alpha1CronJob body, String pretty) throws ApiException {
        ApiResponse<V2alpha1CronJob> resp = this.createNamespacedScheduledJobWithHttpInfo(namespace, body, pretty);
        return resp.getData();
    }

    public ApiResponse<V2alpha1CronJob> createNamespacedScheduledJobWithHttpInfo(String namespace, V2alpha1CronJob body, String pretty) throws ApiException {
        Call call = this.createNamespacedScheduledJobValidateBeforeCall(namespace, body, pretty, null, null);
        Type localVarReturnType = new TypeToken<V2alpha1CronJob>(){}.getType();
        return this.apiClient.execute(call, localVarReturnType);
    }

    public Call createNamespacedScheduledJobAsync(String namespace, V2alpha1CronJob body, String pretty, final ApiCallback<V2alpha1CronJob> callback) throws ApiException {
        ProgressResponseBody.ProgressListener progressListener = null;
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;
        if (callback != null) {
            progressListener = new ProgressResponseBody.ProgressListener(){

                @Override
                public void update(long bytesRead, long contentLength, boolean done) {
                    callback.onDownloadProgress(bytesRead, contentLength, done);
                }
            };
            progressRequestListener = new ProgressRequestBody.ProgressRequestListener(){

                @Override
                public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                    callback.onUploadProgress(bytesWritten, contentLength, done);
                }
            };
        }
        Call call = this.createNamespacedScheduledJobValidateBeforeCall(namespace, body, pretty, progressListener, progressRequestListener);
        Type localVarReturnType = new TypeToken<V2alpha1CronJob>(){}.getType();
        this.apiClient.executeAsync(call, localVarReturnType, callback);
        return call;
    }

    public Call deleteCollectionNamespacedCronJobCall(String namespace, String pretty, String fieldSelector, String labelSelector, String resourceVersion, Integer timeoutSeconds, Boolean watch, final ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        Object localVarPostBody = null;
        String localVarPath = "/apis/batch/v2alpha1/namespaces/{namespace}/cronjobs".replaceAll("\\{namespace\\}", this.apiClient.escapeString(namespace.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        if (pretty != null) {
            localVarQueryParams.addAll(this.apiClient.parameterToPair("pretty", pretty));
        }
        if (fieldSelector != null) {
            localVarQueryParams.addAll(this.apiClient.parameterToPair("fieldSelector", fieldSelector));
        }
        if (labelSelector != null) {
            localVarQueryParams.addAll(this.apiClient.parameterToPair("labelSelector", labelSelector));
        }
        if (resourceVersion != null) {
            localVarQueryParams.addAll(this.apiClient.parameterToPair("resourceVersion", resourceVersion));
        }
        if (timeoutSeconds != null) {
            localVarQueryParams.addAll(this.apiClient.parameterToPair("timeoutSeconds", timeoutSeconds));
        }
        if (watch != null) {
            localVarQueryParams.addAll(this.apiClient.parameterToPair("watch", watch));
        }
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json", "application/yaml", "application/vnd.kubernetes.protobuf"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{"*/*"};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        if (progressListener != null) {
            this.apiClient.getHttpClient().networkInterceptors().add(new Interceptor(){

                public Response intercept(Interceptor.Chain chain) throws IOException {
                    Response originalResponse = chain.proceed(chain.request());
                    return originalResponse.newBuilder().body((ResponseBody)new ProgressResponseBody(originalResponse.body(), progressListener)).build();
                }
            });
        }
        String[] localVarAuthNames = new String[]{"BearerToken"};
        return this.apiClient.buildCall(localVarPath, "DELETE", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAuthNames, progressRequestListener);
    }

    private Call deleteCollectionNamespacedCronJobValidateBeforeCall(String namespace, String pretty, String fieldSelector, String labelSelector, String resourceVersion, Integer timeoutSeconds, Boolean watch, ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        if (namespace == null) {
            throw new ApiException("Missing the required parameter 'namespace' when calling deleteCollectionNamespacedCronJob(Async)");
        }
        Call call = this.deleteCollectionNamespacedCronJobCall(namespace, pretty, fieldSelector, labelSelector, resourceVersion, timeoutSeconds, watch, progressListener, progressRequestListener);
        return call;
    }

    public V1Status deleteCollectionNamespacedCronJob(String namespace, String pretty, String fieldSelector, String labelSelector, String resourceVersion, Integer timeoutSeconds, Boolean watch) throws ApiException {
        ApiResponse<V1Status> resp = this.deleteCollectionNamespacedCronJobWithHttpInfo(namespace, pretty, fieldSelector, labelSelector, resourceVersion, timeoutSeconds, watch);
        return resp.getData();
    }

    public ApiResponse<V1Status> deleteCollectionNamespacedCronJobWithHttpInfo(String namespace, String pretty, String fieldSelector, String labelSelector, String resourceVersion, Integer timeoutSeconds, Boolean watch) throws ApiException {
        Call call = this.deleteCollectionNamespacedCronJobValidateBeforeCall(namespace, pretty, fieldSelector, labelSelector, resourceVersion, timeoutSeconds, watch, null, null);
        Type localVarReturnType = new TypeToken<V1Status>(){}.getType();
        return this.apiClient.execute(call, localVarReturnType);
    }

    public Call deleteCollectionNamespacedCronJobAsync(String namespace, String pretty, String fieldSelector, String labelSelector, String resourceVersion, Integer timeoutSeconds, Boolean watch, final ApiCallback<V1Status> callback) throws ApiException {
        ProgressResponseBody.ProgressListener progressListener = null;
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;
        if (callback != null) {
            progressListener = new ProgressResponseBody.ProgressListener(){

                @Override
                public void update(long bytesRead, long contentLength, boolean done) {
                    callback.onDownloadProgress(bytesRead, contentLength, done);
                }
            };
            progressRequestListener = new ProgressRequestBody.ProgressRequestListener(){

                @Override
                public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                    callback.onUploadProgress(bytesWritten, contentLength, done);
                }
            };
        }
        Call call = this.deleteCollectionNamespacedCronJobValidateBeforeCall(namespace, pretty, fieldSelector, labelSelector, resourceVersion, timeoutSeconds, watch, progressListener, progressRequestListener);
        Type localVarReturnType = new TypeToken<V1Status>(){}.getType();
        this.apiClient.executeAsync(call, localVarReturnType, callback);
        return call;
    }

    public Call deleteCollectionNamespacedScheduledJobCall(String namespace, String pretty, String fieldSelector, String labelSelector, String resourceVersion, Integer timeoutSeconds, Boolean watch, final ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        Object localVarPostBody = null;
        String localVarPath = "/apis/batch/v2alpha1/namespaces/{namespace}/scheduledjobs".replaceAll("\\{namespace\\}", this.apiClient.escapeString(namespace.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        if (pretty != null) {
            localVarQueryParams.addAll(this.apiClient.parameterToPair("pretty", pretty));
        }
        if (fieldSelector != null) {
            localVarQueryParams.addAll(this.apiClient.parameterToPair("fieldSelector", fieldSelector));
        }
        if (labelSelector != null) {
            localVarQueryParams.addAll(this.apiClient.parameterToPair("labelSelector", labelSelector));
        }
        if (resourceVersion != null) {
            localVarQueryParams.addAll(this.apiClient.parameterToPair("resourceVersion", resourceVersion));
        }
        if (timeoutSeconds != null) {
            localVarQueryParams.addAll(this.apiClient.parameterToPair("timeoutSeconds", timeoutSeconds));
        }
        if (watch != null) {
            localVarQueryParams.addAll(this.apiClient.parameterToPair("watch", watch));
        }
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json", "application/yaml", "application/vnd.kubernetes.protobuf"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{"*/*"};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        if (progressListener != null) {
            this.apiClient.getHttpClient().networkInterceptors().add(new Interceptor(){

                public Response intercept(Interceptor.Chain chain) throws IOException {
                    Response originalResponse = chain.proceed(chain.request());
                    return originalResponse.newBuilder().body((ResponseBody)new ProgressResponseBody(originalResponse.body(), progressListener)).build();
                }
            });
        }
        String[] localVarAuthNames = new String[]{"BearerToken"};
        return this.apiClient.buildCall(localVarPath, "DELETE", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAuthNames, progressRequestListener);
    }

    private Call deleteCollectionNamespacedScheduledJobValidateBeforeCall(String namespace, String pretty, String fieldSelector, String labelSelector, String resourceVersion, Integer timeoutSeconds, Boolean watch, ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        if (namespace == null) {
            throw new ApiException("Missing the required parameter 'namespace' when calling deleteCollectionNamespacedScheduledJob(Async)");
        }
        Call call = this.deleteCollectionNamespacedScheduledJobCall(namespace, pretty, fieldSelector, labelSelector, resourceVersion, timeoutSeconds, watch, progressListener, progressRequestListener);
        return call;
    }

    public V1Status deleteCollectionNamespacedScheduledJob(String namespace, String pretty, String fieldSelector, String labelSelector, String resourceVersion, Integer timeoutSeconds, Boolean watch) throws ApiException {
        ApiResponse<V1Status> resp = this.deleteCollectionNamespacedScheduledJobWithHttpInfo(namespace, pretty, fieldSelector, labelSelector, resourceVersion, timeoutSeconds, watch);
        return resp.getData();
    }

    public ApiResponse<V1Status> deleteCollectionNamespacedScheduledJobWithHttpInfo(String namespace, String pretty, String fieldSelector, String labelSelector, String resourceVersion, Integer timeoutSeconds, Boolean watch) throws ApiException {
        Call call = this.deleteCollectionNamespacedScheduledJobValidateBeforeCall(namespace, pretty, fieldSelector, labelSelector, resourceVersion, timeoutSeconds, watch, null, null);
        Type localVarReturnType = new TypeToken<V1Status>(){}.getType();
        return this.apiClient.execute(call, localVarReturnType);
    }

    public Call deleteCollectionNamespacedScheduledJobAsync(String namespace, String pretty, String fieldSelector, String labelSelector, String resourceVersion, Integer timeoutSeconds, Boolean watch, final ApiCallback<V1Status> callback) throws ApiException {
        ProgressResponseBody.ProgressListener progressListener = null;
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;
        if (callback != null) {
            progressListener = new ProgressResponseBody.ProgressListener(){

                @Override
                public void update(long bytesRead, long contentLength, boolean done) {
                    callback.onDownloadProgress(bytesRead, contentLength, done);
                }
            };
            progressRequestListener = new ProgressRequestBody.ProgressRequestListener(){

                @Override
                public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                    callback.onUploadProgress(bytesWritten, contentLength, done);
                }
            };
        }
        Call call = this.deleteCollectionNamespacedScheduledJobValidateBeforeCall(namespace, pretty, fieldSelector, labelSelector, resourceVersion, timeoutSeconds, watch, progressListener, progressRequestListener);
        Type localVarReturnType = new TypeToken<V1Status>(){}.getType();
        this.apiClient.executeAsync(call, localVarReturnType, callback);
        return call;
    }

    public Call deleteNamespacedCronJobCall(String name, String namespace, V1DeleteOptions body, String pretty, Integer gracePeriodSeconds, Boolean orphanDependents, String propagationPolicy, final ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        V1DeleteOptions localVarPostBody = body;
        String localVarPath = "/apis/batch/v2alpha1/namespaces/{namespace}/cronjobs/{name}".replaceAll("\\{name\\}", this.apiClient.escapeString(name.toString())).replaceAll("\\{namespace\\}", this.apiClient.escapeString(namespace.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        if (pretty != null) {
            localVarQueryParams.addAll(this.apiClient.parameterToPair("pretty", pretty));
        }
        if (gracePeriodSeconds != null) {
            localVarQueryParams.addAll(this.apiClient.parameterToPair("gracePeriodSeconds", gracePeriodSeconds));
        }
        if (orphanDependents != null) {
            localVarQueryParams.addAll(this.apiClient.parameterToPair("orphanDependents", orphanDependents));
        }
        if (propagationPolicy != null) {
            localVarQueryParams.addAll(this.apiClient.parameterToPair("propagationPolicy", propagationPolicy));
        }
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json", "application/yaml", "application/vnd.kubernetes.protobuf"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{"*/*"};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        if (progressListener != null) {
            this.apiClient.getHttpClient().networkInterceptors().add(new Interceptor(){

                public Response intercept(Interceptor.Chain chain) throws IOException {
                    Response originalResponse = chain.proceed(chain.request());
                    return originalResponse.newBuilder().body((ResponseBody)new ProgressResponseBody(originalResponse.body(), progressListener)).build();
                }
            });
        }
        String[] localVarAuthNames = new String[]{"BearerToken"};
        return this.apiClient.buildCall(localVarPath, "DELETE", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAuthNames, progressRequestListener);
    }

    private Call deleteNamespacedCronJobValidateBeforeCall(String name, String namespace, V1DeleteOptions body, String pretty, Integer gracePeriodSeconds, Boolean orphanDependents, String propagationPolicy, ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        if (name == null) {
            throw new ApiException("Missing the required parameter 'name' when calling deleteNamespacedCronJob(Async)");
        }
        if (namespace == null) {
            throw new ApiException("Missing the required parameter 'namespace' when calling deleteNamespacedCronJob(Async)");
        }
        if (body == null) {
            throw new ApiException("Missing the required parameter 'body' when calling deleteNamespacedCronJob(Async)");
        }
        Call call = this.deleteNamespacedCronJobCall(name, namespace, body, pretty, gracePeriodSeconds, orphanDependents, propagationPolicy, progressListener, progressRequestListener);
        return call;
    }

    public V1Status deleteNamespacedCronJob(String name, String namespace, V1DeleteOptions body, String pretty, Integer gracePeriodSeconds, Boolean orphanDependents, String propagationPolicy) throws ApiException {
        ApiResponse<V1Status> resp = this.deleteNamespacedCronJobWithHttpInfo(name, namespace, body, pretty, gracePeriodSeconds, orphanDependents, propagationPolicy);
        return resp.getData();
    }

    public ApiResponse<V1Status> deleteNamespacedCronJobWithHttpInfo(String name, String namespace, V1DeleteOptions body, String pretty, Integer gracePeriodSeconds, Boolean orphanDependents, String propagationPolicy) throws ApiException {
        Call call = this.deleteNamespacedCronJobValidateBeforeCall(name, namespace, body, pretty, gracePeriodSeconds, orphanDependents, propagationPolicy, null, null);
        Type localVarReturnType = new TypeToken<V1Status>(){}.getType();
        return this.apiClient.execute(call, localVarReturnType);
    }

    public Call deleteNamespacedCronJobAsync(String name, String namespace, V1DeleteOptions body, String pretty, Integer gracePeriodSeconds, Boolean orphanDependents, String propagationPolicy, final ApiCallback<V1Status> callback) throws ApiException {
        ProgressResponseBody.ProgressListener progressListener = null;
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;
        if (callback != null) {
            progressListener = new ProgressResponseBody.ProgressListener(){

                @Override
                public void update(long bytesRead, long contentLength, boolean done) {
                    callback.onDownloadProgress(bytesRead, contentLength, done);
                }
            };
            progressRequestListener = new ProgressRequestBody.ProgressRequestListener(){

                @Override
                public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                    callback.onUploadProgress(bytesWritten, contentLength, done);
                }
            };
        }
        Call call = this.deleteNamespacedCronJobValidateBeforeCall(name, namespace, body, pretty, gracePeriodSeconds, orphanDependents, propagationPolicy, progressListener, progressRequestListener);
        Type localVarReturnType = new TypeToken<V1Status>(){}.getType();
        this.apiClient.executeAsync(call, localVarReturnType, callback);
        return call;
    }

    public Call deleteNamespacedScheduledJobCall(String name, String namespace, V1DeleteOptions body, String pretty, Integer gracePeriodSeconds, Boolean orphanDependents, String propagationPolicy, final ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        V1DeleteOptions localVarPostBody = body;
        String localVarPath = "/apis/batch/v2alpha1/namespaces/{namespace}/scheduledjobs/{name}".replaceAll("\\{name\\}", this.apiClient.escapeString(name.toString())).replaceAll("\\{namespace\\}", this.apiClient.escapeString(namespace.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        if (pretty != null) {
            localVarQueryParams.addAll(this.apiClient.parameterToPair("pretty", pretty));
        }
        if (gracePeriodSeconds != null) {
            localVarQueryParams.addAll(this.apiClient.parameterToPair("gracePeriodSeconds", gracePeriodSeconds));
        }
        if (orphanDependents != null) {
            localVarQueryParams.addAll(this.apiClient.parameterToPair("orphanDependents", orphanDependents));
        }
        if (propagationPolicy != null) {
            localVarQueryParams.addAll(this.apiClient.parameterToPair("propagationPolicy", propagationPolicy));
        }
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json", "application/yaml", "application/vnd.kubernetes.protobuf"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{"*/*"};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        if (progressListener != null) {
            this.apiClient.getHttpClient().networkInterceptors().add(new Interceptor(){

                public Response intercept(Interceptor.Chain chain) throws IOException {
                    Response originalResponse = chain.proceed(chain.request());
                    return originalResponse.newBuilder().body((ResponseBody)new ProgressResponseBody(originalResponse.body(), progressListener)).build();
                }
            });
        }
        String[] localVarAuthNames = new String[]{"BearerToken"};
        return this.apiClient.buildCall(localVarPath, "DELETE", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAuthNames, progressRequestListener);
    }

    private Call deleteNamespacedScheduledJobValidateBeforeCall(String name, String namespace, V1DeleteOptions body, String pretty, Integer gracePeriodSeconds, Boolean orphanDependents, String propagationPolicy, ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        if (name == null) {
            throw new ApiException("Missing the required parameter 'name' when calling deleteNamespacedScheduledJob(Async)");
        }
        if (namespace == null) {
            throw new ApiException("Missing the required parameter 'namespace' when calling deleteNamespacedScheduledJob(Async)");
        }
        if (body == null) {
            throw new ApiException("Missing the required parameter 'body' when calling deleteNamespacedScheduledJob(Async)");
        }
        Call call = this.deleteNamespacedScheduledJobCall(name, namespace, body, pretty, gracePeriodSeconds, orphanDependents, propagationPolicy, progressListener, progressRequestListener);
        return call;
    }

    public V1Status deleteNamespacedScheduledJob(String name, String namespace, V1DeleteOptions body, String pretty, Integer gracePeriodSeconds, Boolean orphanDependents, String propagationPolicy) throws ApiException {
        ApiResponse<V1Status> resp = this.deleteNamespacedScheduledJobWithHttpInfo(name, namespace, body, pretty, gracePeriodSeconds, orphanDependents, propagationPolicy);
        return resp.getData();
    }

    public ApiResponse<V1Status> deleteNamespacedScheduledJobWithHttpInfo(String name, String namespace, V1DeleteOptions body, String pretty, Integer gracePeriodSeconds, Boolean orphanDependents, String propagationPolicy) throws ApiException {
        Call call = this.deleteNamespacedScheduledJobValidateBeforeCall(name, namespace, body, pretty, gracePeriodSeconds, orphanDependents, propagationPolicy, null, null);
        Type localVarReturnType = new TypeToken<V1Status>(){}.getType();
        return this.apiClient.execute(call, localVarReturnType);
    }

    public Call deleteNamespacedScheduledJobAsync(String name, String namespace, V1DeleteOptions body, String pretty, Integer gracePeriodSeconds, Boolean orphanDependents, String propagationPolicy, final ApiCallback<V1Status> callback) throws ApiException {
        ProgressResponseBody.ProgressListener progressListener = null;
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;
        if (callback != null) {
            progressListener = new ProgressResponseBody.ProgressListener(){

                @Override
                public void update(long bytesRead, long contentLength, boolean done) {
                    callback.onDownloadProgress(bytesRead, contentLength, done);
                }
            };
            progressRequestListener = new ProgressRequestBody.ProgressRequestListener(){

                @Override
                public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                    callback.onUploadProgress(bytesWritten, contentLength, done);
                }
            };
        }
        Call call = this.deleteNamespacedScheduledJobValidateBeforeCall(name, namespace, body, pretty, gracePeriodSeconds, orphanDependents, propagationPolicy, progressListener, progressRequestListener);
        Type localVarReturnType = new TypeToken<V1Status>(){}.getType();
        this.apiClient.executeAsync(call, localVarReturnType, callback);
        return call;
    }

    public Call getAPIResourcesCall(final ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        Object localVarPostBody = null;
        String localVarPath = "/apis/batch/v2alpha1/";
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json", "application/yaml", "application/vnd.kubernetes.protobuf"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{"application/json", "application/yaml", "application/vnd.kubernetes.protobuf"};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        if (progressListener != null) {
            this.apiClient.getHttpClient().networkInterceptors().add(new Interceptor(){

                public Response intercept(Interceptor.Chain chain) throws IOException {
                    Response originalResponse = chain.proceed(chain.request());
                    return originalResponse.newBuilder().body((ResponseBody)new ProgressResponseBody(originalResponse.body(), progressListener)).build();
                }
            });
        }
        String[] localVarAuthNames = new String[]{"BearerToken"};
        return this.apiClient.buildCall(localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAuthNames, progressRequestListener);
    }

    private Call getAPIResourcesValidateBeforeCall(ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        Call call = this.getAPIResourcesCall(progressListener, progressRequestListener);
        return call;
    }

    public V1APIResourceList getAPIResources() throws ApiException {
        ApiResponse<V1APIResourceList> resp = this.getAPIResourcesWithHttpInfo();
        return resp.getData();
    }

    public ApiResponse<V1APIResourceList> getAPIResourcesWithHttpInfo() throws ApiException {
        Call call = this.getAPIResourcesValidateBeforeCall(null, null);
        Type localVarReturnType = new TypeToken<V1APIResourceList>(){}.getType();
        return this.apiClient.execute(call, localVarReturnType);
    }

    public Call getAPIResourcesAsync(final ApiCallback<V1APIResourceList> callback) throws ApiException {
        ProgressResponseBody.ProgressListener progressListener = null;
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;
        if (callback != null) {
            progressListener = new ProgressResponseBody.ProgressListener(){

                @Override
                public void update(long bytesRead, long contentLength, boolean done) {
                    callback.onDownloadProgress(bytesRead, contentLength, done);
                }
            };
            progressRequestListener = new ProgressRequestBody.ProgressRequestListener(){

                @Override
                public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                    callback.onUploadProgress(bytesWritten, contentLength, done);
                }
            };
        }
        Call call = this.getAPIResourcesValidateBeforeCall(progressListener, progressRequestListener);
        Type localVarReturnType = new TypeToken<V1APIResourceList>(){}.getType();
        this.apiClient.executeAsync(call, localVarReturnType, callback);
        return call;
    }

    public Call listCronJobForAllNamespacesCall(String fieldSelector, String labelSelector, String pretty, String resourceVersion, Integer timeoutSeconds, Boolean watch, final ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        Object localVarPostBody = null;
        String localVarPath = "/apis/batch/v2alpha1/cronjobs";
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        if (fieldSelector != null) {
            localVarQueryParams.addAll(this.apiClient.parameterToPair("fieldSelector", fieldSelector));
        }
        if (labelSelector != null) {
            localVarQueryParams.addAll(this.apiClient.parameterToPair("labelSelector", labelSelector));
        }
        if (pretty != null) {
            localVarQueryParams.addAll(this.apiClient.parameterToPair("pretty", pretty));
        }
        if (resourceVersion != null) {
            localVarQueryParams.addAll(this.apiClient.parameterToPair("resourceVersion", resourceVersion));
        }
        if (timeoutSeconds != null) {
            localVarQueryParams.addAll(this.apiClient.parameterToPair("timeoutSeconds", timeoutSeconds));
        }
        if (watch != null) {
            localVarQueryParams.addAll(this.apiClient.parameterToPair("watch", watch));
        }
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json", "application/yaml", "application/vnd.kubernetes.protobuf", "application/json;stream=watch", "application/vnd.kubernetes.protobuf;stream=watch"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{"*/*"};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        if (progressListener != null) {
            this.apiClient.getHttpClient().networkInterceptors().add(new Interceptor(){

                public Response intercept(Interceptor.Chain chain) throws IOException {
                    Response originalResponse = chain.proceed(chain.request());
                    return originalResponse.newBuilder().body((ResponseBody)new ProgressResponseBody(originalResponse.body(), progressListener)).build();
                }
            });
        }
        String[] localVarAuthNames = new String[]{"BearerToken"};
        return this.apiClient.buildCall(localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAuthNames, progressRequestListener);
    }

    private Call listCronJobForAllNamespacesValidateBeforeCall(String fieldSelector, String labelSelector, String pretty, String resourceVersion, Integer timeoutSeconds, Boolean watch, ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        Call call = this.listCronJobForAllNamespacesCall(fieldSelector, labelSelector, pretty, resourceVersion, timeoutSeconds, watch, progressListener, progressRequestListener);
        return call;
    }

    public V2alpha1CronJobList listCronJobForAllNamespaces(String fieldSelector, String labelSelector, String pretty, String resourceVersion, Integer timeoutSeconds, Boolean watch) throws ApiException {
        ApiResponse<V2alpha1CronJobList> resp = this.listCronJobForAllNamespacesWithHttpInfo(fieldSelector, labelSelector, pretty, resourceVersion, timeoutSeconds, watch);
        return resp.getData();
    }

    public ApiResponse<V2alpha1CronJobList> listCronJobForAllNamespacesWithHttpInfo(String fieldSelector, String labelSelector, String pretty, String resourceVersion, Integer timeoutSeconds, Boolean watch) throws ApiException {
        Call call = this.listCronJobForAllNamespacesValidateBeforeCall(fieldSelector, labelSelector, pretty, resourceVersion, timeoutSeconds, watch, null, null);
        Type localVarReturnType = new TypeToken<V2alpha1CronJobList>(){}.getType();
        return this.apiClient.execute(call, localVarReturnType);
    }

    public Call listCronJobForAllNamespacesAsync(String fieldSelector, String labelSelector, String pretty, String resourceVersion, Integer timeoutSeconds, Boolean watch, final ApiCallback<V2alpha1CronJobList> callback) throws ApiException {
        ProgressResponseBody.ProgressListener progressListener = null;
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;
        if (callback != null) {
            progressListener = new ProgressResponseBody.ProgressListener(){

                @Override
                public void update(long bytesRead, long contentLength, boolean done) {
                    callback.onDownloadProgress(bytesRead, contentLength, done);
                }
            };
            progressRequestListener = new ProgressRequestBody.ProgressRequestListener(){

                @Override
                public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                    callback.onUploadProgress(bytesWritten, contentLength, done);
                }
            };
        }
        Call call = this.listCronJobForAllNamespacesValidateBeforeCall(fieldSelector, labelSelector, pretty, resourceVersion, timeoutSeconds, watch, progressListener, progressRequestListener);
        Type localVarReturnType = new TypeToken<V2alpha1CronJobList>(){}.getType();
        this.apiClient.executeAsync(call, localVarReturnType, callback);
        return call;
    }

    public Call listNamespacedCronJobCall(String namespace, String pretty, String fieldSelector, String labelSelector, String resourceVersion, Integer timeoutSeconds, Boolean watch, final ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        Object localVarPostBody = null;
        String localVarPath = "/apis/batch/v2alpha1/namespaces/{namespace}/cronjobs".replaceAll("\\{namespace\\}", this.apiClient.escapeString(namespace.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        if (pretty != null) {
            localVarQueryParams.addAll(this.apiClient.parameterToPair("pretty", pretty));
        }
        if (fieldSelector != null) {
            localVarQueryParams.addAll(this.apiClient.parameterToPair("fieldSelector", fieldSelector));
        }
        if (labelSelector != null) {
            localVarQueryParams.addAll(this.apiClient.parameterToPair("labelSelector", labelSelector));
        }
        if (resourceVersion != null) {
            localVarQueryParams.addAll(this.apiClient.parameterToPair("resourceVersion", resourceVersion));
        }
        if (timeoutSeconds != null) {
            localVarQueryParams.addAll(this.apiClient.parameterToPair("timeoutSeconds", timeoutSeconds));
        }
        if (watch != null) {
            localVarQueryParams.addAll(this.apiClient.parameterToPair("watch", watch));
        }
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json", "application/yaml", "application/vnd.kubernetes.protobuf", "application/json;stream=watch", "application/vnd.kubernetes.protobuf;stream=watch"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{"*/*"};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        if (progressListener != null) {
            this.apiClient.getHttpClient().networkInterceptors().add(new Interceptor(){

                public Response intercept(Interceptor.Chain chain) throws IOException {
                    Response originalResponse = chain.proceed(chain.request());
                    return originalResponse.newBuilder().body((ResponseBody)new ProgressResponseBody(originalResponse.body(), progressListener)).build();
                }
            });
        }
        String[] localVarAuthNames = new String[]{"BearerToken"};
        return this.apiClient.buildCall(localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAuthNames, progressRequestListener);
    }

    private Call listNamespacedCronJobValidateBeforeCall(String namespace, String pretty, String fieldSelector, String labelSelector, String resourceVersion, Integer timeoutSeconds, Boolean watch, ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        if (namespace == null) {
            throw new ApiException("Missing the required parameter 'namespace' when calling listNamespacedCronJob(Async)");
        }
        Call call = this.listNamespacedCronJobCall(namespace, pretty, fieldSelector, labelSelector, resourceVersion, timeoutSeconds, watch, progressListener, progressRequestListener);
        return call;
    }

    public V2alpha1CronJobList listNamespacedCronJob(String namespace, String pretty, String fieldSelector, String labelSelector, String resourceVersion, Integer timeoutSeconds, Boolean watch) throws ApiException {
        ApiResponse<V2alpha1CronJobList> resp = this.listNamespacedCronJobWithHttpInfo(namespace, pretty, fieldSelector, labelSelector, resourceVersion, timeoutSeconds, watch);
        return resp.getData();
    }

    public ApiResponse<V2alpha1CronJobList> listNamespacedCronJobWithHttpInfo(String namespace, String pretty, String fieldSelector, String labelSelector, String resourceVersion, Integer timeoutSeconds, Boolean watch) throws ApiException {
        Call call = this.listNamespacedCronJobValidateBeforeCall(namespace, pretty, fieldSelector, labelSelector, resourceVersion, timeoutSeconds, watch, null, null);
        Type localVarReturnType = new TypeToken<V2alpha1CronJobList>(){}.getType();
        return this.apiClient.execute(call, localVarReturnType);
    }

    public Call listNamespacedCronJobAsync(String namespace, String pretty, String fieldSelector, String labelSelector, String resourceVersion, Integer timeoutSeconds, Boolean watch, final ApiCallback<V2alpha1CronJobList> callback) throws ApiException {
        ProgressResponseBody.ProgressListener progressListener = null;
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;
        if (callback != null) {
            progressListener = new ProgressResponseBody.ProgressListener(){

                @Override
                public void update(long bytesRead, long contentLength, boolean done) {
                    callback.onDownloadProgress(bytesRead, contentLength, done);
                }
            };
            progressRequestListener = new ProgressRequestBody.ProgressRequestListener(){

                @Override
                public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                    callback.onUploadProgress(bytesWritten, contentLength, done);
                }
            };
        }
        Call call = this.listNamespacedCronJobValidateBeforeCall(namespace, pretty, fieldSelector, labelSelector, resourceVersion, timeoutSeconds, watch, progressListener, progressRequestListener);
        Type localVarReturnType = new TypeToken<V2alpha1CronJobList>(){}.getType();
        this.apiClient.executeAsync(call, localVarReturnType, callback);
        return call;
    }

    public Call listNamespacedScheduledJobCall(String namespace, String pretty, String fieldSelector, String labelSelector, String resourceVersion, Integer timeoutSeconds, Boolean watch, final ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        Object localVarPostBody = null;
        String localVarPath = "/apis/batch/v2alpha1/namespaces/{namespace}/scheduledjobs".replaceAll("\\{namespace\\}", this.apiClient.escapeString(namespace.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        if (pretty != null) {
            localVarQueryParams.addAll(this.apiClient.parameterToPair("pretty", pretty));
        }
        if (fieldSelector != null) {
            localVarQueryParams.addAll(this.apiClient.parameterToPair("fieldSelector", fieldSelector));
        }
        if (labelSelector != null) {
            localVarQueryParams.addAll(this.apiClient.parameterToPair("labelSelector", labelSelector));
        }
        if (resourceVersion != null) {
            localVarQueryParams.addAll(this.apiClient.parameterToPair("resourceVersion", resourceVersion));
        }
        if (timeoutSeconds != null) {
            localVarQueryParams.addAll(this.apiClient.parameterToPair("timeoutSeconds", timeoutSeconds));
        }
        if (watch != null) {
            localVarQueryParams.addAll(this.apiClient.parameterToPair("watch", watch));
        }
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json", "application/yaml", "application/vnd.kubernetes.protobuf", "application/json;stream=watch", "application/vnd.kubernetes.protobuf;stream=watch"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{"*/*"};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        if (progressListener != null) {
            this.apiClient.getHttpClient().networkInterceptors().add(new Interceptor(){

                public Response intercept(Interceptor.Chain chain) throws IOException {
                    Response originalResponse = chain.proceed(chain.request());
                    return originalResponse.newBuilder().body((ResponseBody)new ProgressResponseBody(originalResponse.body(), progressListener)).build();
                }
            });
        }
        String[] localVarAuthNames = new String[]{"BearerToken"};
        return this.apiClient.buildCall(localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAuthNames, progressRequestListener);
    }

    private Call listNamespacedScheduledJobValidateBeforeCall(String namespace, String pretty, String fieldSelector, String labelSelector, String resourceVersion, Integer timeoutSeconds, Boolean watch, ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        if (namespace == null) {
            throw new ApiException("Missing the required parameter 'namespace' when calling listNamespacedScheduledJob(Async)");
        }
        Call call = this.listNamespacedScheduledJobCall(namespace, pretty, fieldSelector, labelSelector, resourceVersion, timeoutSeconds, watch, progressListener, progressRequestListener);
        return call;
    }

    public V2alpha1CronJobList listNamespacedScheduledJob(String namespace, String pretty, String fieldSelector, String labelSelector, String resourceVersion, Integer timeoutSeconds, Boolean watch) throws ApiException {
        ApiResponse<V2alpha1CronJobList> resp = this.listNamespacedScheduledJobWithHttpInfo(namespace, pretty, fieldSelector, labelSelector, resourceVersion, timeoutSeconds, watch);
        return resp.getData();
    }

    public ApiResponse<V2alpha1CronJobList> listNamespacedScheduledJobWithHttpInfo(String namespace, String pretty, String fieldSelector, String labelSelector, String resourceVersion, Integer timeoutSeconds, Boolean watch) throws ApiException {
        Call call = this.listNamespacedScheduledJobValidateBeforeCall(namespace, pretty, fieldSelector, labelSelector, resourceVersion, timeoutSeconds, watch, null, null);
        Type localVarReturnType = new TypeToken<V2alpha1CronJobList>(){}.getType();
        return this.apiClient.execute(call, localVarReturnType);
    }

    public Call listNamespacedScheduledJobAsync(String namespace, String pretty, String fieldSelector, String labelSelector, String resourceVersion, Integer timeoutSeconds, Boolean watch, final ApiCallback<V2alpha1CronJobList> callback) throws ApiException {
        ProgressResponseBody.ProgressListener progressListener = null;
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;
        if (callback != null) {
            progressListener = new ProgressResponseBody.ProgressListener(){

                @Override
                public void update(long bytesRead, long contentLength, boolean done) {
                    callback.onDownloadProgress(bytesRead, contentLength, done);
                }
            };
            progressRequestListener = new ProgressRequestBody.ProgressRequestListener(){

                @Override
                public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                    callback.onUploadProgress(bytesWritten, contentLength, done);
                }
            };
        }
        Call call = this.listNamespacedScheduledJobValidateBeforeCall(namespace, pretty, fieldSelector, labelSelector, resourceVersion, timeoutSeconds, watch, progressListener, progressRequestListener);
        Type localVarReturnType = new TypeToken<V2alpha1CronJobList>(){}.getType();
        this.apiClient.executeAsync(call, localVarReturnType, callback);
        return call;
    }

    public Call listScheduledJobForAllNamespacesCall(String fieldSelector, String labelSelector, String pretty, String resourceVersion, Integer timeoutSeconds, Boolean watch, final ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        Object localVarPostBody = null;
        String localVarPath = "/apis/batch/v2alpha1/scheduledjobs";
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        if (fieldSelector != null) {
            localVarQueryParams.addAll(this.apiClient.parameterToPair("fieldSelector", fieldSelector));
        }
        if (labelSelector != null) {
            localVarQueryParams.addAll(this.apiClient.parameterToPair("labelSelector", labelSelector));
        }
        if (pretty != null) {
            localVarQueryParams.addAll(this.apiClient.parameterToPair("pretty", pretty));
        }
        if (resourceVersion != null) {
            localVarQueryParams.addAll(this.apiClient.parameterToPair("resourceVersion", resourceVersion));
        }
        if (timeoutSeconds != null) {
            localVarQueryParams.addAll(this.apiClient.parameterToPair("timeoutSeconds", timeoutSeconds));
        }
        if (watch != null) {
            localVarQueryParams.addAll(this.apiClient.parameterToPair("watch", watch));
        }
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json", "application/yaml", "application/vnd.kubernetes.protobuf", "application/json;stream=watch", "application/vnd.kubernetes.protobuf;stream=watch"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{"*/*"};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        if (progressListener != null) {
            this.apiClient.getHttpClient().networkInterceptors().add(new Interceptor(){

                public Response intercept(Interceptor.Chain chain) throws IOException {
                    Response originalResponse = chain.proceed(chain.request());
                    return originalResponse.newBuilder().body((ResponseBody)new ProgressResponseBody(originalResponse.body(), progressListener)).build();
                }
            });
        }
        String[] localVarAuthNames = new String[]{"BearerToken"};
        return this.apiClient.buildCall(localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAuthNames, progressRequestListener);
    }

    private Call listScheduledJobForAllNamespacesValidateBeforeCall(String fieldSelector, String labelSelector, String pretty, String resourceVersion, Integer timeoutSeconds, Boolean watch, ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        Call call = this.listScheduledJobForAllNamespacesCall(fieldSelector, labelSelector, pretty, resourceVersion, timeoutSeconds, watch, progressListener, progressRequestListener);
        return call;
    }

    public V2alpha1CronJobList listScheduledJobForAllNamespaces(String fieldSelector, String labelSelector, String pretty, String resourceVersion, Integer timeoutSeconds, Boolean watch) throws ApiException {
        ApiResponse<V2alpha1CronJobList> resp = this.listScheduledJobForAllNamespacesWithHttpInfo(fieldSelector, labelSelector, pretty, resourceVersion, timeoutSeconds, watch);
        return resp.getData();
    }

    public ApiResponse<V2alpha1CronJobList> listScheduledJobForAllNamespacesWithHttpInfo(String fieldSelector, String labelSelector, String pretty, String resourceVersion, Integer timeoutSeconds, Boolean watch) throws ApiException {
        Call call = this.listScheduledJobForAllNamespacesValidateBeforeCall(fieldSelector, labelSelector, pretty, resourceVersion, timeoutSeconds, watch, null, null);
        Type localVarReturnType = new TypeToken<V2alpha1CronJobList>(){}.getType();
        return this.apiClient.execute(call, localVarReturnType);
    }

    public Call listScheduledJobForAllNamespacesAsync(String fieldSelector, String labelSelector, String pretty, String resourceVersion, Integer timeoutSeconds, Boolean watch, final ApiCallback<V2alpha1CronJobList> callback) throws ApiException {
        ProgressResponseBody.ProgressListener progressListener = null;
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;
        if (callback != null) {
            progressListener = new ProgressResponseBody.ProgressListener(){

                @Override
                public void update(long bytesRead, long contentLength, boolean done) {
                    callback.onDownloadProgress(bytesRead, contentLength, done);
                }
            };
            progressRequestListener = new ProgressRequestBody.ProgressRequestListener(){

                @Override
                public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                    callback.onUploadProgress(bytesWritten, contentLength, done);
                }
            };
        }
        Call call = this.listScheduledJobForAllNamespacesValidateBeforeCall(fieldSelector, labelSelector, pretty, resourceVersion, timeoutSeconds, watch, progressListener, progressRequestListener);
        Type localVarReturnType = new TypeToken<V2alpha1CronJobList>(){}.getType();
        this.apiClient.executeAsync(call, localVarReturnType, callback);
        return call;
    }

    public Call patchNamespacedCronJobCall(String name, String namespace, Object body, String pretty, final ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        Object localVarPostBody = body;
        String localVarPath = "/apis/batch/v2alpha1/namespaces/{namespace}/cronjobs/{name}".replaceAll("\\{name\\}", this.apiClient.escapeString(name.toString())).replaceAll("\\{namespace\\}", this.apiClient.escapeString(namespace.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        if (pretty != null) {
            localVarQueryParams.addAll(this.apiClient.parameterToPair("pretty", pretty));
        }
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json", "application/yaml", "application/vnd.kubernetes.protobuf"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{"application/json-patch+json", "application/merge-patch+json", "application/strategic-merge-patch+json"};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        if (progressListener != null) {
            this.apiClient.getHttpClient().networkInterceptors().add(new Interceptor(){

                public Response intercept(Interceptor.Chain chain) throws IOException {
                    Response originalResponse = chain.proceed(chain.request());
                    return originalResponse.newBuilder().body((ResponseBody)new ProgressResponseBody(originalResponse.body(), progressListener)).build();
                }
            });
        }
        String[] localVarAuthNames = new String[]{"BearerToken"};
        return this.apiClient.buildCall(localVarPath, "PATCH", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAuthNames, progressRequestListener);
    }

    private Call patchNamespacedCronJobValidateBeforeCall(String name, String namespace, Object body, String pretty, ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        if (name == null) {
            throw new ApiException("Missing the required parameter 'name' when calling patchNamespacedCronJob(Async)");
        }
        if (namespace == null) {
            throw new ApiException("Missing the required parameter 'namespace' when calling patchNamespacedCronJob(Async)");
        }
        if (body == null) {
            throw new ApiException("Missing the required parameter 'body' when calling patchNamespacedCronJob(Async)");
        }
        Call call = this.patchNamespacedCronJobCall(name, namespace, body, pretty, progressListener, progressRequestListener);
        return call;
    }

    public V2alpha1CronJob patchNamespacedCronJob(String name, String namespace, Object body, String pretty) throws ApiException {
        ApiResponse<V2alpha1CronJob> resp = this.patchNamespacedCronJobWithHttpInfo(name, namespace, body, pretty);
        return resp.getData();
    }

    public ApiResponse<V2alpha1CronJob> patchNamespacedCronJobWithHttpInfo(String name, String namespace, Object body, String pretty) throws ApiException {
        Call call = this.patchNamespacedCronJobValidateBeforeCall(name, namespace, body, pretty, null, null);
        Type localVarReturnType = new TypeToken<V2alpha1CronJob>(){}.getType();
        return this.apiClient.execute(call, localVarReturnType);
    }

    public Call patchNamespacedCronJobAsync(String name, String namespace, Object body, String pretty, final ApiCallback<V2alpha1CronJob> callback) throws ApiException {
        ProgressResponseBody.ProgressListener progressListener = null;
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;
        if (callback != null) {
            progressListener = new ProgressResponseBody.ProgressListener(){

                @Override
                public void update(long bytesRead, long contentLength, boolean done) {
                    callback.onDownloadProgress(bytesRead, contentLength, done);
                }
            };
            progressRequestListener = new ProgressRequestBody.ProgressRequestListener(){

                @Override
                public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                    callback.onUploadProgress(bytesWritten, contentLength, done);
                }
            };
        }
        Call call = this.patchNamespacedCronJobValidateBeforeCall(name, namespace, body, pretty, progressListener, progressRequestListener);
        Type localVarReturnType = new TypeToken<V2alpha1CronJob>(){}.getType();
        this.apiClient.executeAsync(call, localVarReturnType, callback);
        return call;
    }

    public Call patchNamespacedCronJobStatusCall(String name, String namespace, Object body, String pretty, final ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        Object localVarPostBody = body;
        String localVarPath = "/apis/batch/v2alpha1/namespaces/{namespace}/cronjobs/{name}/status".replaceAll("\\{name\\}", this.apiClient.escapeString(name.toString())).replaceAll("\\{namespace\\}", this.apiClient.escapeString(namespace.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        if (pretty != null) {
            localVarQueryParams.addAll(this.apiClient.parameterToPair("pretty", pretty));
        }
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json", "application/yaml", "application/vnd.kubernetes.protobuf"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{"application/json-patch+json", "application/merge-patch+json", "application/strategic-merge-patch+json"};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        if (progressListener != null) {
            this.apiClient.getHttpClient().networkInterceptors().add(new Interceptor(){

                public Response intercept(Interceptor.Chain chain) throws IOException {
                    Response originalResponse = chain.proceed(chain.request());
                    return originalResponse.newBuilder().body((ResponseBody)new ProgressResponseBody(originalResponse.body(), progressListener)).build();
                }
            });
        }
        String[] localVarAuthNames = new String[]{"BearerToken"};
        return this.apiClient.buildCall(localVarPath, "PATCH", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAuthNames, progressRequestListener);
    }

    private Call patchNamespacedCronJobStatusValidateBeforeCall(String name, String namespace, Object body, String pretty, ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        if (name == null) {
            throw new ApiException("Missing the required parameter 'name' when calling patchNamespacedCronJobStatus(Async)");
        }
        if (namespace == null) {
            throw new ApiException("Missing the required parameter 'namespace' when calling patchNamespacedCronJobStatus(Async)");
        }
        if (body == null) {
            throw new ApiException("Missing the required parameter 'body' when calling patchNamespacedCronJobStatus(Async)");
        }
        Call call = this.patchNamespacedCronJobStatusCall(name, namespace, body, pretty, progressListener, progressRequestListener);
        return call;
    }

    public V2alpha1CronJob patchNamespacedCronJobStatus(String name, String namespace, Object body, String pretty) throws ApiException {
        ApiResponse<V2alpha1CronJob> resp = this.patchNamespacedCronJobStatusWithHttpInfo(name, namespace, body, pretty);
        return resp.getData();
    }

    public ApiResponse<V2alpha1CronJob> patchNamespacedCronJobStatusWithHttpInfo(String name, String namespace, Object body, String pretty) throws ApiException {
        Call call = this.patchNamespacedCronJobStatusValidateBeforeCall(name, namespace, body, pretty, null, null);
        Type localVarReturnType = new TypeToken<V2alpha1CronJob>(){}.getType();
        return this.apiClient.execute(call, localVarReturnType);
    }

    public Call patchNamespacedCronJobStatusAsync(String name, String namespace, Object body, String pretty, final ApiCallback<V2alpha1CronJob> callback) throws ApiException {
        ProgressResponseBody.ProgressListener progressListener = null;
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;
        if (callback != null) {
            progressListener = new ProgressResponseBody.ProgressListener(){

                @Override
                public void update(long bytesRead, long contentLength, boolean done) {
                    callback.onDownloadProgress(bytesRead, contentLength, done);
                }
            };
            progressRequestListener = new ProgressRequestBody.ProgressRequestListener(){

                @Override
                public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                    callback.onUploadProgress(bytesWritten, contentLength, done);
                }
            };
        }
        Call call = this.patchNamespacedCronJobStatusValidateBeforeCall(name, namespace, body, pretty, progressListener, progressRequestListener);
        Type localVarReturnType = new TypeToken<V2alpha1CronJob>(){}.getType();
        this.apiClient.executeAsync(call, localVarReturnType, callback);
        return call;
    }

    public Call patchNamespacedScheduledJobCall(String name, String namespace, Object body, String pretty, final ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        Object localVarPostBody = body;
        String localVarPath = "/apis/batch/v2alpha1/namespaces/{namespace}/scheduledjobs/{name}".replaceAll("\\{name\\}", this.apiClient.escapeString(name.toString())).replaceAll("\\{namespace\\}", this.apiClient.escapeString(namespace.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        if (pretty != null) {
            localVarQueryParams.addAll(this.apiClient.parameterToPair("pretty", pretty));
        }
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json", "application/yaml", "application/vnd.kubernetes.protobuf"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{"application/json-patch+json", "application/merge-patch+json", "application/strategic-merge-patch+json"};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        if (progressListener != null) {
            this.apiClient.getHttpClient().networkInterceptors().add(new Interceptor(){

                public Response intercept(Interceptor.Chain chain) throws IOException {
                    Response originalResponse = chain.proceed(chain.request());
                    return originalResponse.newBuilder().body((ResponseBody)new ProgressResponseBody(originalResponse.body(), progressListener)).build();
                }
            });
        }
        String[] localVarAuthNames = new String[]{"BearerToken"};
        return this.apiClient.buildCall(localVarPath, "PATCH", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAuthNames, progressRequestListener);
    }

    private Call patchNamespacedScheduledJobValidateBeforeCall(String name, String namespace, Object body, String pretty, ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        if (name == null) {
            throw new ApiException("Missing the required parameter 'name' when calling patchNamespacedScheduledJob(Async)");
        }
        if (namespace == null) {
            throw new ApiException("Missing the required parameter 'namespace' when calling patchNamespacedScheduledJob(Async)");
        }
        if (body == null) {
            throw new ApiException("Missing the required parameter 'body' when calling patchNamespacedScheduledJob(Async)");
        }
        Call call = this.patchNamespacedScheduledJobCall(name, namespace, body, pretty, progressListener, progressRequestListener);
        return call;
    }

    public V2alpha1CronJob patchNamespacedScheduledJob(String name, String namespace, Object body, String pretty) throws ApiException {
        ApiResponse<V2alpha1CronJob> resp = this.patchNamespacedScheduledJobWithHttpInfo(name, namespace, body, pretty);
        return resp.getData();
    }

    public ApiResponse<V2alpha1CronJob> patchNamespacedScheduledJobWithHttpInfo(String name, String namespace, Object body, String pretty) throws ApiException {
        Call call = this.patchNamespacedScheduledJobValidateBeforeCall(name, namespace, body, pretty, null, null);
        Type localVarReturnType = new TypeToken<V2alpha1CronJob>(){}.getType();
        return this.apiClient.execute(call, localVarReturnType);
    }

    public Call patchNamespacedScheduledJobAsync(String name, String namespace, Object body, String pretty, final ApiCallback<V2alpha1CronJob> callback) throws ApiException {
        ProgressResponseBody.ProgressListener progressListener = null;
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;
        if (callback != null) {
            progressListener = new ProgressResponseBody.ProgressListener(){

                @Override
                public void update(long bytesRead, long contentLength, boolean done) {
                    callback.onDownloadProgress(bytesRead, contentLength, done);
                }
            };
            progressRequestListener = new ProgressRequestBody.ProgressRequestListener(){

                @Override
                public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                    callback.onUploadProgress(bytesWritten, contentLength, done);
                }
            };
        }
        Call call = this.patchNamespacedScheduledJobValidateBeforeCall(name, namespace, body, pretty, progressListener, progressRequestListener);
        Type localVarReturnType = new TypeToken<V2alpha1CronJob>(){}.getType();
        this.apiClient.executeAsync(call, localVarReturnType, callback);
        return call;
    }

    public Call patchNamespacedScheduledJobStatusCall(String name, String namespace, Object body, String pretty, final ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        Object localVarPostBody = body;
        String localVarPath = "/apis/batch/v2alpha1/namespaces/{namespace}/scheduledjobs/{name}/status".replaceAll("\\{name\\}", this.apiClient.escapeString(name.toString())).replaceAll("\\{namespace\\}", this.apiClient.escapeString(namespace.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        if (pretty != null) {
            localVarQueryParams.addAll(this.apiClient.parameterToPair("pretty", pretty));
        }
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json", "application/yaml", "application/vnd.kubernetes.protobuf"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{"application/json-patch+json", "application/merge-patch+json", "application/strategic-merge-patch+json"};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        if (progressListener != null) {
            this.apiClient.getHttpClient().networkInterceptors().add(new Interceptor(){

                public Response intercept(Interceptor.Chain chain) throws IOException {
                    Response originalResponse = chain.proceed(chain.request());
                    return originalResponse.newBuilder().body((ResponseBody)new ProgressResponseBody(originalResponse.body(), progressListener)).build();
                }
            });
        }
        String[] localVarAuthNames = new String[]{"BearerToken"};
        return this.apiClient.buildCall(localVarPath, "PATCH", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAuthNames, progressRequestListener);
    }

    private Call patchNamespacedScheduledJobStatusValidateBeforeCall(String name, String namespace, Object body, String pretty, ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        if (name == null) {
            throw new ApiException("Missing the required parameter 'name' when calling patchNamespacedScheduledJobStatus(Async)");
        }
        if (namespace == null) {
            throw new ApiException("Missing the required parameter 'namespace' when calling patchNamespacedScheduledJobStatus(Async)");
        }
        if (body == null) {
            throw new ApiException("Missing the required parameter 'body' when calling patchNamespacedScheduledJobStatus(Async)");
        }
        Call call = this.patchNamespacedScheduledJobStatusCall(name, namespace, body, pretty, progressListener, progressRequestListener);
        return call;
    }

    public V2alpha1CronJob patchNamespacedScheduledJobStatus(String name, String namespace, Object body, String pretty) throws ApiException {
        ApiResponse<V2alpha1CronJob> resp = this.patchNamespacedScheduledJobStatusWithHttpInfo(name, namespace, body, pretty);
        return resp.getData();
    }

    public ApiResponse<V2alpha1CronJob> patchNamespacedScheduledJobStatusWithHttpInfo(String name, String namespace, Object body, String pretty) throws ApiException {
        Call call = this.patchNamespacedScheduledJobStatusValidateBeforeCall(name, namespace, body, pretty, null, null);
        Type localVarReturnType = new TypeToken<V2alpha1CronJob>(){}.getType();
        return this.apiClient.execute(call, localVarReturnType);
    }

    public Call patchNamespacedScheduledJobStatusAsync(String name, String namespace, Object body, String pretty, final ApiCallback<V2alpha1CronJob> callback) throws ApiException {
        ProgressResponseBody.ProgressListener progressListener = null;
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;
        if (callback != null) {
            progressListener = new ProgressResponseBody.ProgressListener(){

                @Override
                public void update(long bytesRead, long contentLength, boolean done) {
                    callback.onDownloadProgress(bytesRead, contentLength, done);
                }
            };
            progressRequestListener = new ProgressRequestBody.ProgressRequestListener(){

                @Override
                public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                    callback.onUploadProgress(bytesWritten, contentLength, done);
                }
            };
        }
        Call call = this.patchNamespacedScheduledJobStatusValidateBeforeCall(name, namespace, body, pretty, progressListener, progressRequestListener);
        Type localVarReturnType = new TypeToken<V2alpha1CronJob>(){}.getType();
        this.apiClient.executeAsync(call, localVarReturnType, callback);
        return call;
    }

    public Call readNamespacedCronJobCall(String name, String namespace, String pretty, Boolean exact, Boolean export, final ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        Object localVarPostBody = null;
        String localVarPath = "/apis/batch/v2alpha1/namespaces/{namespace}/cronjobs/{name}".replaceAll("\\{name\\}", this.apiClient.escapeString(name.toString())).replaceAll("\\{namespace\\}", this.apiClient.escapeString(namespace.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        if (pretty != null) {
            localVarQueryParams.addAll(this.apiClient.parameterToPair("pretty", pretty));
        }
        if (exact != null) {
            localVarQueryParams.addAll(this.apiClient.parameterToPair("exact", exact));
        }
        if (export != null) {
            localVarQueryParams.addAll(this.apiClient.parameterToPair("export", export));
        }
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json", "application/yaml", "application/vnd.kubernetes.protobuf"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{"*/*"};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        if (progressListener != null) {
            this.apiClient.getHttpClient().networkInterceptors().add(new Interceptor(){

                public Response intercept(Interceptor.Chain chain) throws IOException {
                    Response originalResponse = chain.proceed(chain.request());
                    return originalResponse.newBuilder().body((ResponseBody)new ProgressResponseBody(originalResponse.body(), progressListener)).build();
                }
            });
        }
        String[] localVarAuthNames = new String[]{"BearerToken"};
        return this.apiClient.buildCall(localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAuthNames, progressRequestListener);
    }

    private Call readNamespacedCronJobValidateBeforeCall(String name, String namespace, String pretty, Boolean exact, Boolean export, ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        if (name == null) {
            throw new ApiException("Missing the required parameter 'name' when calling readNamespacedCronJob(Async)");
        }
        if (namespace == null) {
            throw new ApiException("Missing the required parameter 'namespace' when calling readNamespacedCronJob(Async)");
        }
        Call call = this.readNamespacedCronJobCall(name, namespace, pretty, exact, export, progressListener, progressRequestListener);
        return call;
    }

    public V2alpha1CronJob readNamespacedCronJob(String name, String namespace, String pretty, Boolean exact, Boolean export) throws ApiException {
        ApiResponse<V2alpha1CronJob> resp = this.readNamespacedCronJobWithHttpInfo(name, namespace, pretty, exact, export);
        return resp.getData();
    }

    public ApiResponse<V2alpha1CronJob> readNamespacedCronJobWithHttpInfo(String name, String namespace, String pretty, Boolean exact, Boolean export) throws ApiException {
        Call call = this.readNamespacedCronJobValidateBeforeCall(name, namespace, pretty, exact, export, null, null);
        Type localVarReturnType = new TypeToken<V2alpha1CronJob>(){}.getType();
        return this.apiClient.execute(call, localVarReturnType);
    }

    public Call readNamespacedCronJobAsync(String name, String namespace, String pretty, Boolean exact, Boolean export, final ApiCallback<V2alpha1CronJob> callback) throws ApiException {
        ProgressResponseBody.ProgressListener progressListener = null;
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;
        if (callback != null) {
            progressListener = new ProgressResponseBody.ProgressListener(){

                @Override
                public void update(long bytesRead, long contentLength, boolean done) {
                    callback.onDownloadProgress(bytesRead, contentLength, done);
                }
            };
            progressRequestListener = new ProgressRequestBody.ProgressRequestListener(){

                @Override
                public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                    callback.onUploadProgress(bytesWritten, contentLength, done);
                }
            };
        }
        Call call = this.readNamespacedCronJobValidateBeforeCall(name, namespace, pretty, exact, export, progressListener, progressRequestListener);
        Type localVarReturnType = new TypeToken<V2alpha1CronJob>(){}.getType();
        this.apiClient.executeAsync(call, localVarReturnType, callback);
        return call;
    }

    public Call readNamespacedCronJobStatusCall(String name, String namespace, String pretty, final ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        Object localVarPostBody = null;
        String localVarPath = "/apis/batch/v2alpha1/namespaces/{namespace}/cronjobs/{name}/status".replaceAll("\\{name\\}", this.apiClient.escapeString(name.toString())).replaceAll("\\{namespace\\}", this.apiClient.escapeString(namespace.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        if (pretty != null) {
            localVarQueryParams.addAll(this.apiClient.parameterToPair("pretty", pretty));
        }
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json", "application/yaml", "application/vnd.kubernetes.protobuf"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{"*/*"};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        if (progressListener != null) {
            this.apiClient.getHttpClient().networkInterceptors().add(new Interceptor(){

                public Response intercept(Interceptor.Chain chain) throws IOException {
                    Response originalResponse = chain.proceed(chain.request());
                    return originalResponse.newBuilder().body((ResponseBody)new ProgressResponseBody(originalResponse.body(), progressListener)).build();
                }
            });
        }
        String[] localVarAuthNames = new String[]{"BearerToken"};
        return this.apiClient.buildCall(localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAuthNames, progressRequestListener);
    }

    private Call readNamespacedCronJobStatusValidateBeforeCall(String name, String namespace, String pretty, ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        if (name == null) {
            throw new ApiException("Missing the required parameter 'name' when calling readNamespacedCronJobStatus(Async)");
        }
        if (namespace == null) {
            throw new ApiException("Missing the required parameter 'namespace' when calling readNamespacedCronJobStatus(Async)");
        }
        Call call = this.readNamespacedCronJobStatusCall(name, namespace, pretty, progressListener, progressRequestListener);
        return call;
    }

    public V2alpha1CronJob readNamespacedCronJobStatus(String name, String namespace, String pretty) throws ApiException {
        ApiResponse<V2alpha1CronJob> resp = this.readNamespacedCronJobStatusWithHttpInfo(name, namespace, pretty);
        return resp.getData();
    }

    public ApiResponse<V2alpha1CronJob> readNamespacedCronJobStatusWithHttpInfo(String name, String namespace, String pretty) throws ApiException {
        Call call = this.readNamespacedCronJobStatusValidateBeforeCall(name, namespace, pretty, null, null);
        Type localVarReturnType = new TypeToken<V2alpha1CronJob>(){}.getType();
        return this.apiClient.execute(call, localVarReturnType);
    }

    public Call readNamespacedCronJobStatusAsync(String name, String namespace, String pretty, final ApiCallback<V2alpha1CronJob> callback) throws ApiException {
        ProgressResponseBody.ProgressListener progressListener = null;
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;
        if (callback != null) {
            progressListener = new ProgressResponseBody.ProgressListener(){

                @Override
                public void update(long bytesRead, long contentLength, boolean done) {
                    callback.onDownloadProgress(bytesRead, contentLength, done);
                }
            };
            progressRequestListener = new ProgressRequestBody.ProgressRequestListener(){

                @Override
                public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                    callback.onUploadProgress(bytesWritten, contentLength, done);
                }
            };
        }
        Call call = this.readNamespacedCronJobStatusValidateBeforeCall(name, namespace, pretty, progressListener, progressRequestListener);
        Type localVarReturnType = new TypeToken<V2alpha1CronJob>(){}.getType();
        this.apiClient.executeAsync(call, localVarReturnType, callback);
        return call;
    }

    public Call readNamespacedScheduledJobCall(String name, String namespace, String pretty, Boolean exact, Boolean export, final ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        Object localVarPostBody = null;
        String localVarPath = "/apis/batch/v2alpha1/namespaces/{namespace}/scheduledjobs/{name}".replaceAll("\\{name\\}", this.apiClient.escapeString(name.toString())).replaceAll("\\{namespace\\}", this.apiClient.escapeString(namespace.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        if (pretty != null) {
            localVarQueryParams.addAll(this.apiClient.parameterToPair("pretty", pretty));
        }
        if (exact != null) {
            localVarQueryParams.addAll(this.apiClient.parameterToPair("exact", exact));
        }
        if (export != null) {
            localVarQueryParams.addAll(this.apiClient.parameterToPair("export", export));
        }
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json", "application/yaml", "application/vnd.kubernetes.protobuf"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{"*/*"};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        if (progressListener != null) {
            this.apiClient.getHttpClient().networkInterceptors().add(new Interceptor(){

                public Response intercept(Interceptor.Chain chain) throws IOException {
                    Response originalResponse = chain.proceed(chain.request());
                    return originalResponse.newBuilder().body((ResponseBody)new ProgressResponseBody(originalResponse.body(), progressListener)).build();
                }
            });
        }
        String[] localVarAuthNames = new String[]{"BearerToken"};
        return this.apiClient.buildCall(localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAuthNames, progressRequestListener);
    }

    private Call readNamespacedScheduledJobValidateBeforeCall(String name, String namespace, String pretty, Boolean exact, Boolean export, ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        if (name == null) {
            throw new ApiException("Missing the required parameter 'name' when calling readNamespacedScheduledJob(Async)");
        }
        if (namespace == null) {
            throw new ApiException("Missing the required parameter 'namespace' when calling readNamespacedScheduledJob(Async)");
        }
        Call call = this.readNamespacedScheduledJobCall(name, namespace, pretty, exact, export, progressListener, progressRequestListener);
        return call;
    }

    public V2alpha1CronJob readNamespacedScheduledJob(String name, String namespace, String pretty, Boolean exact, Boolean export) throws ApiException {
        ApiResponse<V2alpha1CronJob> resp = this.readNamespacedScheduledJobWithHttpInfo(name, namespace, pretty, exact, export);
        return resp.getData();
    }

    public ApiResponse<V2alpha1CronJob> readNamespacedScheduledJobWithHttpInfo(String name, String namespace, String pretty, Boolean exact, Boolean export) throws ApiException {
        Call call = this.readNamespacedScheduledJobValidateBeforeCall(name, namespace, pretty, exact, export, null, null);
        Type localVarReturnType = new TypeToken<V2alpha1CronJob>(){}.getType();
        return this.apiClient.execute(call, localVarReturnType);
    }

    public Call readNamespacedScheduledJobAsync(String name, String namespace, String pretty, Boolean exact, Boolean export, final ApiCallback<V2alpha1CronJob> callback) throws ApiException {
        ProgressResponseBody.ProgressListener progressListener = null;
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;
        if (callback != null) {
            progressListener = new ProgressResponseBody.ProgressListener(){

                @Override
                public void update(long bytesRead, long contentLength, boolean done) {
                    callback.onDownloadProgress(bytesRead, contentLength, done);
                }
            };
            progressRequestListener = new ProgressRequestBody.ProgressRequestListener(){

                @Override
                public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                    callback.onUploadProgress(bytesWritten, contentLength, done);
                }
            };
        }
        Call call = this.readNamespacedScheduledJobValidateBeforeCall(name, namespace, pretty, exact, export, progressListener, progressRequestListener);
        Type localVarReturnType = new TypeToken<V2alpha1CronJob>(){}.getType();
        this.apiClient.executeAsync(call, localVarReturnType, callback);
        return call;
    }

    public Call readNamespacedScheduledJobStatusCall(String name, String namespace, String pretty, final ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        Object localVarPostBody = null;
        String localVarPath = "/apis/batch/v2alpha1/namespaces/{namespace}/scheduledjobs/{name}/status".replaceAll("\\{name\\}", this.apiClient.escapeString(name.toString())).replaceAll("\\{namespace\\}", this.apiClient.escapeString(namespace.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        if (pretty != null) {
            localVarQueryParams.addAll(this.apiClient.parameterToPair("pretty", pretty));
        }
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json", "application/yaml", "application/vnd.kubernetes.protobuf"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{"*/*"};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        if (progressListener != null) {
            this.apiClient.getHttpClient().networkInterceptors().add(new Interceptor(){

                public Response intercept(Interceptor.Chain chain) throws IOException {
                    Response originalResponse = chain.proceed(chain.request());
                    return originalResponse.newBuilder().body((ResponseBody)new ProgressResponseBody(originalResponse.body(), progressListener)).build();
                }
            });
        }
        String[] localVarAuthNames = new String[]{"BearerToken"};
        return this.apiClient.buildCall(localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAuthNames, progressRequestListener);
    }

    private Call readNamespacedScheduledJobStatusValidateBeforeCall(String name, String namespace, String pretty, ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        if (name == null) {
            throw new ApiException("Missing the required parameter 'name' when calling readNamespacedScheduledJobStatus(Async)");
        }
        if (namespace == null) {
            throw new ApiException("Missing the required parameter 'namespace' when calling readNamespacedScheduledJobStatus(Async)");
        }
        Call call = this.readNamespacedScheduledJobStatusCall(name, namespace, pretty, progressListener, progressRequestListener);
        return call;
    }

    public V2alpha1CronJob readNamespacedScheduledJobStatus(String name, String namespace, String pretty) throws ApiException {
        ApiResponse<V2alpha1CronJob> resp = this.readNamespacedScheduledJobStatusWithHttpInfo(name, namespace, pretty);
        return resp.getData();
    }

    public ApiResponse<V2alpha1CronJob> readNamespacedScheduledJobStatusWithHttpInfo(String name, String namespace, String pretty) throws ApiException {
        Call call = this.readNamespacedScheduledJobStatusValidateBeforeCall(name, namespace, pretty, null, null);
        Type localVarReturnType = new TypeToken<V2alpha1CronJob>(){}.getType();
        return this.apiClient.execute(call, localVarReturnType);
    }

    public Call readNamespacedScheduledJobStatusAsync(String name, String namespace, String pretty, final ApiCallback<V2alpha1CronJob> callback) throws ApiException {
        ProgressResponseBody.ProgressListener progressListener = null;
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;
        if (callback != null) {
            progressListener = new ProgressResponseBody.ProgressListener(){

                @Override
                public void update(long bytesRead, long contentLength, boolean done) {
                    callback.onDownloadProgress(bytesRead, contentLength, done);
                }
            };
            progressRequestListener = new ProgressRequestBody.ProgressRequestListener(){

                @Override
                public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                    callback.onUploadProgress(bytesWritten, contentLength, done);
                }
            };
        }
        Call call = this.readNamespacedScheduledJobStatusValidateBeforeCall(name, namespace, pretty, progressListener, progressRequestListener);
        Type localVarReturnType = new TypeToken<V2alpha1CronJob>(){}.getType();
        this.apiClient.executeAsync(call, localVarReturnType, callback);
        return call;
    }

    public Call replaceNamespacedCronJobCall(String name, String namespace, V2alpha1CronJob body, String pretty, final ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        V2alpha1CronJob localVarPostBody = body;
        String localVarPath = "/apis/batch/v2alpha1/namespaces/{namespace}/cronjobs/{name}".replaceAll("\\{name\\}", this.apiClient.escapeString(name.toString())).replaceAll("\\{namespace\\}", this.apiClient.escapeString(namespace.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        if (pretty != null) {
            localVarQueryParams.addAll(this.apiClient.parameterToPair("pretty", pretty));
        }
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json", "application/yaml", "application/vnd.kubernetes.protobuf"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{"*/*"};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        if (progressListener != null) {
            this.apiClient.getHttpClient().networkInterceptors().add(new Interceptor(){

                public Response intercept(Interceptor.Chain chain) throws IOException {
                    Response originalResponse = chain.proceed(chain.request());
                    return originalResponse.newBuilder().body((ResponseBody)new ProgressResponseBody(originalResponse.body(), progressListener)).build();
                }
            });
        }
        String[] localVarAuthNames = new String[]{"BearerToken"};
        return this.apiClient.buildCall(localVarPath, "PUT", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAuthNames, progressRequestListener);
    }

    private Call replaceNamespacedCronJobValidateBeforeCall(String name, String namespace, V2alpha1CronJob body, String pretty, ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        if (name == null) {
            throw new ApiException("Missing the required parameter 'name' when calling replaceNamespacedCronJob(Async)");
        }
        if (namespace == null) {
            throw new ApiException("Missing the required parameter 'namespace' when calling replaceNamespacedCronJob(Async)");
        }
        if (body == null) {
            throw new ApiException("Missing the required parameter 'body' when calling replaceNamespacedCronJob(Async)");
        }
        Call call = this.replaceNamespacedCronJobCall(name, namespace, body, pretty, progressListener, progressRequestListener);
        return call;
    }

    public V2alpha1CronJob replaceNamespacedCronJob(String name, String namespace, V2alpha1CronJob body, String pretty) throws ApiException {
        ApiResponse<V2alpha1CronJob> resp = this.replaceNamespacedCronJobWithHttpInfo(name, namespace, body, pretty);
        return resp.getData();
    }

    public ApiResponse<V2alpha1CronJob> replaceNamespacedCronJobWithHttpInfo(String name, String namespace, V2alpha1CronJob body, String pretty) throws ApiException {
        Call call = this.replaceNamespacedCronJobValidateBeforeCall(name, namespace, body, pretty, null, null);
        Type localVarReturnType = new TypeToken<V2alpha1CronJob>(){}.getType();
        return this.apiClient.execute(call, localVarReturnType);
    }

    public Call replaceNamespacedCronJobAsync(String name, String namespace, V2alpha1CronJob body, String pretty, final ApiCallback<V2alpha1CronJob> callback) throws ApiException {
        ProgressResponseBody.ProgressListener progressListener = null;
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;
        if (callback != null) {
            progressListener = new ProgressResponseBody.ProgressListener(){

                @Override
                public void update(long bytesRead, long contentLength, boolean done) {
                    callback.onDownloadProgress(bytesRead, contentLength, done);
                }
            };
            progressRequestListener = new ProgressRequestBody.ProgressRequestListener(){

                @Override
                public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                    callback.onUploadProgress(bytesWritten, contentLength, done);
                }
            };
        }
        Call call = this.replaceNamespacedCronJobValidateBeforeCall(name, namespace, body, pretty, progressListener, progressRequestListener);
        Type localVarReturnType = new TypeToken<V2alpha1CronJob>(){}.getType();
        this.apiClient.executeAsync(call, localVarReturnType, callback);
        return call;
    }

    public Call replaceNamespacedCronJobStatusCall(String name, String namespace, V2alpha1CronJob body, String pretty, final ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        V2alpha1CronJob localVarPostBody = body;
        String localVarPath = "/apis/batch/v2alpha1/namespaces/{namespace}/cronjobs/{name}/status".replaceAll("\\{name\\}", this.apiClient.escapeString(name.toString())).replaceAll("\\{namespace\\}", this.apiClient.escapeString(namespace.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        if (pretty != null) {
            localVarQueryParams.addAll(this.apiClient.parameterToPair("pretty", pretty));
        }
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json", "application/yaml", "application/vnd.kubernetes.protobuf"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{"*/*"};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        if (progressListener != null) {
            this.apiClient.getHttpClient().networkInterceptors().add(new Interceptor(){

                public Response intercept(Interceptor.Chain chain) throws IOException {
                    Response originalResponse = chain.proceed(chain.request());
                    return originalResponse.newBuilder().body((ResponseBody)new ProgressResponseBody(originalResponse.body(), progressListener)).build();
                }
            });
        }
        String[] localVarAuthNames = new String[]{"BearerToken"};
        return this.apiClient.buildCall(localVarPath, "PUT", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAuthNames, progressRequestListener);
    }

    private Call replaceNamespacedCronJobStatusValidateBeforeCall(String name, String namespace, V2alpha1CronJob body, String pretty, ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        if (name == null) {
            throw new ApiException("Missing the required parameter 'name' when calling replaceNamespacedCronJobStatus(Async)");
        }
        if (namespace == null) {
            throw new ApiException("Missing the required parameter 'namespace' when calling replaceNamespacedCronJobStatus(Async)");
        }
        if (body == null) {
            throw new ApiException("Missing the required parameter 'body' when calling replaceNamespacedCronJobStatus(Async)");
        }
        Call call = this.replaceNamespacedCronJobStatusCall(name, namespace, body, pretty, progressListener, progressRequestListener);
        return call;
    }

    public V2alpha1CronJob replaceNamespacedCronJobStatus(String name, String namespace, V2alpha1CronJob body, String pretty) throws ApiException {
        ApiResponse<V2alpha1CronJob> resp = this.replaceNamespacedCronJobStatusWithHttpInfo(name, namespace, body, pretty);
        return resp.getData();
    }

    public ApiResponse<V2alpha1CronJob> replaceNamespacedCronJobStatusWithHttpInfo(String name, String namespace, V2alpha1CronJob body, String pretty) throws ApiException {
        Call call = this.replaceNamespacedCronJobStatusValidateBeforeCall(name, namespace, body, pretty, null, null);
        Type localVarReturnType = new TypeToken<V2alpha1CronJob>(){}.getType();
        return this.apiClient.execute(call, localVarReturnType);
    }

    public Call replaceNamespacedCronJobStatusAsync(String name, String namespace, V2alpha1CronJob body, String pretty, final ApiCallback<V2alpha1CronJob> callback) throws ApiException {
        ProgressResponseBody.ProgressListener progressListener = null;
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;
        if (callback != null) {
            progressListener = new ProgressResponseBody.ProgressListener(){

                @Override
                public void update(long bytesRead, long contentLength, boolean done) {
                    callback.onDownloadProgress(bytesRead, contentLength, done);
                }
            };
            progressRequestListener = new ProgressRequestBody.ProgressRequestListener(){

                @Override
                public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                    callback.onUploadProgress(bytesWritten, contentLength, done);
                }
            };
        }
        Call call = this.replaceNamespacedCronJobStatusValidateBeforeCall(name, namespace, body, pretty, progressListener, progressRequestListener);
        Type localVarReturnType = new TypeToken<V2alpha1CronJob>(){}.getType();
        this.apiClient.executeAsync(call, localVarReturnType, callback);
        return call;
    }

    public Call replaceNamespacedScheduledJobCall(String name, String namespace, V2alpha1CronJob body, String pretty, final ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        V2alpha1CronJob localVarPostBody = body;
        String localVarPath = "/apis/batch/v2alpha1/namespaces/{namespace}/scheduledjobs/{name}".replaceAll("\\{name\\}", this.apiClient.escapeString(name.toString())).replaceAll("\\{namespace\\}", this.apiClient.escapeString(namespace.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        if (pretty != null) {
            localVarQueryParams.addAll(this.apiClient.parameterToPair("pretty", pretty));
        }
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json", "application/yaml", "application/vnd.kubernetes.protobuf"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{"*/*"};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        if (progressListener != null) {
            this.apiClient.getHttpClient().networkInterceptors().add(new Interceptor(){

                public Response intercept(Interceptor.Chain chain) throws IOException {
                    Response originalResponse = chain.proceed(chain.request());
                    return originalResponse.newBuilder().body((ResponseBody)new ProgressResponseBody(originalResponse.body(), progressListener)).build();
                }
            });
        }
        String[] localVarAuthNames = new String[]{"BearerToken"};
        return this.apiClient.buildCall(localVarPath, "PUT", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAuthNames, progressRequestListener);
    }

    private Call replaceNamespacedScheduledJobValidateBeforeCall(String name, String namespace, V2alpha1CronJob body, String pretty, ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        if (name == null) {
            throw new ApiException("Missing the required parameter 'name' when calling replaceNamespacedScheduledJob(Async)");
        }
        if (namespace == null) {
            throw new ApiException("Missing the required parameter 'namespace' when calling replaceNamespacedScheduledJob(Async)");
        }
        if (body == null) {
            throw new ApiException("Missing the required parameter 'body' when calling replaceNamespacedScheduledJob(Async)");
        }
        Call call = this.replaceNamespacedScheduledJobCall(name, namespace, body, pretty, progressListener, progressRequestListener);
        return call;
    }

    public V2alpha1CronJob replaceNamespacedScheduledJob(String name, String namespace, V2alpha1CronJob body, String pretty) throws ApiException {
        ApiResponse<V2alpha1CronJob> resp = this.replaceNamespacedScheduledJobWithHttpInfo(name, namespace, body, pretty);
        return resp.getData();
    }

    public ApiResponse<V2alpha1CronJob> replaceNamespacedScheduledJobWithHttpInfo(String name, String namespace, V2alpha1CronJob body, String pretty) throws ApiException {
        Call call = this.replaceNamespacedScheduledJobValidateBeforeCall(name, namespace, body, pretty, null, null);
        Type localVarReturnType = new TypeToken<V2alpha1CronJob>(){}.getType();
        return this.apiClient.execute(call, localVarReturnType);
    }

    public Call replaceNamespacedScheduledJobAsync(String name, String namespace, V2alpha1CronJob body, String pretty, final ApiCallback<V2alpha1CronJob> callback) throws ApiException {
        ProgressResponseBody.ProgressListener progressListener = null;
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;
        if (callback != null) {
            progressListener = new ProgressResponseBody.ProgressListener(){

                @Override
                public void update(long bytesRead, long contentLength, boolean done) {
                    callback.onDownloadProgress(bytesRead, contentLength, done);
                }
            };
            progressRequestListener = new ProgressRequestBody.ProgressRequestListener(){

                @Override
                public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                    callback.onUploadProgress(bytesWritten, contentLength, done);
                }
            };
        }
        Call call = this.replaceNamespacedScheduledJobValidateBeforeCall(name, namespace, body, pretty, progressListener, progressRequestListener);
        Type localVarReturnType = new TypeToken<V2alpha1CronJob>(){}.getType();
        this.apiClient.executeAsync(call, localVarReturnType, callback);
        return call;
    }

    public Call replaceNamespacedScheduledJobStatusCall(String name, String namespace, V2alpha1CronJob body, String pretty, final ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        V2alpha1CronJob localVarPostBody = body;
        String localVarPath = "/apis/batch/v2alpha1/namespaces/{namespace}/scheduledjobs/{name}/status".replaceAll("\\{name\\}", this.apiClient.escapeString(name.toString())).replaceAll("\\{namespace\\}", this.apiClient.escapeString(namespace.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        if (pretty != null) {
            localVarQueryParams.addAll(this.apiClient.parameterToPair("pretty", pretty));
        }
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json", "application/yaml", "application/vnd.kubernetes.protobuf"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{"*/*"};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        if (progressListener != null) {
            this.apiClient.getHttpClient().networkInterceptors().add(new Interceptor(){

                public Response intercept(Interceptor.Chain chain) throws IOException {
                    Response originalResponse = chain.proceed(chain.request());
                    return originalResponse.newBuilder().body((ResponseBody)new ProgressResponseBody(originalResponse.body(), progressListener)).build();
                }
            });
        }
        String[] localVarAuthNames = new String[]{"BearerToken"};
        return this.apiClient.buildCall(localVarPath, "PUT", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAuthNames, progressRequestListener);
    }

    private Call replaceNamespacedScheduledJobStatusValidateBeforeCall(String name, String namespace, V2alpha1CronJob body, String pretty, ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        if (name == null) {
            throw new ApiException("Missing the required parameter 'name' when calling replaceNamespacedScheduledJobStatus(Async)");
        }
        if (namespace == null) {
            throw new ApiException("Missing the required parameter 'namespace' when calling replaceNamespacedScheduledJobStatus(Async)");
        }
        if (body == null) {
            throw new ApiException("Missing the required parameter 'body' when calling replaceNamespacedScheduledJobStatus(Async)");
        }
        Call call = this.replaceNamespacedScheduledJobStatusCall(name, namespace, body, pretty, progressListener, progressRequestListener);
        return call;
    }

    public V2alpha1CronJob replaceNamespacedScheduledJobStatus(String name, String namespace, V2alpha1CronJob body, String pretty) throws ApiException {
        ApiResponse<V2alpha1CronJob> resp = this.replaceNamespacedScheduledJobStatusWithHttpInfo(name, namespace, body, pretty);
        return resp.getData();
    }

    public ApiResponse<V2alpha1CronJob> replaceNamespacedScheduledJobStatusWithHttpInfo(String name, String namespace, V2alpha1CronJob body, String pretty) throws ApiException {
        Call call = this.replaceNamespacedScheduledJobStatusValidateBeforeCall(name, namespace, body, pretty, null, null);
        Type localVarReturnType = new TypeToken<V2alpha1CronJob>(){}.getType();
        return this.apiClient.execute(call, localVarReturnType);
    }

    public Call replaceNamespacedScheduledJobStatusAsync(String name, String namespace, V2alpha1CronJob body, String pretty, final ApiCallback<V2alpha1CronJob> callback) throws ApiException {
        ProgressResponseBody.ProgressListener progressListener = null;
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;
        if (callback != null) {
            progressListener = new ProgressResponseBody.ProgressListener(){

                @Override
                public void update(long bytesRead, long contentLength, boolean done) {
                    callback.onDownloadProgress(bytesRead, contentLength, done);
                }
            };
            progressRequestListener = new ProgressRequestBody.ProgressRequestListener(){

                @Override
                public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                    callback.onUploadProgress(bytesWritten, contentLength, done);
                }
            };
        }
        Call call = this.replaceNamespacedScheduledJobStatusValidateBeforeCall(name, namespace, body, pretty, progressListener, progressRequestListener);
        Type localVarReturnType = new TypeToken<V2alpha1CronJob>(){}.getType();
        this.apiClient.executeAsync(call, localVarReturnType, callback);
        return call;
    }
}

