/*
 * Decompiled with CFR 0.152.
 */
package io.kubernetes.client.openapi.models;

import com.google.gson.Gson;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.TypeAdapter;
import com.google.gson.TypeAdapterFactory;
import com.google.gson.annotations.SerializedName;
import com.google.gson.reflect.TypeToken;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonWriter;
import io.kubernetes.client.openapi.JSON;
import io.kubernetes.client.openapi.models.V2CrossVersionObjectReference;
import io.kubernetes.client.openapi.models.V2MetricIdentifier;
import io.kubernetes.client.openapi.models.V2MetricTarget;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import jakarta.annotation.Nonnull;
import java.io.IOException;
import java.util.HashSet;
import java.util.Map;
import java.util.Objects;
import java.util.Set;

@ApiModel(description="ObjectMetricSource indicates how to scale on a metric describing a kubernetes object (for example, hits-per-second on an Ingress object).")
public class V2ObjectMetricSource {
    public static final String SERIALIZED_NAME_DESCRIBED_OBJECT = "describedObject";
    @SerializedName(value="describedObject")
    @Nonnull
    private V2CrossVersionObjectReference describedObject;
    public static final String SERIALIZED_NAME_METRIC = "metric";
    @SerializedName(value="metric")
    @Nonnull
    private V2MetricIdentifier metric;
    public static final String SERIALIZED_NAME_TARGET = "target";
    @SerializedName(value="target")
    @Nonnull
    private V2MetricTarget target;
    public static HashSet<String> openapiFields = new HashSet();
    public static HashSet<String> openapiRequiredFields;

    public V2ObjectMetricSource describedObject(@Nonnull V2CrossVersionObjectReference describedObject) {
        this.describedObject = describedObject;
        return this;
    }

    @Nonnull
    @ApiModelProperty(required=true, value="")
    public V2CrossVersionObjectReference getDescribedObject() {
        return this.describedObject;
    }

    public void setDescribedObject(@Nonnull V2CrossVersionObjectReference describedObject) {
        this.describedObject = describedObject;
    }

    public V2ObjectMetricSource metric(@Nonnull V2MetricIdentifier metric) {
        this.metric = metric;
        return this;
    }

    @Nonnull
    @ApiModelProperty(required=true, value="")
    public V2MetricIdentifier getMetric() {
        return this.metric;
    }

    public void setMetric(@Nonnull V2MetricIdentifier metric) {
        this.metric = metric;
    }

    public V2ObjectMetricSource target(@Nonnull V2MetricTarget target) {
        this.target = target;
        return this;
    }

    @Nonnull
    @ApiModelProperty(required=true, value="")
    public V2MetricTarget getTarget() {
        return this.target;
    }

    public void setTarget(@Nonnull V2MetricTarget target) {
        this.target = target;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        V2ObjectMetricSource v2ObjectMetricSource = (V2ObjectMetricSource)o;
        return Objects.equals(this.describedObject, v2ObjectMetricSource.describedObject) && Objects.equals(this.metric, v2ObjectMetricSource.metric) && Objects.equals(this.target, v2ObjectMetricSource.target);
    }

    public int hashCode() {
        return Objects.hash(this.describedObject, this.metric, this.target);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class V2ObjectMetricSource {\n");
        sb.append("    describedObject: ").append(this.toIndentedString(this.describedObject)).append("\n");
        sb.append("    metric: ").append(this.toIndentedString(this.metric)).append("\n");
        sb.append("    target: ").append(this.toIndentedString(this.target)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    public static void validateJsonElement(JsonElement jsonElement) throws IOException {
        if (jsonElement == null && !openapiRequiredFields.isEmpty()) {
            throw new IllegalArgumentException(String.format("The required field(s) %s in V2ObjectMetricSource is not found in the empty JSON string", openapiRequiredFields.toString()));
        }
        Set entries = jsonElement.getAsJsonObject().entrySet();
        for (Map.Entry entry : entries) {
            if (openapiFields.contains(entry.getKey())) continue;
            throw new IllegalArgumentException(String.format("The field `%s` in the JSON string is not defined in the `V2ObjectMetricSource` properties. JSON: %s", entry.getKey(), jsonElement.toString()));
        }
        for (String requiredField : openapiRequiredFields) {
            if (jsonElement.getAsJsonObject().get(requiredField) != null) continue;
            throw new IllegalArgumentException(String.format("The required field `%s` is not found in the JSON string: %s", requiredField, jsonElement.toString()));
        }
        JsonObject jsonObj = jsonElement.getAsJsonObject();
        V2CrossVersionObjectReference.validateJsonElement(jsonObj.get(SERIALIZED_NAME_DESCRIBED_OBJECT));
        V2MetricIdentifier.validateJsonElement(jsonObj.get(SERIALIZED_NAME_METRIC));
        V2MetricTarget.validateJsonElement(jsonObj.get(SERIALIZED_NAME_TARGET));
    }

    public static V2ObjectMetricSource fromJson(String jsonString) throws IOException {
        return (V2ObjectMetricSource)JSON.getGson().fromJson(jsonString, V2ObjectMetricSource.class);
    }

    public String toJson() {
        return JSON.getGson().toJson((Object)this);
    }

    static {
        openapiFields.add(SERIALIZED_NAME_DESCRIBED_OBJECT);
        openapiFields.add(SERIALIZED_NAME_METRIC);
        openapiFields.add(SERIALIZED_NAME_TARGET);
        openapiRequiredFields = new HashSet();
        openapiRequiredFields.add(SERIALIZED_NAME_DESCRIBED_OBJECT);
        openapiRequiredFields.add(SERIALIZED_NAME_METRIC);
        openapiRequiredFields.add(SERIALIZED_NAME_TARGET);
    }

    public static class CustomTypeAdapterFactory
    implements TypeAdapterFactory {
        public <T> TypeAdapter<T> create(Gson gson, TypeToken<T> type) {
            if (!V2ObjectMetricSource.class.isAssignableFrom(type.getRawType())) {
                return null;
            }
            final TypeAdapter elementAdapter = gson.getAdapter(JsonElement.class);
            final TypeAdapter thisAdapter = gson.getDelegateAdapter((TypeAdapterFactory)this, TypeToken.get(V2ObjectMetricSource.class));
            return new TypeAdapter<V2ObjectMetricSource>(){

                public void write(JsonWriter out, V2ObjectMetricSource value) throws IOException {
                    JsonObject obj = thisAdapter.toJsonTree((Object)value).getAsJsonObject();
                    elementAdapter.write(out, (Object)obj);
                }

                public V2ObjectMetricSource read(JsonReader in) throws IOException {
                    JsonElement jsonElement = (JsonElement)elementAdapter.read(in);
                    V2ObjectMetricSource.validateJsonElement(jsonElement);
                    return (V2ObjectMetricSource)thisAdapter.fromJsonTree(jsonElement);
                }
            }.nullSafe();
        }
    }
}

