/*
 * Decompiled with CFR 0.152.
 */
package io.kubernetes.client.openapi.models;

import io.kubernetes.client.fluent.BaseFluent;
import io.kubernetes.client.fluent.Nested;
import io.kubernetes.client.openapi.models.V2HorizontalPodAutoscalerCondition;
import io.kubernetes.client.openapi.models.V2HorizontalPodAutoscalerConditionBuilder;
import io.kubernetes.client.openapi.models.V2HorizontalPodAutoscalerConditionFluent;
import io.kubernetes.client.openapi.models.V2HorizontalPodAutoscalerStatus;
import io.kubernetes.client.openapi.models.V2MetricStatus;
import io.kubernetes.client.openapi.models.V2MetricStatusBuilder;
import io.kubernetes.client.openapi.models.V2MetricStatusFluent;
import java.time.OffsetDateTime;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Objects;
import java.util.function.Predicate;

public class V2HorizontalPodAutoscalerStatusFluent<A extends V2HorizontalPodAutoscalerStatusFluent<A>>
extends BaseFluent<A> {
    private ArrayList<V2HorizontalPodAutoscalerConditionBuilder> conditions;
    private ArrayList<V2MetricStatusBuilder> currentMetrics;
    private Integer currentReplicas;
    private Integer desiredReplicas;
    private OffsetDateTime lastScaleTime;
    private Long observedGeneration;

    public V2HorizontalPodAutoscalerStatusFluent() {
    }

    public V2HorizontalPodAutoscalerStatusFluent(V2HorizontalPodAutoscalerStatus instance) {
        this.copyInstance(instance);
    }

    protected void copyInstance(V2HorizontalPodAutoscalerStatus instance) {
        V2HorizontalPodAutoscalerStatus v2HorizontalPodAutoscalerStatus = instance = instance != null ? instance : new V2HorizontalPodAutoscalerStatus();
        if (instance != null) {
            this.withConditions(instance.getConditions());
            this.withCurrentMetrics(instance.getCurrentMetrics());
            this.withCurrentReplicas(instance.getCurrentReplicas());
            this.withDesiredReplicas(instance.getDesiredReplicas());
            this.withLastScaleTime(instance.getLastScaleTime());
            this.withObservedGeneration(instance.getObservedGeneration());
        }
    }

    public A addToConditions(int index, V2HorizontalPodAutoscalerCondition item) {
        if (this.conditions == null) {
            this.conditions = new ArrayList();
        }
        V2HorizontalPodAutoscalerConditionBuilder builder = new V2HorizontalPodAutoscalerConditionBuilder(item);
        if (index < 0 || index >= this.conditions.size()) {
            this._visitables.get("conditions").add(builder);
            this.conditions.add(builder);
        } else {
            this._visitables.get("conditions").add(builder);
            this.conditions.add(index, builder);
        }
        return (A)this;
    }

    public A setToConditions(int index, V2HorizontalPodAutoscalerCondition item) {
        if (this.conditions == null) {
            this.conditions = new ArrayList();
        }
        V2HorizontalPodAutoscalerConditionBuilder builder = new V2HorizontalPodAutoscalerConditionBuilder(item);
        if (index < 0 || index >= this.conditions.size()) {
            this._visitables.get("conditions").add(builder);
            this.conditions.add(builder);
        } else {
            this._visitables.get("conditions").add(builder);
            this.conditions.set(index, builder);
        }
        return (A)this;
    }

    public A addToConditions(V2HorizontalPodAutoscalerCondition ... items) {
        if (this.conditions == null) {
            this.conditions = new ArrayList();
        }
        for (V2HorizontalPodAutoscalerCondition item : items) {
            V2HorizontalPodAutoscalerConditionBuilder builder = new V2HorizontalPodAutoscalerConditionBuilder(item);
            this._visitables.get("conditions").add(builder);
            this.conditions.add(builder);
        }
        return (A)this;
    }

    public A addAllToConditions(Collection<V2HorizontalPodAutoscalerCondition> items) {
        if (this.conditions == null) {
            this.conditions = new ArrayList();
        }
        for (V2HorizontalPodAutoscalerCondition item : items) {
            V2HorizontalPodAutoscalerConditionBuilder builder = new V2HorizontalPodAutoscalerConditionBuilder(item);
            this._visitables.get("conditions").add(builder);
            this.conditions.add(builder);
        }
        return (A)this;
    }

    public A removeFromConditions(V2HorizontalPodAutoscalerCondition ... items) {
        if (this.conditions == null) {
            return (A)this;
        }
        for (V2HorizontalPodAutoscalerCondition item : items) {
            V2HorizontalPodAutoscalerConditionBuilder builder = new V2HorizontalPodAutoscalerConditionBuilder(item);
            this._visitables.get("conditions").remove(builder);
            this.conditions.remove(builder);
        }
        return (A)this;
    }

    public A removeAllFromConditions(Collection<V2HorizontalPodAutoscalerCondition> items) {
        if (this.conditions == null) {
            return (A)this;
        }
        for (V2HorizontalPodAutoscalerCondition item : items) {
            V2HorizontalPodAutoscalerConditionBuilder builder = new V2HorizontalPodAutoscalerConditionBuilder(item);
            this._visitables.get("conditions").remove(builder);
            this.conditions.remove(builder);
        }
        return (A)this;
    }

    public A removeMatchingFromConditions(Predicate<V2HorizontalPodAutoscalerConditionBuilder> predicate) {
        if (this.conditions == null) {
            return (A)this;
        }
        Iterator<V2HorizontalPodAutoscalerConditionBuilder> each = this.conditions.iterator();
        Object visitables = this._visitables.get("conditions");
        while (each.hasNext()) {
            V2HorizontalPodAutoscalerConditionBuilder builder = each.next();
            if (!predicate.test(builder)) continue;
            visitables.remove(builder);
            each.remove();
        }
        return (A)this;
    }

    public List<V2HorizontalPodAutoscalerCondition> buildConditions() {
        return this.conditions != null ? V2HorizontalPodAutoscalerStatusFluent.build(this.conditions) : null;
    }

    public V2HorizontalPodAutoscalerCondition buildCondition(int index) {
        return this.conditions.get(index).build();
    }

    public V2HorizontalPodAutoscalerCondition buildFirstCondition() {
        return this.conditions.get(0).build();
    }

    public V2HorizontalPodAutoscalerCondition buildLastCondition() {
        return this.conditions.get(this.conditions.size() - 1).build();
    }

    public V2HorizontalPodAutoscalerCondition buildMatchingCondition(Predicate<V2HorizontalPodAutoscalerConditionBuilder> predicate) {
        for (V2HorizontalPodAutoscalerConditionBuilder item : this.conditions) {
            if (!predicate.test(item)) continue;
            return item.build();
        }
        return null;
    }

    public boolean hasMatchingCondition(Predicate<V2HorizontalPodAutoscalerConditionBuilder> predicate) {
        for (V2HorizontalPodAutoscalerConditionBuilder item : this.conditions) {
            if (!predicate.test(item)) continue;
            return true;
        }
        return false;
    }

    public A withConditions(List<V2HorizontalPodAutoscalerCondition> conditions) {
        if (this.conditions != null) {
            this._visitables.get("conditions").clear();
        }
        if (conditions != null) {
            this.conditions = new ArrayList();
            for (V2HorizontalPodAutoscalerCondition item : conditions) {
                this.addToConditions(item);
            }
        } else {
            this.conditions = null;
        }
        return (A)this;
    }

    public A withConditions(V2HorizontalPodAutoscalerCondition ... conditions) {
        if (this.conditions != null) {
            this.conditions.clear();
            this._visitables.remove("conditions");
        }
        if (conditions != null) {
            for (V2HorizontalPodAutoscalerCondition item : conditions) {
                this.addToConditions(item);
            }
        }
        return (A)this;
    }

    public boolean hasConditions() {
        return this.conditions != null && !this.conditions.isEmpty();
    }

    public ConditionsNested<A> addNewCondition() {
        return new ConditionsNested(-1, null);
    }

    public ConditionsNested<A> addNewConditionLike(V2HorizontalPodAutoscalerCondition item) {
        return new ConditionsNested(-1, item);
    }

    public ConditionsNested<A> setNewConditionLike(int index, V2HorizontalPodAutoscalerCondition item) {
        return new ConditionsNested(index, item);
    }

    public ConditionsNested<A> editCondition(int index) {
        if (this.conditions.size() <= index) {
            throw new RuntimeException("Can't edit conditions. Index exceeds size.");
        }
        return this.setNewConditionLike(index, this.buildCondition(index));
    }

    public ConditionsNested<A> editFirstCondition() {
        if (this.conditions.size() == 0) {
            throw new RuntimeException("Can't edit first conditions. The list is empty.");
        }
        return this.setNewConditionLike(0, this.buildCondition(0));
    }

    public ConditionsNested<A> editLastCondition() {
        int index = this.conditions.size() - 1;
        if (index < 0) {
            throw new RuntimeException("Can't edit last conditions. The list is empty.");
        }
        return this.setNewConditionLike(index, this.buildCondition(index));
    }

    public ConditionsNested<A> editMatchingCondition(Predicate<V2HorizontalPodAutoscalerConditionBuilder> predicate) {
        int index = -1;
        for (int i = 0; i < this.conditions.size(); ++i) {
            if (!predicate.test(this.conditions.get(i))) continue;
            index = i;
            break;
        }
        if (index < 0) {
            throw new RuntimeException("Can't edit matching conditions. No match found.");
        }
        return this.setNewConditionLike(index, this.buildCondition(index));
    }

    public A addToCurrentMetrics(int index, V2MetricStatus item) {
        if (this.currentMetrics == null) {
            this.currentMetrics = new ArrayList();
        }
        V2MetricStatusBuilder builder = new V2MetricStatusBuilder(item);
        if (index < 0 || index >= this.currentMetrics.size()) {
            this._visitables.get("currentMetrics").add(builder);
            this.currentMetrics.add(builder);
        } else {
            this._visitables.get("currentMetrics").add(builder);
            this.currentMetrics.add(index, builder);
        }
        return (A)this;
    }

    public A setToCurrentMetrics(int index, V2MetricStatus item) {
        if (this.currentMetrics == null) {
            this.currentMetrics = new ArrayList();
        }
        V2MetricStatusBuilder builder = new V2MetricStatusBuilder(item);
        if (index < 0 || index >= this.currentMetrics.size()) {
            this._visitables.get("currentMetrics").add(builder);
            this.currentMetrics.add(builder);
        } else {
            this._visitables.get("currentMetrics").add(builder);
            this.currentMetrics.set(index, builder);
        }
        return (A)this;
    }

    public A addToCurrentMetrics(V2MetricStatus ... items) {
        if (this.currentMetrics == null) {
            this.currentMetrics = new ArrayList();
        }
        for (V2MetricStatus item : items) {
            V2MetricStatusBuilder builder = new V2MetricStatusBuilder(item);
            this._visitables.get("currentMetrics").add(builder);
            this.currentMetrics.add(builder);
        }
        return (A)this;
    }

    public A addAllToCurrentMetrics(Collection<V2MetricStatus> items) {
        if (this.currentMetrics == null) {
            this.currentMetrics = new ArrayList();
        }
        for (V2MetricStatus item : items) {
            V2MetricStatusBuilder builder = new V2MetricStatusBuilder(item);
            this._visitables.get("currentMetrics").add(builder);
            this.currentMetrics.add(builder);
        }
        return (A)this;
    }

    public A removeFromCurrentMetrics(V2MetricStatus ... items) {
        if (this.currentMetrics == null) {
            return (A)this;
        }
        for (V2MetricStatus item : items) {
            V2MetricStatusBuilder builder = new V2MetricStatusBuilder(item);
            this._visitables.get("currentMetrics").remove(builder);
            this.currentMetrics.remove(builder);
        }
        return (A)this;
    }

    public A removeAllFromCurrentMetrics(Collection<V2MetricStatus> items) {
        if (this.currentMetrics == null) {
            return (A)this;
        }
        for (V2MetricStatus item : items) {
            V2MetricStatusBuilder builder = new V2MetricStatusBuilder(item);
            this._visitables.get("currentMetrics").remove(builder);
            this.currentMetrics.remove(builder);
        }
        return (A)this;
    }

    public A removeMatchingFromCurrentMetrics(Predicate<V2MetricStatusBuilder> predicate) {
        if (this.currentMetrics == null) {
            return (A)this;
        }
        Iterator<V2MetricStatusBuilder> each = this.currentMetrics.iterator();
        Object visitables = this._visitables.get("currentMetrics");
        while (each.hasNext()) {
            V2MetricStatusBuilder builder = each.next();
            if (!predicate.test(builder)) continue;
            visitables.remove(builder);
            each.remove();
        }
        return (A)this;
    }

    public List<V2MetricStatus> buildCurrentMetrics() {
        return this.currentMetrics != null ? V2HorizontalPodAutoscalerStatusFluent.build(this.currentMetrics) : null;
    }

    public V2MetricStatus buildCurrentMetric(int index) {
        return this.currentMetrics.get(index).build();
    }

    public V2MetricStatus buildFirstCurrentMetric() {
        return this.currentMetrics.get(0).build();
    }

    public V2MetricStatus buildLastCurrentMetric() {
        return this.currentMetrics.get(this.currentMetrics.size() - 1).build();
    }

    public V2MetricStatus buildMatchingCurrentMetric(Predicate<V2MetricStatusBuilder> predicate) {
        for (V2MetricStatusBuilder item : this.currentMetrics) {
            if (!predicate.test(item)) continue;
            return item.build();
        }
        return null;
    }

    public boolean hasMatchingCurrentMetric(Predicate<V2MetricStatusBuilder> predicate) {
        for (V2MetricStatusBuilder item : this.currentMetrics) {
            if (!predicate.test(item)) continue;
            return true;
        }
        return false;
    }

    public A withCurrentMetrics(List<V2MetricStatus> currentMetrics) {
        if (this.currentMetrics != null) {
            this._visitables.get("currentMetrics").clear();
        }
        if (currentMetrics != null) {
            this.currentMetrics = new ArrayList();
            for (V2MetricStatus item : currentMetrics) {
                this.addToCurrentMetrics(item);
            }
        } else {
            this.currentMetrics = null;
        }
        return (A)this;
    }

    public A withCurrentMetrics(V2MetricStatus ... currentMetrics) {
        if (this.currentMetrics != null) {
            this.currentMetrics.clear();
            this._visitables.remove("currentMetrics");
        }
        if (currentMetrics != null) {
            for (V2MetricStatus item : currentMetrics) {
                this.addToCurrentMetrics(item);
            }
        }
        return (A)this;
    }

    public boolean hasCurrentMetrics() {
        return this.currentMetrics != null && !this.currentMetrics.isEmpty();
    }

    public CurrentMetricsNested<A> addNewCurrentMetric() {
        return new CurrentMetricsNested(-1, null);
    }

    public CurrentMetricsNested<A> addNewCurrentMetricLike(V2MetricStatus item) {
        return new CurrentMetricsNested(-1, item);
    }

    public CurrentMetricsNested<A> setNewCurrentMetricLike(int index, V2MetricStatus item) {
        return new CurrentMetricsNested(index, item);
    }

    public CurrentMetricsNested<A> editCurrentMetric(int index) {
        if (this.currentMetrics.size() <= index) {
            throw new RuntimeException("Can't edit currentMetrics. Index exceeds size.");
        }
        return this.setNewCurrentMetricLike(index, this.buildCurrentMetric(index));
    }

    public CurrentMetricsNested<A> editFirstCurrentMetric() {
        if (this.currentMetrics.size() == 0) {
            throw new RuntimeException("Can't edit first currentMetrics. The list is empty.");
        }
        return this.setNewCurrentMetricLike(0, this.buildCurrentMetric(0));
    }

    public CurrentMetricsNested<A> editLastCurrentMetric() {
        int index = this.currentMetrics.size() - 1;
        if (index < 0) {
            throw new RuntimeException("Can't edit last currentMetrics. The list is empty.");
        }
        return this.setNewCurrentMetricLike(index, this.buildCurrentMetric(index));
    }

    public CurrentMetricsNested<A> editMatchingCurrentMetric(Predicate<V2MetricStatusBuilder> predicate) {
        int index = -1;
        for (int i = 0; i < this.currentMetrics.size(); ++i) {
            if (!predicate.test(this.currentMetrics.get(i))) continue;
            index = i;
            break;
        }
        if (index < 0) {
            throw new RuntimeException("Can't edit matching currentMetrics. No match found.");
        }
        return this.setNewCurrentMetricLike(index, this.buildCurrentMetric(index));
    }

    public Integer getCurrentReplicas() {
        return this.currentReplicas;
    }

    public A withCurrentReplicas(Integer currentReplicas) {
        this.currentReplicas = currentReplicas;
        return (A)this;
    }

    public boolean hasCurrentReplicas() {
        return this.currentReplicas != null;
    }

    public Integer getDesiredReplicas() {
        return this.desiredReplicas;
    }

    public A withDesiredReplicas(Integer desiredReplicas) {
        this.desiredReplicas = desiredReplicas;
        return (A)this;
    }

    public boolean hasDesiredReplicas() {
        return this.desiredReplicas != null;
    }

    public OffsetDateTime getLastScaleTime() {
        return this.lastScaleTime;
    }

    public A withLastScaleTime(OffsetDateTime lastScaleTime) {
        this.lastScaleTime = lastScaleTime;
        return (A)this;
    }

    public boolean hasLastScaleTime() {
        return this.lastScaleTime != null;
    }

    public Long getObservedGeneration() {
        return this.observedGeneration;
    }

    public A withObservedGeneration(Long observedGeneration) {
        this.observedGeneration = observedGeneration;
        return (A)this;
    }

    public boolean hasObservedGeneration() {
        return this.observedGeneration != null;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        V2HorizontalPodAutoscalerStatusFluent that = (V2HorizontalPodAutoscalerStatusFluent)o;
        if (!Objects.equals(this.conditions, that.conditions)) {
            return false;
        }
        if (!Objects.equals(this.currentMetrics, that.currentMetrics)) {
            return false;
        }
        if (!Objects.equals(this.currentReplicas, that.currentReplicas)) {
            return false;
        }
        if (!Objects.equals(this.desiredReplicas, that.desiredReplicas)) {
            return false;
        }
        if (!Objects.equals(this.lastScaleTime, that.lastScaleTime)) {
            return false;
        }
        return Objects.equals(this.observedGeneration, that.observedGeneration);
    }

    @Override
    public int hashCode() {
        return Objects.hash(this.conditions, this.currentMetrics, this.currentReplicas, this.desiredReplicas, this.lastScaleTime, this.observedGeneration, super.hashCode());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.conditions != null && !this.conditions.isEmpty()) {
            sb.append("conditions:");
            sb.append(String.valueOf(this.conditions) + ",");
        }
        if (this.currentMetrics != null && !this.currentMetrics.isEmpty()) {
            sb.append("currentMetrics:");
            sb.append(String.valueOf(this.currentMetrics) + ",");
        }
        if (this.currentReplicas != null) {
            sb.append("currentReplicas:");
            sb.append(this.currentReplicas + ",");
        }
        if (this.desiredReplicas != null) {
            sb.append("desiredReplicas:");
            sb.append(this.desiredReplicas + ",");
        }
        if (this.lastScaleTime != null) {
            sb.append("lastScaleTime:");
            sb.append(String.valueOf(this.lastScaleTime) + ",");
        }
        if (this.observedGeneration != null) {
            sb.append("observedGeneration:");
            sb.append(this.observedGeneration);
        }
        sb.append("}");
        return sb.toString();
    }

    public class ConditionsNested<N>
    extends V2HorizontalPodAutoscalerConditionFluent<ConditionsNested<N>>
    implements Nested<N> {
        V2HorizontalPodAutoscalerConditionBuilder builder;
        int index;

        ConditionsNested(int index, V2HorizontalPodAutoscalerCondition item) {
            this.index = index;
            this.builder = new V2HorizontalPodAutoscalerConditionBuilder(this, item);
        }

        @Override
        public N and() {
            return (N)V2HorizontalPodAutoscalerStatusFluent.this.setToConditions(this.index, this.builder.build());
        }

        public N endCondition() {
            return this.and();
        }
    }

    public class CurrentMetricsNested<N>
    extends V2MetricStatusFluent<CurrentMetricsNested<N>>
    implements Nested<N> {
        V2MetricStatusBuilder builder;
        int index;

        CurrentMetricsNested(int index, V2MetricStatus item) {
            this.index = index;
            this.builder = new V2MetricStatusBuilder(this, item);
        }

        @Override
        public N and() {
            return (N)V2HorizontalPodAutoscalerStatusFluent.this.setToCurrentMetrics(this.index, this.builder.build());
        }

        public N endCurrentMetric() {
            return this.and();
        }
    }
}

