/*
 * Decompiled with CFR 0.152.
 */
package io.kubernetes.client.openapi.models;

import io.kubernetes.client.custom.IntOrString;
import io.kubernetes.client.fluent.BaseFluent;
import io.kubernetes.client.openapi.models.V1TCPSocketAction;
import java.util.Objects;

public class V1TCPSocketActionFluent<A extends V1TCPSocketActionFluent<A>>
extends BaseFluent<A> {
    private String host;
    private IntOrString port;

    public V1TCPSocketActionFluent() {
    }

    public V1TCPSocketActionFluent(V1TCPSocketAction instance) {
        this.copyInstance(instance);
    }

    protected void copyInstance(V1TCPSocketAction instance) {
        V1TCPSocketAction v1TCPSocketAction = instance = instance != null ? instance : new V1TCPSocketAction();
        if (instance != null) {
            this.withHost(instance.getHost());
            this.withPort(instance.getPort());
        }
    }

    public String getHost() {
        return this.host;
    }

    public A withHost(String host) {
        this.host = host;
        return (A)this;
    }

    public boolean hasHost() {
        return this.host != null;
    }

    public IntOrString getPort() {
        return this.port;
    }

    public A withPort(IntOrString port) {
        this.port = port;
        return (A)this;
    }

    public boolean hasPort() {
        return this.port != null;
    }

    public A withNewPort(int value) {
        return this.withPort(new IntOrString(value));
    }

    public A withNewPort(String value) {
        return this.withPort(new IntOrString(value));
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        V1TCPSocketActionFluent that = (V1TCPSocketActionFluent)o;
        if (!Objects.equals(this.host, that.host)) {
            return false;
        }
        return Objects.equals(this.port, that.port);
    }

    @Override
    public int hashCode() {
        return Objects.hash(this.host, this.port, super.hashCode());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.host != null) {
            sb.append("host:");
            sb.append(this.host + ",");
        }
        if (this.port != null) {
            sb.append("port:");
            sb.append(this.port);
        }
        sb.append("}");
        return sb.toString();
    }
}

