/*
 * Decompiled with CFR 0.152.
 */
package io.kubernetes.client.openapi.models;

import com.google.gson.Gson;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.TypeAdapter;
import com.google.gson.TypeAdapterFactory;
import com.google.gson.annotations.SerializedName;
import com.google.gson.reflect.TypeToken;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonWriter;
import io.kubernetes.client.common.KubernetesObject;
import io.kubernetes.client.openapi.JSON;
import io.kubernetes.client.openapi.models.V1ObjectMeta;
import io.kubernetes.client.openapi.models.V1TopologySelectorTerm;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import jakarta.annotation.Nonnull;
import jakarta.annotation.Nullable;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;

@ApiModel(description="StorageClass describes the parameters for a class of storage for which PersistentVolumes can be dynamically provisioned.  StorageClasses are non-namespaced; the name of the storage class according to etcd is in ObjectMeta.Name.")
public class V1StorageClass
implements KubernetesObject {
    public static final String SERIALIZED_NAME_ALLOW_VOLUME_EXPANSION = "allowVolumeExpansion";
    @SerializedName(value="allowVolumeExpansion")
    @Nullable
    private Boolean allowVolumeExpansion;
    public static final String SERIALIZED_NAME_ALLOWED_TOPOLOGIES = "allowedTopologies";
    @SerializedName(value="allowedTopologies")
    @Nullable
    private List<V1TopologySelectorTerm> allowedTopologies = new ArrayList<V1TopologySelectorTerm>();
    public static final String SERIALIZED_NAME_API_VERSION = "apiVersion";
    @SerializedName(value="apiVersion")
    @Nullable
    private String apiVersion;
    public static final String SERIALIZED_NAME_KIND = "kind";
    @SerializedName(value="kind")
    @Nullable
    private String kind;
    public static final String SERIALIZED_NAME_METADATA = "metadata";
    @SerializedName(value="metadata")
    @Nullable
    private V1ObjectMeta metadata;
    public static final String SERIALIZED_NAME_MOUNT_OPTIONS = "mountOptions";
    @SerializedName(value="mountOptions")
    @Nullable
    private List<String> mountOptions = new ArrayList<String>();
    public static final String SERIALIZED_NAME_PARAMETERS = "parameters";
    @SerializedName(value="parameters")
    @Nullable
    private Map<String, String> parameters = new HashMap<String, String>();
    public static final String SERIALIZED_NAME_PROVISIONER = "provisioner";
    @SerializedName(value="provisioner")
    @Nonnull
    private String provisioner;
    public static final String SERIALIZED_NAME_RECLAIM_POLICY = "reclaimPolicy";
    @SerializedName(value="reclaimPolicy")
    @Nullable
    private String reclaimPolicy;
    public static final String SERIALIZED_NAME_VOLUME_BINDING_MODE = "volumeBindingMode";
    @SerializedName(value="volumeBindingMode")
    @Nullable
    private String volumeBindingMode;
    public static HashSet<String> openapiFields = new HashSet();
    public static HashSet<String> openapiRequiredFields;

    public V1StorageClass allowVolumeExpansion(@Nullable Boolean allowVolumeExpansion) {
        this.allowVolumeExpansion = allowVolumeExpansion;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="allowVolumeExpansion shows whether the storage class allow volume expand.")
    public Boolean getAllowVolumeExpansion() {
        return this.allowVolumeExpansion;
    }

    public void setAllowVolumeExpansion(@Nullable Boolean allowVolumeExpansion) {
        this.allowVolumeExpansion = allowVolumeExpansion;
    }

    public V1StorageClass allowedTopologies(@Nullable List<V1TopologySelectorTerm> allowedTopologies) {
        this.allowedTopologies = allowedTopologies;
        return this;
    }

    public V1StorageClass addAllowedTopologiesItem(V1TopologySelectorTerm allowedTopologiesItem) {
        if (this.allowedTopologies == null) {
            this.allowedTopologies = new ArrayList<V1TopologySelectorTerm>();
        }
        this.allowedTopologies.add(allowedTopologiesItem);
        return this;
    }

    @Nullable
    @ApiModelProperty(value="allowedTopologies restrict the node topologies where volumes can be dynamically provisioned. Each volume plugin defines its own supported topology specifications. An empty TopologySelectorTerm list means there is no topology restriction. This field is only honored by servers that enable the VolumeScheduling feature.")
    public List<V1TopologySelectorTerm> getAllowedTopologies() {
        return this.allowedTopologies;
    }

    public void setAllowedTopologies(@Nullable List<V1TopologySelectorTerm> allowedTopologies) {
        this.allowedTopologies = allowedTopologies;
    }

    public V1StorageClass apiVersion(@Nullable String apiVersion) {
        this.apiVersion = apiVersion;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="APIVersion defines the versioned schema of this representation of an object. Servers should convert recognized schemas to the latest internal value, and may reject unrecognized values. More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#resources")
    public String getApiVersion() {
        return this.apiVersion;
    }

    public void setApiVersion(@Nullable String apiVersion) {
        this.apiVersion = apiVersion;
    }

    public V1StorageClass kind(@Nullable String kind) {
        this.kind = kind;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Kind is a string value representing the REST resource this object represents. Servers may infer this from the endpoint the client submits requests to. Cannot be updated. In CamelCase. More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#types-kinds")
    public String getKind() {
        return this.kind;
    }

    public void setKind(@Nullable String kind) {
        this.kind = kind;
    }

    public V1StorageClass metadata(@Nullable V1ObjectMeta metadata) {
        this.metadata = metadata;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="")
    public V1ObjectMeta getMetadata() {
        return this.metadata;
    }

    public void setMetadata(@Nullable V1ObjectMeta metadata) {
        this.metadata = metadata;
    }

    public V1StorageClass mountOptions(@Nullable List<String> mountOptions) {
        this.mountOptions = mountOptions;
        return this;
    }

    public V1StorageClass addMountOptionsItem(String mountOptionsItem) {
        if (this.mountOptions == null) {
            this.mountOptions = new ArrayList<String>();
        }
        this.mountOptions.add(mountOptionsItem);
        return this;
    }

    @Nullable
    @ApiModelProperty(value="mountOptions controls the mountOptions for dynamically provisioned PersistentVolumes of this storage class. e.g. [\"ro\", \"soft\"]. Not validated - mount of the PVs will simply fail if one is invalid.")
    public List<String> getMountOptions() {
        return this.mountOptions;
    }

    public void setMountOptions(@Nullable List<String> mountOptions) {
        this.mountOptions = mountOptions;
    }

    public V1StorageClass parameters(@Nullable Map<String, String> parameters) {
        this.parameters = parameters;
        return this;
    }

    public V1StorageClass putParametersItem(String key, String parametersItem) {
        if (this.parameters == null) {
            this.parameters = new HashMap<String, String>();
        }
        this.parameters.put(key, parametersItem);
        return this;
    }

    @Nullable
    @ApiModelProperty(value="parameters holds the parameters for the provisioner that should create volumes of this storage class.")
    public Map<String, String> getParameters() {
        return this.parameters;
    }

    public void setParameters(@Nullable Map<String, String> parameters) {
        this.parameters = parameters;
    }

    public V1StorageClass provisioner(@Nonnull String provisioner) {
        this.provisioner = provisioner;
        return this;
    }

    @Nonnull
    @ApiModelProperty(required=true, value="provisioner indicates the type of the provisioner.")
    public String getProvisioner() {
        return this.provisioner;
    }

    public void setProvisioner(@Nonnull String provisioner) {
        this.provisioner = provisioner;
    }

    public V1StorageClass reclaimPolicy(@Nullable String reclaimPolicy) {
        this.reclaimPolicy = reclaimPolicy;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="reclaimPolicy controls the reclaimPolicy for dynamically provisioned PersistentVolumes of this storage class. Defaults to Delete.")
    public String getReclaimPolicy() {
        return this.reclaimPolicy;
    }

    public void setReclaimPolicy(@Nullable String reclaimPolicy) {
        this.reclaimPolicy = reclaimPolicy;
    }

    public V1StorageClass volumeBindingMode(@Nullable String volumeBindingMode) {
        this.volumeBindingMode = volumeBindingMode;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="volumeBindingMode indicates how PersistentVolumeClaims should be provisioned and bound.  When unset, VolumeBindingImmediate is used. This field is only honored by servers that enable the VolumeScheduling feature.")
    public String getVolumeBindingMode() {
        return this.volumeBindingMode;
    }

    public void setVolumeBindingMode(@Nullable String volumeBindingMode) {
        this.volumeBindingMode = volumeBindingMode;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        V1StorageClass v1StorageClass = (V1StorageClass)o;
        return Objects.equals(this.allowVolumeExpansion, v1StorageClass.allowVolumeExpansion) && Objects.equals(this.allowedTopologies, v1StorageClass.allowedTopologies) && Objects.equals(this.apiVersion, v1StorageClass.apiVersion) && Objects.equals(this.kind, v1StorageClass.kind) && Objects.equals(this.metadata, v1StorageClass.metadata) && Objects.equals(this.mountOptions, v1StorageClass.mountOptions) && Objects.equals(this.parameters, v1StorageClass.parameters) && Objects.equals(this.provisioner, v1StorageClass.provisioner) && Objects.equals(this.reclaimPolicy, v1StorageClass.reclaimPolicy) && Objects.equals(this.volumeBindingMode, v1StorageClass.volumeBindingMode);
    }

    public int hashCode() {
        return Objects.hash(this.allowVolumeExpansion, this.allowedTopologies, this.apiVersion, this.kind, this.metadata, this.mountOptions, this.parameters, this.provisioner, this.reclaimPolicy, this.volumeBindingMode);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class V1StorageClass {\n");
        sb.append("    allowVolumeExpansion: ").append(this.toIndentedString(this.allowVolumeExpansion)).append("\n");
        sb.append("    allowedTopologies: ").append(this.toIndentedString(this.allowedTopologies)).append("\n");
        sb.append("    apiVersion: ").append(this.toIndentedString(this.apiVersion)).append("\n");
        sb.append("    kind: ").append(this.toIndentedString(this.kind)).append("\n");
        sb.append("    metadata: ").append(this.toIndentedString(this.metadata)).append("\n");
        sb.append("    mountOptions: ").append(this.toIndentedString(this.mountOptions)).append("\n");
        sb.append("    parameters: ").append(this.toIndentedString(this.parameters)).append("\n");
        sb.append("    provisioner: ").append(this.toIndentedString(this.provisioner)).append("\n");
        sb.append("    reclaimPolicy: ").append(this.toIndentedString(this.reclaimPolicy)).append("\n");
        sb.append("    volumeBindingMode: ").append(this.toIndentedString(this.volumeBindingMode)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    public static void validateJsonElement(JsonElement jsonElement) throws IOException {
        JsonArray jsonArrayallowedTopologies;
        if (jsonElement == null && !openapiRequiredFields.isEmpty()) {
            throw new IllegalArgumentException(String.format("The required field(s) %s in V1StorageClass is not found in the empty JSON string", openapiRequiredFields.toString()));
        }
        Set entries = jsonElement.getAsJsonObject().entrySet();
        for (Map.Entry entry : entries) {
            if (openapiFields.contains(entry.getKey())) continue;
            throw new IllegalArgumentException(String.format("The field `%s` in the JSON string is not defined in the `V1StorageClass` properties. JSON: %s", entry.getKey(), jsonElement.toString()));
        }
        for (String requiredField : openapiRequiredFields) {
            if (jsonElement.getAsJsonObject().get(requiredField) != null) continue;
            throw new IllegalArgumentException(String.format("The required field `%s` is not found in the JSON string: %s", requiredField, jsonElement.toString()));
        }
        JsonObject jsonObj = jsonElement.getAsJsonObject();
        if (jsonObj.get(SERIALIZED_NAME_ALLOWED_TOPOLOGIES) != null && !jsonObj.get(SERIALIZED_NAME_ALLOWED_TOPOLOGIES).isJsonNull() && (jsonArrayallowedTopologies = jsonObj.getAsJsonArray(SERIALIZED_NAME_ALLOWED_TOPOLOGIES)) != null) {
            if (!jsonObj.get(SERIALIZED_NAME_ALLOWED_TOPOLOGIES).isJsonArray()) {
                throw new IllegalArgumentException(String.format("Expected the field `allowedTopologies` to be an array in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_ALLOWED_TOPOLOGIES).toString()));
            }
            for (int i = 0; i < jsonArrayallowedTopologies.size(); ++i) {
                V1TopologySelectorTerm.validateJsonElement(jsonArrayallowedTopologies.get(i));
            }
        }
        if (jsonObj.get(SERIALIZED_NAME_API_VERSION) != null && !jsonObj.get(SERIALIZED_NAME_API_VERSION).isJsonNull() && !jsonObj.get(SERIALIZED_NAME_API_VERSION).isJsonPrimitive()) {
            throw new IllegalArgumentException(String.format("Expected the field `apiVersion` to be a primitive type in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_API_VERSION).toString()));
        }
        if (jsonObj.get(SERIALIZED_NAME_KIND) != null && !jsonObj.get(SERIALIZED_NAME_KIND).isJsonNull() && !jsonObj.get(SERIALIZED_NAME_KIND).isJsonPrimitive()) {
            throw new IllegalArgumentException(String.format("Expected the field `kind` to be a primitive type in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_KIND).toString()));
        }
        if (jsonObj.get(SERIALIZED_NAME_METADATA) != null && !jsonObj.get(SERIALIZED_NAME_METADATA).isJsonNull()) {
            V1ObjectMeta.validateJsonElement(jsonObj.get(SERIALIZED_NAME_METADATA));
        }
        if (jsonObj.get(SERIALIZED_NAME_MOUNT_OPTIONS) != null && !jsonObj.get(SERIALIZED_NAME_MOUNT_OPTIONS).isJsonNull() && !jsonObj.get(SERIALIZED_NAME_MOUNT_OPTIONS).isJsonArray()) {
            throw new IllegalArgumentException(String.format("Expected the field `mountOptions` to be an array in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_MOUNT_OPTIONS).toString()));
        }
        if (!jsonObj.get(SERIALIZED_NAME_PROVISIONER).isJsonPrimitive()) {
            throw new IllegalArgumentException(String.format("Expected the field `provisioner` to be a primitive type in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_PROVISIONER).toString()));
        }
        if (jsonObj.get(SERIALIZED_NAME_RECLAIM_POLICY) != null && !jsonObj.get(SERIALIZED_NAME_RECLAIM_POLICY).isJsonNull() && !jsonObj.get(SERIALIZED_NAME_RECLAIM_POLICY).isJsonPrimitive()) {
            throw new IllegalArgumentException(String.format("Expected the field `reclaimPolicy` to be a primitive type in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_RECLAIM_POLICY).toString()));
        }
        if (jsonObj.get(SERIALIZED_NAME_VOLUME_BINDING_MODE) != null && !jsonObj.get(SERIALIZED_NAME_VOLUME_BINDING_MODE).isJsonNull() && !jsonObj.get(SERIALIZED_NAME_VOLUME_BINDING_MODE).isJsonPrimitive()) {
            throw new IllegalArgumentException(String.format("Expected the field `volumeBindingMode` to be a primitive type in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_VOLUME_BINDING_MODE).toString()));
        }
    }

    public static V1StorageClass fromJson(String jsonString) throws IOException {
        return (V1StorageClass)JSON.getGson().fromJson(jsonString, V1StorageClass.class);
    }

    public String toJson() {
        return JSON.getGson().toJson((Object)this);
    }

    static {
        openapiFields.add(SERIALIZED_NAME_ALLOW_VOLUME_EXPANSION);
        openapiFields.add(SERIALIZED_NAME_ALLOWED_TOPOLOGIES);
        openapiFields.add(SERIALIZED_NAME_API_VERSION);
        openapiFields.add(SERIALIZED_NAME_KIND);
        openapiFields.add(SERIALIZED_NAME_METADATA);
        openapiFields.add(SERIALIZED_NAME_MOUNT_OPTIONS);
        openapiFields.add(SERIALIZED_NAME_PARAMETERS);
        openapiFields.add(SERIALIZED_NAME_PROVISIONER);
        openapiFields.add(SERIALIZED_NAME_RECLAIM_POLICY);
        openapiFields.add(SERIALIZED_NAME_VOLUME_BINDING_MODE);
        openapiRequiredFields = new HashSet();
        openapiRequiredFields.add(SERIALIZED_NAME_PROVISIONER);
    }

    public static class CustomTypeAdapterFactory
    implements TypeAdapterFactory {
        public <T> TypeAdapter<T> create(Gson gson, TypeToken<T> type) {
            if (!V1StorageClass.class.isAssignableFrom(type.getRawType())) {
                return null;
            }
            final TypeAdapter elementAdapter = gson.getAdapter(JsonElement.class);
            final TypeAdapter thisAdapter = gson.getDelegateAdapter((TypeAdapterFactory)this, TypeToken.get(V1StorageClass.class));
            return new TypeAdapter<V1StorageClass>(){

                public void write(JsonWriter out, V1StorageClass value) throws IOException {
                    JsonObject obj = thisAdapter.toJsonTree((Object)value).getAsJsonObject();
                    elementAdapter.write(out, (Object)obj);
                }

                public V1StorageClass read(JsonReader in) throws IOException {
                    JsonElement jsonElement = (JsonElement)elementAdapter.read(in);
                    V1StorageClass.validateJsonElement(jsonElement);
                    return (V1StorageClass)thisAdapter.fromJsonTree(jsonElement);
                }
            }.nullSafe();
        }
    }
}

