/*
 * Decompiled with CFR 0.152.
 */
package io.kubernetes.client.openapi.models;

import io.kubernetes.client.fluent.BaseFluent;
import io.kubernetes.client.fluent.Nested;
import io.kubernetes.client.openapi.models.V1NetworkPolicyEgressRule;
import io.kubernetes.client.openapi.models.V1NetworkPolicyPeer;
import io.kubernetes.client.openapi.models.V1NetworkPolicyPeerBuilder;
import io.kubernetes.client.openapi.models.V1NetworkPolicyPeerFluent;
import io.kubernetes.client.openapi.models.V1NetworkPolicyPort;
import io.kubernetes.client.openapi.models.V1NetworkPolicyPortBuilder;
import io.kubernetes.client.openapi.models.V1NetworkPolicyPortFluent;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Objects;
import java.util.function.Predicate;

public class V1NetworkPolicyEgressRuleFluent<A extends V1NetworkPolicyEgressRuleFluent<A>>
extends BaseFluent<A> {
    private ArrayList<V1NetworkPolicyPortBuilder> ports;
    private ArrayList<V1NetworkPolicyPeerBuilder> to;

    public V1NetworkPolicyEgressRuleFluent() {
    }

    public V1NetworkPolicyEgressRuleFluent(V1NetworkPolicyEgressRule instance) {
        this.copyInstance(instance);
    }

    protected void copyInstance(V1NetworkPolicyEgressRule instance) {
        V1NetworkPolicyEgressRule v1NetworkPolicyEgressRule = instance = instance != null ? instance : new V1NetworkPolicyEgressRule();
        if (instance != null) {
            this.withPorts(instance.getPorts());
            this.withTo(instance.getTo());
        }
    }

    public A addToPorts(int index, V1NetworkPolicyPort item) {
        if (this.ports == null) {
            this.ports = new ArrayList();
        }
        V1NetworkPolicyPortBuilder builder = new V1NetworkPolicyPortBuilder(item);
        if (index < 0 || index >= this.ports.size()) {
            this._visitables.get("ports").add(builder);
            this.ports.add(builder);
        } else {
            this._visitables.get("ports").add(builder);
            this.ports.add(index, builder);
        }
        return (A)this;
    }

    public A setToPorts(int index, V1NetworkPolicyPort item) {
        if (this.ports == null) {
            this.ports = new ArrayList();
        }
        V1NetworkPolicyPortBuilder builder = new V1NetworkPolicyPortBuilder(item);
        if (index < 0 || index >= this.ports.size()) {
            this._visitables.get("ports").add(builder);
            this.ports.add(builder);
        } else {
            this._visitables.get("ports").add(builder);
            this.ports.set(index, builder);
        }
        return (A)this;
    }

    public A addToPorts(V1NetworkPolicyPort ... items) {
        if (this.ports == null) {
            this.ports = new ArrayList();
        }
        for (V1NetworkPolicyPort item : items) {
            V1NetworkPolicyPortBuilder builder = new V1NetworkPolicyPortBuilder(item);
            this._visitables.get("ports").add(builder);
            this.ports.add(builder);
        }
        return (A)this;
    }

    public A addAllToPorts(Collection<V1NetworkPolicyPort> items) {
        if (this.ports == null) {
            this.ports = new ArrayList();
        }
        for (V1NetworkPolicyPort item : items) {
            V1NetworkPolicyPortBuilder builder = new V1NetworkPolicyPortBuilder(item);
            this._visitables.get("ports").add(builder);
            this.ports.add(builder);
        }
        return (A)this;
    }

    public A removeFromPorts(V1NetworkPolicyPort ... items) {
        if (this.ports == null) {
            return (A)this;
        }
        for (V1NetworkPolicyPort item : items) {
            V1NetworkPolicyPortBuilder builder = new V1NetworkPolicyPortBuilder(item);
            this._visitables.get("ports").remove(builder);
            this.ports.remove(builder);
        }
        return (A)this;
    }

    public A removeAllFromPorts(Collection<V1NetworkPolicyPort> items) {
        if (this.ports == null) {
            return (A)this;
        }
        for (V1NetworkPolicyPort item : items) {
            V1NetworkPolicyPortBuilder builder = new V1NetworkPolicyPortBuilder(item);
            this._visitables.get("ports").remove(builder);
            this.ports.remove(builder);
        }
        return (A)this;
    }

    public A removeMatchingFromPorts(Predicate<V1NetworkPolicyPortBuilder> predicate) {
        if (this.ports == null) {
            return (A)this;
        }
        Iterator<V1NetworkPolicyPortBuilder> each = this.ports.iterator();
        Object visitables = this._visitables.get("ports");
        while (each.hasNext()) {
            V1NetworkPolicyPortBuilder builder = each.next();
            if (!predicate.test(builder)) continue;
            visitables.remove(builder);
            each.remove();
        }
        return (A)this;
    }

    public List<V1NetworkPolicyPort> buildPorts() {
        return this.ports != null ? V1NetworkPolicyEgressRuleFluent.build(this.ports) : null;
    }

    public V1NetworkPolicyPort buildPort(int index) {
        return this.ports.get(index).build();
    }

    public V1NetworkPolicyPort buildFirstPort() {
        return this.ports.get(0).build();
    }

    public V1NetworkPolicyPort buildLastPort() {
        return this.ports.get(this.ports.size() - 1).build();
    }

    public V1NetworkPolicyPort buildMatchingPort(Predicate<V1NetworkPolicyPortBuilder> predicate) {
        for (V1NetworkPolicyPortBuilder item : this.ports) {
            if (!predicate.test(item)) continue;
            return item.build();
        }
        return null;
    }

    public boolean hasMatchingPort(Predicate<V1NetworkPolicyPortBuilder> predicate) {
        for (V1NetworkPolicyPortBuilder item : this.ports) {
            if (!predicate.test(item)) continue;
            return true;
        }
        return false;
    }

    public A withPorts(List<V1NetworkPolicyPort> ports) {
        if (this.ports != null) {
            this._visitables.get("ports").clear();
        }
        if (ports != null) {
            this.ports = new ArrayList();
            for (V1NetworkPolicyPort item : ports) {
                this.addToPorts(item);
            }
        } else {
            this.ports = null;
        }
        return (A)this;
    }

    public A withPorts(V1NetworkPolicyPort ... ports) {
        if (this.ports != null) {
            this.ports.clear();
            this._visitables.remove("ports");
        }
        if (ports != null) {
            for (V1NetworkPolicyPort item : ports) {
                this.addToPorts(item);
            }
        }
        return (A)this;
    }

    public boolean hasPorts() {
        return this.ports != null && !this.ports.isEmpty();
    }

    public PortsNested<A> addNewPort() {
        return new PortsNested(-1, null);
    }

    public PortsNested<A> addNewPortLike(V1NetworkPolicyPort item) {
        return new PortsNested(-1, item);
    }

    public PortsNested<A> setNewPortLike(int index, V1NetworkPolicyPort item) {
        return new PortsNested(index, item);
    }

    public PortsNested<A> editPort(int index) {
        if (this.ports.size() <= index) {
            throw new RuntimeException("Can't edit ports. Index exceeds size.");
        }
        return this.setNewPortLike(index, this.buildPort(index));
    }

    public PortsNested<A> editFirstPort() {
        if (this.ports.size() == 0) {
            throw new RuntimeException("Can't edit first ports. The list is empty.");
        }
        return this.setNewPortLike(0, this.buildPort(0));
    }

    public PortsNested<A> editLastPort() {
        int index = this.ports.size() - 1;
        if (index < 0) {
            throw new RuntimeException("Can't edit last ports. The list is empty.");
        }
        return this.setNewPortLike(index, this.buildPort(index));
    }

    public PortsNested<A> editMatchingPort(Predicate<V1NetworkPolicyPortBuilder> predicate) {
        int index = -1;
        for (int i = 0; i < this.ports.size(); ++i) {
            if (!predicate.test(this.ports.get(i))) continue;
            index = i;
            break;
        }
        if (index < 0) {
            throw new RuntimeException("Can't edit matching ports. No match found.");
        }
        return this.setNewPortLike(index, this.buildPort(index));
    }

    public A addToTo(int index, V1NetworkPolicyPeer item) {
        if (this.to == null) {
            this.to = new ArrayList();
        }
        V1NetworkPolicyPeerBuilder builder = new V1NetworkPolicyPeerBuilder(item);
        if (index < 0 || index >= this.to.size()) {
            this._visitables.get("to").add(builder);
            this.to.add(builder);
        } else {
            this._visitables.get("to").add(builder);
            this.to.add(index, builder);
        }
        return (A)this;
    }

    public A setToTo(int index, V1NetworkPolicyPeer item) {
        if (this.to == null) {
            this.to = new ArrayList();
        }
        V1NetworkPolicyPeerBuilder builder = new V1NetworkPolicyPeerBuilder(item);
        if (index < 0 || index >= this.to.size()) {
            this._visitables.get("to").add(builder);
            this.to.add(builder);
        } else {
            this._visitables.get("to").add(builder);
            this.to.set(index, builder);
        }
        return (A)this;
    }

    public A addToTo(V1NetworkPolicyPeer ... items) {
        if (this.to == null) {
            this.to = new ArrayList();
        }
        for (V1NetworkPolicyPeer item : items) {
            V1NetworkPolicyPeerBuilder builder = new V1NetworkPolicyPeerBuilder(item);
            this._visitables.get("to").add(builder);
            this.to.add(builder);
        }
        return (A)this;
    }

    public A addAllToTo(Collection<V1NetworkPolicyPeer> items) {
        if (this.to == null) {
            this.to = new ArrayList();
        }
        for (V1NetworkPolicyPeer item : items) {
            V1NetworkPolicyPeerBuilder builder = new V1NetworkPolicyPeerBuilder(item);
            this._visitables.get("to").add(builder);
            this.to.add(builder);
        }
        return (A)this;
    }

    public A removeFromTo(V1NetworkPolicyPeer ... items) {
        if (this.to == null) {
            return (A)this;
        }
        for (V1NetworkPolicyPeer item : items) {
            V1NetworkPolicyPeerBuilder builder = new V1NetworkPolicyPeerBuilder(item);
            this._visitables.get("to").remove(builder);
            this.to.remove(builder);
        }
        return (A)this;
    }

    public A removeAllFromTo(Collection<V1NetworkPolicyPeer> items) {
        if (this.to == null) {
            return (A)this;
        }
        for (V1NetworkPolicyPeer item : items) {
            V1NetworkPolicyPeerBuilder builder = new V1NetworkPolicyPeerBuilder(item);
            this._visitables.get("to").remove(builder);
            this.to.remove(builder);
        }
        return (A)this;
    }

    public A removeMatchingFromTo(Predicate<V1NetworkPolicyPeerBuilder> predicate) {
        if (this.to == null) {
            return (A)this;
        }
        Iterator<V1NetworkPolicyPeerBuilder> each = this.to.iterator();
        Object visitables = this._visitables.get("to");
        while (each.hasNext()) {
            V1NetworkPolicyPeerBuilder builder = each.next();
            if (!predicate.test(builder)) continue;
            visitables.remove(builder);
            each.remove();
        }
        return (A)this;
    }

    public List<V1NetworkPolicyPeer> buildTo() {
        return this.to != null ? V1NetworkPolicyEgressRuleFluent.build(this.to) : null;
    }

    public V1NetworkPolicyPeer buildTo(int index) {
        return this.to.get(index).build();
    }

    public V1NetworkPolicyPeer buildFirstTo() {
        return this.to.get(0).build();
    }

    public V1NetworkPolicyPeer buildLastTo() {
        return this.to.get(this.to.size() - 1).build();
    }

    public V1NetworkPolicyPeer buildMatchingTo(Predicate<V1NetworkPolicyPeerBuilder> predicate) {
        for (V1NetworkPolicyPeerBuilder item : this.to) {
            if (!predicate.test(item)) continue;
            return item.build();
        }
        return null;
    }

    public boolean hasMatchingTo(Predicate<V1NetworkPolicyPeerBuilder> predicate) {
        for (V1NetworkPolicyPeerBuilder item : this.to) {
            if (!predicate.test(item)) continue;
            return true;
        }
        return false;
    }

    public A withTo(List<V1NetworkPolicyPeer> to) {
        if (this.to != null) {
            this._visitables.get("to").clear();
        }
        if (to != null) {
            this.to = new ArrayList();
            for (V1NetworkPolicyPeer item : to) {
                this.addToTo(item);
            }
        } else {
            this.to = null;
        }
        return (A)this;
    }

    public A withTo(V1NetworkPolicyPeer ... to) {
        if (this.to != null) {
            this.to.clear();
            this._visitables.remove("to");
        }
        if (to != null) {
            for (V1NetworkPolicyPeer item : to) {
                this.addToTo(item);
            }
        }
        return (A)this;
    }

    public boolean hasTo() {
        return this.to != null && !this.to.isEmpty();
    }

    public ToNested<A> addNewTo() {
        return new ToNested(-1, null);
    }

    public ToNested<A> addNewToLike(V1NetworkPolicyPeer item) {
        return new ToNested(-1, item);
    }

    public ToNested<A> setNewToLike(int index, V1NetworkPolicyPeer item) {
        return new ToNested(index, item);
    }

    public ToNested<A> editTo(int index) {
        if (this.to.size() <= index) {
            throw new RuntimeException("Can't edit to. Index exceeds size.");
        }
        return this.setNewToLike(index, this.buildTo(index));
    }

    public ToNested<A> editFirstTo() {
        if (this.to.size() == 0) {
            throw new RuntimeException("Can't edit first to. The list is empty.");
        }
        return this.setNewToLike(0, this.buildTo(0));
    }

    public ToNested<A> editLastTo() {
        int index = this.to.size() - 1;
        if (index < 0) {
            throw new RuntimeException("Can't edit last to. The list is empty.");
        }
        return this.setNewToLike(index, this.buildTo(index));
    }

    public ToNested<A> editMatchingTo(Predicate<V1NetworkPolicyPeerBuilder> predicate) {
        int index = -1;
        for (int i = 0; i < this.to.size(); ++i) {
            if (!predicate.test(this.to.get(i))) continue;
            index = i;
            break;
        }
        if (index < 0) {
            throw new RuntimeException("Can't edit matching to. No match found.");
        }
        return this.setNewToLike(index, this.buildTo(index));
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        V1NetworkPolicyEgressRuleFluent that = (V1NetworkPolicyEgressRuleFluent)o;
        if (!Objects.equals(this.ports, that.ports)) {
            return false;
        }
        return Objects.equals(this.to, that.to);
    }

    @Override
    public int hashCode() {
        return Objects.hash(this.ports, this.to, super.hashCode());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.ports != null && !this.ports.isEmpty()) {
            sb.append("ports:");
            sb.append(String.valueOf(this.ports) + ",");
        }
        if (this.to != null && !this.to.isEmpty()) {
            sb.append("to:");
            sb.append(this.to);
        }
        sb.append("}");
        return sb.toString();
    }

    public class PortsNested<N>
    extends V1NetworkPolicyPortFluent<PortsNested<N>>
    implements Nested<N> {
        V1NetworkPolicyPortBuilder builder;
        int index;

        PortsNested(int index, V1NetworkPolicyPort item) {
            this.index = index;
            this.builder = new V1NetworkPolicyPortBuilder(this, item);
        }

        @Override
        public N and() {
            return (N)V1NetworkPolicyEgressRuleFluent.this.setToPorts(this.index, this.builder.build());
        }

        public N endPort() {
            return this.and();
        }
    }

    public class ToNested<N>
    extends V1NetworkPolicyPeerFluent<ToNested<N>>
    implements Nested<N> {
        V1NetworkPolicyPeerBuilder builder;
        int index;

        ToNested(int index, V1NetworkPolicyPeer item) {
            this.index = index;
            this.builder = new V1NetworkPolicyPeerBuilder(this, item);
        }

        @Override
        public N and() {
            return (N)V1NetworkPolicyEgressRuleFluent.this.setToTo(this.index, this.builder.build());
        }

        public N endTo() {
            return this.and();
        }
    }
}

