/*
 * Decompiled with CFR 0.152.
 */
package io.kubernetes.client.openapi.models;

import com.google.gson.Gson;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.TypeAdapter;
import com.google.gson.TypeAdapterFactory;
import com.google.gson.annotations.SerializedName;
import com.google.gson.reflect.TypeToken;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonWriter;
import io.kubernetes.client.openapi.JSON;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import jakarta.annotation.Nonnull;
import jakarta.annotation.Nullable;
import java.io.IOException;
import java.util.HashSet;
import java.util.Map;
import java.util.Objects;
import java.util.Set;

@ApiModel(description="IngressClassParametersReference identifies an API object. This can be used to specify a cluster or namespace-scoped resource.")
public class V1IngressClassParametersReference {
    public static final String SERIALIZED_NAME_API_GROUP = "apiGroup";
    @SerializedName(value="apiGroup")
    @Nullable
    private String apiGroup;
    public static final String SERIALIZED_NAME_KIND = "kind";
    @SerializedName(value="kind")
    @Nonnull
    private String kind;
    public static final String SERIALIZED_NAME_NAME = "name";
    @SerializedName(value="name")
    @Nonnull
    private String name;
    public static final String SERIALIZED_NAME_NAMESPACE = "namespace";
    @SerializedName(value="namespace")
    @Nullable
    private String namespace;
    public static final String SERIALIZED_NAME_SCOPE = "scope";
    @SerializedName(value="scope")
    @Nullable
    private String scope;
    public static HashSet<String> openapiFields = new HashSet();
    public static HashSet<String> openapiRequiredFields;

    public V1IngressClassParametersReference apiGroup(@Nullable String apiGroup) {
        this.apiGroup = apiGroup;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="apiGroup is the group for the resource being referenced. If APIGroup is not specified, the specified Kind must be in the core API group. For any other third-party types, APIGroup is required.")
    public String getApiGroup() {
        return this.apiGroup;
    }

    public void setApiGroup(@Nullable String apiGroup) {
        this.apiGroup = apiGroup;
    }

    public V1IngressClassParametersReference kind(@Nonnull String kind) {
        this.kind = kind;
        return this;
    }

    @Nonnull
    @ApiModelProperty(required=true, value="kind is the type of resource being referenced.")
    public String getKind() {
        return this.kind;
    }

    public void setKind(@Nonnull String kind) {
        this.kind = kind;
    }

    public V1IngressClassParametersReference name(@Nonnull String name) {
        this.name = name;
        return this;
    }

    @Nonnull
    @ApiModelProperty(required=true, value="name is the name of resource being referenced.")
    public String getName() {
        return this.name;
    }

    public void setName(@Nonnull String name) {
        this.name = name;
    }

    public V1IngressClassParametersReference namespace(@Nullable String namespace) {
        this.namespace = namespace;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="namespace is the namespace of the resource being referenced. This field is required when scope is set to \"Namespace\" and must be unset when scope is set to \"Cluster\".")
    public String getNamespace() {
        return this.namespace;
    }

    public void setNamespace(@Nullable String namespace) {
        this.namespace = namespace;
    }

    public V1IngressClassParametersReference scope(@Nullable String scope) {
        this.scope = scope;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="scope represents if this refers to a cluster or namespace scoped resource. This may be set to \"Cluster\" (default) or \"Namespace\".")
    public String getScope() {
        return this.scope;
    }

    public void setScope(@Nullable String scope) {
        this.scope = scope;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        V1IngressClassParametersReference v1IngressClassParametersReference = (V1IngressClassParametersReference)o;
        return Objects.equals(this.apiGroup, v1IngressClassParametersReference.apiGroup) && Objects.equals(this.kind, v1IngressClassParametersReference.kind) && Objects.equals(this.name, v1IngressClassParametersReference.name) && Objects.equals(this.namespace, v1IngressClassParametersReference.namespace) && Objects.equals(this.scope, v1IngressClassParametersReference.scope);
    }

    public int hashCode() {
        return Objects.hash(this.apiGroup, this.kind, this.name, this.namespace, this.scope);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class V1IngressClassParametersReference {\n");
        sb.append("    apiGroup: ").append(this.toIndentedString(this.apiGroup)).append("\n");
        sb.append("    kind: ").append(this.toIndentedString(this.kind)).append("\n");
        sb.append("    name: ").append(this.toIndentedString(this.name)).append("\n");
        sb.append("    namespace: ").append(this.toIndentedString(this.namespace)).append("\n");
        sb.append("    scope: ").append(this.toIndentedString(this.scope)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    public static void validateJsonElement(JsonElement jsonElement) throws IOException {
        if (jsonElement == null && !openapiRequiredFields.isEmpty()) {
            throw new IllegalArgumentException(String.format("The required field(s) %s in V1IngressClassParametersReference is not found in the empty JSON string", openapiRequiredFields.toString()));
        }
        Set entries = jsonElement.getAsJsonObject().entrySet();
        for (Map.Entry entry : entries) {
            if (openapiFields.contains(entry.getKey())) continue;
            throw new IllegalArgumentException(String.format("The field `%s` in the JSON string is not defined in the `V1IngressClassParametersReference` properties. JSON: %s", entry.getKey(), jsonElement.toString()));
        }
        for (String requiredField : openapiRequiredFields) {
            if (jsonElement.getAsJsonObject().get(requiredField) != null) continue;
            throw new IllegalArgumentException(String.format("The required field `%s` is not found in the JSON string: %s", requiredField, jsonElement.toString()));
        }
        JsonObject jsonObj = jsonElement.getAsJsonObject();
        if (jsonObj.get(SERIALIZED_NAME_API_GROUP) != null && !jsonObj.get(SERIALIZED_NAME_API_GROUP).isJsonNull() && !jsonObj.get(SERIALIZED_NAME_API_GROUP).isJsonPrimitive()) {
            throw new IllegalArgumentException(String.format("Expected the field `apiGroup` to be a primitive type in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_API_GROUP).toString()));
        }
        if (!jsonObj.get(SERIALIZED_NAME_KIND).isJsonPrimitive()) {
            throw new IllegalArgumentException(String.format("Expected the field `kind` to be a primitive type in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_KIND).toString()));
        }
        if (!jsonObj.get(SERIALIZED_NAME_NAME).isJsonPrimitive()) {
            throw new IllegalArgumentException(String.format("Expected the field `name` to be a primitive type in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_NAME).toString()));
        }
        if (jsonObj.get(SERIALIZED_NAME_NAMESPACE) != null && !jsonObj.get(SERIALIZED_NAME_NAMESPACE).isJsonNull() && !jsonObj.get(SERIALIZED_NAME_NAMESPACE).isJsonPrimitive()) {
            throw new IllegalArgumentException(String.format("Expected the field `namespace` to be a primitive type in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_NAMESPACE).toString()));
        }
        if (jsonObj.get(SERIALIZED_NAME_SCOPE) != null && !jsonObj.get(SERIALIZED_NAME_SCOPE).isJsonNull() && !jsonObj.get(SERIALIZED_NAME_SCOPE).isJsonPrimitive()) {
            throw new IllegalArgumentException(String.format("Expected the field `scope` to be a primitive type in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_SCOPE).toString()));
        }
    }

    public static V1IngressClassParametersReference fromJson(String jsonString) throws IOException {
        return (V1IngressClassParametersReference)JSON.getGson().fromJson(jsonString, V1IngressClassParametersReference.class);
    }

    public String toJson() {
        return JSON.getGson().toJson((Object)this);
    }

    static {
        openapiFields.add(SERIALIZED_NAME_API_GROUP);
        openapiFields.add(SERIALIZED_NAME_KIND);
        openapiFields.add(SERIALIZED_NAME_NAME);
        openapiFields.add(SERIALIZED_NAME_NAMESPACE);
        openapiFields.add(SERIALIZED_NAME_SCOPE);
        openapiRequiredFields = new HashSet();
        openapiRequiredFields.add(SERIALIZED_NAME_KIND);
        openapiRequiredFields.add(SERIALIZED_NAME_NAME);
    }

    public static class CustomTypeAdapterFactory
    implements TypeAdapterFactory {
        public <T> TypeAdapter<T> create(Gson gson, TypeToken<T> type) {
            if (!V1IngressClassParametersReference.class.isAssignableFrom(type.getRawType())) {
                return null;
            }
            final TypeAdapter elementAdapter = gson.getAdapter(JsonElement.class);
            final TypeAdapter thisAdapter = gson.getDelegateAdapter((TypeAdapterFactory)this, TypeToken.get(V1IngressClassParametersReference.class));
            return new TypeAdapter<V1IngressClassParametersReference>(){

                public void write(JsonWriter out, V1IngressClassParametersReference value) throws IOException {
                    JsonObject obj = thisAdapter.toJsonTree((Object)value).getAsJsonObject();
                    elementAdapter.write(out, (Object)obj);
                }

                public V1IngressClassParametersReference read(JsonReader in) throws IOException {
                    JsonElement jsonElement = (JsonElement)elementAdapter.read(in);
                    V1IngressClassParametersReference.validateJsonElement(jsonElement);
                    return (V1IngressClassParametersReference)thisAdapter.fromJsonTree(jsonElement);
                }
            }.nullSafe();
        }
    }
}

