/*
 * Decompiled with CFR 0.152.
 */
package io.kubernetes.client.openapi.models;

import com.google.gson.Gson;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.TypeAdapter;
import com.google.gson.TypeAdapterFactory;
import com.google.gson.annotations.SerializedName;
import com.google.gson.reflect.TypeToken;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonWriter;
import io.kubernetes.client.openapi.JSON;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import jakarta.annotation.Nonnull;
import jakarta.annotation.Nullable;
import java.io.IOException;
import java.util.HashSet;
import java.util.Map;
import java.util.Objects;
import java.util.Set;

@ApiModel(description="Represents a Glusterfs mount that lasts the lifetime of a pod. Glusterfs volumes do not support ownership management or SELinux relabeling.")
public class V1GlusterfsPersistentVolumeSource {
    public static final String SERIALIZED_NAME_ENDPOINTS = "endpoints";
    @SerializedName(value="endpoints")
    @Nonnull
    private String endpoints;
    public static final String SERIALIZED_NAME_ENDPOINTS_NAMESPACE = "endpointsNamespace";
    @SerializedName(value="endpointsNamespace")
    @Nullable
    private String endpointsNamespace;
    public static final String SERIALIZED_NAME_PATH = "path";
    @SerializedName(value="path")
    @Nonnull
    private String path;
    public static final String SERIALIZED_NAME_READ_ONLY = "readOnly";
    @SerializedName(value="readOnly")
    @Nullable
    private Boolean readOnly;
    public static HashSet<String> openapiFields = new HashSet();
    public static HashSet<String> openapiRequiredFields;

    public V1GlusterfsPersistentVolumeSource endpoints(@Nonnull String endpoints) {
        this.endpoints = endpoints;
        return this;
    }

    @Nonnull
    @ApiModelProperty(required=true, value="endpoints is the endpoint name that details Glusterfs topology. More info: https://examples.k8s.io/volumes/glusterfs/README.md#create-a-pod")
    public String getEndpoints() {
        return this.endpoints;
    }

    public void setEndpoints(@Nonnull String endpoints) {
        this.endpoints = endpoints;
    }

    public V1GlusterfsPersistentVolumeSource endpointsNamespace(@Nullable String endpointsNamespace) {
        this.endpointsNamespace = endpointsNamespace;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="endpointsNamespace is the namespace that contains Glusterfs endpoint. If this field is empty, the EndpointNamespace defaults to the same namespace as the bound PVC. More info: https://examples.k8s.io/volumes/glusterfs/README.md#create-a-pod")
    public String getEndpointsNamespace() {
        return this.endpointsNamespace;
    }

    public void setEndpointsNamespace(@Nullable String endpointsNamespace) {
        this.endpointsNamespace = endpointsNamespace;
    }

    public V1GlusterfsPersistentVolumeSource path(@Nonnull String path) {
        this.path = path;
        return this;
    }

    @Nonnull
    @ApiModelProperty(required=true, value="path is the Glusterfs volume path. More info: https://examples.k8s.io/volumes/glusterfs/README.md#create-a-pod")
    public String getPath() {
        return this.path;
    }

    public void setPath(@Nonnull String path) {
        this.path = path;
    }

    public V1GlusterfsPersistentVolumeSource readOnly(@Nullable Boolean readOnly) {
        this.readOnly = readOnly;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="readOnly here will force the Glusterfs volume to be mounted with read-only permissions. Defaults to false. More info: https://examples.k8s.io/volumes/glusterfs/README.md#create-a-pod")
    public Boolean getReadOnly() {
        return this.readOnly;
    }

    public void setReadOnly(@Nullable Boolean readOnly) {
        this.readOnly = readOnly;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        V1GlusterfsPersistentVolumeSource v1GlusterfsPersistentVolumeSource = (V1GlusterfsPersistentVolumeSource)o;
        return Objects.equals(this.endpoints, v1GlusterfsPersistentVolumeSource.endpoints) && Objects.equals(this.endpointsNamespace, v1GlusterfsPersistentVolumeSource.endpointsNamespace) && Objects.equals(this.path, v1GlusterfsPersistentVolumeSource.path) && Objects.equals(this.readOnly, v1GlusterfsPersistentVolumeSource.readOnly);
    }

    public int hashCode() {
        return Objects.hash(this.endpoints, this.endpointsNamespace, this.path, this.readOnly);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class V1GlusterfsPersistentVolumeSource {\n");
        sb.append("    endpoints: ").append(this.toIndentedString(this.endpoints)).append("\n");
        sb.append("    endpointsNamespace: ").append(this.toIndentedString(this.endpointsNamespace)).append("\n");
        sb.append("    path: ").append(this.toIndentedString(this.path)).append("\n");
        sb.append("    readOnly: ").append(this.toIndentedString(this.readOnly)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    public static void validateJsonElement(JsonElement jsonElement) throws IOException {
        if (jsonElement == null && !openapiRequiredFields.isEmpty()) {
            throw new IllegalArgumentException(String.format("The required field(s) %s in V1GlusterfsPersistentVolumeSource is not found in the empty JSON string", openapiRequiredFields.toString()));
        }
        Set entries = jsonElement.getAsJsonObject().entrySet();
        for (Map.Entry entry : entries) {
            if (openapiFields.contains(entry.getKey())) continue;
            throw new IllegalArgumentException(String.format("The field `%s` in the JSON string is not defined in the `V1GlusterfsPersistentVolumeSource` properties. JSON: %s", entry.getKey(), jsonElement.toString()));
        }
        for (String requiredField : openapiRequiredFields) {
            if (jsonElement.getAsJsonObject().get(requiredField) != null) continue;
            throw new IllegalArgumentException(String.format("The required field `%s` is not found in the JSON string: %s", requiredField, jsonElement.toString()));
        }
        JsonObject jsonObj = jsonElement.getAsJsonObject();
        if (!jsonObj.get(SERIALIZED_NAME_ENDPOINTS).isJsonPrimitive()) {
            throw new IllegalArgumentException(String.format("Expected the field `endpoints` to be a primitive type in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_ENDPOINTS).toString()));
        }
        if (jsonObj.get(SERIALIZED_NAME_ENDPOINTS_NAMESPACE) != null && !jsonObj.get(SERIALIZED_NAME_ENDPOINTS_NAMESPACE).isJsonNull() && !jsonObj.get(SERIALIZED_NAME_ENDPOINTS_NAMESPACE).isJsonPrimitive()) {
            throw new IllegalArgumentException(String.format("Expected the field `endpointsNamespace` to be a primitive type in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_ENDPOINTS_NAMESPACE).toString()));
        }
        if (!jsonObj.get(SERIALIZED_NAME_PATH).isJsonPrimitive()) {
            throw new IllegalArgumentException(String.format("Expected the field `path` to be a primitive type in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_PATH).toString()));
        }
    }

    public static V1GlusterfsPersistentVolumeSource fromJson(String jsonString) throws IOException {
        return (V1GlusterfsPersistentVolumeSource)JSON.getGson().fromJson(jsonString, V1GlusterfsPersistentVolumeSource.class);
    }

    public String toJson() {
        return JSON.getGson().toJson((Object)this);
    }

    static {
        openapiFields.add(SERIALIZED_NAME_ENDPOINTS);
        openapiFields.add(SERIALIZED_NAME_ENDPOINTS_NAMESPACE);
        openapiFields.add(SERIALIZED_NAME_PATH);
        openapiFields.add(SERIALIZED_NAME_READ_ONLY);
        openapiRequiredFields = new HashSet();
        openapiRequiredFields.add(SERIALIZED_NAME_ENDPOINTS);
        openapiRequiredFields.add(SERIALIZED_NAME_PATH);
    }

    public static class CustomTypeAdapterFactory
    implements TypeAdapterFactory {
        public <T> TypeAdapter<T> create(Gson gson, TypeToken<T> type) {
            if (!V1GlusterfsPersistentVolumeSource.class.isAssignableFrom(type.getRawType())) {
                return null;
            }
            final TypeAdapter elementAdapter = gson.getAdapter(JsonElement.class);
            final TypeAdapter thisAdapter = gson.getDelegateAdapter((TypeAdapterFactory)this, TypeToken.get(V1GlusterfsPersistentVolumeSource.class));
            return new TypeAdapter<V1GlusterfsPersistentVolumeSource>(){

                public void write(JsonWriter out, V1GlusterfsPersistentVolumeSource value) throws IOException {
                    JsonObject obj = thisAdapter.toJsonTree((Object)value).getAsJsonObject();
                    elementAdapter.write(out, (Object)obj);
                }

                public V1GlusterfsPersistentVolumeSource read(JsonReader in) throws IOException {
                    JsonElement jsonElement = (JsonElement)elementAdapter.read(in);
                    V1GlusterfsPersistentVolumeSource.validateJsonElement(jsonElement);
                    return (V1GlusterfsPersistentVolumeSource)thisAdapter.fromJsonTree(jsonElement);
                }
            }.nullSafe();
        }
    }
}

