/*
 * Decompiled with CFR 0.152.
 */
package io.kubernetes.client.openapi.models;

import com.google.gson.Gson;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.TypeAdapter;
import com.google.gson.TypeAdapterFactory;
import com.google.gson.annotations.SerializedName;
import com.google.gson.reflect.TypeToken;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonWriter;
import io.kubernetes.client.openapi.JSON;
import io.kubernetes.client.openapi.models.V1DeploymentCondition;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import jakarta.annotation.Nullable;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;

@ApiModel(description="DeploymentStatus is the most recently observed status of the Deployment.")
public class V1DeploymentStatus {
    public static final String SERIALIZED_NAME_AVAILABLE_REPLICAS = "availableReplicas";
    @SerializedName(value="availableReplicas")
    @Nullable
    private Integer availableReplicas;
    public static final String SERIALIZED_NAME_COLLISION_COUNT = "collisionCount";
    @SerializedName(value="collisionCount")
    @Nullable
    private Integer collisionCount;
    public static final String SERIALIZED_NAME_CONDITIONS = "conditions";
    @SerializedName(value="conditions")
    @Nullable
    private List<V1DeploymentCondition> conditions = new ArrayList<V1DeploymentCondition>();
    public static final String SERIALIZED_NAME_OBSERVED_GENERATION = "observedGeneration";
    @SerializedName(value="observedGeneration")
    @Nullable
    private Long observedGeneration;
    public static final String SERIALIZED_NAME_READY_REPLICAS = "readyReplicas";
    @SerializedName(value="readyReplicas")
    @Nullable
    private Integer readyReplicas;
    public static final String SERIALIZED_NAME_REPLICAS = "replicas";
    @SerializedName(value="replicas")
    @Nullable
    private Integer replicas;
    public static final String SERIALIZED_NAME_TERMINATING_REPLICAS = "terminatingReplicas";
    @SerializedName(value="terminatingReplicas")
    @Nullable
    private Integer terminatingReplicas;
    public static final String SERIALIZED_NAME_UNAVAILABLE_REPLICAS = "unavailableReplicas";
    @SerializedName(value="unavailableReplicas")
    @Nullable
    private Integer unavailableReplicas;
    public static final String SERIALIZED_NAME_UPDATED_REPLICAS = "updatedReplicas";
    @SerializedName(value="updatedReplicas")
    @Nullable
    private Integer updatedReplicas;
    public static HashSet<String> openapiFields = new HashSet();
    public static HashSet<String> openapiRequiredFields;

    public V1DeploymentStatus availableReplicas(@Nullable Integer availableReplicas) {
        this.availableReplicas = availableReplicas;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Total number of available non-terminating pods (ready for at least minReadySeconds) targeted by this deployment.")
    public Integer getAvailableReplicas() {
        return this.availableReplicas;
    }

    public void setAvailableReplicas(@Nullable Integer availableReplicas) {
        this.availableReplicas = availableReplicas;
    }

    public V1DeploymentStatus collisionCount(@Nullable Integer collisionCount) {
        this.collisionCount = collisionCount;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Count of hash collisions for the Deployment. The Deployment controller uses this field as a collision avoidance mechanism when it needs to create the name for the newest ReplicaSet.")
    public Integer getCollisionCount() {
        return this.collisionCount;
    }

    public void setCollisionCount(@Nullable Integer collisionCount) {
        this.collisionCount = collisionCount;
    }

    public V1DeploymentStatus conditions(@Nullable List<V1DeploymentCondition> conditions) {
        this.conditions = conditions;
        return this;
    }

    public V1DeploymentStatus addConditionsItem(V1DeploymentCondition conditionsItem) {
        if (this.conditions == null) {
            this.conditions = new ArrayList<V1DeploymentCondition>();
        }
        this.conditions.add(conditionsItem);
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Represents the latest available observations of a deployment's current state.")
    public List<V1DeploymentCondition> getConditions() {
        return this.conditions;
    }

    public void setConditions(@Nullable List<V1DeploymentCondition> conditions) {
        this.conditions = conditions;
    }

    public V1DeploymentStatus observedGeneration(@Nullable Long observedGeneration) {
        this.observedGeneration = observedGeneration;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="The generation observed by the deployment controller.")
    public Long getObservedGeneration() {
        return this.observedGeneration;
    }

    public void setObservedGeneration(@Nullable Long observedGeneration) {
        this.observedGeneration = observedGeneration;
    }

    public V1DeploymentStatus readyReplicas(@Nullable Integer readyReplicas) {
        this.readyReplicas = readyReplicas;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Total number of non-terminating pods targeted by this Deployment with a Ready Condition.")
    public Integer getReadyReplicas() {
        return this.readyReplicas;
    }

    public void setReadyReplicas(@Nullable Integer readyReplicas) {
        this.readyReplicas = readyReplicas;
    }

    public V1DeploymentStatus replicas(@Nullable Integer replicas) {
        this.replicas = replicas;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Total number of non-terminating pods targeted by this deployment (their labels match the selector).")
    public Integer getReplicas() {
        return this.replicas;
    }

    public void setReplicas(@Nullable Integer replicas) {
        this.replicas = replicas;
    }

    public V1DeploymentStatus terminatingReplicas(@Nullable Integer terminatingReplicas) {
        this.terminatingReplicas = terminatingReplicas;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Total number of terminating pods targeted by this deployment. Terminating pods have a non-null .metadata.deletionTimestamp and have not yet reached the Failed or Succeeded .status.phase.  This is an alpha field. Enable DeploymentReplicaSetTerminatingReplicas to be able to use this field.")
    public Integer getTerminatingReplicas() {
        return this.terminatingReplicas;
    }

    public void setTerminatingReplicas(@Nullable Integer terminatingReplicas) {
        this.terminatingReplicas = terminatingReplicas;
    }

    public V1DeploymentStatus unavailableReplicas(@Nullable Integer unavailableReplicas) {
        this.unavailableReplicas = unavailableReplicas;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Total number of unavailable pods targeted by this deployment. This is the total number of pods that are still required for the deployment to have 100% available capacity. They may either be pods that are running but not yet available or pods that still have not been created.")
    public Integer getUnavailableReplicas() {
        return this.unavailableReplicas;
    }

    public void setUnavailableReplicas(@Nullable Integer unavailableReplicas) {
        this.unavailableReplicas = unavailableReplicas;
    }

    public V1DeploymentStatus updatedReplicas(@Nullable Integer updatedReplicas) {
        this.updatedReplicas = updatedReplicas;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Total number of non-terminating pods targeted by this deployment that have the desired template spec.")
    public Integer getUpdatedReplicas() {
        return this.updatedReplicas;
    }

    public void setUpdatedReplicas(@Nullable Integer updatedReplicas) {
        this.updatedReplicas = updatedReplicas;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        V1DeploymentStatus v1DeploymentStatus = (V1DeploymentStatus)o;
        return Objects.equals(this.availableReplicas, v1DeploymentStatus.availableReplicas) && Objects.equals(this.collisionCount, v1DeploymentStatus.collisionCount) && Objects.equals(this.conditions, v1DeploymentStatus.conditions) && Objects.equals(this.observedGeneration, v1DeploymentStatus.observedGeneration) && Objects.equals(this.readyReplicas, v1DeploymentStatus.readyReplicas) && Objects.equals(this.replicas, v1DeploymentStatus.replicas) && Objects.equals(this.terminatingReplicas, v1DeploymentStatus.terminatingReplicas) && Objects.equals(this.unavailableReplicas, v1DeploymentStatus.unavailableReplicas) && Objects.equals(this.updatedReplicas, v1DeploymentStatus.updatedReplicas);
    }

    public int hashCode() {
        return Objects.hash(this.availableReplicas, this.collisionCount, this.conditions, this.observedGeneration, this.readyReplicas, this.replicas, this.terminatingReplicas, this.unavailableReplicas, this.updatedReplicas);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class V1DeploymentStatus {\n");
        sb.append("    availableReplicas: ").append(this.toIndentedString(this.availableReplicas)).append("\n");
        sb.append("    collisionCount: ").append(this.toIndentedString(this.collisionCount)).append("\n");
        sb.append("    conditions: ").append(this.toIndentedString(this.conditions)).append("\n");
        sb.append("    observedGeneration: ").append(this.toIndentedString(this.observedGeneration)).append("\n");
        sb.append("    readyReplicas: ").append(this.toIndentedString(this.readyReplicas)).append("\n");
        sb.append("    replicas: ").append(this.toIndentedString(this.replicas)).append("\n");
        sb.append("    terminatingReplicas: ").append(this.toIndentedString(this.terminatingReplicas)).append("\n");
        sb.append("    unavailableReplicas: ").append(this.toIndentedString(this.unavailableReplicas)).append("\n");
        sb.append("    updatedReplicas: ").append(this.toIndentedString(this.updatedReplicas)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    public static void validateJsonElement(JsonElement jsonElement) throws IOException {
        JsonArray jsonArrayconditions;
        if (jsonElement == null && !openapiRequiredFields.isEmpty()) {
            throw new IllegalArgumentException(String.format("The required field(s) %s in V1DeploymentStatus is not found in the empty JSON string", openapiRequiredFields.toString()));
        }
        Set entries = jsonElement.getAsJsonObject().entrySet();
        for (Map.Entry entry : entries) {
            if (openapiFields.contains(entry.getKey())) continue;
            throw new IllegalArgumentException(String.format("The field `%s` in the JSON string is not defined in the `V1DeploymentStatus` properties. JSON: %s", entry.getKey(), jsonElement.toString()));
        }
        JsonObject jsonObj = jsonElement.getAsJsonObject();
        if (jsonObj.get(SERIALIZED_NAME_CONDITIONS) != null && !jsonObj.get(SERIALIZED_NAME_CONDITIONS).isJsonNull() && (jsonArrayconditions = jsonObj.getAsJsonArray(SERIALIZED_NAME_CONDITIONS)) != null) {
            if (!jsonObj.get(SERIALIZED_NAME_CONDITIONS).isJsonArray()) {
                throw new IllegalArgumentException(String.format("Expected the field `conditions` to be an array in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_CONDITIONS).toString()));
            }
            for (int i = 0; i < jsonArrayconditions.size(); ++i) {
                V1DeploymentCondition.validateJsonElement(jsonArrayconditions.get(i));
            }
        }
    }

    public static V1DeploymentStatus fromJson(String jsonString) throws IOException {
        return (V1DeploymentStatus)JSON.getGson().fromJson(jsonString, V1DeploymentStatus.class);
    }

    public String toJson() {
        return JSON.getGson().toJson((Object)this);
    }

    static {
        openapiFields.add(SERIALIZED_NAME_AVAILABLE_REPLICAS);
        openapiFields.add(SERIALIZED_NAME_COLLISION_COUNT);
        openapiFields.add(SERIALIZED_NAME_CONDITIONS);
        openapiFields.add(SERIALIZED_NAME_OBSERVED_GENERATION);
        openapiFields.add(SERIALIZED_NAME_READY_REPLICAS);
        openapiFields.add(SERIALIZED_NAME_REPLICAS);
        openapiFields.add(SERIALIZED_NAME_TERMINATING_REPLICAS);
        openapiFields.add(SERIALIZED_NAME_UNAVAILABLE_REPLICAS);
        openapiFields.add(SERIALIZED_NAME_UPDATED_REPLICAS);
        openapiRequiredFields = new HashSet();
    }

    public static class CustomTypeAdapterFactory
    implements TypeAdapterFactory {
        public <T> TypeAdapter<T> create(Gson gson, TypeToken<T> type) {
            if (!V1DeploymentStatus.class.isAssignableFrom(type.getRawType())) {
                return null;
            }
            final TypeAdapter elementAdapter = gson.getAdapter(JsonElement.class);
            final TypeAdapter thisAdapter = gson.getDelegateAdapter((TypeAdapterFactory)this, TypeToken.get(V1DeploymentStatus.class));
            return new TypeAdapter<V1DeploymentStatus>(){

                public void write(JsonWriter out, V1DeploymentStatus value) throws IOException {
                    JsonObject obj = thisAdapter.toJsonTree((Object)value).getAsJsonObject();
                    elementAdapter.write(out, (Object)obj);
                }

                public V1DeploymentStatus read(JsonReader in) throws IOException {
                    JsonElement jsonElement = (JsonElement)elementAdapter.read(in);
                    V1DeploymentStatus.validateJsonElement(jsonElement);
                    return (V1DeploymentStatus)thisAdapter.fromJsonTree(jsonElement);
                }
            }.nullSafe();
        }
    }
}

