/*
 * Decompiled with CFR 0.152.
 */
package io.kubernetes.client.openapi.models;

import com.google.gson.Gson;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.TypeAdapter;
import com.google.gson.TypeAdapterFactory;
import com.google.gson.annotations.SerializedName;
import com.google.gson.reflect.TypeToken;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonWriter;
import io.kubernetes.client.openapi.JSON;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import jakarta.annotation.Nonnull;
import jakarta.annotation.Nullable;
import java.io.IOException;
import java.util.HashSet;
import java.util.Map;
import java.util.Objects;
import java.util.Set;

@ApiModel(description="AzureFile represents an Azure File Service mount on the host and bind mount to the pod.")
public class V1AzureFileVolumeSource {
    public static final String SERIALIZED_NAME_READ_ONLY = "readOnly";
    @SerializedName(value="readOnly")
    @Nullable
    private Boolean readOnly;
    public static final String SERIALIZED_NAME_SECRET_NAME = "secretName";
    @SerializedName(value="secretName")
    @Nonnull
    private String secretName;
    public static final String SERIALIZED_NAME_SHARE_NAME = "shareName";
    @SerializedName(value="shareName")
    @Nonnull
    private String shareName;
    public static HashSet<String> openapiFields = new HashSet();
    public static HashSet<String> openapiRequiredFields;

    public V1AzureFileVolumeSource readOnly(@Nullable Boolean readOnly) {
        this.readOnly = readOnly;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="readOnly defaults to false (read/write). ReadOnly here will force the ReadOnly setting in VolumeMounts.")
    public Boolean getReadOnly() {
        return this.readOnly;
    }

    public void setReadOnly(@Nullable Boolean readOnly) {
        this.readOnly = readOnly;
    }

    public V1AzureFileVolumeSource secretName(@Nonnull String secretName) {
        this.secretName = secretName;
        return this;
    }

    @Nonnull
    @ApiModelProperty(required=true, value="secretName is the  name of secret that contains Azure Storage Account Name and Key")
    public String getSecretName() {
        return this.secretName;
    }

    public void setSecretName(@Nonnull String secretName) {
        this.secretName = secretName;
    }

    public V1AzureFileVolumeSource shareName(@Nonnull String shareName) {
        this.shareName = shareName;
        return this;
    }

    @Nonnull
    @ApiModelProperty(required=true, value="shareName is the azure share Name")
    public String getShareName() {
        return this.shareName;
    }

    public void setShareName(@Nonnull String shareName) {
        this.shareName = shareName;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        V1AzureFileVolumeSource v1AzureFileVolumeSource = (V1AzureFileVolumeSource)o;
        return Objects.equals(this.readOnly, v1AzureFileVolumeSource.readOnly) && Objects.equals(this.secretName, v1AzureFileVolumeSource.secretName) && Objects.equals(this.shareName, v1AzureFileVolumeSource.shareName);
    }

    public int hashCode() {
        return Objects.hash(this.readOnly, this.secretName, this.shareName);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class V1AzureFileVolumeSource {\n");
        sb.append("    readOnly: ").append(this.toIndentedString(this.readOnly)).append("\n");
        sb.append("    secretName: ").append(this.toIndentedString(this.secretName)).append("\n");
        sb.append("    shareName: ").append(this.toIndentedString(this.shareName)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    public static void validateJsonElement(JsonElement jsonElement) throws IOException {
        if (jsonElement == null && !openapiRequiredFields.isEmpty()) {
            throw new IllegalArgumentException(String.format("The required field(s) %s in V1AzureFileVolumeSource is not found in the empty JSON string", openapiRequiredFields.toString()));
        }
        Set entries = jsonElement.getAsJsonObject().entrySet();
        for (Map.Entry entry : entries) {
            if (openapiFields.contains(entry.getKey())) continue;
            throw new IllegalArgumentException(String.format("The field `%s` in the JSON string is not defined in the `V1AzureFileVolumeSource` properties. JSON: %s", entry.getKey(), jsonElement.toString()));
        }
        for (String requiredField : openapiRequiredFields) {
            if (jsonElement.getAsJsonObject().get(requiredField) != null) continue;
            throw new IllegalArgumentException(String.format("The required field `%s` is not found in the JSON string: %s", requiredField, jsonElement.toString()));
        }
        JsonObject jsonObj = jsonElement.getAsJsonObject();
        if (!jsonObj.get(SERIALIZED_NAME_SECRET_NAME).isJsonPrimitive()) {
            throw new IllegalArgumentException(String.format("Expected the field `secretName` to be a primitive type in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_SECRET_NAME).toString()));
        }
        if (!jsonObj.get(SERIALIZED_NAME_SHARE_NAME).isJsonPrimitive()) {
            throw new IllegalArgumentException(String.format("Expected the field `shareName` to be a primitive type in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_SHARE_NAME).toString()));
        }
    }

    public static V1AzureFileVolumeSource fromJson(String jsonString) throws IOException {
        return (V1AzureFileVolumeSource)JSON.getGson().fromJson(jsonString, V1AzureFileVolumeSource.class);
    }

    public String toJson() {
        return JSON.getGson().toJson((Object)this);
    }

    static {
        openapiFields.add(SERIALIZED_NAME_READ_ONLY);
        openapiFields.add(SERIALIZED_NAME_SECRET_NAME);
        openapiFields.add(SERIALIZED_NAME_SHARE_NAME);
        openapiRequiredFields = new HashSet();
        openapiRequiredFields.add(SERIALIZED_NAME_SECRET_NAME);
        openapiRequiredFields.add(SERIALIZED_NAME_SHARE_NAME);
    }

    public static class CustomTypeAdapterFactory
    implements TypeAdapterFactory {
        public <T> TypeAdapter<T> create(Gson gson, TypeToken<T> type) {
            if (!V1AzureFileVolumeSource.class.isAssignableFrom(type.getRawType())) {
                return null;
            }
            final TypeAdapter elementAdapter = gson.getAdapter(JsonElement.class);
            final TypeAdapter thisAdapter = gson.getDelegateAdapter((TypeAdapterFactory)this, TypeToken.get(V1AzureFileVolumeSource.class));
            return new TypeAdapter<V1AzureFileVolumeSource>(){

                public void write(JsonWriter out, V1AzureFileVolumeSource value) throws IOException {
                    JsonObject obj = thisAdapter.toJsonTree((Object)value).getAsJsonObject();
                    elementAdapter.write(out, (Object)obj);
                }

                public V1AzureFileVolumeSource read(JsonReader in) throws IOException {
                    JsonElement jsonElement = (JsonElement)elementAdapter.read(in);
                    V1AzureFileVolumeSource.validateJsonElement(jsonElement);
                    return (V1AzureFileVolumeSource)thisAdapter.fromJsonTree(jsonElement);
                }
            }.nullSafe();
        }
    }
}

