/*
 * Decompiled with CFR 0.152.
 */
package io.ethers.abi.call;

import com.fasterxml.jackson.databind.MappingIterator;
import com.fasterxml.jackson.databind.ObjectReader;
import io.ethers.abi.AbiContract;
import io.ethers.abi.AbiFunction;
import io.ethers.abi.AbiType;
import io.ethers.abi.ContractStruct;
import io.ethers.abi.StructFactory;
import io.ethers.abi.call.AggregationResult;
import io.ethers.abi.call.FunctionCall;
import io.ethers.abi.call.PayableFunctionCall;
import io.ethers.abi.call.ReadFunctionCall;
import io.ethers.abi.error.ContractError;
import io.ethers.abi.error.RevertError;
import io.ethers.core.Jackson;
import io.ethers.core.Result;
import io.ethers.core.ResultKt;
import io.ethers.core.types.AccountOverride;
import io.ethers.core.types.Address;
import io.ethers.core.types.Bytes;
import io.ethers.core.types.CallRequest;
import io.ethers.core.types.IntoCallRequest;
import io.ethers.providers.middleware.Middleware;
import java.io.InputStream;
import java.io.Serializable;
import java.math.BigInteger;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.JvmField;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Reflection;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000\u008a\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0011\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\f\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u000e\u0018\u0000 C2\u00020\u0001:\t;<=>?@ABCB\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007JA\u0010\b\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u0002H\u000b0\n0\t\"\u0004\b\u0000\u0010\u000b2\"\u0010\f\u001a\u0012\u0012\u000e\b\u0001\u0012\n\u0012\u0006\b\u0001\u0012\u0002H\u000b0\u000e0\r\"\n\u0012\u0006\b\u0001\u0012\u0002H\u000b0\u000e\u00a2\u0006\u0002\u0010\u000fJ%\u0010\u0010\u001a\b\u0012\u0004\u0012\u00020\u00120\u00112\u0012\u0010\f\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u00130\r\"\u00020\u0013\u00a2\u0006\u0002\u0010\u0014J+\u0010\u0015\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00160\r0\u00112\u0012\u0010\f\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u00170\r\"\u00020\u0017\u00a2\u0006\u0002\u0010\u0018J+\u0010\u0019\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00160\r0\u00112\u0012\u0010\f\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u001a0\r\"\u00020\u001a\u00a2\u0006\u0002\u0010\u001bJ%\u0010\u001c\u001a\b\u0012\u0004\u0012\u00020\u001d0\u00112\u0012\u0010\f\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u00130\r\"\u00020\u0013\u00a2\u0006\u0002\u0010\u0014J\f\u0010\u001e\u001a\b\u0012\u0004\u0012\u00020 0\u001fJ\u0014\u0010!\u001a\b\u0012\u0004\u0012\u00020\"0\u001f2\u0006\u0010#\u001a\u00020 J\f\u0010$\u001a\b\u0012\u0004\u0012\u00020 0\u001fJ\f\u0010%\u001a\b\u0012\u0004\u0012\u00020 0\u001fJ\f\u0010&\u001a\b\u0012\u0004\u0012\u00020\u00050\u001fJ\f\u0010'\u001a\b\u0012\u0004\u0012\u00020 0\u001fJ\f\u0010(\u001a\b\u0012\u0004\u0012\u00020 0\u001fJ\f\u0010)\u001a\b\u0012\u0004\u0012\u00020 0\u001fJ\u0014\u0010*\u001a\b\u0012\u0004\u0012\u00020 0\u001f2\u0006\u0010+\u001a\u00020\u0005J\f\u0010,\u001a\b\u0012\u0004\u0012\u00020\"0\u001fJ3\u0010-\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00160\r0\u00112\u0006\u0010.\u001a\u00020/2\u0012\u0010\f\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u00130\r\"\u00020\u0013\u00a2\u0006\u0002\u00100J-\u00101\u001a\b\u0012\u0004\u0012\u0002020\u00112\u0006\u0010.\u001a\u00020/2\u0012\u0010\f\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u00130\r\"\u00020\u0013\u00a2\u0006\u0002\u00100J@\u00103\u001a\u001e\u0012\u0004\u0012\u0002H\u000b\u0012\u0004\u0012\u00020504j\u000e\u0012\u0004\u0012\u0002H\u000b\u0012\u0004\u0012\u000205`6\"\u0004\b\u0000\u0010\u000b2\f\u00107\u001a\b\u0012\u0004\u0012\u0002H\u000b0\u000e2\u0006\u00108\u001a\u00020\u0016H\u0002J\u0010\u00109\u001a\u0002052\u0006\u0010:\u001a\u00020\"H\u0002\u00a8\u0006D"}, d2={"Lio/ethers/abi/call/Multicall3;", "Lio/ethers/abi/AbiContract;", "provider", "Lio/ethers/providers/middleware/Middleware;", "address", "Lio/ethers/core/types/Address;", "<init>", "(Lio/ethers/providers/middleware/Middleware;Lio/ethers/core/types/Address;)V", "aggregateCalls", "Lio/ethers/abi/call/FunctionCall;", "Lio/ethers/abi/call/AggregationResult;", "T", "calls", "", "Lio/ethers/abi/call/Multicall3$Aggregatable;", "([Lio/ethers/abi/call/Multicall3$Aggregatable;)Lio/ethers/abi/call/FunctionCall;", "aggregate", "Lio/ethers/abi/call/PayableFunctionCall;", "Lio/ethers/abi/call/Multicall3$AggregateResult;", "Lio/ethers/abi/call/Multicall3$Call;", "([Lio/ethers/abi/call/Multicall3$Call;)Lio/ethers/abi/call/PayableFunctionCall;", "aggregate3", "Lio/ethers/abi/call/Multicall3$Result;", "Lio/ethers/abi/call/Multicall3$Call3;", "([Lio/ethers/abi/call/Multicall3$Call3;)Lio/ethers/abi/call/PayableFunctionCall;", "aggregate3Value", "Lio/ethers/abi/call/Multicall3$Call3Value;", "([Lio/ethers/abi/call/Multicall3$Call3Value;)Lio/ethers/abi/call/PayableFunctionCall;", "blockAndAggregate", "Lio/ethers/abi/call/Multicall3$BlockAndAggregateResult;", "getBasefee", "Lio/ethers/abi/call/ReadFunctionCall;", "Ljava/math/BigInteger;", "getBlockHash", "Lio/ethers/core/types/Bytes;", "blockNumber", "getBlockNumber", "getChainId", "getCurrentBlockCoinbase", "getCurrentBlockDifficulty", "getCurrentBlockGasLimit", "getCurrentBlockTimestamp", "getEthBalance", "addr", "getLastBlockHash", "tryAggregate", "requireSuccess", "", "(Z[Lio/ethers/abi/call/Multicall3$Call;)Lio/ethers/abi/call/PayableFunctionCall;", "tryBlockAndAggregate", "Lio/ethers/abi/call/Multicall3$TryBlockAndAggregateResult;", "handleRequestResult", "Lio/ethers/core/Result;", "Lio/ethers/abi/error/ContractError;", "Lio/ethers/abi/call/EthersResult;", "request", "result", "tryDecodingCallRevert", "err", "BlockAndAggregateResult", "AggregateResult", "TryBlockAndAggregateResult", "Call", "Call3", "Call3Value", "Result", "Aggregatable", "Companion", "ethers-abi"})
@SourceDebugExtension(value={"SMAP\nMulticall3.kt\nKotlin\n*S Kotlin\n*F\n+ 1 Multicall3.kt\nio/ethers/abi/call/Multicall3\n+ 2 Multicall3.kt\nio/ethers/abi/call/Multicall3Kt\n+ 3 Iterators.kt\nkotlin/collections/CollectionsKt__IteratorsKt\n*L\n1#1,777:1\n714#2,51:778\n32#3,2:829\n*S KotlinDebug\n*F\n+ 1 Multicall3.kt\nio/ethers/abi/call/Multicall3\n*L\n76#1:778,51\n521#1:829,2\n*E\n"})
public final class Multicall3
extends AbiContract {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private static final ConcurrentHashMap<Long, Multicall3> INSTANCE_PER_CHAIN_ID = new ConcurrentHashMap();
    @NotNull
    private static final Address DEFAULT_ADDRESS = new Address((CharSequence)"0xcA11bde05977b3631167028862bE2a173976CA11");
    @NotNull
    private static final Bytes DEPLOYED_BYTECODE = new Bytes((CharSequence)"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");
    @NotNull
    private static final Lazy<HashMap<Long, Companion.MulticallDeployment>> DEPLOYMENT_PER_CHAIN_ID$delegate = LazyKt.lazy(Multicall3::DEPLOYMENT_PER_CHAIN_ID_delegate$lambda$19);
    @JvmField
    @NotNull
    public static final Map<Address, AccountOverride> STATE_OVERRIDE = MapsKt.mapOf((Pair)TuplesKt.to((Object)DEFAULT_ADDRESS, (Object)new AccountOverride().code(DEPLOYED_BYTECODE)));
    @JvmField
    @NotNull
    public static final AbiFunction FUNCTION_AGGREGATE3;
    @JvmField
    @NotNull
    public static final AbiFunction FUNCTION_BLOCK_AND_AGGREGATE;
    @JvmField
    @NotNull
    public static final AbiFunction FUNCTION_AGGREGATE3_VALUE;
    @JvmField
    @NotNull
    public static final AbiFunction FUNCTION_GET_BASEFEE;
    @JvmField
    @NotNull
    public static final AbiFunction FUNCTION_AGGREGATE;
    @JvmField
    @NotNull
    public static final AbiFunction FUNCTION_GET_CURRENT_BLOCK_DIFFICULTY;
    @JvmField
    @NotNull
    public static final AbiFunction FUNCTION_GET_CURRENT_BLOCK_COINBASE;
    @JvmField
    @NotNull
    public static final AbiFunction FUNCTION_GET_ETH_BALANCE;
    @JvmField
    @NotNull
    public static final AbiFunction FUNCTION_GET_BLOCK_NUMBER;
    @JvmField
    @NotNull
    public static final AbiFunction FUNCTION_TRY_AGGREGATE;
    @JvmField
    @NotNull
    public static final AbiFunction FUNCTION_TRY_BLOCK_AND_AGGREGATE;
    @JvmField
    @NotNull
    public static final AbiFunction FUNCTION_GET_CHAIN_ID;
    @JvmField
    @NotNull
    public static final AbiFunction FUNCTION_GET_CURRENT_BLOCK_TIMESTAMP;
    @JvmField
    @NotNull
    public static final AbiFunction FUNCTION_GET_BLOCK_HASH;
    @JvmField
    @NotNull
    public static final AbiFunction FUNCTION_GET_LAST_BLOCK_HASH;
    @JvmField
    @NotNull
    public static final AbiFunction FUNCTION_GET_CURRENT_BLOCK_GAS_LIMIT;

    public Multicall3(@NotNull Middleware provider, @NotNull Address address) {
        super(provider, address);
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final <T> FunctionCall<AggregationResult<T>> aggregateCalls(Aggregatable<? extends T> ... calls) {
        FunctionCall<AggregationResult> functionCall;
        Aggregatable<? extends T>[] $this$withDataAndValue$iv = calls;
        boolean $i$f$withDataAndValue = false;
        if ($this$withDataAndValue$iv.length == 0) {
            void value;
            Object var4_4 = null;
            Bytes data = Bytes.EMPTY;
            boolean bl = false;
            functionCall = new FunctionCall<AggregationResult>(this.getProvider(), this.getAddress(), (BigInteger)value, data, arg_0 -> Multicall3.aggregateCalls$lambda$1$lambda$0(calls, this, arg_0));
        } else {
            boolean anyPayable$iv = false;
            boolean mixedFailureConditions$iv = false;
            int value = $this$withDataAndValue$iv.length;
            for (int i$iv = 0; i$iv < value; ++i$iv) {
                Aggregatable<T> call$iv = $this$withDataAndValue$iv[i$iv];
                if (call$iv.getValue() != null && !Intrinsics.areEqual((Object)call$iv.getValue(), (Object)BigInteger.ZERO)) {
                    anyPayable$iv = true;
                    break;
                }
                if (i$iv <= 0 || call$iv.getAllowFailure() == $this$withDataAndValue$iv[0].getAllowFailure()) continue;
                mixedFailureConditions$iv = true;
                break;
            }
            if (anyPayable$iv) {
                void value2;
                BigInteger totalValue$iv = BigInteger.ZERO;
                int n = $this$withDataAndValue$iv.length;
                Call3Value[] call3ValueArray = new Call3Value[n];
                for (int i = 0; i < n; ++i) {
                    int n2 = i;
                    Aggregatable<T> req$iv = $this$withDataAndValue$iv[n2];
                    BigInteger bigInteger = req$iv.getValue();
                    if (bigInteger == null) {
                        bigInteger = BigInteger.ZERO;
                    }
                    BigInteger value$iv = bigInteger;
                    Intrinsics.checkNotNullExpressionValue((Object)totalValue$iv.add(value$iv), (String)"add(...)");
                    Address address = req$iv.getTo();
                    Intrinsics.checkNotNull((Object)address);
                    boolean bl = req$iv.getAllowFailure();
                    Bytes bytes = req$iv.getData();
                    if (bytes == null) {
                        bytes = Bytes.EMPTY;
                    }
                    call3ValueArray[n2] = new Call3Value(address, bl, value$iv, bytes);
                }
                Call3Value[] arr$iv2 = call3ValueArray;
                Call3Value[][] call3ValueArrayArray = new Call3Value[][]{arr$iv2};
                BigInteger bigInteger = totalValue$iv;
                Bytes data = FUNCTION_AGGREGATE3_VALUE.encodeCall((Object[])call3ValueArrayArray);
                boolean bl = false;
                functionCall = new FunctionCall<AggregationResult>(this.getProvider(), this.getAddress(), (BigInteger)value2, data, arg_0 -> Multicall3.aggregateCalls$lambda$1$lambda$0(calls, this, arg_0));
            } else if (mixedFailureConditions$iv) {
                int n = $this$withDataAndValue$iv.length;
                Call3[] call3Array = new Call3[n];
                for (int arr$iv2 = 0; arr$iv2 < n; ++arr$iv2) {
                    int n3 = arr$iv2;
                    Aggregatable<T> req$iv = $this$withDataAndValue$iv[n3];
                    Address address = req$iv.getTo();
                    Intrinsics.checkNotNull((Object)address);
                    boolean bl = req$iv.getAllowFailure();
                    Bytes bytes = req$iv.getData();
                    if (bytes == null) {
                        bytes = Bytes.EMPTY;
                    }
                    call3Array[n3] = new Call3(address, bl, bytes);
                }
                Call3[] arr$iv = call3Array;
                Call3[][] arr$iv2 = new Call3[][]{arr$iv};
                BigInteger value2 = null;
                Bytes data = FUNCTION_AGGREGATE3.encodeCall((Object[])arr$iv2);
                boolean bl = false;
                functionCall = new FunctionCall<AggregationResult>(this.getProvider(), this.getAddress(), value2, data, arg_0 -> Multicall3.aggregateCalls$lambda$1$lambda$0(calls, this, arg_0));
            } else {
                boolean allowFailure$iv = $this$withDataAndValue$iv[0].getAllowFailure();
                int n = $this$withDataAndValue$iv.length;
                Call[] callArray = new Call[n];
                for (int i = 0; i < n; ++i) {
                    int n4 = i;
                    Aggregatable<T> req$iv = $this$withDataAndValue$iv[n4];
                    Address address = req$iv.getTo();
                    Intrinsics.checkNotNull((Object)address);
                    Bytes bytes = req$iv.getData();
                    if (bytes == null) {
                        bytes = Bytes.EMPTY;
                    }
                    callArray[n4] = new Call(address, bytes);
                }
                Call[] arr$iv = callArray;
                Object[] objectArray = new Serializable[]{Boolean.valueOf(!allowFailure$iv), arr$iv};
                BigInteger value3 = null;
                Bytes data = FUNCTION_TRY_AGGREGATE.encodeCall(objectArray);
                boolean bl = false;
                functionCall = new FunctionCall<AggregationResult>(this.getProvider(), this.getAddress(), value3, data, arg_0 -> Multicall3.aggregateCalls$lambda$1$lambda$0(calls, this, arg_0));
            }
        }
        return functionCall;
    }

    @NotNull
    public final PayableFunctionCall<AggregateResult> aggregate(Call ... calls) {
        Call[][] callArrayArray = new Call[][]{calls};
        return new PayableFunctionCall<AggregateResult>(this.getProvider(), this.getAddress(), FUNCTION_AGGREGATE.encodeCall((Object[])callArrayArray), Multicall3::aggregate$lambda$2);
    }

    @NotNull
    public final PayableFunctionCall<Result[]> aggregate3(Call3 ... calls) {
        Call3[][] call3ArrayArray = new Call3[][]{calls};
        return new PayableFunctionCall<Result[]>(this.getProvider(), this.getAddress(), FUNCTION_AGGREGATE3.encodeCall((Object[])call3ArrayArray), Multicall3::aggregate3$lambda$3);
    }

    @NotNull
    public final PayableFunctionCall<Result[]> aggregate3Value(Call3Value ... calls) {
        Call3Value[][] call3ValueArrayArray = new Call3Value[][]{calls};
        return new PayableFunctionCall<Result[]>(this.getProvider(), this.getAddress(), FUNCTION_AGGREGATE3_VALUE.encodeCall((Object[])call3ValueArrayArray), Multicall3::aggregate3Value$lambda$4);
    }

    @NotNull
    public final PayableFunctionCall<BlockAndAggregateResult> blockAndAggregate(Call ... calls) {
        Call[][] callArrayArray = new Call[][]{calls};
        return new PayableFunctionCall<BlockAndAggregateResult>(this.getProvider(), this.getAddress(), FUNCTION_BLOCK_AND_AGGREGATE.encodeCall((Object[])callArrayArray), Multicall3::blockAndAggregate$lambda$5);
    }

    @NotNull
    public final ReadFunctionCall<BigInteger> getBasefee() {
        return new ReadFunctionCall<BigInteger>(this.getProvider(), this.getAddress(), FUNCTION_GET_BASEFEE.encodeCall(new Object[0]), Multicall3::getBasefee$lambda$6);
    }

    @NotNull
    public final ReadFunctionCall<Bytes> getBlockHash(@NotNull BigInteger blockNumber) {
        Object[] objectArray = new BigInteger[]{blockNumber};
        return new ReadFunctionCall<Bytes>(this.getProvider(), this.getAddress(), FUNCTION_GET_BLOCK_HASH.encodeCall(objectArray), Multicall3::getBlockHash$lambda$7);
    }

    @NotNull
    public final ReadFunctionCall<BigInteger> getBlockNumber() {
        return new ReadFunctionCall<BigInteger>(this.getProvider(), this.getAddress(), FUNCTION_GET_BLOCK_NUMBER.encodeCall(new Object[0]), Multicall3::getBlockNumber$lambda$8);
    }

    @NotNull
    public final ReadFunctionCall<BigInteger> getChainId() {
        return new ReadFunctionCall<BigInteger>(this.getProvider(), this.getAddress(), FUNCTION_GET_CHAIN_ID.encodeCall(new Object[0]), Multicall3::getChainId$lambda$9);
    }

    @NotNull
    public final ReadFunctionCall<Address> getCurrentBlockCoinbase() {
        return new ReadFunctionCall<Address>(this.getProvider(), this.getAddress(), FUNCTION_GET_CURRENT_BLOCK_COINBASE.encodeCall(new Object[0]), Multicall3::getCurrentBlockCoinbase$lambda$10);
    }

    @NotNull
    public final ReadFunctionCall<BigInteger> getCurrentBlockDifficulty() {
        return new ReadFunctionCall<BigInteger>(this.getProvider(), this.getAddress(), FUNCTION_GET_CURRENT_BLOCK_DIFFICULTY.encodeCall(new Object[0]), Multicall3::getCurrentBlockDifficulty$lambda$11);
    }

    @NotNull
    public final ReadFunctionCall<BigInteger> getCurrentBlockGasLimit() {
        return new ReadFunctionCall<BigInteger>(this.getProvider(), this.getAddress(), FUNCTION_GET_CURRENT_BLOCK_GAS_LIMIT.encodeCall(new Object[0]), Multicall3::getCurrentBlockGasLimit$lambda$12);
    }

    @NotNull
    public final ReadFunctionCall<BigInteger> getCurrentBlockTimestamp() {
        return new ReadFunctionCall<BigInteger>(this.getProvider(), this.getAddress(), FUNCTION_GET_CURRENT_BLOCK_TIMESTAMP.encodeCall(new Object[0]), Multicall3::getCurrentBlockTimestamp$lambda$13);
    }

    @NotNull
    public final ReadFunctionCall<BigInteger> getEthBalance(@NotNull Address addr) {
        Object[] objectArray = new Address[]{addr};
        return new ReadFunctionCall<BigInteger>(this.getProvider(), this.getAddress(), FUNCTION_GET_ETH_BALANCE.encodeCall(objectArray), Multicall3::getEthBalance$lambda$14);
    }

    @NotNull
    public final ReadFunctionCall<Bytes> getLastBlockHash() {
        return new ReadFunctionCall<Bytes>(this.getProvider(), this.getAddress(), FUNCTION_GET_LAST_BLOCK_HASH.encodeCall(new Object[0]), Multicall3::getLastBlockHash$lambda$15);
    }

    @NotNull
    public final PayableFunctionCall<Result[]> tryAggregate(boolean requireSuccess, Call ... calls) {
        Object[] objectArray = new Serializable[]{Boolean.valueOf(requireSuccess), calls};
        return new PayableFunctionCall<Result[]>(this.getProvider(), this.getAddress(), FUNCTION_TRY_AGGREGATE.encodeCall(objectArray), Multicall3::tryAggregate$lambda$16);
    }

    @NotNull
    public final PayableFunctionCall<TryBlockAndAggregateResult> tryBlockAndAggregate(boolean requireSuccess, Call ... calls) {
        Object[] objectArray = new Serializable[]{Boolean.valueOf(requireSuccess), calls};
        return new PayableFunctionCall<TryBlockAndAggregateResult>(this.getProvider(), this.getAddress(), FUNCTION_TRY_BLOCK_AND_AGGREGATE.encodeCall(objectArray), Multicall3::tryBlockAndAggregate$lambda$17);
    }

    private final <T> io.ethers.core.Result<T, ContractError> handleRequestResult(Aggregatable<T> request, Result result) {
        io.ethers.core.Result res = result.getSuccess() ? request.decodeCallResult(result.getReturnData()) : ResultKt.failure((Result.Error)this.tryDecodingCallRevert(result.getReturnData()));
        return res;
    }

    private final ContractError tryDecodingCallRevert(Bytes err) {
        ContractError contractError = ContractError.Companion.getOrNull(err);
        if (contractError != null) {
            return contractError;
        }
        return new RevertError(err.toString());
    }

    private static final AggregationResult aggregateCalls$lambda$1$lambda$0(Aggregatable[] $calls, Multicall3 this$0, Bytes it) {
        Object object = FUNCTION_AGGREGATE3_VALUE.decodeResponse(it)[0];
        Intrinsics.checkNotNull((Object)object, (String)"null cannot be cast to non-null type kotlin.Array<io.ethers.abi.call.Multicall3.Result>");
        Result[] decoded = (Result[])object;
        io.ethers.core.Result[] ret = new io.ethers.core.Result[decoded.length];
        int n = decoded.length;
        for (int i = 0; i < n; ++i) {
            Aggregatable request = $calls[i];
            Result callResult = decoded[i];
            ret[i] = this$0.handleRequestResult(request, callResult);
        }
        return new AggregationResult(ret);
    }

    private static final AggregateResult aggregate$lambda$2(Bytes it) {
        Object[] data = FUNCTION_AGGREGATE.decodeResponse(it);
        Object object = data[0];
        Intrinsics.checkNotNull((Object)object, (String)"null cannot be cast to non-null type java.math.BigInteger");
        BigInteger bigInteger = (BigInteger)object;
        Object object2 = data[1];
        Intrinsics.checkNotNull((Object)object2, (String)"null cannot be cast to non-null type kotlin.Array<io.ethers.core.types.Bytes>");
        return new AggregateResult(bigInteger, (Bytes[])object2);
    }

    private static final Result[] aggregate3$lambda$3(Bytes it) {
        Object[] data = FUNCTION_AGGREGATE3.decodeResponse(it);
        Object object = data[0];
        Intrinsics.checkNotNull((Object)object, (String)"null cannot be cast to non-null type kotlin.Array<io.ethers.abi.call.Multicall3.Result>");
        return (Result[])object;
    }

    private static final Result[] aggregate3Value$lambda$4(Bytes it) {
        Object[] data = FUNCTION_AGGREGATE3_VALUE.decodeResponse(it);
        Object object = data[0];
        Intrinsics.checkNotNull((Object)object, (String)"null cannot be cast to non-null type kotlin.Array<io.ethers.abi.call.Multicall3.Result>");
        return (Result[])object;
    }

    private static final BlockAndAggregateResult blockAndAggregate$lambda$5(Bytes it) {
        Object[] data = FUNCTION_BLOCK_AND_AGGREGATE.decodeResponse(it);
        Object object = data[0];
        Intrinsics.checkNotNull((Object)object, (String)"null cannot be cast to non-null type java.math.BigInteger");
        BigInteger bigInteger = (BigInteger)object;
        Object object2 = data[1];
        Intrinsics.checkNotNull((Object)object2, (String)"null cannot be cast to non-null type io.ethers.core.types.Bytes");
        Bytes bytes = (Bytes)object2;
        Object object3 = data[2];
        Intrinsics.checkNotNull((Object)object3, (String)"null cannot be cast to non-null type kotlin.Array<io.ethers.abi.call.Multicall3.Result>");
        return new BlockAndAggregateResult(bigInteger, bytes, (Result[])object3);
    }

    private static final BigInteger getBasefee$lambda$6(Bytes it) {
        Object[] data = FUNCTION_GET_BASEFEE.decodeResponse(it);
        Object object = data[0];
        Intrinsics.checkNotNull((Object)object, (String)"null cannot be cast to non-null type java.math.BigInteger");
        return (BigInteger)object;
    }

    private static final Bytes getBlockHash$lambda$7(Bytes it) {
        Object[] data = FUNCTION_GET_BLOCK_HASH.decodeResponse(it);
        Object object = data[0];
        Intrinsics.checkNotNull((Object)object, (String)"null cannot be cast to non-null type io.ethers.core.types.Bytes");
        return (Bytes)object;
    }

    private static final BigInteger getBlockNumber$lambda$8(Bytes it) {
        Object[] data = FUNCTION_GET_BLOCK_NUMBER.decodeResponse(it);
        Object object = data[0];
        Intrinsics.checkNotNull((Object)object, (String)"null cannot be cast to non-null type java.math.BigInteger");
        return (BigInteger)object;
    }

    private static final BigInteger getChainId$lambda$9(Bytes it) {
        Object[] data = FUNCTION_GET_CHAIN_ID.decodeResponse(it);
        Object object = data[0];
        Intrinsics.checkNotNull((Object)object, (String)"null cannot be cast to non-null type java.math.BigInteger");
        return (BigInteger)object;
    }

    private static final Address getCurrentBlockCoinbase$lambda$10(Bytes it) {
        Object[] data = FUNCTION_GET_CURRENT_BLOCK_COINBASE.decodeResponse(it);
        Object object = data[0];
        Intrinsics.checkNotNull((Object)object, (String)"null cannot be cast to non-null type io.ethers.core.types.Address");
        return (Address)object;
    }

    private static final BigInteger getCurrentBlockDifficulty$lambda$11(Bytes it) {
        Object[] data = FUNCTION_GET_CURRENT_BLOCK_DIFFICULTY.decodeResponse(it);
        Object object = data[0];
        Intrinsics.checkNotNull((Object)object, (String)"null cannot be cast to non-null type java.math.BigInteger");
        return (BigInteger)object;
    }

    private static final BigInteger getCurrentBlockGasLimit$lambda$12(Bytes it) {
        Object[] data = FUNCTION_GET_CURRENT_BLOCK_GAS_LIMIT.decodeResponse(it);
        Object object = data[0];
        Intrinsics.checkNotNull((Object)object, (String)"null cannot be cast to non-null type java.math.BigInteger");
        return (BigInteger)object;
    }

    private static final BigInteger getCurrentBlockTimestamp$lambda$13(Bytes it) {
        Object[] data = FUNCTION_GET_CURRENT_BLOCK_TIMESTAMP.decodeResponse(it);
        Object object = data[0];
        Intrinsics.checkNotNull((Object)object, (String)"null cannot be cast to non-null type java.math.BigInteger");
        return (BigInteger)object;
    }

    private static final BigInteger getEthBalance$lambda$14(Bytes it) {
        Object[] data = FUNCTION_GET_ETH_BALANCE.decodeResponse(it);
        Object object = data[0];
        Intrinsics.checkNotNull((Object)object, (String)"null cannot be cast to non-null type java.math.BigInteger");
        return (BigInteger)object;
    }

    private static final Bytes getLastBlockHash$lambda$15(Bytes it) {
        Object[] data = FUNCTION_GET_LAST_BLOCK_HASH.decodeResponse(it);
        Object object = data[0];
        Intrinsics.checkNotNull((Object)object, (String)"null cannot be cast to non-null type io.ethers.core.types.Bytes");
        return (Bytes)object;
    }

    private static final Result[] tryAggregate$lambda$16(Bytes it) {
        Object[] data = FUNCTION_TRY_AGGREGATE.decodeResponse(it);
        Object object = data[0];
        Intrinsics.checkNotNull((Object)object, (String)"null cannot be cast to non-null type kotlin.Array<io.ethers.abi.call.Multicall3.Result>");
        return (Result[])object;
    }

    private static final TryBlockAndAggregateResult tryBlockAndAggregate$lambda$17(Bytes it) {
        Object[] data = FUNCTION_TRY_BLOCK_AND_AGGREGATE.decodeResponse(it);
        Object object = data[0];
        Intrinsics.checkNotNull((Object)object, (String)"null cannot be cast to non-null type java.math.BigInteger");
        BigInteger bigInteger = (BigInteger)object;
        Object object2 = data[1];
        Intrinsics.checkNotNull((Object)object2, (String)"null cannot be cast to non-null type io.ethers.core.types.Bytes");
        Bytes bytes = (Bytes)object2;
        Object object3 = data[2];
        Intrinsics.checkNotNull((Object)object3, (String)"null cannot be cast to non-null type kotlin.Array<io.ethers.abi.call.Multicall3.Result>");
        return new TryBlockAndAggregateResult(bigInteger, bytes, (Result[])object3);
    }

    private static final HashMap DEPLOYMENT_PER_CHAIN_ID_delegate$lambda$19() {
        HashMap ret = new HashMap();
        ObjectReader reader = Jackson.MAPPER.readerFor(Companion.MulticallDeployment.class);
        InputStream stream = Multicall3.class.getResourceAsStream("/multicall3-deployments.json");
        MappingIterator deployments = reader.readValues(stream);
        Iterator $this$forEach$iv = (Iterator)deployments;
        boolean $i$f$forEach = false;
        Iterator iterator = $this$forEach$iv;
        while (iterator.hasNext()) {
            Object element$iv = iterator.next();
            Companion.MulticallDeployment it = (Companion.MulticallDeployment)element$iv;
            boolean bl = false;
            ((Map)ret).put(it.getChainId(), it);
        }
        return ret;
    }

    @JvmStatic
    @NotNull
    public static final Address getAddressForChainId(long chainId) {
        return Companion.getAddressForChainId(chainId);
    }

    @JvmStatic
    @NotNull
    public static final Multicall3 getInstance(@NotNull Middleware provider) {
        return Companion.getInstance(provider);
    }

    @JvmStatic
    @NotNull
    public static final <T> FunctionCall<AggregationResult<T>> aggregate(Aggregatable<? extends T> ... calls) {
        return Companion.aggregate(calls);
    }

    static {
        Object[] objectArray = new AbiType[]{AbiType.Address.INSTANCE, AbiType.Bool.INSTANCE, AbiType.Bytes.INSTANCE};
        AbiType.Array array = new AbiType.Array(AbiType.Tuple.Companion.struct(Reflection.getOrCreateKotlinClass(Call3.class), (AbiType[])objectArray));
        objectArray = new AbiType[]{AbiType.Bool.INSTANCE, AbiType.Bytes.INSTANCE};
        FUNCTION_AGGREGATE3 = new AbiFunction("aggregate3", CollectionsKt.listOf(array), CollectionsKt.listOf(new AbiType.Array(AbiType.Tuple.Companion.struct(Reflection.getOrCreateKotlinClass(Result.class), (AbiType[])objectArray))));
        objectArray = new AbiType[]{AbiType.Address.INSTANCE, AbiType.Bytes.INSTANCE};
        AbiType.Array array2 = new AbiType.Array(AbiType.Tuple.Companion.struct(Reflection.getOrCreateKotlinClass(Call.class), (AbiType[])objectArray));
        objectArray = new AbiType[3];
        objectArray[0] = new AbiType.UInt(256);
        objectArray[1] = new AbiType.FixedBytes(32);
        AbiType[] abiTypeArray = new AbiType[]{AbiType.Bool.INSTANCE, AbiType.Bytes.INSTANCE};
        objectArray[2] = new AbiType.Array(AbiType.Tuple.Companion.struct(Reflection.getOrCreateKotlinClass(Result.class), abiTypeArray));
        FUNCTION_BLOCK_AND_AGGREGATE = new AbiFunction("blockAndAggregate", CollectionsKt.listOf(array2), CollectionsKt.listOf((Object[])objectArray));
        objectArray = new AbiType[]{AbiType.Address.INSTANCE, AbiType.Bool.INSTANCE, new AbiType.UInt(256), AbiType.Bytes.INSTANCE};
        AbiType.Array array3 = new AbiType.Array(AbiType.Tuple.Companion.struct(Reflection.getOrCreateKotlinClass(Call3Value.class), (AbiType[])objectArray));
        objectArray = new AbiType[]{AbiType.Bool.INSTANCE, AbiType.Bytes.INSTANCE};
        FUNCTION_AGGREGATE3_VALUE = new AbiFunction("aggregate3Value", CollectionsKt.listOf(array3), CollectionsKt.listOf(new AbiType.Array(AbiType.Tuple.Companion.struct(Reflection.getOrCreateKotlinClass(Result.class), (AbiType[])objectArray))));
        FUNCTION_GET_BASEFEE = new AbiFunction("getBasefee", CollectionsKt.emptyList(), CollectionsKt.listOf((Object)new AbiType.UInt(256)));
        objectArray = new AbiType[]{AbiType.Address.INSTANCE, AbiType.Bytes.INSTANCE};
        AbiType.Array array4 = new AbiType.Array(AbiType.Tuple.Companion.struct(Reflection.getOrCreateKotlinClass(Call.class), (AbiType[])objectArray));
        objectArray = new AbiType[]{new AbiType.UInt(256), new AbiType.Array(AbiType.Bytes.INSTANCE)};
        FUNCTION_AGGREGATE = new AbiFunction("aggregate", CollectionsKt.listOf(array4), CollectionsKt.listOf((Object[])objectArray));
        FUNCTION_GET_CURRENT_BLOCK_DIFFICULTY = new AbiFunction("getCurrentBlockDifficulty", CollectionsKt.emptyList(), CollectionsKt.listOf((Object)new AbiType.UInt(256)));
        FUNCTION_GET_CURRENT_BLOCK_COINBASE = new AbiFunction("getCurrentBlockCoinbase", CollectionsKt.emptyList(), CollectionsKt.listOf((Object)AbiType.Address.INSTANCE));
        FUNCTION_GET_ETH_BALANCE = new AbiFunction("getEthBalance", CollectionsKt.listOf((Object)AbiType.Address.INSTANCE), CollectionsKt.listOf((Object)new AbiType.UInt(256)));
        FUNCTION_GET_BLOCK_NUMBER = new AbiFunction("getBlockNumber", CollectionsKt.emptyList(), CollectionsKt.listOf((Object)new AbiType.UInt(256)));
        objectArray = new AbiType[2];
        objectArray[0] = AbiType.Bool.INSTANCE;
        abiTypeArray = new AbiType[]{AbiType.Address.INSTANCE, AbiType.Bytes.INSTANCE};
        objectArray[1] = new AbiType.Array(AbiType.Tuple.Companion.struct(Reflection.getOrCreateKotlinClass(Call.class), abiTypeArray));
        List list = CollectionsKt.listOf((Object[])objectArray);
        objectArray = new AbiType[]{AbiType.Bool.INSTANCE, AbiType.Bytes.INSTANCE};
        FUNCTION_TRY_AGGREGATE = new AbiFunction("tryAggregate", list, CollectionsKt.listOf(new AbiType.Array(AbiType.Tuple.Companion.struct(Reflection.getOrCreateKotlinClass(Result.class), (AbiType[])objectArray))));
        objectArray = new AbiType[2];
        objectArray[0] = AbiType.Bool.INSTANCE;
        abiTypeArray = new AbiType[]{AbiType.Address.INSTANCE, AbiType.Bytes.INSTANCE};
        objectArray[1] = new AbiType.Array(AbiType.Tuple.Companion.struct(Reflection.getOrCreateKotlinClass(Call.class), abiTypeArray));
        List list2 = CollectionsKt.listOf((Object[])objectArray);
        objectArray = new AbiType[3];
        objectArray[0] = new AbiType.UInt(256);
        objectArray[1] = new AbiType.FixedBytes(32);
        abiTypeArray = new AbiType[]{AbiType.Bool.INSTANCE, AbiType.Bytes.INSTANCE};
        objectArray[2] = new AbiType.Array(AbiType.Tuple.Companion.struct(Reflection.getOrCreateKotlinClass(Result.class), abiTypeArray));
        FUNCTION_TRY_BLOCK_AND_AGGREGATE = new AbiFunction("tryBlockAndAggregate", list2, CollectionsKt.listOf((Object[])objectArray));
        FUNCTION_GET_CHAIN_ID = new AbiFunction("getChainId", CollectionsKt.emptyList(), CollectionsKt.listOf((Object)new AbiType.UInt(256)));
        FUNCTION_GET_CURRENT_BLOCK_TIMESTAMP = new AbiFunction("getCurrentBlockTimestamp", CollectionsKt.emptyList(), CollectionsKt.listOf((Object)new AbiType.UInt(256)));
        FUNCTION_GET_BLOCK_HASH = new AbiFunction("getBlockHash", CollectionsKt.listOf((Object)new AbiType.UInt(256)), CollectionsKt.listOf((Object)new AbiType.FixedBytes(32)));
        FUNCTION_GET_LAST_BLOCK_HASH = new AbiFunction("getLastBlockHash", CollectionsKt.emptyList(), CollectionsKt.listOf((Object)new AbiType.FixedBytes(32)));
        FUNCTION_GET_CURRENT_BLOCK_GAS_LIMIT = new AbiFunction("getCurrentBlockGasLimit", CollectionsKt.emptyList(), CollectionsKt.listOf((Object)new AbiType.UInt(256)));
    }

    @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000@\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\bf\u0018\u0000*\u0004\b\u0000\u0010\u00012\u00020\u0002J\u001c\u0010\u0017\u001a\u000e\u0012\u0004\u0012\u00028\u0000\u0012\u0004\u0012\u00020\u00190\u00182\u0006\u0010\u001a\u001a\u00020\u0010H&J\u000e\u0010\u0013\u001a\b\u0012\u0004\u0012\u00028\u00000\u0000H\u0016R\u0012\u0010\u0003\u001a\u00020\u0004X\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0005\u0010\u0006R\u0014\u0010\u0007\u001a\u0004\u0018\u00010\bX\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\t\u0010\nR\u0014\u0010\u000b\u001a\u0004\u0018\u00010\fX\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\r\u0010\u000eR\u0014\u0010\u000f\u001a\u0004\u0018\u00010\u0010X\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0011\u0010\u0012R\u0014\u0010\u0013\u001a\u00020\u00148VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0015\u0010\u0016\u00f8\u0001\u0000\u0082\u0002\u0006\n\u0004\b!0\u0001\u00a8\u0006\u001b\u00c0\u0006\u0001"}, d2={"Lio/ethers/abi/call/Multicall3$Aggregatable;", "T", "Lio/ethers/core/types/IntoCallRequest;", "provider", "Lio/ethers/providers/middleware/Middleware;", "getProvider", "()Lio/ethers/providers/middleware/Middleware;", "to", "Lio/ethers/core/types/Address;", "getTo", "()Lio/ethers/core/types/Address;", "value", "Ljava/math/BigInteger;", "getValue", "()Ljava/math/BigInteger;", "data", "Lio/ethers/core/types/Bytes;", "getData", "()Lio/ethers/core/types/Bytes;", "allowFailure", "", "getAllowFailure", "()Z", "decodeCallResult", "Lio/ethers/core/Result;", "Lio/ethers/abi/error/ContractError;", "result", "ethers-abi"})
    public static interface Aggregatable<T>
    extends IntoCallRequest {
        @NotNull
        public Middleware getProvider();

        @Nullable
        public Address getTo();

        @Nullable
        public BigInteger getValue();

        @Nullable
        public Bytes getData();

        default public boolean getAllowFailure() {
            return false;
        }

        @NotNull
        public io.ethers.core.Result<T, ContractError> decodeCallResult(@NotNull Bytes var1);

        @NotNull
        default public Aggregatable<T> allowFailure() {
            if (this.getAllowFailure()) {
                return this;
            }
            return new Aggregatable<T>(this){
                private final /* synthetic */ Aggregatable<T> $$delegate_0;
                {
                    this.$$delegate_0 = $receiver;
                }

                public boolean getAllowFailure() {
                    return true;
                }

                public Middleware getProvider() {
                    return this.$$delegate_0.getProvider();
                }

                public Address getTo() {
                    return this.$$delegate_0.getTo();
                }

                public BigInteger getValue() {
                    return this.$$delegate_0.getValue();
                }

                public Bytes getData() {
                    return this.$$delegate_0.getData();
                }

                public Aggregatable<T> allowFailure() {
                    return this.$$delegate_0.allowFailure();
                }

                public io.ethers.core.Result<T, ContractError> decodeCallResult(Bytes result) {
                    return this.$$delegate_0.decodeCallResult(result);
                }

                public CallRequest toCallRequest() {
                    return this.$$delegate_0.toCallRequest();
                }
            };
        }
    }

    @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0011\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0005\n\u0002\u0010\u000e\n\u0000\b\u0086\b\u0018\u00002\u00020\u0001B\u001d\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\f\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005\u00a2\u0006\u0004\b\u0007\u0010\bJ\u0013\u0010\u000e\u001a\u00020\u000f2\b\u0010\u0010\u001a\u0004\u0018\u00010\u0001H\u0096\u0002J\b\u0010\u0011\u001a\u00020\u0012H\u0016J\t\u0010\u0013\u001a\u00020\u0003H\u00c6\u0003J\u0014\u0010\u0014\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005H\u00c6\u0003\u00a2\u0006\u0002\u0010\fJ(\u0010\u0015\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\u000e\b\u0002\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005H\u00c6\u0001\u00a2\u0006\u0002\u0010\u0016J\t\u0010\u0017\u001a\u00020\u0018H\u00d6\u0001R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nR\u0019\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005\u00a2\u0006\n\n\u0002\u0010\r\u001a\u0004\b\u000b\u0010\f\u00a8\u0006\u0019"}, d2={"Lio/ethers/abi/call/Multicall3$AggregateResult;", "", "blockNumber", "Ljava/math/BigInteger;", "returnData", "", "Lio/ethers/core/types/Bytes;", "<init>", "(Ljava/math/BigInteger;[Lio/ethers/core/types/Bytes;)V", "getBlockNumber", "()Ljava/math/BigInteger;", "getReturnData", "()[Lio/ethers/core/types/Bytes;", "[Lio/ethers/core/types/Bytes;", "equals", "", "other", "hashCode", "", "component1", "component2", "copy", "(Ljava/math/BigInteger;[Lio/ethers/core/types/Bytes;)Lio/ethers/abi/call/Multicall3$AggregateResult;", "toString", "", "ethers-abi"})
    public static final class AggregateResult {
        @NotNull
        private final BigInteger blockNumber;
        @NotNull
        private final Bytes[] returnData;

        public AggregateResult(@NotNull BigInteger blockNumber, @NotNull Bytes[] returnData) {
            this.blockNumber = blockNumber;
            this.returnData = returnData;
        }

        @NotNull
        public final BigInteger getBlockNumber() {
            return this.blockNumber;
        }

        @NotNull
        public final Bytes[] getReturnData() {
            return this.returnData;
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            Object object = other;
            if (!Intrinsics.areEqual(this.getClass(), object != null ? object.getClass() : null)) {
                return false;
            }
            Intrinsics.checkNotNull((Object)other, (String)"null cannot be cast to non-null type io.ethers.abi.call.Multicall3.AggregateResult");
            AggregateResult cfr_ignored_0 = (AggregateResult)other;
            if (!Intrinsics.areEqual((Object)this.blockNumber, (Object)((AggregateResult)other).blockNumber)) {
                return false;
            }
            return Arrays.equals(this.returnData, ((AggregateResult)other).returnData);
        }

        public int hashCode() {
            int result = this.blockNumber.hashCode();
            result = 31 * result + Arrays.hashCode(this.returnData);
            return result;
        }

        @NotNull
        public final BigInteger component1() {
            return this.blockNumber;
        }

        @NotNull
        public final Bytes[] component2() {
            return this.returnData;
        }

        @NotNull
        public final AggregateResult copy(@NotNull BigInteger blockNumber, @NotNull Bytes[] returnData) {
            return new AggregateResult(blockNumber, returnData);
        }

        public static /* synthetic */ AggregateResult copy$default(AggregateResult aggregateResult, BigInteger bigInteger, Bytes[] bytesArray, int n, Object object) {
            if ((n & 1) != 0) {
                bigInteger = aggregateResult.blockNumber;
            }
            if ((n & 2) != 0) {
                bytesArray = aggregateResult.returnData;
            }
            return aggregateResult.copy(bigInteger, bytesArray);
        }

        @NotNull
        public String toString() {
            return "AggregateResult(blockNumber=" + this.blockNumber + ", returnData=" + Arrays.toString(this.returnData) + ")";
        }
    }

    @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u00008\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0011\n\u0002\u0018\u0002\n\u0002\b\n\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0006\n\u0002\u0010\u000e\n\u0000\b\u0086\b\u0018\u00002\u00020\u0001B%\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\f\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\b0\u0007\u00a2\u0006\u0004\b\t\u0010\nJ\u0013\u0010\u0012\u001a\u00020\u00132\b\u0010\u0014\u001a\u0004\u0018\u00010\u0001H\u0096\u0002J\b\u0010\u0015\u001a\u00020\u0016H\u0016J\t\u0010\u0017\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\u0018\u001a\u00020\u0005H\u00c6\u0003J\u0014\u0010\u0019\u001a\b\u0012\u0004\u0012\u00020\b0\u0007H\u00c6\u0003\u00a2\u0006\u0002\u0010\u0010J2\u0010\u001a\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u00052\u000e\b\u0002\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\b0\u0007H\u00c6\u0001\u00a2\u0006\u0002\u0010\u001bJ\t\u0010\u001c\u001a\u00020\u001dH\u00d6\u0001R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000eR\u0019\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\b0\u0007\u00a2\u0006\n\n\u0002\u0010\u0011\u001a\u0004\b\u000f\u0010\u0010\u00a8\u0006\u001e"}, d2={"Lio/ethers/abi/call/Multicall3$BlockAndAggregateResult;", "", "blockNumber", "Ljava/math/BigInteger;", "blockHash", "Lio/ethers/core/types/Bytes;", "returnData", "", "Lio/ethers/abi/call/Multicall3$Result;", "<init>", "(Ljava/math/BigInteger;Lio/ethers/core/types/Bytes;[Lio/ethers/abi/call/Multicall3$Result;)V", "getBlockNumber", "()Ljava/math/BigInteger;", "getBlockHash", "()Lio/ethers/core/types/Bytes;", "getReturnData", "()[Lio/ethers/abi/call/Multicall3$Result;", "[Lio/ethers/abi/call/Multicall3$Result;", "equals", "", "other", "hashCode", "", "component1", "component2", "component3", "copy", "(Ljava/math/BigInteger;Lio/ethers/core/types/Bytes;[Lio/ethers/abi/call/Multicall3$Result;)Lio/ethers/abi/call/Multicall3$BlockAndAggregateResult;", "toString", "", "ethers-abi"})
    public static final class BlockAndAggregateResult {
        @NotNull
        private final BigInteger blockNumber;
        @NotNull
        private final Bytes blockHash;
        @NotNull
        private final Result[] returnData;

        public BlockAndAggregateResult(@NotNull BigInteger blockNumber, @NotNull Bytes blockHash, @NotNull Result[] returnData) {
            this.blockNumber = blockNumber;
            this.blockHash = blockHash;
            this.returnData = returnData;
        }

        @NotNull
        public final BigInteger getBlockNumber() {
            return this.blockNumber;
        }

        @NotNull
        public final Bytes getBlockHash() {
            return this.blockHash;
        }

        @NotNull
        public final Result[] getReturnData() {
            return this.returnData;
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            Object object = other;
            if (!Intrinsics.areEqual(this.getClass(), object != null ? object.getClass() : null)) {
                return false;
            }
            Intrinsics.checkNotNull((Object)other, (String)"null cannot be cast to non-null type io.ethers.abi.call.Multicall3.BlockAndAggregateResult");
            BlockAndAggregateResult cfr_ignored_0 = (BlockAndAggregateResult)other;
            if (!Intrinsics.areEqual((Object)this.blockNumber, (Object)((BlockAndAggregateResult)other).blockNumber)) {
                return false;
            }
            if (!Intrinsics.areEqual((Object)this.blockHash, (Object)((BlockAndAggregateResult)other).blockHash)) {
                return false;
            }
            return Arrays.equals(this.returnData, ((BlockAndAggregateResult)other).returnData);
        }

        public int hashCode() {
            int result = this.blockNumber.hashCode();
            result = 31 * result + this.blockHash.hashCode();
            result = 31 * result + Arrays.hashCode(this.returnData);
            return result;
        }

        @NotNull
        public final BigInteger component1() {
            return this.blockNumber;
        }

        @NotNull
        public final Bytes component2() {
            return this.blockHash;
        }

        @NotNull
        public final Result[] component3() {
            return this.returnData;
        }

        @NotNull
        public final BlockAndAggregateResult copy(@NotNull BigInteger blockNumber, @NotNull Bytes blockHash, @NotNull Result[] returnData) {
            return new BlockAndAggregateResult(blockNumber, blockHash, returnData);
        }

        public static /* synthetic */ BlockAndAggregateResult copy$default(BlockAndAggregateResult blockAndAggregateResult, BigInteger bigInteger, Bytes bytes, Result[] resultArray, int n, Object object) {
            if ((n & 1) != 0) {
                bigInteger = blockAndAggregateResult.blockNumber;
            }
            if ((n & 2) != 0) {
                bytes = blockAndAggregateResult.blockHash;
            }
            if ((n & 4) != 0) {
                resultArray = blockAndAggregateResult.returnData;
            }
            return blockAndAggregateResult.copy(bigInteger, bytes, resultArray);
        }

        @NotNull
        public String toString() {
            return "BlockAndAggregateResult(blockNumber=" + this.blockNumber + ", blockHash=" + this.blockHash + ", returnData=" + Arrays.toString(this.returnData) + ")";
        }
    }

    @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000<\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0010\u0011\n\u0002\u0010\u0000\n\u0002\b\u0004\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0004\n\u0002\u0010\u000e\n\u0002\b\u0002\b\u0086\b\u0018\u0000 \u001c2\u00020\u0001:\u0001\u001cB\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J\u0013\u0010\u0012\u001a\u00020\u00132\b\u0010\u0014\u001a\u0004\u0018\u00010\u000eH\u0096\u0002J\b\u0010\u0015\u001a\u00020\u0016H\u0016J\t\u0010\u0017\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\u0018\u001a\u00020\u0005H\u00c6\u0003J\u001d\u0010\u0019\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u0005H\u00c6\u0001J\t\u0010\u001a\u001a\u00020\u001bH\u00d6\u0001R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR\u001c\u0010\f\u001a\b\u0012\u0004\u0012\u00020\u000e0\rX\u0096\u0004\u00a2\u0006\n\n\u0002\u0010\u0011\u001a\u0004\b\u000f\u0010\u0010\u00a8\u0006\u001d"}, d2={"Lio/ethers/abi/call/Multicall3$Call;", "Lio/ethers/abi/ContractStruct;", "target", "Lio/ethers/core/types/Address;", "callData", "Lio/ethers/core/types/Bytes;", "<init>", "(Lio/ethers/core/types/Address;Lio/ethers/core/types/Bytes;)V", "getTarget", "()Lio/ethers/core/types/Address;", "getCallData", "()Lio/ethers/core/types/Bytes;", "tuple", "", "", "getTuple", "()[Ljava/lang/Object;", "[Ljava/lang/Object;", "equals", "", "other", "hashCode", "", "component1", "component2", "copy", "toString", "", "Companion", "ethers-abi"})
    public static final class Call
    implements ContractStruct {
        @NotNull
        public static final Companion Companion = new Companion(null);
        @NotNull
        private final Address target;
        @NotNull
        private final Bytes callData;
        @NotNull
        private final Object[] tuple;

        public Call(@NotNull Address target, @NotNull Bytes callData) {
            this.target = target;
            this.callData = callData;
            Object[] objectArray = new Object[]{this.target, this.callData};
            this.tuple = objectArray;
        }

        @NotNull
        public final Address getTarget() {
            return this.target;
        }

        @NotNull
        public final Bytes getCallData() {
            return this.callData;
        }

        @Override
        @NotNull
        public Object[] getTuple() {
            return this.tuple;
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            Object object = other;
            if (!Intrinsics.areEqual(this.getClass(), object != null ? object.getClass() : null)) {
                return false;
            }
            Intrinsics.checkNotNull((Object)other, (String)"null cannot be cast to non-null type io.ethers.abi.call.Multicall3.Call");
            Call cfr_ignored_0 = (Call)other;
            if (!Intrinsics.areEqual((Object)this.target, (Object)((Call)other).target)) {
                return false;
            }
            return Intrinsics.areEqual((Object)this.callData, (Object)((Call)other).callData);
        }

        public int hashCode() {
            int result = this.target.hashCode();
            result = 31 * result + this.callData.hashCode();
            return result;
        }

        @NotNull
        public final Address component1() {
            return this.target;
        }

        @NotNull
        public final Bytes component2() {
            return this.callData;
        }

        @NotNull
        public final Call copy(@NotNull Address target, @NotNull Bytes callData) {
            return new Call(target, callData);
        }

        public static /* synthetic */ Call copy$default(Call call, Address address, Bytes bytes, int n, Object object) {
            if ((n & 1) != 0) {
                address = call.target;
            }
            if ((n & 2) != 0) {
                bytes = call.callData;
            }
            return call.copy(address, bytes);
        }

        @NotNull
        public String toString() {
            return "Call(target=" + this.target + ", callData=" + this.callData + ")";
        }

        @JvmStatic
        @NotNull
        public static Call fromTuple(@NotNull Object[] data) {
            return Companion.fromTuple(data);
        }

        @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000\u001c\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u0011\n\u0002\u0010\u0000\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0003\u0010\u0004J\u001d\u0010\u0005\u001a\u00020\u00022\u000e\u0010\u0006\u001a\n\u0012\u0006\b\u0001\u0012\u00020\b0\u0007H\u0017\u00a2\u0006\u0002\u0010\t\u00a8\u0006\n"}, d2={"Lio/ethers/abi/call/Multicall3$Call$Companion;", "Lio/ethers/abi/StructFactory;", "Lio/ethers/abi/call/Multicall3$Call;", "<init>", "()V", "fromTuple", "data", "", "", "([Ljava/lang/Object;)Lio/ethers/abi/call/Multicall3$Call;", "ethers-abi"})
        public static final class Companion
        implements StructFactory<Call> {
            private Companion() {
            }

            @Override
            @JvmStatic
            @NotNull
            public Call fromTuple(@NotNull Object[] data) {
                Object object = data[0];
                Intrinsics.checkNotNull((Object)object, (String)"null cannot be cast to non-null type io.ethers.core.types.Address");
                Address address = (Address)object;
                Object object2 = data[1];
                Intrinsics.checkNotNull((Object)object2, (String)"null cannot be cast to non-null type io.ethers.core.types.Bytes");
                return new Call(address, (Bytes)object2);
            }

            public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
                this();
            }
        }
    }

    @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000:\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0010\u0011\n\u0002\u0010\u0000\n\u0002\b\u0006\n\u0002\u0010\b\n\u0002\b\u0005\n\u0002\u0010\u000e\n\u0002\b\u0002\b\u0086\b\u0018\u0000  2\u00020\u0001:\u0001 B\u001f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0004\b\b\u0010\tJ\u0013\u0010\u0016\u001a\u00020\u00052\b\u0010\u0017\u001a\u0004\u0018\u00010\u0012H\u0096\u0002J\b\u0010\u0018\u001a\u00020\u0019H\u0016J\t\u0010\u001a\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\u001b\u001a\u00020\u0005H\u00c6\u0003J\t\u0010\u001c\u001a\u00020\u0007H\u00c6\u0003J'\u0010\u001d\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u00052\b\b\u0002\u0010\u0006\u001a\u00020\u0007H\u00c6\u0001J\t\u0010\u001e\u001a\u00020\u001fH\u00d6\u0001R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\rR\u0011\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000fR\u001c\u0010\u0010\u001a\b\u0012\u0004\u0012\u00020\u00120\u0011X\u0096\u0004\u00a2\u0006\n\n\u0002\u0010\u0015\u001a\u0004\b\u0013\u0010\u0014\u00a8\u0006!"}, d2={"Lio/ethers/abi/call/Multicall3$Call3;", "Lio/ethers/abi/ContractStruct;", "target", "Lio/ethers/core/types/Address;", "allowFailure", "", "callData", "Lio/ethers/core/types/Bytes;", "<init>", "(Lio/ethers/core/types/Address;ZLio/ethers/core/types/Bytes;)V", "getTarget", "()Lio/ethers/core/types/Address;", "getAllowFailure", "()Z", "getCallData", "()Lio/ethers/core/types/Bytes;", "tuple", "", "", "getTuple", "()[Ljava/lang/Object;", "[Ljava/lang/Object;", "equals", "other", "hashCode", "", "component1", "component2", "component3", "copy", "toString", "", "Companion", "ethers-abi"})
    public static final class Call3
    implements ContractStruct {
        @NotNull
        public static final Companion Companion = new Companion(null);
        @NotNull
        private final Address target;
        private final boolean allowFailure;
        @NotNull
        private final Bytes callData;
        @NotNull
        private final Object[] tuple;

        public Call3(@NotNull Address target, boolean allowFailure2, @NotNull Bytes callData) {
            this.target = target;
            this.allowFailure = allowFailure2;
            this.callData = callData;
            Object[] objectArray = new Object[]{this.target, this.allowFailure, this.callData};
            this.tuple = objectArray;
        }

        @NotNull
        public final Address getTarget() {
            return this.target;
        }

        public final boolean getAllowFailure() {
            return this.allowFailure;
        }

        @NotNull
        public final Bytes getCallData() {
            return this.callData;
        }

        @Override
        @NotNull
        public Object[] getTuple() {
            return this.tuple;
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            Object object = other;
            if (!Intrinsics.areEqual(this.getClass(), object != null ? object.getClass() : null)) {
                return false;
            }
            Intrinsics.checkNotNull((Object)other, (String)"null cannot be cast to non-null type io.ethers.abi.call.Multicall3.Call3");
            Call3 cfr_ignored_0 = (Call3)other;
            if (!Intrinsics.areEqual((Object)this.target, (Object)((Call3)other).target)) {
                return false;
            }
            if (this.allowFailure != ((Call3)other).allowFailure) {
                return false;
            }
            return Intrinsics.areEqual((Object)this.callData, (Object)((Call3)other).callData);
        }

        public int hashCode() {
            int result = this.target.hashCode();
            result = 31 * result + Boolean.hashCode(this.allowFailure);
            result = 31 * result + this.callData.hashCode();
            return result;
        }

        @NotNull
        public final Address component1() {
            return this.target;
        }

        public final boolean component2() {
            return this.allowFailure;
        }

        @NotNull
        public final Bytes component3() {
            return this.callData;
        }

        @NotNull
        public final Call3 copy(@NotNull Address target, boolean allowFailure2, @NotNull Bytes callData) {
            return new Call3(target, allowFailure2, callData);
        }

        public static /* synthetic */ Call3 copy$default(Call3 call3, Address address, boolean bl, Bytes bytes, int n, Object object) {
            if ((n & 1) != 0) {
                address = call3.target;
            }
            if ((n & 2) != 0) {
                bl = call3.allowFailure;
            }
            if ((n & 4) != 0) {
                bytes = call3.callData;
            }
            return call3.copy(address, bl, bytes);
        }

        @NotNull
        public String toString() {
            return "Call3(target=" + this.target + ", allowFailure=" + this.allowFailure + ", callData=" + this.callData + ")";
        }

        @JvmStatic
        @NotNull
        public static Call3 fromTuple(@NotNull Object[] data) {
            return Companion.fromTuple(data);
        }

        @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000\u001c\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u0011\n\u0002\u0010\u0000\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0003\u0010\u0004J\u001d\u0010\u0005\u001a\u00020\u00022\u000e\u0010\u0006\u001a\n\u0012\u0006\b\u0001\u0012\u00020\b0\u0007H\u0017\u00a2\u0006\u0002\u0010\t\u00a8\u0006\n"}, d2={"Lio/ethers/abi/call/Multicall3$Call3$Companion;", "Lio/ethers/abi/StructFactory;", "Lio/ethers/abi/call/Multicall3$Call3;", "<init>", "()V", "fromTuple", "data", "", "", "([Ljava/lang/Object;)Lio/ethers/abi/call/Multicall3$Call3;", "ethers-abi"})
        public static final class Companion
        implements StructFactory<Call3> {
            private Companion() {
            }

            @Override
            @JvmStatic
            @NotNull
            public Call3 fromTuple(@NotNull Object[] data) {
                Object object = data[0];
                Intrinsics.checkNotNull((Object)object, (String)"null cannot be cast to non-null type io.ethers.core.types.Address");
                Address address = (Address)object;
                Object object2 = data[1];
                Intrinsics.checkNotNull((Object)object2, (String)"null cannot be cast to non-null type kotlin.Boolean");
                boolean bl = (Boolean)object2;
                Object object3 = data[2];
                Intrinsics.checkNotNull((Object)object3, (String)"null cannot be cast to non-null type io.ethers.core.types.Bytes");
                return new Call3(address, bl, (Bytes)object3);
            }

            public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
                this();
            }
        }
    }

    @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000@\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u000b\n\u0002\u0010\u0011\n\u0002\u0010\u0000\n\u0002\b\u0006\n\u0002\u0010\b\n\u0002\b\u0006\n\u0002\u0010\u000e\n\u0002\b\u0002\b\u0086\b\u0018\u0000 %2\u00020\u0001:\u0001%B'\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u00a2\u0006\u0004\b\n\u0010\u000bJ\u0013\u0010\u001a\u001a\u00020\u00052\b\u0010\u001b\u001a\u0004\u0018\u00010\u0016H\u0096\u0002J\b\u0010\u001c\u001a\u00020\u001dH\u0016J\t\u0010\u001e\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\u001f\u001a\u00020\u0005H\u00c6\u0003J\t\u0010 \u001a\u00020\u0007H\u00c6\u0003J\t\u0010!\u001a\u00020\tH\u00c6\u0003J1\u0010\"\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u00052\b\b\u0002\u0010\u0006\u001a\u00020\u00072\b\b\u0002\u0010\b\u001a\u00020\tH\u00c6\u0001J\t\u0010#\u001a\u00020$H\u00d6\u0001R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\rR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000fR\u0011\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\u0011R\u0011\u0010\b\u001a\u00020\t\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0012\u0010\u0013R\u001c\u0010\u0014\u001a\b\u0012\u0004\u0012\u00020\u00160\u0015X\u0096\u0004\u00a2\u0006\n\n\u0002\u0010\u0019\u001a\u0004\b\u0017\u0010\u0018\u00a8\u0006&"}, d2={"Lio/ethers/abi/call/Multicall3$Call3Value;", "Lio/ethers/abi/ContractStruct;", "target", "Lio/ethers/core/types/Address;", "allowFailure", "", "value", "Ljava/math/BigInteger;", "callData", "Lio/ethers/core/types/Bytes;", "<init>", "(Lio/ethers/core/types/Address;ZLjava/math/BigInteger;Lio/ethers/core/types/Bytes;)V", "getTarget", "()Lio/ethers/core/types/Address;", "getAllowFailure", "()Z", "getValue", "()Ljava/math/BigInteger;", "getCallData", "()Lio/ethers/core/types/Bytes;", "tuple", "", "", "getTuple", "()[Ljava/lang/Object;", "[Ljava/lang/Object;", "equals", "other", "hashCode", "", "component1", "component2", "component3", "component4", "copy", "toString", "", "Companion", "ethers-abi"})
    public static final class Call3Value
    implements ContractStruct {
        @NotNull
        public static final Companion Companion = new Companion(null);
        @NotNull
        private final Address target;
        private final boolean allowFailure;
        @NotNull
        private final BigInteger value;
        @NotNull
        private final Bytes callData;
        @NotNull
        private final Object[] tuple;

        public Call3Value(@NotNull Address target, boolean allowFailure2, @NotNull BigInteger value, @NotNull Bytes callData) {
            this.target = target;
            this.allowFailure = allowFailure2;
            this.value = value;
            this.callData = callData;
            Object[] objectArray = new Object[]{this.target, this.allowFailure, this.value, this.callData};
            this.tuple = objectArray;
        }

        @NotNull
        public final Address getTarget() {
            return this.target;
        }

        public final boolean getAllowFailure() {
            return this.allowFailure;
        }

        @NotNull
        public final BigInteger getValue() {
            return this.value;
        }

        @NotNull
        public final Bytes getCallData() {
            return this.callData;
        }

        @Override
        @NotNull
        public Object[] getTuple() {
            return this.tuple;
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            Object object = other;
            if (!Intrinsics.areEqual(this.getClass(), object != null ? object.getClass() : null)) {
                return false;
            }
            Intrinsics.checkNotNull((Object)other, (String)"null cannot be cast to non-null type io.ethers.abi.call.Multicall3.Call3Value");
            Call3Value cfr_ignored_0 = (Call3Value)other;
            if (!Intrinsics.areEqual((Object)this.target, (Object)((Call3Value)other).target)) {
                return false;
            }
            if (this.allowFailure != ((Call3Value)other).allowFailure) {
                return false;
            }
            if (!Intrinsics.areEqual((Object)this.value, (Object)((Call3Value)other).value)) {
                return false;
            }
            return Intrinsics.areEqual((Object)this.callData, (Object)((Call3Value)other).callData);
        }

        public int hashCode() {
            int result = this.target.hashCode();
            result = 31 * result + Boolean.hashCode(this.allowFailure);
            result = 31 * result + this.value.hashCode();
            result = 31 * result + this.callData.hashCode();
            return result;
        }

        @NotNull
        public final Address component1() {
            return this.target;
        }

        public final boolean component2() {
            return this.allowFailure;
        }

        @NotNull
        public final BigInteger component3() {
            return this.value;
        }

        @NotNull
        public final Bytes component4() {
            return this.callData;
        }

        @NotNull
        public final Call3Value copy(@NotNull Address target, boolean allowFailure2, @NotNull BigInteger value, @NotNull Bytes callData) {
            return new Call3Value(target, allowFailure2, value, callData);
        }

        public static /* synthetic */ Call3Value copy$default(Call3Value call3Value, Address address, boolean bl, BigInteger bigInteger, Bytes bytes, int n, Object object) {
            if ((n & 1) != 0) {
                address = call3Value.target;
            }
            if ((n & 2) != 0) {
                bl = call3Value.allowFailure;
            }
            if ((n & 4) != 0) {
                bigInteger = call3Value.value;
            }
            if ((n & 8) != 0) {
                bytes = call3Value.callData;
            }
            return call3Value.copy(address, bl, bigInteger, bytes);
        }

        @NotNull
        public String toString() {
            return "Call3Value(target=" + this.target + ", allowFailure=" + this.allowFailure + ", value=" + this.value + ", callData=" + this.callData + ")";
        }

        @JvmStatic
        @NotNull
        public static Call3Value fromTuple(@NotNull Object[] data) {
            return Companion.fromTuple(data);
        }

        @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000\u001c\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u0011\n\u0002\u0010\u0000\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0003\u0010\u0004J\u001d\u0010\u0005\u001a\u00020\u00022\u000e\u0010\u0006\u001a\n\u0012\u0006\b\u0001\u0012\u00020\b0\u0007H\u0017\u00a2\u0006\u0002\u0010\t\u00a8\u0006\n"}, d2={"Lio/ethers/abi/call/Multicall3$Call3Value$Companion;", "Lio/ethers/abi/StructFactory;", "Lio/ethers/abi/call/Multicall3$Call3Value;", "<init>", "()V", "fromTuple", "data", "", "", "([Ljava/lang/Object;)Lio/ethers/abi/call/Multicall3$Call3Value;", "ethers-abi"})
        public static final class Companion
        implements StructFactory<Call3Value> {
            private Companion() {
            }

            @Override
            @JvmStatic
            @NotNull
            public Call3Value fromTuple(@NotNull Object[] data) {
                Object object = data[0];
                Intrinsics.checkNotNull((Object)object, (String)"null cannot be cast to non-null type io.ethers.core.types.Address");
                Address address = (Address)object;
                Object object2 = data[1];
                Intrinsics.checkNotNull((Object)object2, (String)"null cannot be cast to non-null type kotlin.Boolean");
                boolean bl = (Boolean)object2;
                Object object3 = data[2];
                Intrinsics.checkNotNull((Object)object3, (String)"null cannot be cast to non-null type java.math.BigInteger");
                BigInteger bigInteger = (BigInteger)object3;
                Object object4 = data[3];
                Intrinsics.checkNotNull((Object)object4, (String)"null cannot be cast to non-null type io.ethers.core.types.Bytes");
                return new Call3Value(address, bl, bigInteger, (Bytes)object4);
            }

            public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
                this();
            }
        }
    }

    @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000f\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0010\t\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0011\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010$\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0011\b\u0086\u0003\u0018\u00002\u00020\u0001:\u00015B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0010\u0010\u0014\u001a\u00020\t2\u0006\u0010\u0015\u001a\u00020\u0006H\u0007J\u0010\u0010\u0016\u001a\u00020\u00072\u0006\u0010\u0017\u001a\u00020\u0018H\u0007JC\u0010\u0019\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u0002H\u001c0\u001b0\u001a\"\u0004\b\u0000\u0010\u001c2\"\u0010\u001d\u001a\u0012\u0012\u000e\b\u0001\u0012\n\u0012\u0006\b\u0001\u0012\u0002H\u001c0\u001f0\u001e\"\n\u0012\u0006\b\u0001\u0012\u0002H\u001c0\u001fH\u0007\u00a2\u0006\u0002\u0010 R\u001a\u0010\u0004\u001a\u000e\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\u00070\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R7\u0010\f\u001a\u001e\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\u000e0\rj\u000e\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\u000e`\u000f8BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b\u0012\u0010\u0013\u001a\u0004\b\u0010\u0010\u0011R\u001c\u0010!\u001a\u000e\u0012\u0004\u0012\u00020\t\u0012\u0004\u0012\u00020#0\"8\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010$\u001a\u00020%8\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010&\u001a\u00020%8\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010'\u001a\u00020%8\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010(\u001a\u00020%8\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010)\u001a\u00020%8\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010*\u001a\u00020%8\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010+\u001a\u00020%8\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010,\u001a\u00020%8\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010-\u001a\u00020%8\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010.\u001a\u00020%8\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010/\u001a\u00020%8\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u00100\u001a\u00020%8\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u00101\u001a\u00020%8\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u00102\u001a\u00020%8\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u00103\u001a\u00020%8\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u00104\u001a\u00020%8\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u00066"}, d2={"Lio/ethers/abi/call/Multicall3$Companion;", "", "<init>", "()V", "INSTANCE_PER_CHAIN_ID", "Ljava/util/concurrent/ConcurrentHashMap;", "", "Lio/ethers/abi/call/Multicall3;", "DEFAULT_ADDRESS", "Lio/ethers/core/types/Address;", "DEPLOYED_BYTECODE", "Lio/ethers/core/types/Bytes;", "DEPLOYMENT_PER_CHAIN_ID", "Ljava/util/HashMap;", "Lio/ethers/abi/call/Multicall3$Companion$MulticallDeployment;", "Lkotlin/collections/HashMap;", "getDEPLOYMENT_PER_CHAIN_ID", "()Ljava/util/HashMap;", "DEPLOYMENT_PER_CHAIN_ID$delegate", "Lkotlin/Lazy;", "getAddressForChainId", "chainId", "getInstance", "provider", "Lio/ethers/providers/middleware/Middleware;", "aggregate", "Lio/ethers/abi/call/FunctionCall;", "Lio/ethers/abi/call/AggregationResult;", "T", "calls", "", "Lio/ethers/abi/call/Multicall3$Aggregatable;", "([Lio/ethers/abi/call/Multicall3$Aggregatable;)Lio/ethers/abi/call/FunctionCall;", "STATE_OVERRIDE", "", "Lio/ethers/core/types/AccountOverride;", "FUNCTION_AGGREGATE3", "Lio/ethers/abi/AbiFunction;", "FUNCTION_BLOCK_AND_AGGREGATE", "FUNCTION_AGGREGATE3_VALUE", "FUNCTION_GET_BASEFEE", "FUNCTION_AGGREGATE", "FUNCTION_GET_CURRENT_BLOCK_DIFFICULTY", "FUNCTION_GET_CURRENT_BLOCK_COINBASE", "FUNCTION_GET_ETH_BALANCE", "FUNCTION_GET_BLOCK_NUMBER", "FUNCTION_TRY_AGGREGATE", "FUNCTION_TRY_BLOCK_AND_AGGREGATE", "FUNCTION_GET_CHAIN_ID", "FUNCTION_GET_CURRENT_BLOCK_TIMESTAMP", "FUNCTION_GET_BLOCK_HASH", "FUNCTION_GET_LAST_BLOCK_HASH", "FUNCTION_GET_CURRENT_BLOCK_GAS_LIMIT", "MulticallDeployment", "ethers-abi"})
    public static final class Companion {
        private Companion() {
        }

        private final HashMap<Long, MulticallDeployment> getDEPLOYMENT_PER_CHAIN_ID() {
            Lazy lazy = DEPLOYMENT_PER_CHAIN_ID$delegate;
            return (HashMap)lazy.getValue();
        }

        @JvmStatic
        @NotNull
        public final Address getAddressForChainId(long chainId) {
            MulticallDeployment multicallDeployment = this.getDEPLOYMENT_PER_CHAIN_ID().get(chainId);
            if (multicallDeployment == null || (multicallDeployment = multicallDeployment.getAddress()) == null) {
                multicallDeployment = DEFAULT_ADDRESS;
            }
            return multicallDeployment;
        }

        @JvmStatic
        @NotNull
        public final Multicall3 getInstance(@NotNull Middleware provider) {
            return INSTANCE_PER_CHAIN_ID.computeIfAbsent(provider.getChainId(), arg_0 -> Companion.getInstance$lambda$1(arg_0 -> Companion.getInstance$lambda$0(provider, arg_0), arg_0));
        }

        @JvmStatic
        @NotNull
        public final <T> FunctionCall<AggregationResult<T>> aggregate(Aggregatable<? extends T> ... calls) {
            if (calls.length == 0) {
                throw new IllegalArgumentException("No calls to aggregate");
            }
            Middleware provider = ((Aggregatable)ArraysKt.first((Object[])calls)).getProvider();
            return this.getInstance(provider).aggregateCalls(Arrays.copyOf(calls, calls.length));
        }

        private static final Multicall3 getInstance$lambda$0(Middleware $provider, Long it) {
            return new Multicall3($provider, Companion.getAddressForChainId($provider.getChainId()));
        }

        private static final Multicall3 getInstance$lambda$1(Function1 $tmp0, Object p0) {
            return (Multicall3)$tmp0.invoke(p0);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }

        @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\t\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u000f\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0002\b\u0082\b\u0018\u00002\u00020\u0001B+\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0003\u0012\n\b\u0002\u0010\u0007\u001a\u0004\u0018\u00010\b\u00a2\u0006\u0004\b\t\u0010\nJ\t\u0010\u0012\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\u0013\u001a\u00020\u0005H\u00c6\u0003J\t\u0010\u0014\u001a\u00020\u0003H\u00c6\u0003J\u000b\u0010\u0015\u001a\u0004\u0018\u00010\bH\u00c6\u0003J3\u0010\u0016\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u00052\b\b\u0002\u0010\u0006\u001a\u00020\u00032\n\b\u0002\u0010\u0007\u001a\u0004\u0018\u00010\bH\u00c6\u0001J\u0013\u0010\u0017\u001a\u00020\u00182\b\u0010\u0019\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\u001a\u001a\u00020\u001bH\u00d6\u0001J\t\u0010\u001c\u001a\u00020\u0003H\u00d6\u0001R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000eR\u0011\u0010\u0006\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\fR\u0013\u0010\u0007\u001a\u0004\u0018\u00010\b\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\u0011\u00a8\u0006\u001d"}, d2={"Lio/ethers/abi/call/Multicall3$Companion$MulticallDeployment;", "", "name", "", "chainId", "", "url", "address", "Lio/ethers/core/types/Address;", "<init>", "(Ljava/lang/String;JLjava/lang/String;Lio/ethers/core/types/Address;)V", "getName", "()Ljava/lang/String;", "getChainId", "()J", "getUrl", "getAddress", "()Lio/ethers/core/types/Address;", "component1", "component2", "component3", "component4", "copy", "equals", "", "other", "hashCode", "", "toString", "ethers-abi"})
        private static final class MulticallDeployment {
            @NotNull
            private final String name;
            private final long chainId;
            @NotNull
            private final String url;
            @Nullable
            private final Address address;

            public MulticallDeployment(@NotNull String name, long chainId, @NotNull String url, @Nullable Address address) {
                this.name = name;
                this.chainId = chainId;
                this.url = url;
                this.address = address;
            }

            public /* synthetic */ MulticallDeployment(String string, long l, String string2, Address address, int n, DefaultConstructorMarker defaultConstructorMarker) {
                if ((n & 8) != 0) {
                    address = null;
                }
                this(string, l, string2, address);
            }

            @NotNull
            public final String getName() {
                return this.name;
            }

            public final long getChainId() {
                return this.chainId;
            }

            @NotNull
            public final String getUrl() {
                return this.url;
            }

            @Nullable
            public final Address getAddress() {
                return this.address;
            }

            @NotNull
            public final String component1() {
                return this.name;
            }

            public final long component2() {
                return this.chainId;
            }

            @NotNull
            public final String component3() {
                return this.url;
            }

            @Nullable
            public final Address component4() {
                return this.address;
            }

            @NotNull
            public final MulticallDeployment copy(@NotNull String name, long chainId, @NotNull String url, @Nullable Address address) {
                return new MulticallDeployment(name, chainId, url, address);
            }

            public static /* synthetic */ MulticallDeployment copy$default(MulticallDeployment multicallDeployment, String string, long l, String string2, Address address, int n, Object object) {
                if ((n & 1) != 0) {
                    string = multicallDeployment.name;
                }
                if ((n & 2) != 0) {
                    l = multicallDeployment.chainId;
                }
                if ((n & 4) != 0) {
                    string2 = multicallDeployment.url;
                }
                if ((n & 8) != 0) {
                    address = multicallDeployment.address;
                }
                return multicallDeployment.copy(string, l, string2, address);
            }

            @NotNull
            public String toString() {
                return "MulticallDeployment(name=" + this.name + ", chainId=" + this.chainId + ", url=" + this.url + ", address=" + this.address + ")";
            }

            public int hashCode() {
                int result = this.name.hashCode();
                result = result * 31 + Long.hashCode(this.chainId);
                result = result * 31 + this.url.hashCode();
                result = result * 31 + (this.address == null ? 0 : this.address.hashCode());
                return result;
            }

            public boolean equals(@Nullable Object other) {
                if (this == other) {
                    return true;
                }
                if (!(other instanceof MulticallDeployment)) {
                    return false;
                }
                MulticallDeployment multicallDeployment = (MulticallDeployment)other;
                if (!Intrinsics.areEqual((Object)this.name, (Object)multicallDeployment.name)) {
                    return false;
                }
                if (this.chainId != multicallDeployment.chainId) {
                    return false;
                }
                if (!Intrinsics.areEqual((Object)this.url, (Object)multicallDeployment.url)) {
                    return false;
                }
                return Intrinsics.areEqual((Object)this.address, (Object)multicallDeployment.address);
            }
        }
    }

    @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0010\u0011\n\u0002\u0010\u0000\n\u0002\b\u0006\n\u0002\u0010\b\n\u0002\b\u0004\n\u0002\u0010\u000e\n\u0002\b\u0002\b\u0086\b\u0018\u0000 \u001b2\u00020\u0001:\u0001\u001bB\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J\u0013\u0010\u0012\u001a\u00020\u00032\b\u0010\u0013\u001a\u0004\u0018\u00010\u000eH\u0096\u0002J\b\u0010\u0014\u001a\u00020\u0015H\u0016J\t\u0010\u0016\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\u0017\u001a\u00020\u0005H\u00c6\u0003J\u001d\u0010\u0018\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u0005H\u00c6\u0001J\t\u0010\u0019\u001a\u00020\u001aH\u00d6\u0001R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR\u001c\u0010\f\u001a\b\u0012\u0004\u0012\u00020\u000e0\rX\u0096\u0004\u00a2\u0006\n\n\u0002\u0010\u0011\u001a\u0004\b\u000f\u0010\u0010\u00a8\u0006\u001c"}, d2={"Lio/ethers/abi/call/Multicall3$Result;", "Lio/ethers/abi/ContractStruct;", "success", "", "returnData", "Lio/ethers/core/types/Bytes;", "<init>", "(ZLio/ethers/core/types/Bytes;)V", "getSuccess", "()Z", "getReturnData", "()Lio/ethers/core/types/Bytes;", "tuple", "", "", "getTuple", "()[Ljava/lang/Object;", "[Ljava/lang/Object;", "equals", "other", "hashCode", "", "component1", "component2", "copy", "toString", "", "Companion", "ethers-abi"})
    public static final class Result
    implements ContractStruct {
        @NotNull
        public static final Companion Companion = new Companion(null);
        private final boolean success;
        @NotNull
        private final Bytes returnData;
        @NotNull
        private final Object[] tuple;

        public Result(boolean success, @NotNull Bytes returnData) {
            this.success = success;
            this.returnData = returnData;
            Object[] objectArray = new Object[]{this.success, this.returnData};
            this.tuple = objectArray;
        }

        public final boolean getSuccess() {
            return this.success;
        }

        @NotNull
        public final Bytes getReturnData() {
            return this.returnData;
        }

        @Override
        @NotNull
        public Object[] getTuple() {
            return this.tuple;
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            Object object = other;
            if (!Intrinsics.areEqual(this.getClass(), object != null ? object.getClass() : null)) {
                return false;
            }
            Intrinsics.checkNotNull((Object)other, (String)"null cannot be cast to non-null type io.ethers.abi.call.Multicall3.Result");
            Result cfr_ignored_0 = (Result)other;
            if (this.success != ((Result)other).success) {
                return false;
            }
            return Intrinsics.areEqual((Object)this.returnData, (Object)((Result)other).returnData);
        }

        public int hashCode() {
            int result = Boolean.hashCode(this.success);
            result = 31 * result + this.returnData.hashCode();
            return result;
        }

        public final boolean component1() {
            return this.success;
        }

        @NotNull
        public final Bytes component2() {
            return this.returnData;
        }

        @NotNull
        public final Result copy(boolean success, @NotNull Bytes returnData) {
            return new Result(success, returnData);
        }

        public static /* synthetic */ Result copy$default(Result result, boolean bl, Bytes bytes, int n, Object object) {
            if ((n & 1) != 0) {
                bl = result.success;
            }
            if ((n & 2) != 0) {
                bytes = result.returnData;
            }
            return result.copy(bl, bytes);
        }

        @NotNull
        public String toString() {
            return "Result(success=" + this.success + ", returnData=" + this.returnData + ")";
        }

        @JvmStatic
        @NotNull
        public static Result fromTuple(@NotNull Object[] data) {
            return Companion.fromTuple(data);
        }

        @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000\u001c\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u0011\n\u0002\u0010\u0000\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0003\u0010\u0004J\u001d\u0010\u0005\u001a\u00020\u00022\u000e\u0010\u0006\u001a\n\u0012\u0006\b\u0001\u0012\u00020\b0\u0007H\u0017\u00a2\u0006\u0002\u0010\t\u00a8\u0006\n"}, d2={"Lio/ethers/abi/call/Multicall3$Result$Companion;", "Lio/ethers/abi/StructFactory;", "Lio/ethers/abi/call/Multicall3$Result;", "<init>", "()V", "fromTuple", "data", "", "", "([Ljava/lang/Object;)Lio/ethers/abi/call/Multicall3$Result;", "ethers-abi"})
        public static final class Companion
        implements StructFactory<Result> {
            private Companion() {
            }

            @Override
            @JvmStatic
            @NotNull
            public Result fromTuple(@NotNull Object[] data) {
                Object object = data[0];
                Intrinsics.checkNotNull((Object)object, (String)"null cannot be cast to non-null type kotlin.Boolean");
                boolean bl = (Boolean)object;
                Object object2 = data[1];
                Intrinsics.checkNotNull((Object)object2, (String)"null cannot be cast to non-null type io.ethers.core.types.Bytes");
                return new Result(bl, (Bytes)object2);
            }

            public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
                this();
            }
        }
    }

    @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u00008\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0011\n\u0002\u0018\u0002\n\u0002\b\n\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0006\n\u0002\u0010\u000e\n\u0000\b\u0086\b\u0018\u00002\u00020\u0001B%\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\f\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\b0\u0007\u00a2\u0006\u0004\b\t\u0010\nJ\u0013\u0010\u0012\u001a\u00020\u00132\b\u0010\u0014\u001a\u0004\u0018\u00010\u0001H\u0096\u0002J\b\u0010\u0015\u001a\u00020\u0016H\u0016J\t\u0010\u0017\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\u0018\u001a\u00020\u0005H\u00c6\u0003J\u0014\u0010\u0019\u001a\b\u0012\u0004\u0012\u00020\b0\u0007H\u00c6\u0003\u00a2\u0006\u0002\u0010\u0010J2\u0010\u001a\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u00052\u000e\b\u0002\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\b0\u0007H\u00c6\u0001\u00a2\u0006\u0002\u0010\u001bJ\t\u0010\u001c\u001a\u00020\u001dH\u00d6\u0001R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000eR\u0019\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\b0\u0007\u00a2\u0006\n\n\u0002\u0010\u0011\u001a\u0004\b\u000f\u0010\u0010\u00a8\u0006\u001e"}, d2={"Lio/ethers/abi/call/Multicall3$TryBlockAndAggregateResult;", "", "blockNumber", "Ljava/math/BigInteger;", "blockHash", "Lio/ethers/core/types/Bytes;", "returnData", "", "Lio/ethers/abi/call/Multicall3$Result;", "<init>", "(Ljava/math/BigInteger;Lio/ethers/core/types/Bytes;[Lio/ethers/abi/call/Multicall3$Result;)V", "getBlockNumber", "()Ljava/math/BigInteger;", "getBlockHash", "()Lio/ethers/core/types/Bytes;", "getReturnData", "()[Lio/ethers/abi/call/Multicall3$Result;", "[Lio/ethers/abi/call/Multicall3$Result;", "equals", "", "other", "hashCode", "", "component1", "component2", "component3", "copy", "(Ljava/math/BigInteger;Lio/ethers/core/types/Bytes;[Lio/ethers/abi/call/Multicall3$Result;)Lio/ethers/abi/call/Multicall3$TryBlockAndAggregateResult;", "toString", "", "ethers-abi"})
    public static final class TryBlockAndAggregateResult {
        @NotNull
        private final BigInteger blockNumber;
        @NotNull
        private final Bytes blockHash;
        @NotNull
        private final Result[] returnData;

        public TryBlockAndAggregateResult(@NotNull BigInteger blockNumber, @NotNull Bytes blockHash, @NotNull Result[] returnData) {
            this.blockNumber = blockNumber;
            this.blockHash = blockHash;
            this.returnData = returnData;
        }

        @NotNull
        public final BigInteger getBlockNumber() {
            return this.blockNumber;
        }

        @NotNull
        public final Bytes getBlockHash() {
            return this.blockHash;
        }

        @NotNull
        public final Result[] getReturnData() {
            return this.returnData;
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            Object object = other;
            if (!Intrinsics.areEqual(this.getClass(), object != null ? object.getClass() : null)) {
                return false;
            }
            Intrinsics.checkNotNull((Object)other, (String)"null cannot be cast to non-null type io.ethers.abi.call.Multicall3.TryBlockAndAggregateResult");
            TryBlockAndAggregateResult cfr_ignored_0 = (TryBlockAndAggregateResult)other;
            if (!Intrinsics.areEqual((Object)this.blockNumber, (Object)((TryBlockAndAggregateResult)other).blockNumber)) {
                return false;
            }
            if (!Intrinsics.areEqual((Object)this.blockHash, (Object)((TryBlockAndAggregateResult)other).blockHash)) {
                return false;
            }
            return Arrays.equals(this.returnData, ((TryBlockAndAggregateResult)other).returnData);
        }

        public int hashCode() {
            int result = this.blockNumber.hashCode();
            result = 31 * result + this.blockHash.hashCode();
            result = 31 * result + Arrays.hashCode(this.returnData);
            return result;
        }

        @NotNull
        public final BigInteger component1() {
            return this.blockNumber;
        }

        @NotNull
        public final Bytes component2() {
            return this.blockHash;
        }

        @NotNull
        public final Result[] component3() {
            return this.returnData;
        }

        @NotNull
        public final TryBlockAndAggregateResult copy(@NotNull BigInteger blockNumber, @NotNull Bytes blockHash, @NotNull Result[] returnData) {
            return new TryBlockAndAggregateResult(blockNumber, blockHash, returnData);
        }

        public static /* synthetic */ TryBlockAndAggregateResult copy$default(TryBlockAndAggregateResult tryBlockAndAggregateResult, BigInteger bigInteger, Bytes bytes, Result[] resultArray, int n, Object object) {
            if ((n & 1) != 0) {
                bigInteger = tryBlockAndAggregateResult.blockNumber;
            }
            if ((n & 2) != 0) {
                bytes = tryBlockAndAggregateResult.blockHash;
            }
            if ((n & 4) != 0) {
                resultArray = tryBlockAndAggregateResult.returnData;
            }
            return tryBlockAndAggregateResult.copy(bigInteger, bytes, resultArray);
        }

        @NotNull
        public String toString() {
            return "TryBlockAndAggregateResult(blockNumber=" + this.blockNumber + ", blockHash=" + this.blockHash + ", returnData=" + Arrays.toString(this.returnData) + ")";
        }
    }
}

