/*
 * Decompiled with CFR 0.152.
 */
package io.ethers.abi.call;

import io.ethers.abi.AbiContract;
import io.ethers.abi.call.CallDeploy;
import io.ethers.abi.call.ConstructorCallKt;
import io.ethers.abi.call.PendingContractDeploy;
import io.ethers.abi.call.ReadWriteContractCall;
import io.ethers.abi.error.ContractError;
import io.ethers.abi.error.DeployError;
import io.ethers.core.Result;
import io.ethers.core.ResultKt;
import io.ethers.core.types.AccountOverride;
import io.ethers.core.types.Address;
import io.ethers.core.types.BlockId;
import io.ethers.core.types.BlockOverride;
import io.ethers.core.types.Bytes;
import io.ethers.core.types.IntoCallRequest;
import io.ethers.core.types.StateOverride;
import io.ethers.core.types.tracers.AnyTracer;
import io.ethers.core.types.tracers.PrestateTracer;
import io.ethers.core.types.tracers.TracerConfig;
import io.ethers.providers.RpcError;
import io.ethers.providers.middleware.Middleware;
import io.ethers.providers.types.PendingTransaction;
import io.ethers.providers.types.RpcRequest;
import java.util.function.BiFunction;
import kotlin.Function;
import kotlin.Metadata;
import kotlin.jvm.internal.FunctionAdapter;
import kotlin.jvm.internal.FunctionReferenceImpl;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000T\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\u0018\u0000*\b\b\u0000\u0010\u0001*\u00020\u00022&\u0012\n\u0012\b\u0012\u0004\u0012\u0002H\u00010\u0004\u0012\n\u0012\b\u0012\u0004\u0012\u0002H\u00010\u0005\u0012\n\u0012\b\u0012\u0004\u0012\u0002H\u00010\u00000\u0003B1\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u0012\u0018\u0010\n\u001a\u0014\u0012\u0004\u0012\u00020\u0007\u0012\u0004\u0012\u00020\f\u0012\u0004\u0012\u00028\u00000\u000b\u00a2\u0006\u0004\b\r\u0010\u000eJ6\u0010\u0012\u001a\u0014\u0012\n\u0012\b\u0012\u0004\u0012\u00028\u00000\u0004\u0012\u0004\u0012\u00020\u00140\u00132\u0006\u0010\u0015\u001a\u00020\u00162\b\u0010\u0017\u001a\u0004\u0018\u00010\u00182\b\u0010\u0019\u001a\u0004\u0018\u00010\u001aH\u0014J\u0016\u0010\u001b\u001a\b\u0012\u0004\u0012\u00028\u00000\u00052\u0006\u0010\u001c\u001a\u00020\u001dH\u0014R \u0010\n\u001a\u0014\u0012\u0004\u0012\u00020\u0007\u0012\u0004\u0012\u00020\f\u0012\u0004\u0012\u00028\u00000\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u000f\u001a\b\u0012\u0004\u0012\u00028\u00000\u00008TX\u0094\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0010\u0010\u0011\u00a8\u0006\u001e"}, d2={"Lio/ethers/abi/call/ConstructorCall;", "T", "Lio/ethers/abi/AbiContract;", "Lio/ethers/abi/call/ReadWriteContractCall;", "Lio/ethers/abi/call/CallDeploy;", "Lio/ethers/abi/call/PendingContractDeploy;", "provider", "Lio/ethers/providers/middleware/Middleware;", "bytecode", "Lio/ethers/core/types/Bytes;", "constructor", "Ljava/util/function/BiFunction;", "Lio/ethers/core/types/Address;", "<init>", "(Lio/ethers/providers/middleware/Middleware;Lio/ethers/core/types/Bytes;Ljava/util/function/BiFunction;)V", "self", "getSelf", "()Lio/ethers/abi/call/ConstructorCall;", "doCall", "Lio/ethers/providers/types/RpcRequest;", "Lio/ethers/abi/error/ContractError;", "blockId", "Lio/ethers/core/types/BlockId;", "stateOverride", "Lio/ethers/core/types/StateOverride;", "blockOverride", "Lio/ethers/core/types/BlockOverride;", "handleSendResult", "result", "Lio/ethers/providers/types/PendingTransaction;", "ethers-abi"})
public final class ConstructorCall<T extends AbiContract>
extends ReadWriteContractCall<CallDeploy<T>, PendingContractDeploy<T>, ConstructorCall<T>> {
    @NotNull
    private final BiFunction<Middleware, Address, T> constructor;

    public ConstructorCall(@NotNull Middleware provider, @NotNull Bytes bytecode, @NotNull BiFunction<Middleware, Address, T> constructor) {
        super(provider);
        this.constructor = constructor;
        this.getCall().setFrom(Address.Companion.random());
        this.getCall().setTo(null);
        this.getCall().setData(bytecode);
    }

    @Override
    @NotNull
    protected ConstructorCall<T> getSelf() {
        return this;
    }

    @Override
    @NotNull
    protected RpcRequest<CallDeploy<T>, ContractError> doCall(@NotNull BlockId blockId, @Nullable StateOverride stateOverride, @Nullable BlockOverride blockOverride) {
        TracerConfig config = stateOverride == null && blockOverride == null ? ConstructorCallKt.access$getTRACER_CONFIG_NO_OVERRIDES$p() : new TracerConfig((AnyTracer)ConstructorCallKt.access$getPRESTATE_DIFF_TRACER$p(), 0L, 0L, stateOverride, blockOverride, 0, 38, null);
        Address address = this.getCall().getFrom();
        if (address == null) {
            address = Address.ZERO;
        }
        Address sender = address;
        long nonce = this.getCall().getNonce() == -1L ? 0L : this.getCall().getNonce();
        Address deployAddress = Address.Companion.computeCreate(sender, nonce);
        return this.getProvider().traceCall((IntoCallRequest)this.getCall(), blockId, config).mapError(new Result.Transformer(this){
            final /* synthetic */ ConstructorCall<T> $tmp0;
            {
                this.$tmp0 = $tmp0;
            }

            public final ContractError invoke(RpcError p0) {
                return this.$tmp0.tryDecodingContractRevert(p0);
            }

            public final Function<?> getFunctionDelegate() {
                return (Function)new FunctionReferenceImpl(1, this.$tmp0, ConstructorCall.class, "tryDecodingContractRevert", "tryDecodingContractRevert(Lio/ethers/providers/RpcError;)Lio/ethers/abi/error/ContractError;", 0);
            }

            public final boolean equals(Object other) {
                return other instanceof Result.Transformer ? (other instanceof FunctionAdapter ? Intrinsics.areEqual((Object)((FunctionAdapter)this).getFunctionDelegate(), (Object)((FunctionAdapter)other).getFunctionDelegate()) : false) : false;
            }

            public final int hashCode() {
                return ((FunctionAdapter)this).getFunctionDelegate().hashCode();
            }
        }).andThen(arg_0 -> ConstructorCall.doCall$lambda$0(deployAddress, this, arg_0));
    }

    @Override
    @NotNull
    protected PendingContractDeploy<T> handleSendResult(@NotNull PendingTransaction result) {
        return new PendingContractDeploy<T>(this.getProvider(), result, this.constructor);
    }

    private static final Result doCall$lambda$0(Address $deployAddress, ConstructorCall this$0, PrestateTracer.Result it) {
        StateOverride overrides = it.toStateOverride();
        AccountOverride accountOverride = (AccountOverride)overrides.get((Object)$deployAddress);
        if (accountOverride == null || (accountOverride = accountOverride.getCode()) == null) {
            return ResultKt.failure((Result.Error)DeployError.NoBytecode.INSTANCE);
        }
        AccountOverride deployedBytecode = accountOverride;
        return ResultKt.success(new CallDeploy<AbiContract>((AbiContract)this$0.constructor.apply(this$0.getProvider(), $deployAddress), overrides, (Bytes)deployedBytecode));
    }
}

