/*
 * Decompiled with CFR 0.152.
 */
package io.kjson.resource;

import io.kjson.resource.ResourceDescriptor;
import io.kjson.resource.ResourceLoader;
import io.kjson.resource.ResourceLoaderException;
import io.kjson.resource.ResourceNotFoundException;
import io.kjson.resource.ResourceVetoedException;
import io.kjson.util.HTTPHeader;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.net.HttpURLConnection;
import java.net.JarURLConnection;
import java.net.URL;
import java.net.URLConnection;
import java.nio.file.Paths;
import java.time.Instant;
import java.util.Locale;
import java.util.jar.JarEntry;
import kotlin.Metadata;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u00006\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\b\n\u0002\b\u0003\b\u0016\u0018\u0000 \u001b*\u0004\b\u0000\u0010\u00012\u00020\u0002:\u0001\u001bB%\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\f\u0010\u0007\u001a\b\u0012\u0004\u0012\u00028\u00000\b\u00a2\u0006\u0004\b\t\u0010\nJ\r\u0010\u000e\u001a\u00028\u0000H\u0016\u00a2\u0006\u0002\u0010\u000fJ\u0016\u0010\u0010\u001a\b\u0012\u0004\u0012\u00028\u00000\u00002\u0006\u0010\u0011\u001a\u00020\u0012H\u0016J\b\u0010\u0013\u001a\u00020\u0014H\u0016J\f\u0010\u0015\u001a\u00020\u0004*\u00020\u0004H\u0002J\u0013\u0010\u0016\u001a\u00020\u00062\b\u0010\u0017\u001a\u0004\u0018\u00010\u0002H\u0096\u0002J\b\u0010\u0018\u001a\u00020\u0019H\u0016J\b\u0010\u001a\u001a\u00020\u0012H\u0016R\u0011\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR\u0011\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\rR\u0014\u0010\u0007\u001a\b\u0012\u0004\u0012\u00028\u00000\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001c"}, d2={"Lio/kjson/resource/Resource;", "T", "", "url", "Ljava/net/URL;", "isDirectory", "", "resourceLoader", "Lio/kjson/resource/ResourceLoader;", "<init>", "(Ljava/net/URL;ZLio/kjson/resource/ResourceLoader;)V", "getUrl", "()Ljava/net/URL;", "()Z", "load", "()Ljava/lang/Object;", "resolve", "relativeURL", "", "open", "Lio/kjson/resource/ResourceDescriptor;", "addDefaultExtension", "equals", "other", "hashCode", "", "toString", "Companion", "resource-loader"})
@SourceDebugExtension(value={"SMAP\nResource.kt\nKotlin\n*S Kotlin\n*F\n+ 1 Resource.kt\nio/kjson/resource/Resource\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,219:1\n1#2:220\n*E\n"})
public class Resource<T> {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final URL url;
    private final boolean isDirectory;
    @NotNull
    private final ResourceLoader<T> resourceLoader;
    @NotNull
    private static final String currentPath = new File(".").getCanonicalPath() + File.separatorChar;

    public Resource(@NotNull URL url, boolean isDirectory, @NotNull ResourceLoader<T> resourceLoader) {
        Intrinsics.checkNotNullParameter((Object)url, (String)"url");
        Intrinsics.checkNotNullParameter(resourceLoader, (String)"resourceLoader");
        this.url = url;
        this.isDirectory = isDirectory;
        this.resourceLoader = resourceLoader;
    }

    @NotNull
    public final URL getUrl() {
        return this.url;
    }

    public final boolean isDirectory() {
        return this.isDirectory;
    }

    public T load() {
        return this.resourceLoader.load(this);
    }

    @NotNull
    public Resource<T> resolve(@NotNull String relativeURL) {
        Intrinsics.checkNotNullParameter((Object)relativeURL, (String)"relativeURL");
        URL resolvedURL = new URL(this.url, relativeURL);
        String string = resolvedURL.toString();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toString(...)");
        return new Resource<T>(resolvedURL, StringsKt.endsWith$default((CharSequence)string, (char)'/', (boolean)false, (int)2, null), this.resourceLoader);
    }

    @NotNull
    public ResourceDescriptor open() {
        if (this.isDirectory) {
            throw new ResourceLoaderException("Can't load directory resource " + this.url, null, 2, null);
        }
        URL extendedURL = this.addDefaultExtension(this.url);
        try {
            ResourceDescriptor resourceDescriptor;
            Long contentLength;
            URLConnection uRLConnection = extendedURL.openConnection();
            Intrinsics.checkNotNullExpressionValue((Object)uRLConnection, (String)"openConnection(...)");
            URLConnection conn = uRLConnection;
            for (Function1<URLConnection, URLConnection> filter : this.resourceLoader.getConnectionFilters$resource_loader()) {
                if ((URLConnection)filter.invoke((Object)conn) != null) continue;
                throw new ResourceVetoedException(this.toString());
            }
            URLConnection uRLConnection2 = conn;
            if (uRLConnection2 instanceof HttpURLConnection) {
                HTTPHeader contentTypeHeader;
                Object object;
                HTTPHeader hTTPHeader;
                Instant instant;
                if (((HttpURLConnection)conn).getResponseCode() == 404) {
                    throw new ResourceNotFoundException(this.toString());
                }
                if (((HttpURLConnection)conn).getResponseCode() != 200) {
                    throw new IOException("Error status - " + ((HttpURLConnection)conn).getResponseCode() + " - " + extendedURL);
                }
                Long l = ((HttpURLConnection)conn).getContentLengthLong();
                long it = ((Number)l).longValue();
                boolean bl = false;
                contentLength = it >= 0L ? l : null;
                Long l2 = ((HttpURLConnection)conn).getLastModified();
                long it2 = ((Number)l2).longValue();
                boolean bl2 = false;
                Long l3 = it2 != 0L ? l2 : null;
                if (l3 != null) {
                    it2 = ((Number)l3).longValue();
                    boolean bl3 = false;
                    instant = Instant.ofEpochMilli(it2);
                } else {
                    instant = null;
                }
                Instant lastModified = instant;
                String string = ((HttpURLConnection)conn).getContentType();
                if (string != null) {
                    String it3 = string;
                    boolean bl4 = false;
                    hTTPHeader = HTTPHeader.Companion.parse(it3);
                } else {
                    hTTPHeader = null;
                }
                String charsetName = (object = (contentTypeHeader = hTTPHeader)) != null && (object = HTTPHeader.element$default((HTTPHeader)object, 0, 1, null)) != null ? HTTPHeader.Element.parameter$default((HTTPHeader.Element)object, "charset", 0, 2, null) : null;
                HTTPHeader hTTPHeader2 = contentTypeHeader;
                String mimeType = hTTPHeader2 != null ? hTTPHeader2.firstElementText() : null;
                InputStream inputStream = ((HttpURLConnection)conn).getInputStream();
                Intrinsics.checkNotNullExpressionValue((Object)inputStream, (String)"getInputStream(...)");
                resourceDescriptor = new ResourceDescriptor(inputStream, extendedURL, charsetName, contentLength, lastModified, mimeType, conn.getHeaderField("etag"));
            } else if (uRLConnection2 instanceof JarURLConnection) {
                JarEntry jarEntry = ((JarURLConnection)conn).getJarEntry();
                InputStream inputStream = ((JarURLConnection)conn).getInputStream();
                Intrinsics.checkNotNullExpressionValue((Object)inputStream, (String)"getInputStream(...)");
                resourceDescriptor = new ResourceDescriptor(inputStream, extendedURL, null, jarEntry.getSize(), Instant.ofEpochMilli(jarEntry.getTime()), null, null, 100, null);
            } else {
                HTTPHeader contentTypeHeader;
                HTTPHeader hTTPHeader;
                Instant instant;
                Long lastModified = conn.getContentLengthLong();
                long it = ((Number)lastModified).longValue();
                boolean bl = false;
                contentLength = it >= 0L ? lastModified : null;
                Long charsetName = conn.getLastModified();
                long it4 = ((Number)charsetName).longValue();
                boolean bl5 = false;
                Long l = it4 != 0L ? charsetName : null;
                if (l != null) {
                    it4 = ((Number)l).longValue();
                    boolean bl6 = false;
                    instant = Instant.ofEpochMilli(it4);
                } else {
                    instant = null;
                }
                lastModified = instant;
                String string = conn.getContentType();
                if (string != null) {
                    String it5 = string;
                    boolean bl7 = false;
                    hTTPHeader = HTTPHeader.Companion.parse(it5);
                } else {
                    hTTPHeader = null;
                }
                HTTPHeader hTTPHeader3 = contentTypeHeader = hTTPHeader;
                String mimeType = hTTPHeader3 != null ? hTTPHeader3.firstElementText() : null;
                InputStream inputStream = conn.getInputStream();
                Intrinsics.checkNotNullExpressionValue((Object)inputStream, (String)"getInputStream(...)");
                resourceDescriptor = new ResourceDescriptor(inputStream, extendedURL, null, contentLength, (Instant)((Object)lastModified), mimeType, null, 68, null);
            }
            return resourceDescriptor;
        }
        catch (ResourceLoaderException rle) {
            throw rle;
        }
        catch (FileNotFoundException fnfe) {
            throw new ResourceNotFoundException(this.toString());
        }
        catch (Exception e) {
            throw new ResourceLoaderException("Error opening resource " + extendedURL, e);
        }
    }

    private final URL addDefaultExtension(URL $this$addDefaultExtension) {
        String string = this.resourceLoader.getDefaultExtension();
        if (string == null) {
            return $this$addDefaultExtension;
        }
        String defaultExtension = string;
        String string2 = this.url.getPath();
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"getPath(...)");
        String filename = StringsKt.substringAfterLast$default((String)string2, (char)'/', null, (int)2, null);
        return ((CharSequence)filename).length() == 0 || StringsKt.contains$default((CharSequence)filename, (char)'.', (boolean)false, (int)2, null) ? $this$addDefaultExtension : new URL($this$addDefaultExtension, filename + '.' + defaultExtension);
    }

    public boolean equals(@Nullable Object other) {
        return this == other || other instanceof Resource && Companion.sameAs(this.url, ((Resource)other).url) && this.isDirectory == ((Resource)other).isDirectory && this.resourceLoader == ((Resource)other).resourceLoader;
    }

    public int hashCode() {
        return Companion.relevantHashCode(this.url) ^ Boolean.hashCode(this.isDirectory) ^ this.resourceLoader.hashCode();
    }

    @NotNull
    public String toString() {
        String string;
        if (!Intrinsics.areEqual((Object)this.url.getProtocol(), (Object)"file")) {
            String string2 = this.url.toString();
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"toString(...)");
            return string2;
        }
        String filePath = File.separatorChar == '/' ? this.url.getPath() : ((Object)Paths.get(this.url.toURI())).toString();
        Intrinsics.checkNotNull((Object)filePath);
        if (!StringsKt.startsWith$default((String)filePath, (String)currentPath, (boolean)false, (int)2, null)) {
            string = filePath;
        } else if (filePath.length() == currentPath.length()) {
            string = ".";
        } else {
            String string3 = filePath.substring(currentPath.length());
            string = string3;
            Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"substring(...)");
        }
        return string;
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0010\u0010\b\u001a\u0004\u0018\u00010\t2\u0006\u0010\n\u001a\u00020\u0005J\u0015\u0010\u000b\u001a\u00020\f*\u00020\t2\u0006\u0010\r\u001a\u00020\tH\u0086\u0004J\n\u0010\u000e\u001a\u00020\u000f*\u00020\tR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007\u00a8\u0006\u0010"}, d2={"Lio/kjson/resource/Resource$Companion;", "", "<init>", "()V", "currentPath", "", "getCurrentPath", "()Ljava/lang/String;", "classPathURL", "Ljava/net/URL;", "name", "sameAs", "", "other", "relevantHashCode", "", "resource-loader"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final String getCurrentPath() {
            return currentPath;
        }

        @Nullable
        public final URL classPathURL(@NotNull String name) {
            Intrinsics.checkNotNullParameter((Object)name, (String)"name");
            return Resource.class.getResource(name);
        }

        public final boolean sameAs(@NotNull URL $this$sameAs, @NotNull URL other) {
            Intrinsics.checkNotNullParameter((Object)$this$sameAs, (String)"<this>");
            Intrinsics.checkNotNullParameter((Object)other, (String)"other");
            if (!Intrinsics.areEqual((Object)$this$sameAs.getProtocol(), (Object)other.getProtocol())) {
                return false;
            }
            CharSequence charSequence = $this$sameAs.getHost();
            if (charSequence == null || charSequence.length() == 0 ? !((charSequence = (CharSequence)other.getHost()) == null || charSequence.length() == 0) : (StringsKt.equals((String)$this$sameAs.getHost(), (String)"localhost", (boolean)true) || Intrinsics.areEqual((Object)$this$sameAs.getHost(), (Object)"127.0.0.1") ? !StringsKt.equals((String)other.getHost(), (String)"localhost", (boolean)true) && !Intrinsics.areEqual((Object)other.getHost(), (Object)"127.0.0.1") : !StringsKt.equals((String)$this$sameAs.getHost(), (String)other.getHost(), (boolean)true))) {
                return false;
            }
            if ($this$sameAs.getPort() != other.getPort()) {
                return false;
            }
            charSequence = $this$sameAs.getPath();
            if (charSequence == null || charSequence.length() == 0 ? !((charSequence = (CharSequence)other.getPath()) == null || charSequence.length() == 0) : !Intrinsics.areEqual((Object)$this$sameAs.getPath(), (Object)other.getPath())) {
                return false;
            }
            if (!Intrinsics.areEqual((Object)$this$sameAs.getQuery(), (Object)other.getQuery())) {
                return false;
            }
            return Intrinsics.areEqual((Object)$this$sameAs.getRef(), (Object)other.getRef());
        }

        public final int relevantHashCode(@NotNull URL $this$relevantHashCode) {
            int n;
            Intrinsics.checkNotNullParameter((Object)$this$relevantHashCode, (String)"<this>");
            int n2 = $this$relevantHashCode.getProtocol().hashCode();
            CharSequence charSequence = $this$relevantHashCode.getHost();
            if (charSequence == null || charSequence.length() == 0) {
                n = 0;
            } else if (Intrinsics.areEqual((Object)$this$relevantHashCode.getHost(), (Object)"127.0.0.1")) {
                n = "localhost".hashCode();
            } else {
                String string = $this$relevantHashCode.getHost();
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getHost(...)");
                String string2 = string.toLowerCase(Locale.ROOT);
                Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"toLowerCase(...)");
                n = string2.hashCode();
            }
            charSequence = $this$relevantHashCode.getPath();
            return n2 + n + $this$relevantHashCode.getPort() + (charSequence == null || charSequence.length() == 0 ? 0 : $this$relevantHashCode.getPath().hashCode()) + ($this$relevantHashCode.getQuery() == null ? 0 : $this$relevantHashCode.getQuery().hashCode()) + ($this$relevantHashCode.getRef() == null ? 0 : $this$relevantHashCode.getRef().hashCode());
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

