/*
 * Decompiled with CFR 0.152.
 */
package io.kjson.resource;

import io.kjson.resource.Resource;
import io.kjson.resource.ResourceDescriptor;
import io.kjson.resource.ResourceLoader;
import io.kjson.resource.ResourceLoaderException;
import io.kjson.resource.ResourceNotFoundException;
import io.kjson.util.Cache;
import io.kjson.util.HTTPHeader;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.HttpURLConnection;
import java.net.URI;
import java.net.URL;
import java.net.URLConnection;
import java.nio.file.FileSystem;
import java.nio.file.FileSystems;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.time.Instant;
import java.util.ArrayList;
import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000Z\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0002\b\n\n\u0002\u0010\b\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\b&\u0018\u0000 -*\u0004\b\u0000\u0010\u00012\u00020\u0002:\u0003,-.B\u0005\u00a2\u0006\u0002\u0010\u0003J \u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\t2\u0006\u0010\u0011\u001a\u00020\t2\b\u0010\u0012\u001a\u0004\u0018\u00010\tJ\u001c\u0010\u0013\u001a\u00020\u000f2\u0014\u0010\u0014\u001a\u0010\u0012\u0004\u0012\u00020\u0007\u0012\u0006\u0012\u0004\u0018\u00010\u00070\u0006J\u000e\u0010\u0015\u001a\u00020\t2\u0006\u0010\u0016\u001a\u00020\tJ*\u0010\u0017\u001a\u00020\u000f2\u0006\u0010\u0018\u001a\u00020\t2\b\b\u0002\u0010\u0019\u001a\u00020\u001a2\u0006\u0010\u001b\u001a\u00020\t2\b\b\u0002\u0010\u001c\u001a\u00020\u001aJ\u001b\u0010\u001d\u001a\u00028\u00002\f\u0010\u001e\u001a\b\u0012\u0004\u0012\u00028\u00000\u001fH\u0016\u00a2\u0006\u0002\u0010 J\u0015\u0010\u001d\u001a\u00028\u00002\u0006\u0010!\u001a\u00020\"H&\u00a2\u0006\u0002\u0010#J\u0013\u0010\u001d\u001a\u00028\u00002\u0006\u0010$\u001a\u00020%\u00a2\u0006\u0002\u0010&J\u0016\u0010'\u001a\u00020\"2\f\u0010\u001e\u001a\b\u0012\u0004\u0012\u00028\u00000\u001fH\u0016J\u0014\u0010\u001e\u001a\b\u0012\u0004\u0012\u00028\u00000\u001f2\u0006\u0010(\u001a\u00020)J\u0014\u0010\u001e\u001a\b\u0012\u0004\u0012\u00028\u00000\u001f2\u0006\u0010$\u001a\u00020%J\u0014\u0010\u001e\u001a\b\u0012\u0004\u0012\u00028\u00000\u001f2\u0006\u0010*\u001a\u00020+R\"\u0010\u0004\u001a\u0016\u0012\u0012\u0012\u0010\u0012\u0004\u0012\u00020\u0007\u0012\u0006\u0012\u0004\u0018\u00010\u00070\u00060\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\b\u001a\u0004\u0018\u00010\tX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR\u0016\u0010\f\u001a\u0004\u0018\u00010\tX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000b\u00a8\u0006/"}, d2={"Lio/kjson/resource/ResourceLoader;", "T", "", "()V", "connectionFilters", "", "Lkotlin/Function1;", "Ljava/net/HttpURLConnection;", "defaultExtension", "", "getDefaultExtension", "()Ljava/lang/String;", "defaultMIMEType", "getDefaultMIMEType", "addAuthorizationFilter", "", "host", "headerName", "headerValue", "addConnectionFilter", "filter", "addExtension", "s", "addRedirectionFilter", "fromHost", "fromPort", "", "toHost", "toPort", "load", "resource", "Lio/kjson/resource/Resource;", "(Lio/kjson/resource/Resource;)Ljava/lang/Object;", "rd", "Lio/kjson/resource/ResourceDescriptor;", "(Lio/kjson/resource/ResourceDescriptor;)Ljava/lang/Object;", "resourceURL", "Ljava/net/URL;", "(Ljava/net/URL;)Ljava/lang/Object;", "openResource", "resourceFile", "Ljava/io/File;", "resourcePath", "Ljava/nio/file/Path;", "AuthorizationFilter", "Companion", "RedirectionFilter", "resource-loader"})
@SourceDebugExtension(value={"SMAP\nResourceLoader.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ResourceLoader.kt\nio/kjson/resource/ResourceLoader\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,243:1\n1#2:244\n*E\n"})
public abstract class ResourceLoader<T> {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final List<Function1<HttpURLConnection, HttpURLConnection>> connectionFilters = new ArrayList();
    @Nullable
    private final String defaultExtension;
    @Nullable
    private final String defaultMIMEType;
    private static final FileSystem defaultFileSystem = FileSystems.getDefault();
    @NotNull
    private static final Cache<String, FileSystem> fileSystemCache = new Cache(Companion.fileSystemCache.1.INSTANCE);

    @Nullable
    public String getDefaultExtension() {
        return this.defaultExtension;
    }

    @Nullable
    public String getDefaultMIMEType() {
        return this.defaultMIMEType;
    }

    public abstract T load(@NotNull ResourceDescriptor var1);

    @NotNull
    public final Resource<T> resource(@NotNull File resourceFile) {
        Intrinsics.checkNotNullParameter((Object)resourceFile, (String)"resourceFile");
        Path path = resourceFile.toPath();
        URL uRL = resourceFile.toURI().toURL();
        Intrinsics.checkNotNullExpressionValue((Object)uRL, (String)"toURL(...)");
        return new Resource(path, uRL, this);
    }

    @NotNull
    public final Resource<T> resource(@NotNull Path resourcePath) {
        Intrinsics.checkNotNullParameter((Object)resourcePath, (String)"resourcePath");
        URL uRL = resourcePath.toUri().toURL();
        Intrinsics.checkNotNullExpressionValue((Object)uRL, (String)"toURL(...)");
        return new Resource(resourcePath, uRL, this);
    }

    @NotNull
    public final Resource<T> resource(@NotNull URL resourceURL) {
        Intrinsics.checkNotNullParameter((Object)resourceURL, (String)"resourceURL");
        return new Resource(Companion.derivePath(resourceURL), resourceURL, this);
    }

    public T load(@NotNull Resource<T> resource) {
        Intrinsics.checkNotNullParameter(resource, (String)"resource");
        return this.load(this.openResource(resource));
    }

    public final T load(@NotNull URL resourceURL) {
        Intrinsics.checkNotNullParameter((Object)resourceURL, (String)"resourceURL");
        return this.load(this.resource(resourceURL));
    }

    @NotNull
    public ResourceDescriptor openResource(@NotNull Resource<T> resource) {
        Intrinsics.checkNotNullParameter(resource, (String)"resource");
        try {
            Path path = resource.getResourcePath$resource_loader();
            if (path != null) {
                Path path2 = path;
                boolean bl = false;
                if (!Files.exists(path2, new LinkOption[0]) || Files.isDirectory(path2, new LinkOption[0])) {
                    throw new ResourceNotFoundException(resource.getResourceURL());
                }
                InputStream inputStream = Files.newInputStream(path2, new OpenOption[0]);
                Intrinsics.checkNotNullExpressionValue((Object)inputStream, (String)"newInputStream(...)");
                return new ResourceDescriptor(inputStream, resource.getResourceURL(), null, Files.size(path2), Files.getLastModifiedTime(path2, new LinkOption[0]).toInstant(), null, null, 100, null);
            }
            URLConnection uRLConnection = resource.getResourceURL().openConnection();
            Intrinsics.checkNotNullExpressionValue((Object)uRLConnection, (String)"openConnection(...)");
            URLConnection conn = uRLConnection;
            if (conn instanceof HttpURLConnection) {
                HTTPHeader contentTypeHeader;
                Object object;
                HTTPHeader hTTPHeader;
                Instant instant;
                Object filter2;
                HttpURLConnection httpConn = (HttpURLConnection)conn;
                for (Object filter2 : this.connectionFilters) {
                    if ((HttpURLConnection)filter2.invoke((Object)httpConn) != null) continue;
                    throw new ResourceLoaderException("Connection vetoed - " + resource.getResourceURL(), null, 2, null);
                }
                if (httpConn.getResponseCode() == 404) {
                    throw new ResourceNotFoundException(resource.getResourceURL());
                }
                if (httpConn.getResponseCode() != 200) {
                    throw new IOException("Error status - " + httpConn.getResponseCode() + " - " + resource.getResourceURL());
                }
                filter2 = httpConn.getContentLengthLong();
                long it = ((Number)filter2).longValue();
                boolean bl = false;
                Object contentLength = it >= 0L ? filter2 : null;
                Long l = httpConn.getLastModified();
                long it2 = ((Number)l).longValue();
                boolean bl2 = false;
                Long l2 = it2 != 0L ? l : null;
                if (l2 != null) {
                    it2 = ((Number)l2).longValue();
                    boolean bl3 = false;
                    instant = Instant.ofEpochMilli(it2);
                } else {
                    instant = null;
                }
                Instant lastModified = instant;
                String string = httpConn.getContentType();
                if (string != null) {
                    String it3 = string;
                    boolean bl4 = false;
                    hTTPHeader = HTTPHeader.Companion.create(it3);
                } else {
                    hTTPHeader = null;
                }
                String charsetName = (object = (contentTypeHeader = hTTPHeader)) != null && (object = HTTPHeader.element$default((HTTPHeader)object, 0, 1, null)) != null ? HTTPHeader.Element.parameter$default((HTTPHeader.Element)object, "charset", 0, 2, null) : null;
                HTTPHeader hTTPHeader2 = contentTypeHeader;
                String mimeType = hTTPHeader2 != null ? hTTPHeader2.firstElementText() : null;
                InputStream inputStream = httpConn.getInputStream();
                Intrinsics.checkNotNullExpressionValue((Object)inputStream, (String)"getInputStream(...)");
                return new ResourceDescriptor(inputStream, resource.getResourceURL(), charsetName, (Long)contentLength, lastModified, mimeType, httpConn.getHeaderField("etag"));
            }
            InputStream inputStream = conn.getInputStream();
            Intrinsics.checkNotNullExpressionValue((Object)inputStream, (String)"getInputStream(...)");
            return new ResourceDescriptor(inputStream, resource.getResourceURL(), null, null, null, null, null, 124, null);
        }
        catch (ResourceLoaderException rle) {
            throw rle;
        }
        catch (Exception e) {
            throw new ResourceLoaderException("Error opening resource " + resource.getResourceURL(), e);
        }
    }

    @NotNull
    public final String addExtension(@NotNull String s) {
        Intrinsics.checkNotNullParameter((Object)s, (String)"s");
        return this.getDefaultExtension() != null && StringsKt.indexOf$default((CharSequence)s, (char)'.', (int)(StringsKt.lastIndexOf$default((CharSequence)s, (char)File.separatorChar, (int)0, (boolean)false, (int)6, null) + 1), (boolean)false, (int)4, null) < 0 ? s + '.' + this.getDefaultExtension() : s;
    }

    public final void addConnectionFilter(@NotNull Function1<? super HttpURLConnection, ? extends HttpURLConnection> filter) {
        Intrinsics.checkNotNullParameter(filter, (String)"filter");
        this.connectionFilters.add(filter);
    }

    public final void addAuthorizationFilter(@NotNull String host, @NotNull String headerName, @Nullable String headerValue) {
        Intrinsics.checkNotNullParameter((Object)host, (String)"host");
        Intrinsics.checkNotNullParameter((Object)headerName, (String)"headerName");
        this.addConnectionFilter((Function1<HttpURLConnection, HttpURLConnection>)((Function1)new AuthorizationFilter(host, headerName, headerValue)));
    }

    public final void addRedirectionFilter(@NotNull String fromHost, int fromPort, @NotNull String toHost, int toPort) {
        Intrinsics.checkNotNullParameter((Object)fromHost, (String)"fromHost");
        Intrinsics.checkNotNullParameter((Object)toHost, (String)"toHost");
        this.addConnectionFilter((Function1<HttpURLConnection, HttpURLConnection>)((Function1)new RedirectionFilter(fromHost, fromPort, toHost, toPort)));
    }

    public static /* synthetic */ void addRedirectionFilter$default(ResourceLoader resourceLoader, String string, int n, String string2, int n2, int n3, Object object) {
        if (object != null) {
            throw new UnsupportedOperationException("Super calls with default arguments not supported in this target, function: addRedirectionFilter");
        }
        if ((n3 & 2) != 0) {
            n = -1;
        }
        if ((n3 & 8) != 0) {
            n2 = -1;
        }
        resourceLoader.addRedirectionFilter(string, n, string2, n2);
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u0016\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0006\u0018\u00002\u0010\u0012\u0004\u0012\u00020\u0002\u0012\u0006\u0012\u0004\u0018\u00010\u00020\u0001B\u001f\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0004\u0012\b\u0010\u0006\u001a\u0004\u0018\u00010\u0004\u00a2\u0006\u0002\u0010\u0007J\u0011\u0010\b\u001a\u00020\u00022\u0006\u0010\t\u001a\u00020\u0002H\u0096\u0002R\u000e\u0010\u0005\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0006\u001a\u0004\u0018\u00010\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\n"}, d2={"Lio/kjson/resource/ResourceLoader$AuthorizationFilter;", "Lkotlin/Function1;", "Ljava/net/HttpURLConnection;", "host", "", "headerName", "headerValue", "(Ljava/lang/String;Ljava/lang/String;Ljava/lang/String;)V", "invoke", "httpConn", "resource-loader"})
    public static final class AuthorizationFilter
    implements Function1<HttpURLConnection, HttpURLConnection> {
        @NotNull
        private final String host;
        @NotNull
        private final String headerName;
        @Nullable
        private final String headerValue;

        public AuthorizationFilter(@NotNull String host, @NotNull String headerName, @Nullable String headerValue) {
            Intrinsics.checkNotNullParameter((Object)host, (String)"host");
            Intrinsics.checkNotNullParameter((Object)headerName, (String)"headerName");
            this.host = host;
            this.headerName = headerName;
            this.headerValue = headerValue;
        }

        @NotNull
        public HttpURLConnection invoke(@NotNull HttpURLConnection httpConn) {
            Intrinsics.checkNotNullParameter((Object)httpConn, (String)"httpConn");
            URL uRL = httpConn.getURL();
            Intrinsics.checkNotNullExpressionValue((Object)uRL, (String)"getURL(...)");
            if (Companion.matchesHost(uRL, this.host)) {
                httpConn.addRequestProperty(this.headerName, this.headerValue);
            }
            return httpConn;
        }
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\t\u001a\u0004\u0018\u00010\n2\u0006\u0010\u000b\u001a\u00020\fJ\u0012\u0010\r\u001a\u00020\u000e*\u00020\f2\u0006\u0010\u000f\u001a\u00020\bR\u0016\u0010\u0003\u001a\n \u0005*\u0004\u0018\u00010\u00040\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u0006\u001a\u000e\u0012\u0004\u0012\u00020\b\u0012\u0004\u0012\u00020\u00040\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0010"}, d2={"Lio/kjson/resource/ResourceLoader$Companion;", "", "()V", "defaultFileSystem", "Ljava/nio/file/FileSystem;", "kotlin.jvm.PlatformType", "fileSystemCache", "Lio/kjson/util/Cache;", "", "derivePath", "Ljava/nio/file/Path;", "url", "Ljava/net/URL;", "matchesHost", "", "target", "resource-loader"})
    public static final class Companion {
        private Companion() {
        }

        @Nullable
        public final Path derivePath(@NotNull URL url) {
            Path path;
            Intrinsics.checkNotNullParameter((Object)url, (String)"url");
            URI uri = url.toURI();
            String string = uri.getScheme();
            if (Intrinsics.areEqual((Object)string, (Object)"jar")) {
                String schemeSpecific = uri.getSchemeSpecificPart();
                Intrinsics.checkNotNull((Object)schemeSpecific);
                int start = StringsKt.indexOf$default((CharSequence)schemeSpecific, (char)':', (int)0, (boolean)false, (int)6, null);
                int bang = StringsKt.lastIndexOf$default((CharSequence)schemeSpecific, (char)'!', (int)0, (boolean)false, (int)6, null);
                if (!(0 <= start ? start < bang : false)) {
                    return null;
                }
                ++start;
                while (start + 2 < bang && schemeSpecific.charAt(start) == '/' && schemeSpecific.charAt(start + 1) == '/') {
                    ++start;
                }
                Cache cache = fileSystemCache;
                String string2 = schemeSpecific.substring(start, bang);
                Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"substring(...)");
                FileSystem fs = (FileSystem)cache.get(string2);
                String string3 = schemeSpecific.substring(bang + 1);
                Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"substring(...)");
                path = fs.getPath(string3, new String[0]);
            } else {
                path = Intrinsics.areEqual((Object)string, (Object)"file") ? defaultFileSystem.getPath(uri.getPath(), new String[0]) : null;
            }
            return path;
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public final boolean matchesHost(@NotNull URL $this$matchesHost, @NotNull String target) {
            Intrinsics.checkNotNullParameter((Object)$this$matchesHost, (String)"<this>");
            Intrinsics.checkNotNullParameter((Object)target, (String)"target");
            if (StringsKt.startsWith$default((String)target, (String)"*.", (boolean)false, (int)2, null)) {
                String string = $this$matchesHost.getHost();
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getHost(...)");
                String string2 = target.substring(1);
                Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"substring(...)");
                if (StringsKt.endsWith$default((String)string, (String)string2, (boolean)false, (int)2, null)) return true;
                String string3 = $this$matchesHost.getHost();
                String string4 = target.substring(2);
                Intrinsics.checkNotNullExpressionValue((Object)string4, (String)"substring(...)");
                if (!Intrinsics.areEqual((Object)string3, (Object)string4)) return false;
                return true;
            }
            boolean bl = Intrinsics.areEqual((Object)$this$matchesHost.getHost(), (Object)target);
            return bl;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u001c\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\b\n\u0002\b\u0006\u0018\u00002\u0010\u0012\u0004\u0012\u00020\u0002\u0012\u0006\u0012\u0004\u0018\u00010\u00020\u0001B)\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\b\b\u0002\u0010\u0005\u001a\u00020\u0006\u0012\u0006\u0010\u0007\u001a\u00020\u0004\u0012\b\b\u0002\u0010\b\u001a\u00020\u0006\u00a2\u0006\u0002\u0010\tJ\u0011\u0010\n\u001a\u00020\u00022\u0006\u0010\u000b\u001a\u00020\u0002H\u0096\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\f"}, d2={"Lio/kjson/resource/ResourceLoader$RedirectionFilter;", "Lkotlin/Function1;", "Ljava/net/HttpURLConnection;", "fromHost", "", "fromPort", "", "toHost", "toPort", "(Ljava/lang/String;ILjava/lang/String;I)V", "invoke", "httpCon", "resource-loader"})
    public static final class RedirectionFilter
    implements Function1<HttpURLConnection, HttpURLConnection> {
        @NotNull
        private final String fromHost;
        private final int fromPort;
        @NotNull
        private final String toHost;
        private final int toPort;

        public RedirectionFilter(@NotNull String fromHost, int fromPort, @NotNull String toHost, int toPort) {
            Intrinsics.checkNotNullParameter((Object)fromHost, (String)"fromHost");
            Intrinsics.checkNotNullParameter((Object)toHost, (String)"toHost");
            this.fromHost = fromHost;
            this.fromPort = fromPort;
            this.toHost = toHost;
            this.toPort = toPort;
        }

        public /* synthetic */ RedirectionFilter(String string, int n, String string2, int n2, int n3, DefaultConstructorMarker defaultConstructorMarker) {
            if ((n3 & 2) != 0) {
                n = -1;
            }
            if ((n3 & 8) != 0) {
                n2 = -1;
            }
            this(string, n, string2, n2);
        }

        @NotNull
        public HttpURLConnection invoke(@NotNull HttpURLConnection httpCon) {
            HttpURLConnection httpURLConnection;
            Intrinsics.checkNotNullParameter((Object)httpCon, (String)"httpCon");
            URL url = httpCon.getURL();
            Intrinsics.checkNotNull((Object)url);
            if (!Companion.matchesHost(url, this.fromHost) || url.getPort() != this.fromPort) {
                httpURLConnection = httpCon;
            } else {
                URLConnection uRLConnection = new URL(url.getProtocol(), this.toHost, this.toPort, url.getFile()).openConnection();
                Intrinsics.checkNotNull((Object)uRLConnection, (String)"null cannot be cast to non-null type java.net.HttpURLConnection");
                httpURLConnection = (HttpURLConnection)uRLConnection;
            }
            return httpURLConnection;
        }
    }
}

