/*
 * Decompiled with CFR 0.152.
 */
package io.kjson.resource;

import io.kjson.resource.Resource;
import io.kjson.resource.ResourceDescriptor;
import io.kjson.resource.ResourceLoader;
import io.kjson.resource.ResourceLoaderException;
import io.kjson.resource.ResourceNotFoundException;
import io.kjson.util.Cache;
import io.kjson.util.HTTPHeader;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.HttpURLConnection;
import java.net.URI;
import java.net.URL;
import java.net.URLConnection;
import java.nio.file.FileSystem;
import java.nio.file.FileSystems;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.time.Instant;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000>\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0004\n\u0002\u0010\u000e\n\u0002\b\u0003\u0018\u0000 \u0019*\u0004\b\u0000\u0010\u00012\u00020\u0002:\u0001\u0019B'\b\u0000\u0012\b\u0010\u0003\u001a\u0004\u0018\u00010\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\f\u0010\u0007\u001a\b\u0012\u0004\u0012\u00028\u00000\b\u00a2\u0006\u0002\u0010\tJ\b\u0010\f\u001a\u00020\rH\u0002J\u0013\u0010\u000e\u001a\u00020\u000f2\b\u0010\u0010\u001a\u0004\u0018\u00010\u0002H\u0096\u0002J\b\u0010\u0011\u001a\u00020\u0012H\u0016J\u000b\u0010\u0013\u001a\u00028\u0000\u00a2\u0006\u0002\u0010\u0014J\u0014\u0010\u0015\u001a\b\u0012\u0004\u0012\u00028\u00000\u00002\u0006\u0010\u0016\u001a\u00020\u0017J\b\u0010\u0018\u001a\u00020\u0017H\u0016R\u0014\u0010\u0007\u001a\b\u0012\u0004\u0012\u00028\u00000\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0003\u001a\u0004\u0018\u00010\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000b\u00a8\u0006\u001a"}, d2={"Lio/kjson/resource/Resource;", "T", "", "resourcePath", "Ljava/nio/file/Path;", "resourceURL", "Ljava/net/URL;", "resourceLoader", "Lio/kjson/resource/ResourceLoader;", "(Ljava/nio/file/Path;Ljava/net/URL;Lio/kjson/resource/ResourceLoader;)V", "getResourceURL", "()Ljava/net/URL;", "createResourceDescriptor", "Lio/kjson/resource/ResourceDescriptor;", "equals", "", "other", "hashCode", "", "load", "()Ljava/lang/Object;", "resolve", "name", "", "toString", "Companion", "resource-loader"})
@SourceDebugExtension(value={"SMAP\nResource.kt\nKotlin\n*S Kotlin\n*F\n+ 1 Resource.kt\nio/kjson/resource/Resource\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,174:1\n1#2:175\n*E\n"})
public final class Resource<T> {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @Nullable
    private final Path resourcePath;
    @NotNull
    private final URL resourceURL;
    @NotNull
    private final ResourceLoader<T> resourceLoader;
    private static final FileSystem defaultFileSystem = FileSystems.getDefault();
    @NotNull
    private static final Cache<String, FileSystem> fileSystemCache = new Cache(Companion.fileSystemCache.1.INSTANCE);
    @NotNull
    private static final String currentPath;

    public Resource(@Nullable Path resourcePath, @NotNull URL resourceURL, @NotNull ResourceLoader<T> resourceLoader) {
        Intrinsics.checkNotNullParameter((Object)resourceURL, (String)"resourceURL");
        Intrinsics.checkNotNullParameter(resourceLoader, (String)"resourceLoader");
        this.resourcePath = resourcePath;
        this.resourceURL = resourceURL;
        this.resourceLoader = resourceLoader;
    }

    @NotNull
    public final URL getResourceURL() {
        return this.resourceURL;
    }

    public final T load() {
        return this.resourceLoader.load(this.createResourceDescriptor());
    }

    private final ResourceDescriptor createResourceDescriptor() {
        Instant instant;
        Path path = this.resourcePath;
        if (path != null) {
            Path path2 = path;
            boolean bl2 = false;
            if (!Files.exists(path2, new LinkOption[0]) || Files.isDirectory(path2, new LinkOption[0])) {
                throw new ResourceNotFoundException(this.resourceURL);
            }
            InputStream inputStream = Files.newInputStream(path2, new OpenOption[0]);
            Intrinsics.checkNotNullExpressionValue((Object)inputStream, (String)"newInputStream(path)");
            return new ResourceDescriptor(inputStream, this.resourceURL, null, Files.size(path2), Files.getLastModifiedTime(path2, new LinkOption[0]).toInstant(), null, 36, null);
        }
        URLConnection conn = this.resourceURL.openConnection();
        boolean bl = false;
        Long bl2 = conn.getContentLengthLong();
        long it = ((Number)bl2).longValue();
        boolean bl3 = false;
        Long contentLength = it >= 0L ? bl2 : null;
        Long l = conn.getLastModified();
        long it2 = ((Number)l).longValue();
        boolean bl4 = false;
        Long l2 = it2 != 0L ? l : null;
        if (l2 != null) {
            it2 = ((Number)l2).longValue();
            boolean bl5 = false;
            instant = Instant.ofEpochMilli(it2);
        } else {
            instant = null;
        }
        Instant lastModified = instant;
        String charsetName = null;
        String mimeType = null;
        if (conn instanceof HttpURLConnection) {
            HTTPHeader contentTypeHeader;
            Object object;
            HTTPHeader hTTPHeader;
            String string;
            if (!this.resourceLoader.checkHTTP((HttpURLConnection)conn)) {
                throw new ResourceLoaderException("Connection vetoed - " + this.resourceURL);
            }
            if (((HttpURLConnection)conn).getResponseCode() == 404) {
                throw new ResourceNotFoundException(this.resourceURL);
            }
            if (((HttpURLConnection)conn).getResponseCode() != 200) {
                throw new IOException("Error status - " + ((HttpURLConnection)conn).getResponseCode() + " - " + this.resourceURL);
            }
            String string2 = string = ((HttpURLConnection)conn).getContentType();
            if (string2 != null) {
                Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"contentType");
                String it3 = string;
                boolean bl6 = false;
                hTTPHeader = HTTPHeader.Companion.create(it3);
            } else {
                hTTPHeader = null;
            }
            charsetName = (object = (contentTypeHeader = hTTPHeader)) != null && (object = HTTPHeader.element$default((HTTPHeader)object, 0, 1, null)) != null ? HTTPHeader.Element.parameter$default((HTTPHeader.Element)object, "charset", 0, 2, null) : null;
            HTTPHeader hTTPHeader2 = contentTypeHeader;
            mimeType = hTTPHeader2 != null ? hTTPHeader2.firstElementText() : null;
        } else {
            charsetName = null;
            mimeType = conn.getContentType();
        }
        InputStream inputStream = conn.getInputStream();
        Intrinsics.checkNotNullExpressionValue((Object)inputStream, (String)"conn.getInputStream()");
        return new ResourceDescriptor(inputStream, this.resourceURL, charsetName, contentLength, lastModified, mimeType);
    }

    @NotNull
    public final Resource<T> resolve(@NotNull String name) {
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        String extendedName = this.resourceLoader.addExtension(name);
        if (new URI(extendedName).getScheme() == null && this.resourcePath != null) {
            Path resolved = Files.isDirectory(this.resourcePath, new LinkOption[0]) ? this.resourcePath.resolve(extendedName) : this.resourcePath.resolveSibling(extendedName);
            URL uRL = resolved.toUri().toURL();
            Intrinsics.checkNotNullExpressionValue((Object)uRL, (String)"resolved.toUri().toURL()");
            return new Resource<T>(resolved, uRL, this.resourceLoader);
        }
        URL resolvedURL = this.resourceURL.toURI().resolve(extendedName).toURL();
        Intrinsics.checkNotNullExpressionValue((Object)resolvedURL, (String)"resolvedURL");
        return new Resource<T>(Companion.derivePath(resolvedURL), resolvedURL, this.resourceLoader);
    }

    public boolean equals(@Nullable Object other) {
        return this == other || other instanceof Resource && this.resourceLoader == ((Resource)other).resourceLoader && Intrinsics.areEqual((Object)this.resourceURL.toString(), (Object)((Resource)other).resourceURL.toString());
    }

    public int hashCode() {
        return this.resourceLoader.hashCode() ^ this.resourceURL.toString().hashCode();
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public String toString() {
        String string;
        if (!Intrinsics.areEqual((Object)this.resourceURL.getProtocol(), (Object)"file")) {
            String string2 = this.resourceURL.toString();
            string = string2;
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"resourceURL.toString()");
        } else {
            void var2_3;
            void var3_1;
            String it = this.resourceURL.getPath();
            boolean bl = false;
            Intrinsics.checkNotNullExpressionValue((Object)it, (String)"it");
            String path = StringsKt.startsWith$default((String)it, (String)"///", (boolean)false, (int)2, null) ? StringsKt.drop((String)it, (int)2) : var3_1;
            Intrinsics.checkNotNullExpressionValue((Object)path, (String)"path");
            void var1_4 = StringsKt.startsWith$default((String)path, (String)currentPath, (boolean)false, (int)2, null) ? StringsKt.drop((String)path, (int)currentPath.length()) : var2_3;
            Intrinsics.checkNotNullExpressionValue((Object)var1_4, (String)"{\n        val path = res\u2026se\n            path\n    }");
            string = var1_4;
        }
        return string;
    }

    static {
        String it = new File(".").getAbsolutePath();
        boolean bl = false;
        Intrinsics.checkNotNullExpressionValue((Object)it, (String)"it");
        String string = StringsKt.endsWith$default((String)it, (String)"/.", (boolean)false, (int)2, null) ? StringsKt.dropLast((String)it, (int)1) : (StringsKt.endsWith$default((CharSequence)it, (char)'/', (boolean)false, (int)2, null) ? it : it + '/');
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"File(\".\").absolutePath.l\u2026\"\n            }\n        }");
        currentPath = string;
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\f\u001a\u0004\u0018\u00010\r2\u0006\u0010\u000e\u001a\u00020\u0004J\u0010\u0010\u000f\u001a\u0004\u0018\u00010\u00102\u0006\u0010\u0011\u001a\u00020\rR\u0011\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006R\u0016\u0010\u0007\u001a\n \t*\u0004\u0018\u00010\b0\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\n\u001a\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\b0\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0012"}, d2={"Lio/kjson/resource/Resource$Companion;", "", "()V", "currentPath", "", "getCurrentPath", "()Ljava/lang/String;", "defaultFileSystem", "Ljava/nio/file/FileSystem;", "kotlin.jvm.PlatformType", "fileSystemCache", "Lio/kjson/util/Cache;", "classPathURL", "Ljava/net/URL;", "name", "derivePath", "Ljava/nio/file/Path;", "url", "resource-loader"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final String getCurrentPath() {
            return currentPath;
        }

        @Nullable
        public final URL classPathURL(@NotNull String name) {
            Intrinsics.checkNotNullParameter((Object)name, (String)"name");
            return Resource.class.getResource(name);
        }

        @Nullable
        public final Path derivePath(@NotNull URL url) {
            Path path;
            Intrinsics.checkNotNullParameter((Object)url, (String)"url");
            URI uri = url.toURI();
            String string = uri.getScheme();
            if (Intrinsics.areEqual((Object)string, (Object)"jar")) {
                String schemeSpecific = uri.getSchemeSpecificPart();
                Intrinsics.checkNotNullExpressionValue((Object)schemeSpecific, (String)"schemeSpecific");
                int start = StringsKt.indexOf$default((CharSequence)schemeSpecific, (char)':', (int)0, (boolean)false, (int)6, null);
                int bang = StringsKt.lastIndexOf$default((CharSequence)schemeSpecific, (char)'!', (int)0, (boolean)false, (int)6, null);
                if (start < 0 || bang < 0 || start > bang) {
                    return null;
                }
                ++start;
                while (start + 2 < bang && schemeSpecific.charAt(start) == '/' && schemeSpecific.charAt(start + 1) == '/') {
                    ++start;
                }
                Cache cache = fileSystemCache;
                String string2 = schemeSpecific.substring(start, bang);
                Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"this as java.lang.String\u2026ing(startIndex, endIndex)");
                FileSystem fs = (FileSystem)cache.get(string2);
                String string3 = schemeSpecific.substring(bang + 1);
                Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"this as java.lang.String).substring(startIndex)");
                path = fs.getPath(string3, new String[0]);
            } else {
                path = Intrinsics.areEqual((Object)string, (Object)"file") ? defaultFileSystem.getPath(uri.getPath(), new String[0]) : null;
            }
            return path;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

