/*
 * Decompiled with CFR 0.152.
 */
package io.kjson.pointer;

import io.kjson.JSON;
import io.kjson.JSONArray;
import io.kjson.JSONObject;
import io.kjson.JSONValue;
import io.kjson.pointer.JSONPointer;
import io.kjson.pointer.JSONPointerException;
import io.kjson.pointer.JSONReference;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import kotlin.KotlinNothingValueException;
import kotlin.Metadata;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import net.pwall.text.CharMapResult;
import net.pwall.text.MapResult;
import net.pwall.text.StringMapper;
import net.pwall.text.URIStringMapper;
import net.pwall.text.UTF8StringMapper;
import net.pwall.util.ImmutableList;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000P\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\u0011\n\u0002\b\u0005\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u000b\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010 \n\u0002\b\u0002\u0018\u0000 /2\u00020\u0001:\u0001/B\u000f\b\u0016\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004B\u0015\b\u0000\u0012\f\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00030\u0006\u00a2\u0006\u0002\u0010\u0007J\u000e\u0010\u0015\u001a\u00020\u00002\u0006\u0010\u0016\u001a\u00020\fJ\u000e\u0010\u0015\u001a\u00020\u00002\u0006\u0010\u0017\u001a\u00020\u0003J\u0013\u0010\u0018\u001a\u00020\u00102\b\u0010\u0019\u001a\u0004\u0018\u00010\u0001H\u0096\u0002J\u0013\u0010\u001a\u001a\u00020\u00102\b\u0010\u001b\u001a\u0004\u0018\u00010\u001cH\u0086\u0004J\u0012\u0010\u001d\u001a\u0004\u0018\u00010\u001c2\b\u0010\u001e\u001a\u0004\u0018\u00010\u001cJ\u0010\u0010\u001f\u001a\u00020 2\b\u0010\u001e\u001a\u0004\u0018\u00010\u001cJ\u0010\u0010!\u001a\u00020\"2\b\u0010\u001e\u001a\u0004\u0018\u00010\u001cJ\u0012\u0010#\u001a\u0004\u0018\u00010\u001c2\b\u0010\u001e\u001a\u0004\u0018\u00010\u001cJ\b\u0010$\u001a\u00020\fH\u0016J\u001c\u0010%\u001a\u0004\u0018\u00010\u00002\b\u0010\u001e\u001a\u0004\u0018\u00010\u001c2\b\u0010&\u001a\u0004\u0018\u00010\u001cJ\u0006\u0010'\u001a\u00020\u0000J\u0013\u0010(\u001a\u00020)2\b\u0010\u001e\u001a\u0004\u0018\u00010\u001cH\u0086\u0004J\b\u0010*\u001a\u00020\u0003H\u0016J\u0006\u0010+\u001a\u00020\u0003J\u0011\u0010,\u001a\b\u0012\u0004\u0012\u00020\u00030\u0006\u00a2\u0006\u0002\u0010\u0013J\f\u0010-\u001a\b\u0012\u0004\u0012\u00020\u00030.R\u0013\u0010\b\u001a\u0004\u0018\u00010\u00038F\u00a2\u0006\u0006\u001a\u0004\b\t\u0010\nR\u0011\u0010\u000b\u001a\u00020\f8F\u00a2\u0006\u0006\u001a\u0004\b\r\u0010\u000eR\u0011\u0010\u000f\u001a\u00020\u00108F\u00a2\u0006\u0006\u001a\u0004\b\u000f\u0010\u0011R\u001c\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00030\u0006X\u0080\u0004\u00a2\u0006\n\n\u0002\u0010\u0014\u001a\u0004\b\u0012\u0010\u0013\u00a8\u00060"}, d2={"Lio/kjson/pointer/JSONPointer;", "", "pointer", "", "(Ljava/lang/String;)V", "tokens", "", "([Ljava/lang/String;)V", "current", "getCurrent", "()Ljava/lang/String;", "depth", "", "getDepth", "()I", "isRoot", "", "()Z", "getTokens$kjson_pointer", "()[Ljava/lang/String;", "[Ljava/lang/String;", "child", "index", "string", "equals", "other", "existsIn", "json", "Lio/kjson/JSONValue;", "find", "base", "findArray", "Lio/kjson/JSONArray;", "findObject", "Lio/kjson/JSONObject;", "findOrNull", "hashCode", "locateChild", "target", "parent", "ref", "Lio/kjson/pointer/JSONReference;", "toString", "toURIFragment", "tokensAsArray", "tokensAsList", "", "Companion", "kjson-pointer"})
@SourceDebugExtension(value={"SMAP\nJSONPointer.kt\nKotlin\n*S Kotlin\n*F\n+ 1 JSONPointer.kt\nio/kjson/pointer/JSONPointer\n+ 2 ArrayIntrinsics.kt\nkotlin/ArrayIntrinsicsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,411:1\n26#2:412\n26#2:414\n1#3:413\n*S KotlinDebug\n*F\n+ 1 JSONPointer.kt\nio/kjson/pointer/JSONPointer\n*L\n63#1:412\n185#1:414\n*E\n"})
public final class JSONPointer {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final String[] tokens;
    @NotNull
    private static final JSONPointer root;
    @NotNull
    private static final String emptyString = "";
    @NotNull
    private static final CharMapResult mapJSONPointerTilde;
    @NotNull
    private static final CharMapResult mapJSONPointerSlash;

    public JSONPointer(@NotNull String[] tokens) {
        Intrinsics.checkNotNullParameter((Object)tokens, (String)"tokens");
        this.tokens = tokens;
    }

    @NotNull
    public final String[] getTokens$kjson_pointer() {
        return this.tokens;
    }

    public JSONPointer(@NotNull String pointer) {
        Intrinsics.checkNotNullParameter((Object)pointer, (String)"pointer");
        this(Companion.parseString(pointer));
    }

    public final int getDepth() {
        return this.tokens.length;
    }

    @NotNull
    public final String[] tokensAsArray() {
        String[] stringArray;
        if (this.tokens.length == 0) {
            boolean $i$f$emptyArray = false;
            stringArray = new String[]{};
        } else {
            String[] stringArray2 = Arrays.copyOf(this.tokens, this.tokens.length);
            Intrinsics.checkNotNullExpressionValue((Object)stringArray2, (String)"copyOf(this, size)");
            stringArray = stringArray2;
        }
        return stringArray;
    }

    @NotNull
    public final List<String> tokensAsList() {
        ImmutableList immutableList = ImmutableList.listOf((Object[])this.tokens);
        Intrinsics.checkNotNullExpressionValue((Object)immutableList, (String)"listOf(tokens)");
        return (List)immutableList;
    }

    @Nullable
    public final JSONValue find(@Nullable JSONValue base) {
        return Companion.find(this.tokens, base);
    }

    @Nullable
    public final JSONValue findOrNull(@Nullable JSONValue base) {
        return Companion.findOrNull(this.tokens, base);
    }

    @NotNull
    public final JSONObject findObject(@Nullable JSONValue base) {
        JSONValue it = Companion.findOrNull(this.tokens, base);
        boolean bl = false;
        JSONObject jSONObject = it instanceof JSONObject ? (JSONObject)it : null;
        if (jSONObject == null) {
            JSON.typeError$default((JSON)JSON.INSTANCE, (JSONValue)it, (String)"JSONObject", (Object)this, null, (int)4, null);
            throw new KotlinNothingValueException();
        }
        return jSONObject;
    }

    @NotNull
    public final JSONArray findArray(@Nullable JSONValue base) {
        JSONValue it = Companion.findOrNull(this.tokens, base);
        boolean bl = false;
        JSONArray jSONArray = it instanceof JSONArray ? (JSONArray)it : null;
        if (jSONArray == null) {
            JSON.typeError$default((JSON)JSON.INSTANCE, (JSONValue)it, (String)"JSONArray", (Object)this, null, (int)4, null);
            throw new KotlinNothingValueException();
        }
        return jSONArray;
    }

    public final boolean existsIn(@Nullable JSONValue json) {
        return Companion.existsIn(this.tokens, json);
    }

    @NotNull
    public final JSONPointer parent() {
        JSONPointer jSONPointer;
        int len = this.tokens.length;
        switch (len) {
            case 0: {
                Companion.rootParentError$kjson_pointer();
                throw new KotlinNothingValueException();
            }
            case 1: {
                jSONPointer = root;
                break;
            }
            default: {
                Object[] objectArray = this.tokens;
                int n = 0;
                int n2 = len - 1;
                JSONPointer jSONPointer2 = new JSONPointer((String[])ArraysKt.copyOfRange((Object[])objectArray, (int)n, (int)n2));
                jSONPointer = jSONPointer2;
            }
        }
        return jSONPointer;
    }

    @NotNull
    public final JSONPointer child(@NotNull String string) {
        Intrinsics.checkNotNullParameter((Object)string, (String)"string");
        return new JSONPointer((String[])ArraysKt.plus((Object[])this.tokens, (Object)string));
    }

    @NotNull
    public final JSONPointer child(int index) {
        if (index < 0) {
            throw new JSONPointerException("JSON Pointer index must not be negative");
        }
        return this.child(String.valueOf(index));
    }

    @Nullable
    public final String getCurrent() {
        return (String)ArraysKt.lastOrNull((Object[])this.tokens);
    }

    public final boolean isRoot() {
        return this.tokens.length == 0;
    }

    @NotNull
    public final String toURIFragment() {
        StringBuilder stringBuilder;
        StringBuilder $this$toURIFragment_u24lambda_u242 = stringBuilder = new StringBuilder();
        boolean bl = false;
        for (String token : this.tokens) {
            $this$toURIFragment_u24lambda_u242.append('/');
            $this$toURIFragment_u24lambda_u242.append(URIStringMapper.INSTANCE.encodeURI(UTF8StringMapper.INSTANCE.encodeUTF8(Companion.encodeJSONPointer(token))));
        }
        String string = stringBuilder.toString();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"StringBuilder().apply(builderAction).toString()");
        return string;
    }

    @Nullable
    public final JSONPointer locateChild(@Nullable JSONValue base, @Nullable JSONValue target) {
        block4: {
            block3: {
                if (base == target) {
                    return this;
                }
                if (!(base instanceof JSONObject)) break block3;
                for (String key : ((JSONObject)base).keySet()) {
                    JSONPointer jSONPointer = this.child(key).locateChild((JSONValue)((JSONObject)base).get((Object)key), target);
                    if (jSONPointer == null) continue;
                    JSONPointer it = jSONPointer;
                    boolean bl = false;
                    return it;
                }
                break block4;
            }
            if (!(base instanceof JSONArray)) break block4;
            int n = ((JSONArray)base).size();
            for (int i = 0; i < n; ++i) {
                JSONPointer jSONPointer = this.child(i).locateChild(((JSONArray)base).get(i), target);
                if (jSONPointer == null) continue;
                JSONPointer it = jSONPointer;
                boolean bl = false;
                return it;
            }
        }
        return null;
    }

    @NotNull
    public final JSONReference ref(@Nullable JSONValue base) {
        return Companion.existsIn(this.tokens, base) ? new JSONReference(base, this.tokens, true, Companion.find(this.tokens, base)) : new JSONReference(base, this.tokens, false, null);
    }

    public boolean equals(@Nullable Object other) {
        return this == other || other instanceof JSONPointer && Arrays.equals(this.tokens, ((JSONPointer)other).tokens);
    }

    public int hashCode() {
        return Arrays.hashCode(this.tokens);
    }

    @NotNull
    public String toString() {
        return Companion.toString(this.tokens, this.tokens.length);
    }

    public static final /* synthetic */ CharMapResult access$getMapJSONPointerTilde$cp() {
        return mapJSONPointerTilde;
    }

    public static final /* synthetic */ CharMapResult access$getMapJSONPointerSlash$cp() {
        return mapJSONPointerSlash;
    }

    static {
        boolean $i$f$emptyArray = false;
        root = new JSONPointer(new String[0]);
        mapJSONPointerTilde = new CharMapResult(2, '~');
        mapJSONPointerSlash = new CharMapResult(2, '/');
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000R\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010\u0011\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\n\n\u0002\u0010 \n\u0002\b\u0005\n\u0002\u0010\u0001\n\u0002\b\u000b\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J+\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u00042\f\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\u00040\u00102\u0006\u0010\u0011\u001a\u00020\rH\u0002\u00a2\u0006\u0002\u0010\u0012J\u0015\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u000e\u001a\u00020\u0004H\u0000\u00a2\u0006\u0002\b\u0015J#\u0010\u0016\u001a\u00020\u00142\f\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\u00040\u00102\b\u0010\u0017\u001a\u0004\u0018\u00010\u0018\u00a2\u0006\u0002\u0010\u0019J\u0018\u0010\u0016\u001a\u00020\u00142\u0006\u0010\u001a\u001a\u00020\u00042\b\u0010\u0017\u001a\u0004\u0018\u00010\u0018J%\u0010\u001b\u001a\u0004\u0018\u00010\u00182\f\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\u00040\u00102\b\u0010\u0017\u001a\u0004\u0018\u00010\u0018\u00a2\u0006\u0002\u0010\u001cJ\u001a\u0010\u001b\u001a\u0004\u0018\u00010\u00182\u0006\u0010\u001d\u001a\u00020\u00042\b\u0010\u0017\u001a\u0004\u0018\u00010\u0018J%\u0010\u001e\u001a\u0004\u0018\u00010\u00182\f\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\u00040\u00102\b\u0010\u0017\u001a\u0004\u0018\u00010\u0018\u00a2\u0006\u0002\u0010\u001cJ\u001a\u0010\u001e\u001a\u0004\u0018\u00010\u00182\u0006\u0010\u001d\u001a\u00020\u00042\b\u0010\u0017\u001a\u0004\u0018\u00010\u0018J\u0019\u0010\u001f\u001a\u00020\t2\f\u0010 \u001a\b\u0012\u0004\u0012\u00020\u00040\u0010\u00a2\u0006\u0002\u0010!J\u0014\u0010\u001f\u001a\u00020\t2\f\u0010\"\u001a\b\u0012\u0004\u0012\u00020\u00040#J\u000e\u0010$\u001a\u00020\t2\u0006\u0010%\u001a\u00020\u0004J\u0019\u0010&\u001a\b\u0012\u0004\u0012\u00020\u00040\u00102\u0006\u0010\u001a\u001a\u00020\u0004\u00a2\u0006\u0002\u0010'J-\u0010(\u001a\u00020)2\u0006\u0010*\u001a\u00020\u00042\f\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\u00040\u00102\u0006\u0010\u0011\u001a\u00020\rH\u0000\u00a2\u0006\u0004\b+\u0010,J\u001d\u0010(\u001a\u00020)2\u0006\u0010*\u001a\u00020\u00042\u0006\u0010\u001d\u001a\u00020\u0004H\u0000\u00a2\u0006\u0002\b+J\r\u0010-\u001a\u00020)H\u0000\u00a2\u0006\u0002\b.J!\u0010/\u001a\u00020\u00042\f\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\u00040\u00102\u0006\u00100\u001a\u00020\r\u00a2\u0006\u0002\u00101J\n\u00102\u001a\u00020\u0004*\u00020\u0004J\n\u00103\u001a\u00020\u0004*\u00020\u0004R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\b\u001a\u00020\t\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000b\u00a8\u00064"}, d2={"Lio/kjson/pointer/JSONPointer$Companion;", "", "()V", "emptyString", "", "mapJSONPointerSlash", "Lnet/pwall/text/CharMapResult;", "mapJSONPointerTilde", "root", "Lio/kjson/pointer/JSONPointer;", "getRoot", "()Lio/kjson/pointer/JSONPointer;", "checkIndex", "", "token", "tokens", "", "tokenIndex", "(Ljava/lang/String;[Ljava/lang/String;I)I", "checkNumber", "", "checkNumber$kjson_pointer", "existsIn", "base", "Lio/kjson/JSONValue;", "([Ljava/lang/String;Lio/kjson/JSONValue;)Z", "string", "find", "([Ljava/lang/String;Lio/kjson/JSONValue;)Lio/kjson/JSONValue;", "pointer", "findOrNull", "from", "array", "([Ljava/lang/String;)Lio/kjson/pointer/JSONPointer;", "list", "", "fromURIFragment", "fragment", "parseString", "(Ljava/lang/String;)[Ljava/lang/String;", "pointerError", "", "mainText", "pointerError$kjson_pointer", "(Ljava/lang/String;[Ljava/lang/String;I)Ljava/lang/Void;", "rootParentError", "rootParentError$kjson_pointer", "toString", "n", "([Ljava/lang/String;I)Ljava/lang/String;", "decodeJSONPointer", "encodeJSONPointer", "kjson-pointer"})
    @SourceDebugExtension(value={"SMAP\nJSONPointer.kt\nKotlin\n*S Kotlin\n*F\n+ 1 JSONPointer.kt\nio/kjson/pointer/JSONPointer$Companion\n+ 2 ArraysJVM.kt\nkotlin/collections/ArraysKt__ArraysJVMKt\n+ 3 ArrayIntrinsics.kt\nkotlin/ArrayIntrinsicsKt\n+ 4 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,411:1\n37#2,2:412\n37#2,2:419\n26#3:414\n1549#4:415\n1620#4,3:416\n*S KotlinDebug\n*F\n+ 1 JSONPointer.kt\nio/kjson/pointer/JSONPointer$Companion\n*L\n197#1:412,2\n350#1:419,2\n340#1:414\n343#1:415\n343#1:416,3\n*E\n"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final JSONPointer getRoot() {
            return root;
        }

        @NotNull
        public final JSONPointer from(@NotNull String[] array) {
            JSONPointer jSONPointer;
            Intrinsics.checkNotNullParameter((Object)array, (String)"array");
            if (array.length == 0) {
                jSONPointer = this.getRoot();
            } else {
                String[] stringArray = Arrays.copyOf(array, array.length);
                Intrinsics.checkNotNullExpressionValue((Object)stringArray, (String)"copyOf(this, size)");
                jSONPointer = new JSONPointer(stringArray);
            }
            return jSONPointer;
        }

        @NotNull
        public final JSONPointer from(@NotNull List<String> list) {
            JSONPointer jSONPointer;
            Intrinsics.checkNotNullParameter(list, (String)"list");
            if (list.isEmpty()) {
                jSONPointer = this.getRoot();
            } else {
                Collection $this$toTypedArray$iv = list;
                boolean $i$f$toTypedArray = false;
                Collection thisCollection$iv = $this$toTypedArray$iv;
                JSONPointer jSONPointer2 = new JSONPointer(thisCollection$iv.toArray(new String[0]));
                jSONPointer = jSONPointer2;
            }
            return jSONPointer;
        }

        @Nullable
        public final JSONValue find(@NotNull String pointer, @Nullable JSONValue base) {
            Intrinsics.checkNotNullParameter((Object)pointer, (String)"pointer");
            return this.find(this.parseString(pointer), base);
        }

        @Nullable
        public final JSONValue find(@NotNull String[] tokens, @Nullable JSONValue base) {
            Intrinsics.checkNotNullParameter((Object)tokens, (String)"tokens");
            JSONValue result = base;
            int n = tokens.length;
            for (int i = 0; i < n; ++i) {
                JSONValue jSONValue;
                String token = tokens[i];
                JSONValue jSONValue2 = result;
                if (jSONValue2 instanceof JSONObject) {
                    if (!((JSONObject)result).containsKey((Object)token)) {
                        this.pointerError$kjson_pointer("Can't resolve JSON Pointer", tokens, i + 1);
                        throw new KotlinNothingValueException();
                    }
                    jSONValue = (JSONValue)((JSONObject)result).get((Object)token);
                } else if (jSONValue2 instanceof JSONArray) {
                    if (Intrinsics.areEqual((Object)token, (Object)"-")) {
                        this.pointerError$kjson_pointer("Can't dereference end-of-array JSON Pointer", tokens, i + 1);
                        throw new KotlinNothingValueException();
                    }
                    int index = this.checkIndex(token, tokens, i + 1);
                    if (index < 0 || index >= ((JSONArray)result).size()) {
                        this.pointerError$kjson_pointer("Array index out of range in JSON Pointer", tokens, i + 1);
                        throw new KotlinNothingValueException();
                    }
                    jSONValue = ((JSONArray)result).get(index);
                } else {
                    this.pointerError$kjson_pointer("Can't resolve JSON Pointer", tokens, i + 1);
                    throw new KotlinNothingValueException();
                }
                result = jSONValue;
            }
            return result;
        }

        @Nullable
        public final JSONValue findOrNull(@NotNull String pointer, @Nullable JSONValue base) {
            Intrinsics.checkNotNullParameter((Object)pointer, (String)"pointer");
            return this.findOrNull(this.parseString(pointer), base);
        }

        @Nullable
        public final JSONValue findOrNull(@NotNull String[] tokens, @Nullable JSONValue base) {
            Intrinsics.checkNotNullParameter((Object)tokens, (String)"tokens");
            JSONValue result = base;
            for (String token : tokens) {
                JSONValue jSONValue;
                JSONValue jSONValue2 = result;
                if (jSONValue2 instanceof JSONObject) {
                    if (!((JSONObject)result).containsKey((Object)token)) {
                        return null;
                    }
                    jSONValue = (JSONValue)((JSONObject)result).get((Object)token);
                } else if (jSONValue2 instanceof JSONArray) {
                    if (!this.checkNumber$kjson_pointer(token)) {
                        return null;
                    }
                    int index = Integer.parseInt(token);
                    if (index < 0 || index >= ((JSONArray)result).size()) {
                        return null;
                    }
                    jSONValue = ((JSONArray)result).get(index);
                } else {
                    return null;
                }
                result = jSONValue;
            }
            return result;
        }

        public final boolean existsIn(@NotNull String string, @Nullable JSONValue base) {
            Intrinsics.checkNotNullParameter((Object)string, (String)"string");
            return this.existsIn(this.parseString(string), base);
        }

        public final boolean existsIn(@NotNull String[] tokens, @Nullable JSONValue base) {
            Intrinsics.checkNotNullParameter((Object)tokens, (String)"tokens");
            JSONValue jSONValue = base;
            if (jSONValue == null) {
                return false;
            }
            JSONValue current = jSONValue;
            for (String token : tokens) {
                JSONValue jSONValue2;
                JSONValue jSONValue3 = current;
                if (jSONValue3 instanceof JSONObject) {
                    if (!((JSONObject)current).containsKey((Object)token)) {
                        return false;
                    }
                    jSONValue2 = (JSONValue)((JSONObject)current).get((Object)token);
                } else if (jSONValue3 instanceof JSONArray) {
                    if (!this.checkNumber$kjson_pointer(token)) {
                        return false;
                    }
                    int index = Integer.parseInt(token);
                    if (index < 0 || index >= ((JSONArray)current).size()) {
                        return false;
                    }
                    jSONValue2 = ((JSONArray)current).get(index);
                } else {
                    return false;
                }
                current = jSONValue2;
            }
            return true;
        }

        private final int checkIndex(String token, String[] tokens, int tokenIndex) {
            if (!this.checkNumber$kjson_pointer(token)) {
                this.pointerError$kjson_pointer("Illegal array index in JSON Pointer", tokens, tokenIndex);
                throw new KotlinNothingValueException();
            }
            return Integer.parseInt(token);
        }

        public final boolean checkNumber$kjson_pointer(@NotNull String token) {
            Intrinsics.checkNotNullParameter((Object)token, (String)"token");
            int len = token.length();
            if (len < 1 || len > 8) {
                return false;
            }
            char ch = token.charAt(0);
            if (ch == '0') {
                return len == 1;
            }
            int i = 1;
            while ('0' <= ch ? ch < ':' : false) {
                if (i >= len) {
                    return true;
                }
                ch = token.charAt(i++);
            }
            return false;
        }

        @NotNull
        public final String toString(@NotNull String[] tokens, int n) {
            StringBuilder stringBuilder;
            Intrinsics.checkNotNullParameter((Object)tokens, (String)"tokens");
            if (n == 0) {
                return JSONPointer.emptyString;
            }
            StringBuilder $this$toString_u24lambda_u240 = stringBuilder = new StringBuilder();
            boolean bl = false;
            for (int i = 0; i < n; ++i) {
                $this$toString_u24lambda_u240.append('/');
                $this$toString_u24lambda_u240.append(Companion.encodeJSONPointer(tokens[i]));
            }
            String string = stringBuilder.toString();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"StringBuilder().apply(builderAction).toString()");
            return string;
        }

        /*
         * WARNING - void declaration
         */
        @NotNull
        public final String[] parseString(@NotNull String string) {
            void $this$mapTo$iv$iv;
            Intrinsics.checkNotNullParameter((Object)string, (String)"string");
            if (((CharSequence)string).length() == 0) {
                boolean $i$f$emptyArray = false;
                return new String[0];
            }
            if (string.charAt(0) != '/') {
                this.pointerError$kjson_pointer("Illegal JSON Pointer", string);
                throw new KotlinNothingValueException();
            }
            String string2 = string.substring(1);
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"this as java.lang.String).substring(startIndex)");
            char[] $i$f$emptyArray = new char[]{'/'};
            Iterable $this$map$iv = StringsKt.split$default((CharSequence)string2, (char[])$i$f$emptyArray, (boolean)false, (int)0, (int)6, null);
            boolean $i$f$map = false;
            Iterable iterable = $this$map$iv;
            Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                String string3;
                void it;
                String string4 = (String)item$iv$iv;
                Collection collection = destination$iv$iv;
                boolean bl = false;
                try {
                    string3 = Companion.decodeJSONPointer((String)it);
                }
                catch (Exception e) {
                    Companion.pointerError$kjson_pointer("Illegal token in JSON Pointer", (String)it);
                    throw new KotlinNothingValueException();
                }
                collection.add(string3);
            }
            Collection $this$toTypedArray$iv = (List)destination$iv$iv;
            boolean $i$f$toTypedArray = false;
            Collection thisCollection$iv = $this$toTypedArray$iv;
            return thisCollection$iv.toArray(new String[0]);
        }

        @NotNull
        public final JSONPointer fromURIFragment(@NotNull String fragment) {
            String string;
            Intrinsics.checkNotNullParameter((Object)fragment, (String)"fragment");
            try {
                string = UTF8StringMapper.INSTANCE.decodeUTF8(URIStringMapper.INSTANCE.decodeURI(fragment));
            }
            catch (Exception e) {
                this.pointerError$kjson_pointer("Illegal URI fragment", fragment);
                throw new KotlinNothingValueException();
            }
            String pointer = string;
            return new JSONPointer(pointer);
        }

        @NotNull
        public final Void pointerError$kjson_pointer(@NotNull String mainText, @NotNull String[] tokens, int tokenIndex) {
            Intrinsics.checkNotNullParameter((Object)mainText, (String)"mainText");
            Intrinsics.checkNotNullParameter((Object)tokens, (String)"tokens");
            this.pointerError$kjson_pointer(mainText, this.toString(tokens, tokenIndex));
            throw new KotlinNothingValueException();
        }

        @NotNull
        public final Void pointerError$kjson_pointer(@NotNull String mainText, @NotNull String pointer) {
            Intrinsics.checkNotNullParameter((Object)mainText, (String)"mainText");
            Intrinsics.checkNotNullParameter((Object)pointer, (String)"pointer");
            throw new JSONPointerException(((CharSequence)pointer).length() == 0 ? mainText : mainText + " - \"" + pointer + '\"');
        }

        @NotNull
        public final Void rootParentError$kjson_pointer() {
            throw new JSONPointerException("Can't get parent of root JSON Pointer");
        }

        @NotNull
        public final String encodeJSONPointer(@NotNull String $this$encodeJSONPointer) {
            Intrinsics.checkNotNullParameter((Object)$this$encodeJSONPointer, (String)"<this>");
            return StringMapper.INSTANCE.mapCharacters($this$encodeJSONPointer, (Function1)encodeJSONPointer.1.INSTANCE);
        }

        @NotNull
        public final String decodeJSONPointer(@NotNull String $this$decodeJSONPointer) {
            Intrinsics.checkNotNullParameter((Object)$this$decodeJSONPointer, (String)"<this>");
            return StringMapper.INSTANCE.mapSubstrings($this$decodeJSONPointer, (Function1)new Function1<Integer, MapResult>($this$decodeJSONPointer){
                final /* synthetic */ String $this_decodeJSONPointer;
                {
                    this.$this_decodeJSONPointer = $receiver;
                    super(1);
                }

                @Nullable
                public final MapResult invoke(int index) {
                    MapResult mapResult;
                    if (this.$this_decodeJSONPointer.charAt(index) == '~') {
                        CharMapResult charMapResult;
                        StringMapper.checkLength$default((StringMapper)StringMapper.INSTANCE, (String)this.$this_decodeJSONPointer, (int)index, (int)2, null, (int)8, null);
                        char c = this.$this_decodeJSONPointer.charAt(index + 1);
                        if (c == '0') {
                            charMapResult = JSONPointer.access$getMapJSONPointerTilde$cp();
                        } else if (c == '1') {
                            charMapResult = JSONPointer.access$getMapJSONPointerSlash$cp();
                        } else {
                            throw new IllegalArgumentException("Invalid escape sequence");
                        }
                        mapResult = (MapResult)charMapResult;
                    } else {
                        mapResult = null;
                    }
                    return mapResult;
                }
            });
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

