/*
 * Decompiled with CFR 0.152.
 */
package io.kjson.parser;

import io.kjson.JSONArray;
import io.kjson.JSONBoolean;
import io.kjson.JSONDecimal;
import io.kjson.JSONInt;
import io.kjson.JSONLong;
import io.kjson.JSONNumber;
import io.kjson.JSONObject;
import io.kjson.JSONString;
import io.kjson.JSONValue;
import io.kjson.parser.ParseException;
import io.kjson.parser.ParseOptions;
import io.kjson.parser.ParserConstants;
import java.math.BigDecimal;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import net.pwall.json.JSONFunctions;
import net.pwall.text.TextMatcher;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000J\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0002\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u001a\u0010\u0003\u001a\u0004\u0018\u00010\u00042\u0006\u0010\u0005\u001a\u00020\u00062\b\b\u0002\u0010\u0007\u001a\u00020\bJ*\u0010\u0003\u001a\u0004\u0018\u00010\u00042\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\u000b\u001a\u00020\u00062\u0006\u0010\f\u001a\u00020\rH\u0002J(\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\u000b\u001a\u00020\u00062\u0006\u0010\f\u001a\u00020\rH\u0002J\u0018\u0010\u0010\u001a\u00020\u000f2\u0006\u0010\u0011\u001a\u00020\u00062\b\b\u0002\u0010\u0007\u001a\u00020\bJ\u001a\u0010\u0012\u001a\u0004\u0018\u00010\u00132\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\u0006H\u0002J(\u0010\u0014\u001a\u00020\u00152\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\u000b\u001a\u00020\u00062\u0006\u0010\f\u001a\u00020\rH\u0002J\u0018\u0010\u0016\u001a\u00020\u00062\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\u0006H\u0002J\u0018\u0010\u0017\u001a\u00020\u00182\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\u0006H\u0002J\f\u0010\u0019\u001a\u00020\u0018*\u00020\nH\u0002\u00a8\u0006\u001a"}, d2={"Lio/kjson/parser/Parser;", "", "()V", "parse", "Lio/kjson/JSONValue;", "json", "", "options", "Lio/kjson/parser/ParseOptions;", "tm", "Lnet/pwall/text/TextMatcher;", "pointer", "depth", "", "parseArray", "Lio/kjson/JSONArray;", "parseLines", "jsonLines", "parseNumber", "Lio/kjson/JSONNumber;", "parseObject", "Lio/kjson/JSONObject;", "parseString", "skipExponent", "", "matchIdentifier", "kjson-core"})
public final class Parser {
    @NotNull
    public static final Parser INSTANCE = new Parser();

    private Parser() {
    }

    @Nullable
    public final JSONValue parse(@NotNull String json, @NotNull ParseOptions options) {
        Intrinsics.checkNotNullParameter((Object)json, (String)"json");
        Intrinsics.checkNotNullParameter((Object)options, (String)"options");
        TextMatcher tm = new TextMatcher(json);
        tm.match('\ufeff');
        JSONValue result = this.parse(tm, options, "", 0);
        tm.skip(JSONFunctions::isSpaceCharacter);
        if (!tm.isAtEnd()) {
            throw new ParseException("Excess characters following JSON", null, 2, null);
        }
        return result;
    }

    public static /* synthetic */ JSONValue parse$default(Parser parser, String string, ParseOptions parseOptions, int n, Object object) {
        if ((n & 2) != 0) {
            parseOptions = ParseOptions.Companion.getDEFAULT();
        }
        return parser.parse(string, parseOptions);
    }

    @NotNull
    public final JSONArray parseLines(@NotNull String jsonLines, @NotNull ParseOptions options) {
        Intrinsics.checkNotNullParameter((Object)jsonLines, (String)"jsonLines");
        Intrinsics.checkNotNullParameter((Object)options, (String)"options");
        TextMatcher tm = new TextMatcher(jsonLines);
        tm.match('\ufeff');
        return JSONArray.Companion.build((Function1<? super JSONArray.Builder, Unit>)((Function1)new Function1<JSONArray.Builder, Unit>(tm, options){
            final /* synthetic */ TextMatcher $tm;
            final /* synthetic */ ParseOptions $options;
            {
                this.$tm = $tm;
                this.$options = $options;
                super(1);
            }

            public final void invoke(@NotNull JSONArray.Builder $this$build) {
                Intrinsics.checkNotNullParameter((Object)$this$build, (String)"$this$build");
                this.$tm.skip(JSONFunctions::isSpaceCharacter);
                int counter = 0;
                while (!this.$tm.isAtEnd()) {
                    $this$build.add(Parser.access$parse(Parser.INSTANCE, this.$tm, this.$options, "" + '/' + counter++, 0));
                    this.$tm.skip(JSONFunctions::isSpaceCharacter);
                }
            }
        }));
    }

    public static /* synthetic */ JSONArray parseLines$default(Parser parser, String string, ParseOptions parseOptions, int n, Object object) {
        if ((n & 2) != 0) {
            parseOptions = ParseOptions.Companion.getDEFAULT();
        }
        return parser.parseLines(string, parseOptions);
    }

    private final JSONValue parse(TextMatcher tm, ParseOptions options, String pointer, int depth) {
        if (depth > options.getMaximumNestingDepth()) {
            throw new ParseException("Maximum nesting depth exceeded", null, 2, null);
        }
        tm.skip(JSONFunctions::isSpaceCharacter);
        if (tm.match('{')) {
            return this.parseObject(tm, options, pointer, depth);
        }
        if (tm.match('[')) {
            return this.parseArray(tm, options, pointer, depth);
        }
        if (tm.match('\"')) {
            return new JSONString(this.parseString(tm, pointer));
        }
        if (tm.match((CharSequence)"true")) {
            return JSONBoolean.TRUE;
        }
        if (tm.match((CharSequence)"false")) {
            return JSONBoolean.FALSE;
        }
        if (tm.match((CharSequence)"null")) {
            return null;
        }
        JSONNumber jSONNumber = this.parseNumber(tm, pointer);
        if (jSONNumber == null) {
            throw new ParseException("Illegal JSON syntax", pointer);
        }
        return jSONNumber;
    }

    private final JSONObject parseObject(TextMatcher tm, ParseOptions options, String pointer, int depth) {
        return JSONObject.Companion.build$default(JSONObject.Companion, 0, options.getObjectKeyDuplicate(), pointer, (Function1)new Function1<JSONObject.Builder, Unit>(tm, pointer, options, depth){
            final /* synthetic */ TextMatcher $tm;
            final /* synthetic */ String $pointer;
            final /* synthetic */ ParseOptions $options;
            final /* synthetic */ int $depth;
            {
                this.$tm = $tm;
                this.$pointer = $pointer;
                this.$options = $options;
                this.$depth = $depth;
                super(1);
            }

            public final void invoke(@NotNull JSONObject.Builder $this$build) {
                Intrinsics.checkNotNullParameter((Object)$this$build, (String)"$this$build");
                this.$tm.skip(JSONFunctions::isSpaceCharacter);
                if (!this.$tm.match('}')) {
                    block8: {
                        do {
                            String string;
                            if (this.$tm.match('\"')) {
                                string = Parser.access$parseString(Parser.INSTANCE, this.$tm, this.$pointer);
                            } else if (this.$options.getObjectKeyUnquoted() && Parser.access$matchIdentifier(Parser.INSTANCE, this.$tm)) {
                                string = this.$tm.getResult();
                            } else {
                                throw new ParseException("Illegal key in JSON object", this.$pointer);
                            }
                            String key = string;
                            this.$tm.skip(JSONFunctions::isSpaceCharacter);
                            if (!this.$tm.match(':')) {
                                throw new ParseException("Missing colon in JSON object", this.$pointer);
                            }
                            Intrinsics.checkNotNull((Object)key);
                            $this$build.add(key, Parser.access$parse(Parser.INSTANCE, this.$tm, this.$options, this.$pointer + '/' + key, this.$depth + 1));
                            this.$tm.skip(JSONFunctions::isSpaceCharacter);
                            if (!this.$tm.match(',')) break block8;
                            this.$tm.skip(JSONFunctions::isSpaceCharacter);
                        } while (!this.$options.getObjectTrailingComma() || !this.$tm.match('}'));
                        return;
                    }
                    if (!this.$tm.match('}')) {
                        throw new ParseException("Missing closing brace in JSON object", this.$pointer);
                    }
                }
            }
        }, 1, null);
    }

    private final JSONArray parseArray(TextMatcher tm, ParseOptions options, String pointer, int depth) {
        return JSONArray.Companion.build((Function1<? super JSONArray.Builder, Unit>)((Function1)new Function1<JSONArray.Builder, Unit>(tm, options, pointer, depth){
            final /* synthetic */ TextMatcher $tm;
            final /* synthetic */ ParseOptions $options;
            final /* synthetic */ String $pointer;
            final /* synthetic */ int $depth;
            {
                this.$tm = $tm;
                this.$options = $options;
                this.$pointer = $pointer;
                this.$depth = $depth;
                super(1);
            }

            public final void invoke(@NotNull JSONArray.Builder $this$build) {
                Intrinsics.checkNotNullParameter((Object)$this$build, (String)"$this$build");
                this.$tm.skip(JSONFunctions::isSpaceCharacter);
                if (!this.$tm.match(']')) {
                    block3: {
                        do {
                            $this$build.add(Parser.access$parse(Parser.INSTANCE, this.$tm, this.$options, this.$pointer + '/' + $this$build.getSize(), this.$depth + 1));
                            this.$tm.skip(JSONFunctions::isSpaceCharacter);
                            if (!this.$tm.match(',')) break block3;
                            this.$tm.skip(JSONFunctions::isSpaceCharacter);
                        } while (!this.$options.getArrayTrailingComma() || !this.$tm.match(']'));
                        return;
                    }
                    if (!this.$tm.match(']')) {
                        throw new ParseException("Missing closing bracket in JSON array", this.$pointer);
                    }
                }
            }
        }));
    }

    private final String parseString(TextMatcher tm, String pointer) {
        String string;
        try {
            string = JSONFunctions.parseString((TextMatcher)tm);
            Intrinsics.checkNotNull((Object)string);
        }
        catch (IllegalArgumentException iae) {
            String string2 = iae.getMessage();
            if (string2 == null) {
                string2 = "Error parsing JSON string";
            }
            throw new ParseException(string2, pointer);
        }
        return string;
    }

    private final JSONNumber parseNumber(TextMatcher tm, String pointer) {
        int numberStart = tm.getIndex();
        boolean negative = tm.match('-');
        if (tm.matchDec()) {
            int integerLength = tm.getResultLength();
            if (integerLength > 1 && tm.getResultChar() == '0') {
                throw new ParseException("Illegal JSON number", pointer);
            }
            if (tm.match('.')) {
                if (!tm.matchDec()) {
                    throw new ParseException("Illegal JSON number", pointer);
                }
                this.skipExponent(tm, pointer);
            } else if (!this.skipExponent(tm, pointer)) {
                if (integerLength < 10) {
                    return JSONInt.Companion.of(tm.getResultInt(negative));
                }
                try {
                    long result = tm.getResultLong(negative);
                    return result >= Integer.MIN_VALUE && result <= Integer.MAX_VALUE ? (JSONNumber)JSONInt.Companion.of((int)result) : (JSONNumber)JSONLong.Companion.of(result);
                }
                catch (NumberFormatException numberFormatException) {
                    // empty catch block
                }
            }
            String string = tm.getString(numberStart, tm.getIndex());
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getString(...)");
            String string2 = string;
            return JSONDecimal.Companion.of(new BigDecimal(string2));
        }
        return null;
    }

    private final boolean skipExponent(TextMatcher tm, String pointer) {
        boolean bl;
        if (tm.match(Parser::skipExponent$lambda$0)) {
            tm.match(Parser::skipExponent$lambda$1);
            if (!tm.matchDec()) {
                throw new ParseException("Illegal JSON number", pointer);
            }
            bl = true;
        } else {
            bl = false;
        }
        return bl;
    }

    private final boolean matchIdentifier(TextMatcher $this$matchIdentifier) {
        return $this$matchIdentifier.match(Parser::matchIdentifier$lambda$2) && $this$matchIdentifier.matchContinue(Parser::matchIdentifier$lambda$3);
    }

    private static final boolean skipExponent$lambda$0(char it) {
        return it == 'e' || it == 'E';
    }

    private static final boolean skipExponent$lambda$1(char it) {
        return it == '-' || it == '+';
    }

    private static final boolean matchIdentifier$lambda$2(char it) {
        return ParserConstants.INSTANCE.getIdentifierStartSet().contains(Character.valueOf(it));
    }

    private static final boolean matchIdentifier$lambda$3(char it) {
        return ParserConstants.INSTANCE.getIdentifierContinuationSet().contains(Character.valueOf(it));
    }

    public static final /* synthetic */ JSONValue access$parse(Parser $this, TextMatcher tm, ParseOptions options, String pointer, int depth) {
        return $this.parse(tm, options, pointer, depth);
    }

    public static final /* synthetic */ String access$parseString(Parser $this, TextMatcher tm, String pointer) {
        return $this.parseString(tm, pointer);
    }

    public static final /* synthetic */ boolean access$matchIdentifier(Parser $this, TextMatcher $receiver) {
        return $this.matchIdentifier($receiver);
    }
}

