/*
 * Decompiled with CFR 0.152.
 */
package io.kjson;

import io.kjson.JSONInt;
import io.kjson.JSONLong;
import io.kjson.JSONValue;
import java.math.BigDecimal;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000h\n\u0002\u0018\u0002\n\u0002\u0010\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u0005\n\u0000\n\u0002\u0010\f\n\u0000\n\u0002\u0010\u0006\n\u0000\n\u0002\u0010\u0007\n\u0002\b\u0003\n\u0002\u0010\t\n\u0000\n\u0002\u0010\n\n\u0002\b\u0003\u0018\u0000 %2\u00020\u00012\u00020\u0002:\u0001%B\u000f\b\u0016\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\u0002\u0010\u0005B\r\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\bJ\u0014\u0010\u000b\u001a\u00020\f2\n\u0010\r\u001a\u00060\u000ej\u0002`\u000fH\u0016J\u0013\u0010\u0010\u001a\u00020\u00112\b\u0010\u0012\u001a\u0004\u0018\u00010\u0013H\u0096\u0002J\b\u0010\u0014\u001a\u00020\u0015H\u0016J\b\u0010\u0016\u001a\u00020\u0017H\u0016J\b\u0010\u0018\u001a\u00020\u0019H\u0016J\b\u0010\u001a\u001a\u00020\u001bH\u0016J\b\u0010\u001c\u001a\u00020\u001dH\u0016J\b\u0010\u001e\u001a\u00020\u0015H\u0016J\b\u0010\u001f\u001a\u00020\u0004H\u0016J\b\u0010 \u001a\u00020!H\u0016J\b\u0010\"\u001a\u00020#H\u0016J\b\u0010$\u001a\u00020\u0004H\u0016R\u0011\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\n\u00a8\u0006&"}, d2={"Lio/kjson/JSONDecimal;", "", "Lio/kjson/JSONValue;", "str", "", "(Ljava/lang/String;)V", "value", "Ljava/math/BigDecimal;", "(Ljava/math/BigDecimal;)V", "getValue", "()Ljava/math/BigDecimal;", "appendTo", "", "a", "Ljava/lang/Appendable;", "Lkotlin/text/Appendable;", "equals", "", "other", "", "hashCode", "", "toByte", "", "toChar", "", "toDouble", "", "toFloat", "", "toInt", "toJSON", "toLong", "", "toShort", "", "toString", "Companion", "kjson-core"})
public final class JSONDecimal
extends Number
implements JSONValue {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final BigDecimal value;
    @NotNull
    private static final JSONDecimal ZERO;

    public JSONDecimal(@NotNull BigDecimal value) {
        Intrinsics.checkNotNullParameter((Object)value, (String)"value");
        this.value = value;
    }

    @NotNull
    public final BigDecimal getValue() {
        return this.value;
    }

    public JSONDecimal(@NotNull String str) {
        Intrinsics.checkNotNullParameter((Object)str, (String)"str");
        this(new BigDecimal(str));
    }

    @Override
    @NotNull
    public String toJSON() {
        String string = this.value.toString();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"value.toString()");
        return string;
    }

    @Override
    public void appendTo(@NotNull Appendable a) {
        Intrinsics.checkNotNullParameter((Object)a, (String)"a");
        a.append(this.value.toString());
    }

    public double toDouble() {
        return this.value.doubleValue();
    }

    public float toFloat() {
        return this.value.floatValue();
    }

    public long toLong() {
        return this.value.longValue();
    }

    public int toInt() {
        return this.value.intValue();
    }

    public char toChar() {
        return this.value.toChar();
    }

    public short toShort() {
        return this.value.shortValue();
    }

    public byte toByte() {
        return this.value.byteValue();
    }

    public boolean equals(@Nullable Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof JSONValue)) {
            return false;
        }
        JSONValue jSONValue = (JSONValue)other;
        return jSONValue instanceof JSONInt ? this.value.compareTo(new BigDecimal(((JSONInt)other).getValue())) == 0 : (jSONValue instanceof JSONLong ? this.value.compareTo(new BigDecimal(((JSONLong)other).getValue())) == 0 : (jSONValue instanceof JSONDecimal ? this.value.compareTo(((JSONDecimal)other).value) == 0 : false));
    }

    public int hashCode() {
        return this.value.intValue();
    }

    @NotNull
    public String toString() {
        return this.toJSON();
    }

    static {
        BigDecimal bigDecimal = BigDecimal.ZERO;
        Intrinsics.checkNotNullExpressionValue((Object)bigDecimal, (String)"ZERO");
        ZERO = new JSONDecimal(bigDecimal);
    }

    @Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u000e\u0010\u0007\u001a\u00020\u00042\u0006\u0010\b\u001a\u00020\tR\u0011\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006\u00a8\u0006\n"}, d2={"Lio/kjson/JSONDecimal$Companion;", "", "()V", "ZERO", "Lio/kjson/JSONDecimal;", "getZERO", "()Lio/kjson/JSONDecimal;", "of", "d", "Ljava/math/BigDecimal;", "kjson-core"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final JSONDecimal getZERO() {
            return ZERO;
        }

        @NotNull
        public final JSONDecimal of(@NotNull BigDecimal d) {
            Intrinsics.checkNotNullParameter((Object)d, (String)"d");
            return Intrinsics.areEqual((Object)d, (Object)BigDecimal.ZERO) ? this.getZERO() : new JSONDecimal(d);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

