/*
 * Decompiled with CFR 0.152.
 */
package io.jstuff.log;

import io.jstuff.log.AbstractLogger;
import io.jstuff.log.Level;
import io.jstuff.log.LogListener;
import io.jstuff.log.Slf4jProxyInterface;
import java.lang.reflect.InvocationTargetException;
import java.time.Clock;
import java.util.function.Supplier;

public class Slf4jLogger
extends AbstractLogger {
    private final Slf4jProxyInterface slf4jProxy;
    private final Object slf4jLogger;

    Slf4jLogger(String name, Level level, Clock clock, Slf4jProxyInterface slf4jProxy) throws InvocationTargetException, IllegalAccessException {
        super(name, level, clock);
        this.slf4jProxy = slf4jProxy;
        this.slf4jLogger = slf4jProxy.getLogger(name);
    }

    public boolean isTraceEnabled() {
        return super.isTraceEnabled() && this.slf4jProxy.isTraceEnabled(this.slf4jLogger);
    }

    public boolean isDebugEnabled() {
        return super.isDebugEnabled() && this.slf4jProxy.isDebugEnabled(this.slf4jLogger);
    }

    public boolean isInfoEnabled() {
        return super.isInfoEnabled() && this.slf4jProxy.isInfoEnabled(this.slf4jLogger);
    }

    public boolean isWarnEnabled() {
        return super.isWarnEnabled() && this.slf4jProxy.isWarnEnabled(this.slf4jLogger);
    }

    public boolean isErrorEnabled() {
        return super.isErrorEnabled() && this.slf4jProxy.isErrorEnabled(this.slf4jLogger);
    }

    public boolean isEnabled(Level level) {
        return super.isEnabled(level) && this.slf4jProxy.isEnabled(this.slf4jLogger, level);
    }

    public void trace(Object message) {
        if (this.isTraceEnabled()) {
            if (LogListener.present()) {
                LogListener.invokeAll(this.getClock().millis(), this, Level.TRACE, message, null);
            }
            Slf4jLogger.outputMultiLine(String.valueOf(message), s -> this.slf4jProxy.trace(this.slf4jLogger, (String)s));
        }
    }

    public void debug(Object message) {
        if (this.isDebugEnabled()) {
            if (LogListener.present()) {
                LogListener.invokeAll(this.getClock().millis(), this, Level.DEBUG, message, null);
            }
            Slf4jLogger.outputMultiLine(String.valueOf(message), s -> this.slf4jProxy.debug(this.slf4jLogger, (String)s));
        }
    }

    public void info(Object message) {
        if (this.isInfoEnabled()) {
            if (LogListener.present()) {
                LogListener.invokeAll(this.getClock().millis(), this, Level.INFO, message, null);
            }
            Slf4jLogger.outputMultiLine(String.valueOf(message), s -> this.slf4jProxy.info(this.slf4jLogger, (String)s));
        }
    }

    public void warn(Object message) {
        if (this.isWarnEnabled()) {
            if (LogListener.present()) {
                LogListener.invokeAll(this.getClock().millis(), this, Level.WARN, message, null);
            }
            Slf4jLogger.outputMultiLine(String.valueOf(message), s -> this.slf4jProxy.warn(this.slf4jLogger, (String)s));
        }
    }

    public void error(Object message) {
        if (this.isErrorEnabled()) {
            if (LogListener.present()) {
                LogListener.invokeAll(this.getClock().millis(), this, Level.ERROR, message, null);
            }
            Slf4jLogger.outputMultiLine(String.valueOf(message), s -> this.slf4jProxy.error(this.slf4jLogger, (String)s));
        }
    }

    public void error(Throwable throwable, Object message) {
        if (this.isErrorEnabled()) {
            if (LogListener.present()) {
                LogListener.invokeAll(this.getClock().millis(), this, Level.ERROR, message, throwable);
            }
            Slf4jLogger.outputMultiLine(String.valueOf(message), s -> this.slf4jProxy.error(this.slf4jLogger, (String)s, throwable));
        }
    }

    public void log(Level level, Object message) {
        if (this.isEnabled(level)) {
            if (LogListener.present()) {
                LogListener.invokeAll(this.getClock().millis(), this, level, message, null);
            }
            Slf4jLogger.outputMultiLine(String.valueOf(message), s -> this.slf4jProxy.log(this.slf4jLogger, level, (String)s));
        }
    }

    public void log(Level level, Supplier<Object> messageSupplier) {
        if (this.isEnabled(level)) {
            Object message = messageSupplier.get();
            if (LogListener.present()) {
                LogListener.invokeAll(this.getClock().millis(), this, level, message, null);
            }
            Slf4jLogger.outputMultiLine(String.valueOf(message), s -> this.slf4jProxy.log(this.slf4jLogger, level, (String)s));
        }
    }
}

