/*
 * Decompiled with CFR 0.152.
 */
package io.jstuff.log;

import io.jstuff.log.Level;
import io.jstuff.log.Slf4jLoggerException;
import io.jstuff.log.Slf4jProxyInterface;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;

public class GradleProxy
implements Slf4jProxyInterface {
    private final Method getLoggerMethod;
    private final Object debugLevel;
    private final Object infoLevel;
    private final Object lifecycleLevel;
    private final Object warnLevel;
    private final Object errorLevel;
    private final Object[] levels;
    private final Method isEnabledMethod;
    private final Method logMethod;
    private final Method logThrowableMethod;

    public GradleProxy() throws ClassNotFoundException, NoSuchMethodException, InvocationTargetException, IllegalAccessException {
        Class<?> loggerFactoryClass = Class.forName("org.gradle.api.logging.Logging");
        this.getLoggerMethod = loggerFactoryClass.getMethod("getLogger", String.class);
        Class<?> levelClass = Class.forName("org.gradle.api.logging.LogLevel");
        Method valueOfMethod = levelClass.getMethod("valueOf", String.class);
        this.debugLevel = valueOfMethod.invoke(null, "DEBUG");
        this.infoLevel = valueOfMethod.invoke(null, "INFO");
        this.lifecycleLevel = valueOfMethod.invoke(null, "LIFECYCLE");
        this.warnLevel = valueOfMethod.invoke(null, "WARN");
        this.errorLevel = valueOfMethod.invoke(null, "ERROR");
        this.levels = new Object[]{this.debugLevel, this.infoLevel, this.lifecycleLevel, this.warnLevel, this.errorLevel};
        Class<?> loggerClass = Class.forName("org.gradle.api.logging.Logger");
        this.isEnabledMethod = loggerClass.getMethod("isEnabled", levelClass);
        this.logMethod = loggerClass.getMethod("log", levelClass, String.class);
        this.logThrowableMethod = loggerClass.getMethod("log", levelClass, String.class, Throwable.class);
    }

    @Override
    public Object getLogger(String name) throws InvocationTargetException, IllegalAccessException {
        return this.getLoggerMethod.invoke(null, name);
    }

    @Override
    public boolean isTraceEnabled(Object gradleLogger) {
        try {
            return (Boolean)this.isEnabledMethod.invoke(gradleLogger, this.debugLevel);
        }
        catch (IllegalAccessException | InvocationTargetException e) {
            throw new Slf4jLoggerException(e);
        }
    }

    @Override
    public boolean isDebugEnabled(Object gradleLogger) {
        try {
            return (Boolean)this.isEnabledMethod.invoke(gradleLogger, this.infoLevel);
        }
        catch (IllegalAccessException | InvocationTargetException e) {
            throw new Slf4jLoggerException(e);
        }
    }

    @Override
    public boolean isInfoEnabled(Object gradleLogger) {
        try {
            return (Boolean)this.isEnabledMethod.invoke(gradleLogger, this.lifecycleLevel);
        }
        catch (IllegalAccessException | InvocationTargetException e) {
            throw new Slf4jLoggerException(e);
        }
    }

    @Override
    public boolean isWarnEnabled(Object gradleLogger) {
        try {
            return (Boolean)this.isEnabledMethod.invoke(gradleLogger, this.warnLevel);
        }
        catch (IllegalAccessException | InvocationTargetException e) {
            throw new Slf4jLoggerException(e);
        }
    }

    @Override
    public boolean isErrorEnabled(Object gradleLogger) {
        try {
            return (Boolean)this.isEnabledMethod.invoke(gradleLogger, this.warnLevel);
        }
        catch (IllegalAccessException | InvocationTargetException e) {
            throw new Slf4jLoggerException(e);
        }
    }

    @Override
    public boolean isEnabled(Object gradleLogger, Level level) {
        try {
            return (Boolean)this.isEnabledMethod.invoke(gradleLogger, this.levels[level.ordinal()]);
        }
        catch (IllegalAccessException | InvocationTargetException e) {
            throw new Slf4jLoggerException(e);
        }
    }

    @Override
    public void trace(Object gradleLogger, String text) {
        try {
            this.logMethod.invoke(gradleLogger, this.debugLevel, text);
        }
        catch (IllegalAccessException | InvocationTargetException e) {
            throw new Slf4jLoggerException(e);
        }
    }

    @Override
    public void debug(Object gradleLogger, String text) {
        try {
            this.logMethod.invoke(gradleLogger, this.infoLevel, text);
        }
        catch (IllegalAccessException | InvocationTargetException e) {
            throw new Slf4jLoggerException(e);
        }
    }

    @Override
    public void info(Object gradleLogger, String text) {
        try {
            this.logMethod.invoke(gradleLogger, this.lifecycleLevel, text);
        }
        catch (IllegalAccessException | InvocationTargetException e) {
            throw new Slf4jLoggerException(e);
        }
    }

    @Override
    public void warn(Object gradleLogger, String text) {
        try {
            this.logMethod.invoke(gradleLogger, this.warnLevel, text);
        }
        catch (IllegalAccessException | InvocationTargetException e) {
            throw new Slf4jLoggerException(e);
        }
    }

    @Override
    public void error(Object gradleLogger, String text) {
        try {
            this.logMethod.invoke(gradleLogger, this.errorLevel, text);
        }
        catch (IllegalAccessException | InvocationTargetException e) {
            throw new Slf4jLoggerException(e);
        }
    }

    @Override
    public void error(Object gradleLogger, String text, Throwable throwable) {
        try {
            this.logThrowableMethod.invoke(gradleLogger, this.errorLevel, text, throwable);
        }
        catch (IllegalAccessException | InvocationTargetException e) {
            throw new Slf4jLoggerException(e);
        }
    }

    @Override
    public void log(Object gradleLogger, Level level, String text) {
        try {
            this.logMethod.invoke(gradleLogger, this.levels[level.ordinal()], text);
        }
        catch (IllegalAccessException | InvocationTargetException e) {
            throw new Slf4jLoggerException(e);
        }
    }
}

