/*
 * Decompiled with CFR 0.152.
 */
package io.jstuff.log;

import io.jstuff.log.AbstractLogger;
import io.jstuff.log.Level;
import io.jstuff.log.LogAppender;
import io.jstuff.log.LogFormatter;
import io.jstuff.log.LogListener;
import java.time.Clock;
import java.util.function.Supplier;

public class FormattingLogger<F extends LogFormatter, A extends LogAppender<F>>
extends AbstractLogger {
    private final A appender;

    FormattingLogger(String name, A appender, Level level, Clock clock) {
        super(name, level, clock);
        this.appender = appender;
    }

    public A getAppender() {
        return this.appender;
    }

    public F getFormatter() {
        return this.appender.getFormatter();
    }

    public void trace(Object message) {
        this.outputMessage(Level.TRACE, message, null);
    }

    public void debug(Object message) {
        this.outputMessage(Level.DEBUG, message, null);
    }

    public void info(Object message) {
        this.outputMessage(Level.INFO, message, null);
    }

    public void warn(Object message) {
        this.outputMessage(Level.WARN, message, null);
    }

    public void error(Object message) {
        this.outputMessage(Level.ERROR, message, null);
    }

    public void error(Throwable throwable, Object message) {
        this.outputMessage(Level.ERROR, message, throwable);
    }

    public void log(Level level, Object message) {
        this.outputMessage(level, message, null);
    }

    public void log(Level level, Supplier<Object> messageSupplier) {
        if (this.isEnabled(level)) {
            this.outputMessage(level, messageSupplier.get(), null);
        }
    }

    private void outputMessage(Level level, Object message, Throwable throwable) {
        if (level.ordinal() >= this.getLevel().ordinal()) {
            long millis = this.getClock().millis();
            if (LogListener.present()) {
                LogListener.invokeAll(millis, this, level, message, throwable);
            }
            this.appender.output(millis, this, level, message, throwable);
        }
    }
}

