/*
 * Decompiled with CFR 0.152.
 */
package io.joynr.runtime;

import com.google.inject.Provides;
import com.google.inject.name.Named;
import io.joynr.guice.ApplicationModule;
import io.joynr.runtime.JoynrApplication;
import io.joynr.runtime.PropertyLoader;
import java.util.Map;
import java.util.Properties;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JoynrApplicationModule
extends ApplicationModule {
    Logger logger = LoggerFactory.getLogger(JoynrApplicationModule.class);
    static final String PATTERN_STARTS_WITH_JOYNAPP = "^(joynrapp).*$";
    public static final String KEY_JOYNR_APPLICATION_PROPERTIES = "joynr.application.properties";

    @Provides
    @Named(value="joynr.application.properties")
    Properties joynrApplcationProperties() {
        return this.properties;
    }

    public JoynrApplicationModule(Class<? extends JoynrApplication> applicationClass) {
        this(applicationClass.getName(), applicationClass);
    }

    public JoynrApplicationModule(Class<? extends JoynrApplication> applicationClass, Properties properties) {
        this(applicationClass.getName(), applicationClass, properties);
    }

    public JoynrApplicationModule(String appId, Class<? extends JoynrApplication> applicationClass) {
        this(appId, applicationClass, new Properties());
    }

    public JoynrApplicationModule(String appId, Class<? extends JoynrApplication> applicationClass, Properties properties) {
        super(appId, applicationClass, JoynrApplicationModule.combineProperties(properties));
    }

    private static Properties combineProperties(Properties applicationSpecificProperties) {
        if (applicationSpecificProperties == null) {
            applicationSpecificProperties = new Properties();
        }
        applicationSpecificProperties.putAll((Map<?, ?>)PropertyLoader.getPropertiesWithPattern(System.getProperties(), PATTERN_STARTS_WITH_JOYNAPP));
        return applicationSpecificProperties;
    }
}

