/*
 * Decompiled with CFR 0.152.
 */
package io.joynr.messaging.routing;

import com.google.inject.Inject;
import com.google.inject.Singleton;
import com.google.inject.name.Named;
import io.joynr.exceptions.JoynrMessageNotSentException;
import io.joynr.messaging.AbstractMiddlewareMessagingStubFactory;
import io.joynr.messaging.IMessagingStub;
import java.util.Map;
import joynr.system.RoutingTypes.Address;

@Singleton
public class MessagingStubFactory {
    public static final String MIDDLEWARE_MESSAGING_STUB_FACTORIES = "MIDDLEWARE_MESSAGING_STUB_FACTORIES";
    private final Map<Class<? extends Address>, AbstractMiddlewareMessagingStubFactory<? extends IMessagingStub, ? extends Address>> middlewareMessagingStubFactories;

    @Inject
    public MessagingStubFactory(@Named(value="MIDDLEWARE_MESSAGING_STUB_FACTORIES") Map<Class<? extends Address>, AbstractMiddlewareMessagingStubFactory<? extends IMessagingStub, ? extends Address>> middlewareMessagingStubFactories) {
        this.middlewareMessagingStubFactories = middlewareMessagingStubFactories;
    }

    public IMessagingStub create(Address address) {
        AbstractMiddlewareMessagingStubFactory<? extends IMessagingStub, ? extends Address> messagingStubFactory = this.middlewareMessagingStubFactories.get(address.getClass());
        if (messagingStubFactory == null) {
            throw new JoynrMessageNotSentException("Failed to send Request: Address type not supported: " + address.getClass().getName());
        }
        return messagingStubFactory.create((Address)address);
    }
}

