/*
 * Decompiled with CFR 0.152.
 */
package io.joynr.messaging.routing;

import com.google.inject.Inject;
import com.google.inject.name.Named;
import io.joynr.exceptions.JoynrMessageExpiredException;
import io.joynr.exceptions.JoynrMessageNotSentException;
import java.text.MessageFormat;
import joynr.ImmutableMessage;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MessageRouterUtil {
    private static final Logger logger = LoggerFactory.getLogger(MessageRouterUtil.class);
    @Inject
    @Named(value="joynr.messaging.sendmsgretryintervalms")
    private static long sendMsgRetryIntervalMs;
    @Inject(optional=true)
    @Named(value="joynr.messaging.maxDelayWithExponentialBackoffMs")
    private static long maxDelayMs;

    public static boolean isExpired(ImmutableMessage message) {
        if (!message.isTtlAbsolute()) {
            return true;
        }
        return message.getTtlMs() <= System.currentTimeMillis();
    }

    public static long createDelayWithExponentialBackoff(int retries) {
        long millis = sendMsgRetryIntervalMs + (long)((double)((long)(2 ^ retries) * sendMsgRetryIntervalMs) * Math.random());
        if (maxDelayMs >= sendMsgRetryIntervalMs && millis > maxDelayMs) {
            millis = maxDelayMs;
        }
        logger.trace("Created delay of {}ms in retry {}", (Object)millis, (Object)retries);
        return millis;
    }

    public static void checkExpiry(ImmutableMessage message) throws JoynrMessageNotSentException, JoynrMessageExpiredException {
        if (!message.isTtlAbsolute()) {
            throw new JoynrMessageNotSentException("Relative ttl not supported");
        }
        long currentTimeMillis = System.currentTimeMillis();
        if (message.getTtlMs() <= currentTimeMillis) {
            String errorMessage = MessageFormat.format("Received expired message: (now ={0}). Dropping the message {1}", currentTimeMillis, message.getTrackingInfo());
            logger.trace(errorMessage);
            throw new JoynrMessageExpiredException(errorMessage);
        }
    }

    static {
        maxDelayMs = -1L;
    }
}

