/*
 * Decompiled with CFR 0.152.
 */
package io.joynr.messaging.routing;

import com.google.inject.Inject;
import com.google.inject.name.Named;
import io.joynr.messaging.routing.DelayableImmutableMessage;
import java.util.concurrent.DelayQueue;
import java.util.concurrent.TimeUnit;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MessageQueue {
    private static final Logger logger = LoggerFactory.getLogger(MessageQueue.class);
    public static final String PROPERTY_MESSAGE_QUEUE_SHUTDOWN_MAX_TIMEOUT = "io.joynr.messaging.queue.shutdown.timeout";
    private DelayQueue<DelayableImmutableMessage> delayableImmutableMessages;
    private final long shutdownTimeoutMs;

    @Inject
    public MessageQueue(DelayQueue<DelayableImmutableMessage> delayableImmutableMessages, MaxTimeoutHolder maxTimeoutHolder) {
        this.delayableImmutableMessages = delayableImmutableMessages;
        this.shutdownTimeoutMs = maxTimeoutHolder.getTimeout();
    }

    void waitForQueueToDrain() {
        int remainingMessages = this.delayableImmutableMessages.size();
        logger.info("Joynr message queue stopping. Contains {} remaining messages.", (Object)remainingMessages);
        if (remainingMessages > 0) {
            long shutdownStart = System.currentTimeMillis();
            while (System.currentTimeMillis() - shutdownStart < this.shutdownTimeoutMs && this.delayableImmutableMessages.size() != 0) {
                try {
                    Thread.sleep(5L);
                }
                catch (InterruptedException e) {
                    logger.error("Interrupted while waiting for joynr message queue to drain.");
                    Thread.currentThread().interrupt();
                    break;
                }
            }
        }
        if ((remainingMessages = this.delayableImmutableMessages.size()) == 0) {
            logger.info("Joynr message queue successfully emptied.");
        } else {
            logger.info("Joynr message queue still contained {} messages at shutdown.", (Object)remainingMessages);
        }
    }

    public void put(DelayableImmutableMessage delayableImmutableMessage) {
        this.delayableImmutableMessages.put(delayableImmutableMessage);
    }

    public DelayableImmutableMessage poll(long timeout, TimeUnit unit) throws InterruptedException {
        DelayableImmutableMessage message = (DelayableImmutableMessage)this.delayableImmutableMessages.poll(timeout, unit);
        return message;
    }

    public static class MaxTimeoutHolder {
        @Inject(optional=true)
        @Named(value="io.joynr.messaging.queue.shutdown.timeout")
        private Long timeout = 5000L;

        public long getTimeout() {
            return this.timeout;
        }
    }
}

