/*
 * Decompiled with CFR 0.152.
 */
package io.joynr.messaging.routing;

import com.google.inject.Inject;
import com.google.inject.Singleton;
import com.google.inject.name.Named;
import io.joynr.exceptions.JoynrIllegalStateException;
import io.joynr.messaging.routing.MessageRouter;
import io.joynr.runtime.ShutdownListener;
import io.joynr.runtime.ShutdownNotifier;
import java.lang.ref.Reference;
import java.lang.ref.ReferenceQueue;
import java.lang.ref.WeakReference;
import java.util.HashSet;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Singleton
public class GarbageCollectionHandler
implements ShutdownListener {
    private static final Logger logger = LoggerFactory.getLogger(GarbageCollectionHandler.class);
    private final ConcurrentHashMap<WeakReference<Object>, ProxyInformation> proxyMap = new ConcurrentHashMap();
    private final ConcurrentHashMap<String, ProxyInformation> proxyParticipantIdToProxyInformationMap = new ConcurrentHashMap();
    private final ReferenceQueue<Object> garbageCollectedProxiesQueue = new ReferenceQueue();
    private MessageRouter messageRouter;
    private ScheduledFuture<?> cleanupScheduledFuture;
    private ShutdownNotifier shutdownNotifier;

    @Inject
    public GarbageCollectionHandler(MessageRouter messageRouter, ShutdownNotifier shutdownNotifier, @Named(value="io.joynr.messaging.scheduledthreadpool") ScheduledExecutorService scheduler, @Named(value="joynr.messaging.routingtablecleanupintervalms") long routingTableCleanupIntervalMs) {
        this.messageRouter = messageRouter;
        this.shutdownNotifier = shutdownNotifier;
        this.startCleanupThread(scheduler, routingTableCleanupIntervalMs);
        shutdownNotifier.registerForShutdown(this);
    }

    private void startCleanupThread(ScheduledExecutorService scheduler, long cleanupIntervalMs) {
        this.cleanupScheduledFuture = scheduler.scheduleWithFixedDelay(new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                Reference<Object> r;
                ReferenceQueue<Object> referenceQueue = GarbageCollectionHandler.this.garbageCollectedProxiesQueue;
                synchronized (referenceQueue) {
                    r = GarbageCollectionHandler.this.garbageCollectedProxiesQueue.poll();
                }
                while (r != null) {
                    ProxyInformation proxyInformation = GarbageCollectionHandler.this.proxyMap.get(r);
                    logger.debug("Removing garbage collected proxy participantId {}", (Object)proxyInformation.participantId);
                    GarbageCollectionHandler.this.messageRouter.removeNextHop(proxyInformation.participantId);
                    for (String providerParticipantId : proxyInformation.providerParticipantIds) {
                        GarbageCollectionHandler.this.messageRouter.removeNextHop(providerParticipantId);
                    }
                    GarbageCollectionHandler.this.shutdownNotifier.unregister(proxyInformation.shutdownListener);
                    GarbageCollectionHandler.this.proxyMap.remove(r);
                    GarbageCollectionHandler.this.proxyParticipantIdToProxyInformationMap.remove(proxyInformation.participantId);
                    ReferenceQueue<Object> referenceQueue2 = GarbageCollectionHandler.this.garbageCollectedProxiesQueue;
                    synchronized (referenceQueue2) {
                        r = GarbageCollectionHandler.this.garbageCollectedProxiesQueue.poll();
                    }
                }
            }
        }, cleanupIntervalMs, cleanupIntervalMs, TimeUnit.MILLISECONDS);
    }

    @Override
    public void shutdown() {
        if (this.cleanupScheduledFuture != null) {
            this.cleanupScheduledFuture.cancel(false);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void registerProxy(Object proxy, String proxyParticipantId, ShutdownListener shutdownListener) {
        ReferenceQueue<Object> referenceQueue = this.garbageCollectedProxiesQueue;
        synchronized (referenceQueue) {
            ProxyInformation proxyInformation = new ProxyInformation(proxyParticipantId, shutdownListener);
            if (this.proxyParticipantIdToProxyInformationMap.putIfAbsent(proxyParticipantId, proxyInformation) != null) {
                throw new JoynrIllegalStateException("The proxy with " + proxyParticipantId + " has already been registered.");
            }
            logger.debug("registerProxy called for {}", (Object)proxyParticipantId);
            this.proxyMap.put(new WeakReference<Object>(proxy, this.garbageCollectedProxiesQueue), proxyInformation);
        }
    }

    public void registerProxyProviderParticipantIds(String proxyParticipantId, Set<String> providerParticipantIds) {
        if (proxyParticipantId == null || proxyParticipantId.isEmpty()) {
            throw new JoynrIllegalStateException("Proxy participant id is null or has an empty value.Registration of proxy's provider participant ids failed.");
        }
        if (providerParticipantIds == null || providerParticipantIds.isEmpty()) {
            throw new JoynrIllegalStateException("Set of the provider participant ids is null or empty.Registration of proxy's provider participant ids failed.");
        }
        if (providerParticipantIds.contains(null) || providerParticipantIds.contains("")) {
            throw new JoynrIllegalStateException("Set of the provider participant ids has an entry with an empty or null value.Registration of proxy's provider participant ids failed.");
        }
        this.proxyParticipantIdToProxyInformationMap.computeIfPresent(proxyParticipantId, (key, oldVal) -> {
            if (oldVal.providerParticipantIds.isEmpty()) {
                oldVal.providerParticipantIds.addAll(providerParticipantIds);
                return oldVal;
            }
            throw new JoynrIllegalStateException("The proxy with " + proxyParticipantId + " already has registered providers. Registration of proxy's provider participant ids failed.");
        });
    }

    static class ProxyInformation {
        public String participantId;
        public ShutdownListener shutdownListener;
        public final Set<String> providerParticipantIds;

        public ProxyInformation(String participantId, ShutdownListener shutdownListener) {
            this.participantId = participantId;
            this.shutdownListener = shutdownListener;
            this.providerParticipantIds = new HashSet<String>();
        }
    }
}

