/*
 * Decompiled with CFR 0.152.
 */
package io.joynr.messaging.routing;

import com.google.inject.Inject;
import io.joynr.messaging.IMessagingMulticastSubscriber;
import io.joynr.messaging.IMessagingSkeleton;
import io.joynr.messaging.routing.RoutingTable;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Set;
import joynr.ImmutableMessage;
import joynr.Message;
import joynr.system.RoutingTypes.Address;
import joynr.system.RoutingTypes.MqttAddress;
import joynr.system.RoutingTypes.RoutingTypesUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractGlobalMessagingSkeleton
implements IMessagingSkeleton,
IMessagingMulticastSubscriber {
    private static final Set<Message.MessageType> MESSAGE_TYPE_REQUESTS = new HashSet<Message.MessageType>(Arrays.asList(Message.MessageType.VALUE_MESSAGE_TYPE_REQUEST, Message.MessageType.VALUE_MESSAGE_TYPE_SUBSCRIPTION_REQUEST, Message.MessageType.VALUE_MESSAGE_TYPE_BROADCAST_SUBSCRIPTION_REQUEST, Message.MessageType.VALUE_MESSAGE_TYPE_MULTICAST_SUBSCRIPTION_REQUEST));
    private static final Logger logger = LoggerFactory.getLogger(AbstractGlobalMessagingSkeleton.class);
    private final RoutingTable routingTable;

    @Inject
    protected AbstractGlobalMessagingSkeleton(RoutingTable routingTable) {
        this.routingTable = routingTable;
    }

    protected boolean registerGlobalRoutingEntry(ImmutableMessage message, String gbid) {
        Message.MessageType messageType = message.getType();
        if (!MESSAGE_TYPE_REQUESTS.contains((Object)messageType)) {
            logger.trace("Message type is: {}, no global routing entry added to the routing table for it ", (Object)messageType);
            return false;
        }
        String replyTo = message.getReplyTo();
        if (replyTo != null && !replyTo.isEmpty()) {
            Address address = RoutingTypesUtil.fromAddressString((String)replyTo);
            if (address instanceof MqttAddress) {
                MqttAddress mqttAddress = (MqttAddress)address;
                mqttAddress.setBrokerUri(gbid);
                logger.trace("Register Global Routing Entry of incoming request message {} for MqttAddress with topic: {} for gbid: {}", new Object[]{message.getId(), mqttAddress.getTopic(), mqttAddress.getBrokerUri()});
            }
            boolean isGloballyVisible = true;
            long expiryDateMs = message.getTtlMs();
            return this.routingTable.put(message.getSender(), address, true, expiryDateMs);
        }
        logger.error("Message ({}) has no replyTo. Reply might not be routable.", (Object)message.getTrackingInfo());
        return false;
    }

    protected void removeGlobalRoutingEntry(ImmutableMessage message, boolean routingEntryRegistered) {
        if (message.isMessageProcessed()) {
            return;
        }
        message.messageProcessed();
        if (routingEntryRegistered) {
            this.routingTable.remove(message.getSender());
        }
    }
}

