/*
 * Decompiled with CFR 0.152.
 */
package io.joynr.messaging;

import io.joynr.messaging.IMessagingStub;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.Map;
import joynr.system.RoutingTypes.Address;

public abstract class AbstractMiddlewareMessagingStubFactory<S extends IMessagingStub, A extends Address> {
    private static final int MAX_SIZE = 100000;
    private Map<A, S> stubMap = new LinkedHashMap<A, S>(){

        @Override
        protected boolean removeEldestEntry(Map.Entry eldest) {
            return this.size() > 100000;
        }
    };

    protected abstract S createInternal(A var1);

    public synchronized IMessagingStub create(A address) {
        IMessagingStub stub = (IMessagingStub)this.stubMap.get(address);
        if (stub == null) {
            stub = this.createInternal(address);
            this.stubMap.put(address, stub);
        }
        return stub;
    }

    protected Collection<S> getAllMessagingStubs() {
        return this.stubMap.values();
    }

    public int getMaxCacheSize() {
        return 100000;
    }

    public synchronized int getCacheSize() {
        return this.stubMap.size();
    }

    public synchronized void clearCache() {
        this.stubMap.clear();
    }
}

