/*
 * Decompiled with CFR 0.152.
 */
package io.joynr.common;

import io.joynr.common.LongToLongBiFunction;
import io.joynr.common.LongToLongFunction;

public class ExpiryDateUtils {
    public static final long MAX_JS_INT = 0x1FFFFFFFFFFFFFL;
    private static final LongToLongBiFunction ADD = Math::addExact;
    private static final LongToLongFunction LIMIT_MAX = x -> Math.min(x, 0x1FFFFFFFFFFFFFL);
    private static final LongToLongBiFunction ADD_AND_LIMIT = ADD.andThen(LIMIT_MAX);
    private static final LongToLongBiFunction SUBTRACT = Math::subtractExact;

    private ExpiryDateUtils() {
    }

    private static long clamp(LongToLongBiFunction biFunction, long clampValue, long firstParam, long secondParam) {
        try {
            return biFunction.apply(firstParam, secondParam);
        }
        catch (ArithmeticException exception) {
            return clampValue;
        }
    }

    public static long addAndLimit(long first, long second) {
        return ExpiryDateUtils.clamp(ADD_AND_LIMIT, 0x1FFFFFFFFFFFFFL, first, second);
    }

    public static long subtract(long first, long second) {
        return ExpiryDateUtils.clamp(SUBTRACT, Long.MIN_VALUE, first, second);
    }
}

