/*
 * Decompiled with CFR 0.152.
 */
package io.joynr.common;

import io.joynr.common.ExpiryDateUtils;
import java.text.SimpleDateFormat;

public class ExpiryDate {
    private final long value;
    private final long relativeTtl;

    public static ExpiryDate fromRelativeTtl(long relativeTtl) {
        long creationTime = System.currentTimeMillis();
        long expiryDate = ExpiryDateUtils.addAndLimit(creationTime, relativeTtl);
        return new ExpiryDate(relativeTtl, expiryDate);
    }

    public static ExpiryDate fromAbsolute(long expiryDate) {
        long creationTime = System.currentTimeMillis();
        long relativeTtl = ExpiryDateUtils.subtract(expiryDate, creationTime);
        return new ExpiryDate(relativeTtl, expiryDate);
    }

    private ExpiryDate(long relativeTtl, long expiryDate) {
        this.relativeTtl = relativeTtl;
        this.value = expiryDate;
    }

    public long getValue() {
        return this.value;
    }

    public long getRelativeTtl() {
        return this.relativeTtl;
    }

    public String toString() {
        SimpleDateFormat dateFormatter = new SimpleDateFormat("dd/MM HH:mm:ss:sss");
        return "ExpiryDate in ms: " + this.value + " ExpiryDate: " + dateFormatter.format(this.value) + " relativeTtl:" + this.relativeTtl;
    }
}

