/*
 * Decompiled with CFR 0.152.
 */
package io.joynr.capabilities;

import com.google.inject.Inject;
import com.google.inject.name.Named;
import io.joynr.capabilities.CapabilityUtils;
import io.joynr.messaging.inprocess.InProcessAddress;
import java.util.HashMap;
import java.util.Map;
import joynr.infrastructure.GlobalCapabilitiesDirectory;
import joynr.infrastructure.GlobalDomainAccessController;
import joynr.system.RoutingTypes.Address;
import joynr.system.RoutingTypes.ChannelAddress;
import joynr.system.RoutingTypes.MqttAddress;
import joynr.types.DiscoveryEntry;
import joynr.types.GlobalDiscoveryEntry;
import joynr.types.ProviderQos;
import joynr.types.Version;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LegacyCapabilitiesProvisioning {
    private static final Logger logger = LoggerFactory.getLogger(LegacyCapabilitiesProvisioning.class);
    private Map<Class<?>, DiscoveryEntry> legacyDiscoveryEntries = new HashMap();
    private Map<Class<?>, Address> legacyAddresses = new HashMap();

    @Inject
    public LegacyCapabilitiesProvisioning(LegacyProvisioningPropertiesHolder properties) {
        this.createDiscoveryEntryFor(GlobalCapabilitiesDirectory.class, "infrastructure/GlobalCapabilitiesDirectory", properties.capabilitiesDirectoryChannelId, properties.capabilitiesDirectoryParticipantId, properties.discoveryDirectoryUrl, properties.channelId, properties.discoveryDirectoriesDomain);
        this.createDiscoveryEntryFor(GlobalDomainAccessController.class, "infrastructure/GlobalDomainAccessController", properties.domainAccessControllerChannelId, properties.domainAccessControllerParticipantId, properties.domainAccessControllerUrl, properties.channelId, properties.discoveryDirectoriesDomain);
    }

    private void createDiscoveryEntryFor(Class<?> interfaceClass, String interfaceName, String channelId, String participantId, String urlForAddress, String localChannelId, String domain) {
        boolean hasUrl = this.isPresent(urlForAddress);
        boolean hasParticipantId = this.isPresent(participantId);
        if (hasUrl && !hasParticipantId) {
            throw new IllegalArgumentException(String.format("When configuring the discovery directory or domain access controller via properties, you must provide both a URL and a participant ID per service.%nYou provided the URL '%s' and the participant ID '%s' for the service %s.%nPlease complete the configuration and restart the application.", urlForAddress, participantId, interfaceName));
        }
        if (hasParticipantId && hasUrl && this.isPresent(channelId) && this.isPresent(domain)) {
            Object address = localChannelId.equals(channelId) ? new InProcessAddress() : (urlForAddress.startsWith("http") || urlForAddress.startsWith("https") ? new ChannelAddress(urlForAddress, channelId) : new MqttAddress(urlForAddress, channelId));
            GlobalDiscoveryEntry discoveryEntry = CapabilityUtils.newGlobalDiscoveryEntry(new Version(Integer.valueOf(0), Integer.valueOf(1)), domain, interfaceName, participantId, new ProviderQos(), System.currentTimeMillis(), Long.MAX_VALUE, "", (Address)address);
            logger.debug("Created legacy discovery entry: {}", (Object)discoveryEntry);
            this.legacyDiscoveryEntries.put(interfaceClass, (DiscoveryEntry)discoveryEntry);
            this.legacyAddresses.put(interfaceClass, (Address)address);
        } else {
            logger.trace("Insufficient properties data to create entry for interface {}", (Object)interfaceName);
        }
    }

    private boolean isPresent(String value) {
        return value != null && !value.trim().isEmpty();
    }

    public DiscoveryEntry getDiscoveryEntryForInterface(Class<?> serviceInterface) {
        return this.legacyDiscoveryEntries.get(serviceInterface);
    }

    public Address getAddressForInterface(Class<?> serviceInterface) {
        return this.legacyAddresses.get(serviceInterface);
    }

    public static class LegacyProvisioningPropertiesHolder {
        @Inject(optional=true)
        @Named(value="joynr.messaging.discoverydirectoryurl")
        protected String discoveryDirectoryUrl;
        @Inject(optional=true)
        @Named(value="joynr.messaging.domainaccesscontrollerurl")
        protected String domainAccessControllerUrl;
        @Inject(optional=true)
        @Named(value="joynr.messaging.channelid")
        protected String channelId;
        @Inject(optional=true)
        @Named(value="joynr.messaging.discoverydirectoriesdomain")
        protected String discoveryDirectoriesDomain;
        @Inject(optional=true)
        @Named(value="joynr.messaging.capabilitiesdirectoryparticipantid")
        protected String capabilitiesDirectoryParticipantId;
        @Inject(optional=true)
        @Named(value="joynr.messaging.capabilitiesdirectorychannelid")
        protected String capabilitiesDirectoryChannelId;
        @Inject(optional=true)
        @Named(value="joynr.messaging.domainaccesscontrollerparticipantid")
        protected String domainAccessControllerParticipantId;
        @Inject(optional=true)
        @Named(value="joynr.messaging.domainaccesscontrollerchannelid")
        protected String domainAccessControllerChannelId;

        public LegacyProvisioningPropertiesHolder() {
        }

        public LegacyProvisioningPropertiesHolder(String discoveryDirectoryUrl, String domainAccessControllerUrl, String channelId, String discoveryDirectoriesDomain, String capabilitiesDirectoryParticipantId, String capabilitiesDirectoryChannelId, String domainAccessControllerParticipantId, String domainAccessControllerChannelId) {
            this.discoveryDirectoryUrl = discoveryDirectoryUrl;
            this.domainAccessControllerUrl = domainAccessControllerUrl;
            this.channelId = channelId;
            this.discoveryDirectoriesDomain = discoveryDirectoriesDomain;
            this.capabilitiesDirectoryParticipantId = capabilitiesDirectoryParticipantId;
            this.capabilitiesDirectoryChannelId = capabilitiesDirectoryChannelId;
            this.domainAccessControllerParticipantId = domainAccessControllerParticipantId;
            this.domainAccessControllerChannelId = domainAccessControllerChannelId;
        }
    }
}

