/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.jenkins.plugins.sam;

import hudson.Extension;
import hudson.model.AbstractDescribableImpl;
import hudson.model.Descriptor;
import hudson.util.FormValidation;
import org.apache.commons.lang.StringUtils;
import org.kohsuke.stapler.DataBoundConstructor;
import org.kohsuke.stapler.QueryParameter;

public class KeyValuePairBean
extends AbstractDescribableImpl<KeyValuePairBean> {
    private String key;
    private String value;

    @DataBoundConstructor
    public KeyValuePairBean(String key, String value) {
        this.key = key;
        this.value = value;
    }

    public String getKey() {
        return this.key;
    }

    public String getValue() {
        return this.value;
    }

    @Extension
    public static class DescriptorImpl
    extends Descriptor<KeyValuePairBean> {
        public String getDisplayName() {
            return "Key Value pair";
        }

        public FormValidation doCheckKey(@QueryParameter String value) {
            if (StringUtils.isEmpty((String)value)) {
                return FormValidation.error((String)"Please fill in key.");
            }
            if (value.length() > 128) {
                return FormValidation.error((String)"The maximum length is 128 characters.");
            }
            if (!StringUtils.isAlphanumeric((String)value)) {
                return FormValidation.error((String)"The key can contain only alphanumeric characters.");
            }
            return FormValidation.ok();
        }

        public FormValidation doCheckValue(@QueryParameter String value) {
            if (StringUtils.isEmpty((String)value)) {
                return FormValidation.error((String)"Please fill in value.");
            }
            if (value.length() > 256) {
                return FormValidation.error((String)"The maximum length is 256 characters.");
            }
            return FormValidation.ok();
        }
    }
}

