/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.jenkins.plugins.sam;

import com.amazonaws.AmazonServiceException;
import com.amazonaws.jenkins.plugins.sam.DeploySettings;
import com.amazonaws.jenkins.plugins.sam.export.ArtifactExporter;
import com.amazonaws.jenkins.plugins.sam.export.ArtifactUploader;
import com.amazonaws.jenkins.plugins.sam.model.ChangeSetNoChangesException;
import com.amazonaws.jenkins.plugins.sam.service.AmazonCloudFormationBuilder;
import com.amazonaws.jenkins.plugins.sam.service.AmazonS3Builder;
import com.amazonaws.jenkins.plugins.sam.service.CloudFormationService;
import com.amazonaws.services.cloudformation.model.CreateChangeSetResult;
import com.amazonaws.services.s3.AmazonS3;
import hudson.Extension;
import hudson.FilePath;
import hudson.Launcher;
import hudson.model.AbstractProject;
import hudson.model.Run;
import hudson.model.TaskListener;
import hudson.tasks.BuildStepDescriptor;
import hudson.tasks.Builder;
import java.io.IOException;
import java.io.OutputStreamWriter;
import java.io.PrintStream;
import java.io.Writer;
import java.nio.charset.StandardCharsets;
import java.util.Map;
import jenkins.tasks.SimpleBuildStep;
import org.apache.commons.lang.StringUtils;
import org.jenkinsci.Symbol;
import org.kohsuke.stapler.DataBoundConstructor;
import org.yaml.snakeyaml.Yaml;

public class DeployBuildStep
extends Builder
implements SimpleBuildStep {
    private final DeploySettings settings;

    @DataBoundConstructor
    public DeployBuildStep(DeploySettings settings) {
        this.settings = settings;
    }

    public DeploySettings getSettings() {
        return this.settings;
    }

    public void perform(Run<?, ?> run, FilePath workspace, Launcher launcher, TaskListener listener) throws InterruptedException, IOException, AmazonServiceException {
        PrintStream logger = listener.getLogger();
        CloudFormationService cloudFormation = CloudFormationService.build(AmazonCloudFormationBuilder.build(this.settings), logger);
        AmazonS3 s3Client = AmazonS3Builder.build(this.settings);
        String template = workspace.child(this.settings.getTemplateFile()).readToString();
        String s3Bucket = this.settings.getS3Bucket();
        ArtifactUploader uploader = ArtifactUploader.build(s3Client, this.settings.buildUploaderConfig(), logger);
        ArtifactExporter exporter = ArtifactExporter.build(workspace.child(this.settings.getTemplateFile()), uploader);
        cloudFormation.validateTemplate(template);
        if (!s3Client.doesBucketExistV2(s3Bucket)) {
            logger.println("Bucket [" + s3Bucket + "] does not exist, creating...");
            s3Client.createBucket(s3Bucket);
        }
        Map<String, Object> outputTemplate = exporter.export();
        logger.println("Successfully packaged artifacts.");
        String outputTemplateFilepath = this.createOutputTemplateFile(outputTemplate, workspace, run.getId());
        logger.println("Output template: " + outputTemplateFilepath);
        try {
            CreateChangeSetResult changeSetResult = this.createChangeSet(cloudFormation, outputTemplate, run.getId());
            cloudFormation.executeChangeSet(changeSetResult.getId());
            logger.println("Application successfully deployed.");
        }
        catch (ChangeSetNoChangesException e) {
            logger.println(e.getMessage());
        }
    }

    private CreateChangeSetResult createChangeSet(CloudFormationService cloudFormation, Map<String, Object> outputTemplate, String jobId) {
        Yaml yaml = new Yaml();
        String roleArn = this.settings.getRoleArn();
        return cloudFormation.createChangeSet(this.settings.getStackName(), "jenkins-build-" + jobId, yaml.dump(outputTemplate), this.settings.buildTemplateParameters(), this.settings.buildTags(), StringUtils.isEmpty((String)roleArn) ? null : roleArn);
    }

    private String createOutputTemplateFile(Map<String, Object> outputTemplate, FilePath workspace, String jobId) throws IOException, InterruptedException {
        Yaml yaml = new Yaml();
        String outputTemplateFile = this.settings.getOutputTemplateFile();
        if (StringUtils.isEmpty((String)outputTemplateFile)) {
            outputTemplateFile = String.format("template-%s.yaml", jobId);
        }
        OutputStreamWriter writer = new OutputStreamWriter(workspace.child(outputTemplateFile).write(), StandardCharsets.UTF_8);
        yaml.dump(outputTemplate, (Writer)writer);
        return outputTemplateFile;
    }

    @Symbol(value={"samDeploy"})
    @Extension
    public static final class DescriptorImpl
    extends BuildStepDescriptor<Builder> {
        public String getDisplayName() {
            return "AWS SAM deploy application";
        }

        public boolean isApplicable(Class<? extends AbstractProject> jobType) {
            return true;
        }
    }
}

