/*
 * Decompiled with CFR 0.152.
 */
package io.jenkins.plugins.casc;

import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import org.apache.commons.text.lookup.StringLookup;

class FixedInterpolatorStringLookup
implements StringLookup {
    private static final char PREFIX_SEPARATOR = ':';
    private final StringLookup defaultStringLookup;
    private final Map<String, StringLookup> stringLookupMap;

    static String toKey(String key) {
        return key.toLowerCase(Locale.ROOT);
    }

    FixedInterpolatorStringLookup(Map<String, StringLookup> stringLookupMap, StringLookup defaultStringLookup) {
        this.defaultStringLookup = defaultStringLookup;
        this.stringLookupMap = new HashMap<String, StringLookup>(stringLookupMap.size());
        for (Map.Entry<String, StringLookup> entry : stringLookupMap.entrySet()) {
            this.stringLookupMap.put(FixedInterpolatorStringLookup.toKey(entry.getKey()), entry.getValue());
        }
    }

    public String lookup(String var) {
        if (var == null) {
            return null;
        }
        int prefixPos = var.indexOf(58);
        if (prefixPos >= 0) {
            String prefix = FixedInterpolatorStringLookup.toKey(var.substring(0, prefixPos));
            String name = var.substring(prefixPos + 1);
            StringLookup lookup = this.stringLookupMap.get(prefix);
            String value = null;
            if (lookup != null) {
                value = lookup.lookup(name);
            }
            if (value != null) {
                return value;
            }
        }
        if (this.defaultStringLookup != null) {
            return this.defaultStringLookup.lookup(var);
        }
        return null;
    }

    public String toString() {
        return super.toString() + " [stringLookupMap=" + this.stringLookupMap + ", defaultStringLookup=" + this.defaultStringLookup + "]";
    }
}

