/*
 * Decompiled with CFR 0.152.
 */
package io.jenkins.plugins.casc.impl.configurators;

import edu.umd.cs.findbugs.annotations.CheckForNull;
import edu.umd.cs.findbugs.annotations.NonNull;
import hudson.DescriptorExtensionList;
import hudson.model.Describable;
import hudson.model.Descriptor;
import io.jenkins.plugins.casc.Attribute;
import io.jenkins.plugins.casc.ConfigurationContext;
import io.jenkins.plugins.casc.Configurator;
import io.jenkins.plugins.casc.ObsoleteConfigurationMonitor;
import io.jenkins.plugins.casc.impl.attributes.DescribableAttribute;
import io.jenkins.plugins.casc.model.CNode;
import io.jenkins.plugins.casc.model.Mapping;
import io.jenkins.plugins.casc.model.Scalar;
import io.vavr.API;
import io.vavr.CheckedFunction0;
import io.vavr.Tuple;
import io.vavr.Tuple2;
import io.vavr.collection.HashMap;
import io.vavr.collection.Stream;
import io.vavr.control.Option;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.function.Predicate;
import java.util.logging.Level;
import java.util.logging.Logger;
import jenkins.model.Jenkins;
import org.kohsuke.accmod.Restricted;
import org.kohsuke.accmod.restrictions.NoExternalUse;

@Restricted(value={NoExternalUse.class})
public class HeteroDescribableConfigurator<T extends Describable<T>>
implements Configurator<T> {
    private static final Logger LOGGER = Logger.getLogger(HeteroDescribableConfigurator.class.getName());
    private final Class<T> target;

    public HeteroDescribableConfigurator(Class<T> clazz) {
        this.target = clazz;
    }

    @Override
    public Class<T> getTarget() {
        return this.target;
    }

    @Override
    @NonNull
    public List<Configurator<T>> getConfigurators(ConfigurationContext context) {
        return this.getDescriptors().flatMap(d -> this.lookupConfigurator(context, this.descriptorClass((Descriptor<T>)d))).append((Object)this).toJavaList();
    }

    @Override
    @NonNull
    public T configure(CNode config, ConfigurationContext context) {
        return (T)((Describable)((Option)this.preConfigure(config).apply((shortName, subConfig) -> this.lookupDescriptor((String)shortName, config).map(descriptor -> this.forceLookupConfigurator(context, (Descriptor<T>)descriptor)).map(configurator -> this.doConfigure(context, (Configurator<T>)configurator, (CNode)subConfig.getOrNull())))).getOrNull());
    }

    @Override
    public T check(CNode config, ConfigurationContext context) {
        return this.configure(config, context);
    }

    @Override
    @NonNull
    public Set<Attribute<T, ?>> describe() {
        return Collections.emptySet();
    }

    @Override
    @CheckForNull
    public CNode describe(T instance, ConfigurationContext context) {
        Predicate<CNode> isScalar = node -> {
            if (!node.getType().equals((Object)CNode.Type.MAPPING)) return false;
            if (((Mapping)API.unchecked(node::asMapping).apply()).size() != 0) return false;
            return true;
        };
        return (CNode)this.lookupConfigurator(context, instance.getClass()).map(configurator -> this.convertToNode(context, (Configurator)configurator, (Describable)instance)).filter(Objects::nonNull).map(node -> {
            if (isScalar.test((CNode)node)) {
                return new Scalar(this.preferredSymbol(instance.getDescriptor()));
            }
            Mapping mapping = new Mapping();
            mapping.put(this.preferredSymbol(instance.getDescriptor()), node);
            return mapping;
        }).getOrNull();
    }

    public Map<String, Class<T>> getImplementors() {
        return ((HashMap)this.getDescriptors().map(descriptor -> Tuple.of((Object)this.preferredSymbol((Descriptor<?>)descriptor), (Object)descriptor)).foldLeft((Object)HashMap.empty(), this::handleDuplicateSymbols)).mapValues(this::descriptorClass).toJavaMap();
    }

    private Option<Configurator<T>> lookupConfigurator(ConfigurationContext context, Class<?> descriptor) {
        return Option.of(context.lookup(descriptor));
    }

    private Configurator<T> forceLookupConfigurator(ConfigurationContext context, Descriptor<T> descriptor) {
        Class klazz = this.descriptorClass(descriptor);
        return (Configurator)this.lookupConfigurator(context, klazz).getOrElseThrow(() -> new IllegalStateException("No configurator implementation to manage " + klazz));
    }

    private Stream<Descriptor<T>> getDescriptors() {
        DescriptorExtensionList descriptorList = Jenkins.get().getDescriptorList(this.target);
        if (!descriptorList.isEmpty()) {
            return Stream.ofAll((Iterable)descriptorList);
        }
        LOGGER.log(Level.FINEST, "getDescriptors(): Cannot find descriptors for {0}.Will try parent classes to find proper extension points", this.target);
        DescriptorExtensionList parentDescriptorClassList = descriptorList;
        for (Class<T> effectiveTarget = this.target.getSuperclass(); parentDescriptorClassList.isEmpty() && effectiveTarget != null && effectiveTarget != Object.class; effectiveTarget = effectiveTarget.getSuperclass()) {
            Class<T> match;
            LOGGER.log(Level.FINEST, "getDescriptors() for {0}: Trying parent class {1}", new Object[]{this.target, effectiveTarget});
            try {
                match = effectiveTarget;
            }
            catch (Exception ex) {
                if (!LOGGER.isLoggable(Level.FINEST)) break;
                LOGGER.log(Level.FINEST, String.format("getDescriptors() for %s: Class %s is not describable, interrupting search", this.target, effectiveTarget), ex);
                break;
            }
            parentDescriptorClassList = Jenkins.get().getDescriptorList(match);
        }
        if (parentDescriptorClassList.isEmpty()) {
            return Stream.empty();
        }
        ArrayList<Descriptor> descriptorsWithProperType = new ArrayList<Descriptor>();
        for (Descriptor d : parentDescriptorClassList) {
            try {
                descriptorsWithProperType.add(d);
                LOGGER.log(Level.FINEST, "getDescriptors() for {0}: Accepting {1} as a suitable descriptor", new Object[]{this.target, d});
            }
            catch (ClassCastException ex) {
                if (!LOGGER.isLoggable(Level.FINEST)) continue;
                LOGGER.log(Level.FINEST, String.format("getDescriptors() for %s: Ignoring %s, because it is not a proper describable type", this.target, d), ex);
            }
        }
        return Stream.ofAll(descriptorsWithProperType);
    }

    private Class<T> descriptorClass(Descriptor<T> descriptor) {
        return descriptor.getKlass().toJavaClass();
    }

    private Option<Descriptor<T>> lookupDescriptor(String symbol, CNode config) {
        return ((HashMap)this.getDescriptors().filter(descriptor -> this.findByPreferredSymbol((Descriptor<T>)descriptor, symbol) != false || this.findBySymbols((Descriptor<T>)descriptor, symbol, config) != false).map(descriptor -> Tuple.of((Object)this.preferredSymbol((Descriptor<?>)descriptor), (Object)descriptor)).foldLeft((Object)HashMap.empty(), this::handleDuplicateSymbols)).values().headOption().orElse(() -> {
            throw new IllegalArgumentException("No " + this.target.getName() + " implementation found for " + symbol);
        });
    }

    private Boolean findByPreferredSymbol(Descriptor<T> descriptor, String symbol) {
        return this.preferredSymbol(descriptor).equalsIgnoreCase(symbol);
    }

    private Boolean findBySymbols(Descriptor<T> descriptor, String symbol, CNode node) {
        return this.getSymbols(descriptor).find(actual -> actual.equalsIgnoreCase(symbol)).map(actual -> {
            ObsoleteConfigurationMonitor.get().record(node, "'" + symbol + "' is obsolete, please use '" + this.preferredSymbol(descriptor) + "'");
            return this.descriptorClass(descriptor);
        }).isDefined();
    }

    private Stream<String> getSymbols(Descriptor<T> descriptor) {
        return Stream.ofAll(DescribableAttribute.getSymbols(descriptor, this.target, this.target));
    }

    private String preferredSymbol(Descriptor<?> descriptor) {
        return DescribableAttribute.getPreferredSymbol(descriptor, this.target, this.target);
    }

    private HashMap<String, Descriptor<T>> handleDuplicateSymbols(HashMap<String, Descriptor<T>> r, Tuple2<String, Descriptor<T>> t) {
        if (r.containsKey(t._1)) {
            String message = String.format("Found multiple implementations for symbol = %s: [%s, %s]. Please report to plugin maintainer.", t._1, r.get(t._1).get(), t._2);
            LOGGER.warning(message);
            return r;
        }
        return r.put(t);
    }

    private Tuple2<String, Option<CNode>> preConfigure(CNode config) {
        switch (config.getType()) {
            case SCALAR: {
                return this.configureScalar(config);
            }
            case MAPPING: {
                return this.configureMapping(config);
            }
        }
        return this.configureUnexpected(config);
    }

    private Tuple2<String, Option<CNode>> configureUnexpected(CNode config) {
        throw new IllegalArgumentException("Unexpected configuration type " + config);
    }

    private Tuple2<String, Option<CNode>> configureScalar(CNode config) {
        Scalar scalar = (Scalar)API.unchecked(config::asScalar).apply();
        return Tuple.of((Object)scalar.getValue(), (Object)Option.none());
    }

    private Tuple2<String, Option<CNode>> configureMapping(CNode config) {
        Mapping mapping = (Mapping)API.unchecked(config::asMapping).apply();
        if (mapping.size() != 1) {
            throw new IllegalArgumentException("Single entry map expected to configure a " + this.target.getName());
        }
        Map.Entry next = mapping.entrySet().iterator().next();
        return Tuple.of(next.getKey(), (Object)Option.some(next.getValue()));
    }

    private T doConfigure(ConfigurationContext context, Configurator<T> configurator, CNode subConfig) {
        return (T)((Describable)API.unchecked((CheckedFunction0 & Serializable)() -> (Describable)configurator.configure(subConfig, context)).apply());
    }

    private CNode convertToNode(ConfigurationContext context, Configurator configurator, Describable instance) {
        return (CNode)API.unchecked((CheckedFunction0 & Serializable)() -> configurator.describe(instance, context)).apply();
    }
}

