/*
 * Decompiled with CFR 0.152.
 */
package org.jenkinsci.plugins.casc;

import hudson.DescriptorExtensionList;
import hudson.model.Describable;
import hudson.model.Descriptor;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.logging.Logger;
import java.util.stream.Collectors;
import javax.annotation.CheckForNull;
import jenkins.model.Jenkins;
import org.jenkinsci.plugins.casc.Attribute;
import org.jenkinsci.plugins.casc.Configurator;
import org.jenkinsci.plugins.casc.ConfiguratorException;
import org.jenkinsci.plugins.casc.DescribableAttribute;
import org.jenkinsci.plugins.casc.ObsoleteConfigurationMonitor;
import org.jenkinsci.plugins.casc.model.CNode;
import org.jenkinsci.plugins.casc.model.Mapping;
import org.jenkinsci.plugins.casc.model.Scalar;

public class HeteroDescribableConfigurator
extends Configurator<Describable> {
    private static final Logger LOGGER = Logger.getLogger(HeteroDescribableConfigurator.class.getName());
    private final Class<Describable> target;

    public HeteroDescribableConfigurator(Class<Describable> clazz) {
        this.target = clazz;
    }

    @Override
    public Class<Describable> getTarget() {
        return this.target;
    }

    @Override
    public List<Configurator> getConfigurators() {
        DescriptorExtensionList candidates = Jenkins.getInstance().getDescriptorList(this.target);
        return candidates.stream().map(d -> Configurator.lookup(d.getKlass().toJavaClass())).filter(c -> c != null).collect(Collectors.toList());
    }

    @Override
    public Describable configure(CNode config) throws ConfiguratorException {
        String shortname;
        CNode subconfig = null;
        switch (config.getType()) {
            case SCALAR: {
                shortname = config.asScalar().getValue();
                break;
            }
            case MAPPING: {
                Mapping map = config.asMapping();
                if (map.size() != 1) {
                    throw new IllegalArgumentException("single entry map expected to configure a " + this.target.getName());
                }
                Map.Entry next = map.entrySet().iterator().next();
                shortname = (String)next.getKey();
                subconfig = (CNode)next.getValue();
                break;
            }
            default: {
                throw new IllegalArgumentException("Unexpected configuration type " + config);
            }
        }
        DescriptorExtensionList candidates = Jenkins.getInstance().getDescriptorList(this.target);
        Class k = this.findDescribableBySymbol(config, shortname, (List<Descriptor>)candidates);
        Configurator configurator = Configurator.lookup(k);
        if (configurator == null) {
            throw new IllegalStateException("No configurator implementation to manage " + k);
        }
        return (Describable)configurator.configure(subconfig);
    }

    private Class findDescribableBySymbol(CNode node, String shortname, List<Descriptor> candidates) {
        Class clazz;
        for (Descriptor d : candidates) {
            List<String> symbols = DescribableAttribute.getSymbols(d, this.getExtensionPoint(), this.target);
            String preferred = symbols.get(0);
            if (preferred.equalsIgnoreCase(shortname)) {
                return d.getKlass().toJavaClass();
            }
            for (String symbol : symbols) {
                if (!symbol.equalsIgnoreCase(shortname)) continue;
                ObsoleteConfigurationMonitor.get().record(node, "'" + shortname + "' is obsolete, please use '" + preferred + "'");
                return d.getKlass().toJavaClass();
            }
        }
        Configurator c = Configurator.lookupForBaseType(this.target, shortname);
        if (c != null && Describable.class.isAssignableFrom(clazz = c.getTarget())) {
            return clazz;
        }
        throw new IllegalArgumentException("No " + this.target.getName() + " implementation found for " + shortname);
    }

    @Override
    public Set<Attribute> describe() {
        return Collections.EMPTY_SET;
    }

    @Override
    @CheckForNull
    public CNode describe(Describable instance) throws Exception {
        String symbol = DescribableAttribute.getPreferredSymbol(instance.getDescriptor(), this.getTarget(), instance.getClass());
        Configurator c = Configurator.lookupOrFail(instance.getClass());
        CNode describe = c.describe(instance);
        if (describe == null) {
            return null;
        }
        if (describe.getType() == CNode.Type.MAPPING && describe.asMapping().size() == 0) {
            return new Scalar(symbol);
        }
        Mapping mapping = new Mapping();
        mapping.put(symbol, describe);
        return mapping;
    }
}

