/*
 * Decompiled with CFR 0.152.
 */
package org.jenkinsci.plugins.casc;

import hudson.EnvVars;
import hudson.Extension;
import hudson.slaves.Cloud;
import hudson.slaves.NodeProperty;
import java.util.Collection;
import java.util.Map;
import java.util.Set;
import java.util.logging.Logger;
import javaposse.jobdsl.dsl.JobManagement;
import javaposse.jobdsl.plugin.JenkinsDslScriptLoader;
import javaposse.jobdsl.plugin.JenkinsJobManagement;
import javaposse.jobdsl.plugin.LookupStrategy;
import javax.annotation.CheckForNull;
import jenkins.model.Jenkins;
import jenkins.security.s2m.AdminWhitelistRule;
import org.jenkinsci.plugins.casc.Attribute;
import org.jenkinsci.plugins.casc.BaseConfigurator;
import org.jenkinsci.plugins.casc.ConfiguratorException;
import org.jenkinsci.plugins.casc.MultivaluedAttribute;
import org.jenkinsci.plugins.casc.PersistedListAttribute;
import org.jenkinsci.plugins.casc.RootElementConfigurator;
import org.jenkinsci.plugins.casc.model.CNode;
import org.jenkinsci.plugins.casc.model.Mapping;

@Extension
public class JenkinsConfigurator
extends BaseConfigurator<Jenkins>
implements RootElementConfigurator<Jenkins> {
    private static final Logger LOGGER = Logger.getLogger(JenkinsConfigurator.class.getName());

    @Override
    public Class<Jenkins> getTarget() {
        return Jenkins.class;
    }

    @Override
    public Jenkins getTargetComponent() {
        return Jenkins.getInstance();
    }

    @Override
    public Jenkins configure(CNode c) throws ConfiguratorException {
        Mapping config = c.asMapping();
        Jenkins jenkins = Jenkins.getInstance();
        this.configure(config, jenkins);
        return jenkins;
    }

    @Override
    public Set<Attribute> describe() {
        Set<Attribute> attributes = super.describe();
        attributes.add(new PersistedListAttribute<Jenkins, Cloud>("clouds", Cloud.class).getter(target -> target.clouds));
        attributes.add(new MultivaluedAttribute<Jenkins, Collection>("jobs", String.class).setter((target, value) -> {
            JenkinsJobManagement mng = new JenkinsJobManagement(System.out, (Map)new EnvVars(), null, null, LookupStrategy.JENKINS_ROOT);
            for (String script : value) {
                new JenkinsDslScriptLoader((JobManagement)mng).runScript(script);
            }
        }));
        attributes.add(new PersistedListAttribute("nodeProperties", NodeProperty.class));
        attributes.add(new PersistedListAttribute("globalNodeProperties", NodeProperty.class));
        attributes.add(new Attribute("remotingSecurity", AdminWhitelistRule.class).setter(Attribute.NOOP));
        return attributes;
    }

    @Override
    @CheckForNull
    public CNode describe(Jenkins instance) throws Exception {
        Mapping mapping = new Mapping();
        for (Attribute attribute : this.describe()) {
            mapping.put(attribute.getName(), attribute.describe(instance));
        }
        return mapping;
    }

    @Override
    public String getName() {
        return "jenkins";
    }
}

