/*
 * Decompiled with CFR 0.152.
 */
package org.jenkinsci.plugins.casc.impl.configurators;

import hudson.model.Descriptor;
import javax.annotation.CheckForNull;
import org.jenkinsci.Symbol;
import org.jenkinsci.plugins.casc.BaseConfigurator;
import org.jenkinsci.plugins.casc.ConfigurationContext;
import org.jenkinsci.plugins.casc.RootElementConfigurator;
import org.jenkinsci.plugins.casc.model.CNode;
import org.jenkinsci.plugins.casc.model.Mapping;
import org.kohsuke.accmod.Restricted;
import org.kohsuke.accmod.restrictions.NoExternalUse;

@Restricted(value={NoExternalUse.class})
public class DescriptorConfigurator
extends BaseConfigurator<Descriptor>
implements RootElementConfigurator<Descriptor> {
    private final String name;
    private final Descriptor descriptor;
    private final Class target;

    public DescriptorConfigurator(Descriptor descriptor) {
        this.descriptor = descriptor;
        this.target = descriptor.getClass();
        Symbol symbol = descriptor.getClass().getAnnotation(Symbol.class);
        if (symbol != null) {
            this.name = symbol.value()[0];
        } else {
            String cl = descriptor.getKlass().toJavaClass().getSimpleName();
            this.name = cl.toLowerCase();
        }
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public Class<Descriptor> getTarget() {
        return this.target;
    }

    @Override
    public Descriptor getTargetComponent(ConfigurationContext context) {
        return this.descriptor;
    }

    @Override
    protected Descriptor instance(Mapping mapping, ConfigurationContext context) {
        return this.descriptor;
    }

    @Override
    @CheckForNull
    public CNode describe(Descriptor instance) throws Exception {
        Descriptor ref = (Descriptor)this.target.newInstance();
        return this.compare(instance, ref);
    }
}

