/*
 * Decompiled with CFR 0.152.
 */
package org.jenkinsci.plugins.casc;

import com.google.common.annotations.VisibleForTesting;
import hudson.Extension;
import hudson.init.InitMilestone;
import hudson.init.Initializer;
import hudson.model.ManagementLink;
import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Reader;
import java.io.Writer;
import java.net.URI;
import java.net.URL;
import java.nio.charset.StandardCharsets;
import java.nio.file.FileSystems;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.NoSuchFileException;
import java.nio.file.Path;
import java.nio.file.PathMatcher;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.TreeSet;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.annotation.CheckForNull;
import javax.servlet.ServletContext;
import javax.servlet.http.HttpServletRequest;
import jenkins.model.Jenkins;
import net.sf.json.JSONArray;
import net.sf.json.JSONObject;
import org.jenkinsci.plugins.casc.Attribute;
import org.jenkinsci.plugins.casc.ConfigurationContext;
import org.jenkinsci.plugins.casc.Configurator;
import org.jenkinsci.plugins.casc.ConfiguratorException;
import org.jenkinsci.plugins.casc.ObsoleteConfigurationMonitor;
import org.jenkinsci.plugins.casc.RootElementConfigurator;
import org.jenkinsci.plugins.casc.model.CNode;
import org.jenkinsci.plugins.casc.model.Mapping;
import org.jenkinsci.plugins.casc.model.Scalar;
import org.jenkinsci.plugins.casc.model.Sequence;
import org.jenkinsci.plugins.casc.model.Source;
import org.jenkinsci.plugins.casc.yaml.ModelConstructor;
import org.jenkinsci.plugins.casc.yaml.YamlSource;
import org.jenkinsci.plugins.casc.yaml.YamlUtils;
import org.kohsuke.accmod.Restricted;
import org.kohsuke.accmod.restrictions.NoExternalUse;
import org.kohsuke.stapler.StaplerRequest;
import org.kohsuke.stapler.StaplerResponse;
import org.kohsuke.stapler.interceptor.RequirePOST;
import org.yaml.snakeyaml.DumperOptions;
import org.yaml.snakeyaml.Yaml;
import org.yaml.snakeyaml.composer.Composer;
import org.yaml.snakeyaml.emitter.Emitable;
import org.yaml.snakeyaml.emitter.Emitter;
import org.yaml.snakeyaml.error.YAMLException;
import org.yaml.snakeyaml.nodes.MappingNode;
import org.yaml.snakeyaml.nodes.Node;
import org.yaml.snakeyaml.nodes.NodeTuple;
import org.yaml.snakeyaml.nodes.ScalarNode;
import org.yaml.snakeyaml.nodes.SequenceNode;
import org.yaml.snakeyaml.nodes.Tag;
import org.yaml.snakeyaml.resolver.Resolver;
import org.yaml.snakeyaml.serializer.Serializer;

@Extension
@Restricted(value={NoExternalUse.class})
public class ConfigurationAsCode
extends ManagementLink {
    public static final String CASC_JENKINS_CONFIG_PROPERTY = "casc.jenkins.config";
    public static final String CASC_JENKINS_CONFIG_ENV = "CASC_JENKINS_CONFIG";
    public static final String DEFAULT_JENKINS_YAML_PATH = "./jenkins.yaml";
    public static final String YAML_FILES_PATTERN = "glob:**.{yml,yaml,YAML,YML}";
    public static final Logger LOGGER = Logger.getLogger(ConfigurationAsCode.class.getName());
    private long lastTimeLoaded;
    private List<String> sources = Collections.emptyList();

    @CheckForNull
    public String getIconFileName() {
        return "/plugin/configuration-as-code/img/logo-head.svg";
    }

    @CheckForNull
    public String getDisplayName() {
        return "Configuration as Code";
    }

    @CheckForNull
    public String getUrlName() {
        return "configuration-as-code";
    }

    public String getDescription() {
        return "An opinionated way to configure jenkins based on human-readable declarative configuration files";
    }

    public Date getLastTimeLoaded() {
        return new Date(this.lastTimeLoaded);
    }

    public List<String> getSources() {
        return this.sources;
    }

    @RequirePOST
    public void doReload(StaplerRequest request, StaplerResponse response) throws Exception {
        if (!Jenkins.getInstance().hasPermission(Jenkins.ADMINISTER)) {
            response.sendError(403);
            return;
        }
        this.configure();
        response.sendRedirect("");
    }

    @Initializer(after=InitMilestone.EXTENSIONS_AUGMENTED, before=InitMilestone.JOB_LOADED)
    public static void init() throws Exception {
        ConfigurationAsCode.get().configure();
    }

    public void configure() throws ConfiguratorException {
        this.configureWith(this.getStandardConfigSources());
    }

    private List<YamlSource> getStandardConfigSources() throws ConfiguratorException {
        ArrayList<YamlSource> configs = new ArrayList<YamlSource>();
        for (String p : this.getStandardConfig()) {
            if (ConfigurationAsCode.isSupportedURI(p)) {
                configs.add(new YamlSource<String>(p, YamlSource.READ_FROM_URL));
            } else {
                configs.addAll(this.configs(p).stream().map(s -> new YamlSource<Path>((Path)s, YamlSource.READ_FROM_PATH)).collect(Collectors.toList()));
            }
            this.sources = Collections.singletonList(p);
        }
        return configs;
    }

    private List<String> getStandardConfig() {
        String configParameter;
        List<String> configParameters = this.getBundledCasCURIs();
        if (!configParameters.isEmpty()) {
            LOGGER.log(Level.FINE, "Located bundled config YAMLs: {0}", configParameters);
        }
        if ((configParameter = System.getProperty(CASC_JENKINS_CONFIG_PROPERTY, System.getenv(CASC_JENKINS_CONFIG_ENV))) == null && Files.exists(Paths.get(DEFAULT_JENKINS_YAML_PATH, new String[0]), new LinkOption[0])) {
            configParameter = DEFAULT_JENKINS_YAML_PATH;
        }
        if (configParameter != null) {
            configParameters.add(configParameter);
        }
        if (configParameters.isEmpty()) {
            LOGGER.log(Level.FINE, "No configuration set nor default config file");
        }
        return configParameters;
    }

    public List<String> getBundledCasCURIs() {
        String cascFile = "/WEB-INF/./jenkins.yaml";
        String cascDirectory = "/WEB-INF/./jenkins.yaml.d/";
        ArrayList<String> res = new ArrayList<String>();
        ServletContext servletContext = Jenkins.getInstance().servletContext;
        try {
            URL bundled = servletContext.getResource("/WEB-INF/./jenkins.yaml");
            if (bundled != null) {
                res.add(bundled.toString());
            }
        }
        catch (IOException e) {
            LOGGER.log(Level.WARNING, "Failed to load /WEB-INF/./jenkins.yaml", e);
        }
        PathMatcher matcher = FileSystems.getDefault().getPathMatcher(YAML_FILES_PATTERN);
        Set resources = servletContext.getResourcePaths("/WEB-INF/./jenkins.yaml.d/");
        if (resources != null) {
            for (String cascItem : new TreeSet(resources)) {
                try {
                    URL bundled = servletContext.getResource(cascItem);
                    if (bundled == null || !matcher.matches(new File(bundled.getPath()).toPath())) continue;
                    res.add(bundled.toString());
                }
                catch (IOException e) {
                    LOGGER.log(Level.WARNING, "Failed to execute " + res, e);
                }
            }
        }
        return res;
    }

    @RequirePOST
    public void doCheck(StaplerRequest req, StaplerResponse res) throws Exception {
        if (!Jenkins.getInstance().hasPermission(Jenkins.ADMINISTER)) {
            res.sendError(403);
            return;
        }
        Map<Source, String> issues = this.checkWith(new YamlSource<HttpServletRequest>((HttpServletRequest)req, YamlSource.READ_FROM_REQUEST));
        res.setContentType("application/json");
        JSONArray warnings = new JSONArray();
        issues.entrySet().stream().map(e -> new JSONObject().accumulate("line", ((Source)e.getKey()).line).accumulate("warning", e.getValue())).forEach(arg_0 -> ((JSONArray)warnings).add(arg_0));
        warnings.write((Writer)res.getWriter());
    }

    @RequirePOST
    public void doApply(StaplerRequest req, StaplerResponse res) throws Exception {
        if (!Jenkins.getInstance().hasPermission(Jenkins.ADMINISTER)) {
            res.sendError(403);
            return;
        }
        this.configureWith(new YamlSource<HttpServletRequest>((HttpServletRequest)req, YamlSource.READ_FROM_REQUEST));
    }

    @RequirePOST
    public void doExport(StaplerRequest req, StaplerResponse res) throws Exception {
        if (!Jenkins.getInstance().hasPermission(Jenkins.ADMINISTER)) {
            res.sendError(403);
            return;
        }
        res.setContentType("application/x-yaml; charset=utf-8");
        res.addHeader("Content-Disposition", "attachment; filename=jenkins.yaml");
        this.export((OutputStream)res.getOutputStream());
    }

    @Restricted(value={NoExternalUse.class})
    public void export(OutputStream out) throws Exception {
        ArrayList<NodeTuple> tuples = new ArrayList<NodeTuple>();
        ConfigurationContext context = new ConfigurationContext();
        for (RootElementConfigurator root : RootElementConfigurator.all()) {
            CNode config = root.describe(root.getTargetComponent(context));
            Node valueNode = this.toYaml(config);
            if (valueNode == null) continue;
            tuples.add(new NodeTuple((Node)new ScalarNode(Tag.STR, root.getName(), null, null, DumperOptions.ScalarStyle.PLAIN), valueNode));
        }
        MappingNode root = new MappingNode(Tag.MAP, tuples, DumperOptions.FlowStyle.BLOCK);
        try (OutputStreamWriter writer = new OutputStreamWriter(out, StandardCharsets.UTF_8);){
            ConfigurationAsCode.serializeYamlNode((Node)root, writer);
        }
        catch (IOException e) {
            throw new YAMLException((Throwable)e);
        }
    }

    @Restricted(value={NoExternalUse.class})
    @VisibleForTesting
    public static void serializeYamlNode(Node root, Writer writer) throws IOException {
        DumperOptions options = new DumperOptions();
        options.setDefaultFlowStyle(DumperOptions.FlowStyle.BLOCK);
        options.setDefaultScalarStyle(DumperOptions.ScalarStyle.PLAIN);
        options.setSplitLines(true);
        options.setPrettyFlow(true);
        Serializer serializer = new Serializer((Emitable)new Emitter(writer, options), new Resolver(), options, null);
        serializer.open();
        serializer.serialize(root);
        serializer.close();
    }

    @CheckForNull
    @Restricted(value={NoExternalUse.class})
    @VisibleForTesting
    public Node toYaml(CNode config) throws ConfiguratorException {
        if (config == null) {
            return null;
        }
        switch (config.getType()) {
            case MAPPING: {
                Mapping mapping = config.asMapping();
                ArrayList<NodeTuple> tuples = new ArrayList<NodeTuple>();
                ArrayList entries = new ArrayList(mapping.entrySet());
                entries.sort(Comparator.comparing(Map.Entry::getKey));
                for (Map.Entry entry : entries) {
                    Node valueNode = this.toYaml((CNode)entry.getValue());
                    if (valueNode == null) continue;
                    tuples.add(new NodeTuple((Node)new ScalarNode(Tag.STR, (String)entry.getKey(), null, null, DumperOptions.ScalarStyle.PLAIN), valueNode));
                }
                if (tuples.isEmpty()) {
                    return null;
                }
                return new MappingNode(Tag.MAP, tuples, DumperOptions.FlowStyle.BLOCK);
            }
            case SEQUENCE: {
                Sequence sequence = config.asSequence();
                ArrayList<Node> arrayList = new ArrayList<Node>();
                for (CNode cNode : sequence) {
                    Node valueNode = this.toYaml(cNode);
                    if (valueNode == null) continue;
                    arrayList.add(valueNode);
                }
                if (arrayList.isEmpty()) {
                    return null;
                }
                return new SequenceNode(Tag.SEQ, arrayList, DumperOptions.FlowStyle.BLOCK);
            }
        }
        Scalar scalar = config.asScalar();
        String value = scalar.getValue();
        if (value == null || value.length() == 0) {
            return null;
        }
        DumperOptions.ScalarStyle style = scalar.isRaw() ? DumperOptions.ScalarStyle.PLAIN : DumperOptions.ScalarStyle.DOUBLE_QUOTED;
        return new ScalarNode(scalar.getTag(), value, null, null, style);
    }

    public void configure(String ... configParameters) throws ConfiguratorException {
        this.configure(Arrays.asList(configParameters));
    }

    public void configure(Collection<String> configParameters) throws ConfiguratorException {
        ArrayList<YamlSource> configs = new ArrayList<YamlSource>();
        for (String p : configParameters) {
            if (ConfigurationAsCode.isSupportedURI(p)) {
                configs.add(new YamlSource<String>(p, YamlSource.READ_FROM_URL));
            } else {
                configs.addAll(this.configs(p).stream().map(s -> new YamlSource<Path>((Path)s, YamlSource.READ_FROM_PATH)).collect(Collectors.toList()));
            }
            this.sources = Collections.singletonList(p);
        }
        this.configureWith(configs);
        this.lastTimeLoaded = System.currentTimeMillis();
    }

    public static boolean isSupportedURI(String configurationParameter) {
        if (configurationParameter == null) {
            return false;
        }
        List<String> supportedProtocols = Arrays.asList("https", "http", "file");
        URI uri = URI.create(configurationParameter);
        if (uri == null || uri.getScheme() == null) {
            return false;
        }
        return supportedProtocols.contains(uri.getScheme());
    }

    @Restricted(value={NoExternalUse.class})
    public void configureWith(YamlSource source) throws ConfiguratorException {
        List<YamlSource> sources = this.getStandardConfigSources();
        sources.add(source);
        this.configureWith(sources);
    }

    private void configureWith(List<YamlSource> sources) throws ConfiguratorException {
        if (sources.isEmpty()) {
            return;
        }
        Node merged = YamlUtils.merge(sources);
        Mapping map = this.loadAs(merged);
        ConfigurationAsCode.configureWith(map.entrySet());
    }

    @Restricted(value={NoExternalUse.class})
    public Map<Source, String> checkWith(YamlSource source) throws ConfiguratorException {
        List<YamlSource> sources = this.getStandardConfigSources();
        sources.add(source);
        return this.checkWith(sources);
    }

    private Map<Source, String> checkWith(List<YamlSource> sources) throws ConfiguratorException {
        if (sources.isEmpty()) {
            return null;
        }
        Node merged = YamlUtils.merge(sources);
        Mapping map = this.loadAs(merged);
        return ConfigurationAsCode.checkWith(map.entrySet());
    }

    private Mapping loadAs(final Node node) {
        ModelConstructor constructor = new ModelConstructor();
        constructor.setComposer(new Composer(null, null){

            public Node getSingleNode() {
                return node;
            }
        });
        return (Mapping)constructor.getSingleData(Mapping.class);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public List<Path> configs(String path) throws ConfiguratorException {
        PathMatcher matcher = FileSystems.getDefault().getPathMatcher(YAML_FILES_PATTERN);
        try (Stream<Path> stream = Files.find(Paths.get(path, new String[0]), Integer.MAX_VALUE, (next, attrs) -> attrs.isRegularFile() && matcher.matches((Path)next), new FileVisitOption[0]);){
            List<Path> list = stream.collect(Collectors.toList());
            return list;
        }
        catch (NoSuchFileException e) {
            throw new ConfiguratorException("File does not exist: " + path, e);
        }
        catch (IOException e) {
            throw new IllegalStateException("failed config scan for " + path, e);
        }
    }

    private static Stream<? extends Map.Entry<String, Object>> entries(Reader config) {
        return ((Map)new Yaml().loadAs(config, Map.class)).entrySet().stream();
    }

    private static void invokeWith(Set<Map.Entry<String, CNode>> entries, ConfigratorOperation function) throws ConfiguratorException {
        block2: for (RootElementConfigurator configurator : RootElementConfigurator.all()) {
            Iterator<Map.Entry<String, CNode>> it = entries.iterator();
            while (it.hasNext()) {
                Map.Entry<String, CNode> entry = it.next();
                if (!entry.getKey().equalsIgnoreCase(configurator.getName())) continue;
                try {
                    function.apply(configurator, entry.getValue());
                    it.remove();
                    continue block2;
                }
                catch (ConfiguratorException e) {
                    throw new ConfiguratorException(configurator, String.format("error configuring '%s' with %s configurator", entry.getKey(), configurator.getClass()), e);
                }
            }
        }
        if (!entries.isEmpty()) {
            Map.Entry<String, CNode> next = entries.iterator().next();
            throw new ConfiguratorException(String.format("No configurator for root element <%s>", next.getKey()));
        }
    }

    private static void configureWith(Set<Map.Entry<String, CNode>> entries) throws ConfiguratorException {
        ObsoleteConfigurationMonitor monitor = ObsoleteConfigurationMonitor.get();
        monitor.reset();
        ConfigurationContext context = new ConfigurationContext();
        context.addListener(monitor::record);
        ConfigurationAsCode.invokeWith(entries, (configurator, config) -> configurator.configure(config, context));
    }

    public static Map<Source, String> checkWith(Set<Map.Entry<String, CNode>> entries) throws ConfiguratorException {
        HashMap<Source, String> issues = new HashMap<Source, String>();
        ConfigurationContext context = new ConfigurationContext();
        context.addListener((node, message) -> issues.put(node.getSource(), message));
        ConfigurationAsCode.invokeWith(entries, (configurator, config) -> configurator.check(config, context));
        return issues;
    }

    public static ConfigurationAsCode get() {
        return (ConfigurationAsCode)((Object)Jenkins.getInstance().getExtensionList(ConfigurationAsCode.class).get(0));
    }

    public Collection<?> getRootConfigurators() {
        return new LinkedHashSet<RootElementConfigurator>(RootElementConfigurator.all());
    }

    public Collection<?> getConfigurators() {
        List<RootElementConfigurator> roots = RootElementConfigurator.all();
        LinkedHashSet<Object> elements = new LinkedHashSet<Object>(roots);
        for (RootElementConfigurator root : roots) {
            this.listElements(elements, root.describe());
        }
        return elements;
    }

    private void listElements(Set<Object> elements, Set<Attribute> attributes) {
        attributes.stream().map(Attribute::getType).map(Configurator::lookup).filter(Objects::nonNull).map(Configurator::getConfigurators).flatMap(Collection::stream).forEach(configurator -> {
            if (elements.add(configurator)) {
                this.listElements(elements, ((Configurator)configurator).describe());
            }
        });
    }

    @FunctionalInterface
    private static interface ConfigratorOperation {
        public Object apply(RootElementConfigurator var1, CNode var2) throws ConfiguratorException;
    }
}

