/*
 * Decompiled with CFR 0.152.
 */
package org.jenkinsci.plugins.casc.impl.configurators;

import hudson.ExtensionList;
import java.util.logging.Logger;
import javax.annotation.CheckForNull;
import jenkins.model.Jenkins;
import org.jenkinsci.plugins.casc.BaseConfigurator;
import org.jenkinsci.plugins.casc.ConfiguratorException;
import org.jenkinsci.plugins.casc.model.CNode;
import org.jenkinsci.plugins.casc.model.Mapping;
import org.kohsuke.accmod.Restricted;
import org.kohsuke.accmod.restrictions.NoExternalUse;

@Restricted(value={NoExternalUse.class})
public class ExtensionConfigurator<T>
extends BaseConfigurator<T> {
    private static final Logger logger = Logger.getLogger(ExtensionConfigurator.class.getName());
    private final Class<T> target;

    public ExtensionConfigurator(Class<T> clazz) {
        this.target = clazz;
    }

    @Override
    public Class<T> getTarget() {
        return this.target;
    }

    @Override
    protected T instance(Mapping mapping) throws ConfiguratorException {
        ExtensionList list = Jenkins.getInstance().getExtensionList(this.target);
        if (list.size() != 1) {
            throw new ConfiguratorException("Expected a unique instance of extension " + this.target);
        }
        return (T)list.get(0);
    }

    @Override
    @CheckForNull
    public CNode describe(T instance) throws Exception {
        T ref = this.target.newInstance();
        return this.compare(instance, ref);
    }
}

