/*
 * Decompiled with CFR 0.152.
 */
package org.jenkinsci.plugins.casc;

import java.io.IOException;
import javax.annotation.CheckForNull;
import org.jenkinsci.plugins.casc.ElementConfigurator;
import org.kohsuke.accmod.Restricted;
import org.kohsuke.accmod.restrictions.Beta;

@Restricted(value={Beta.class})
public class ConfiguratorException
extends IOException {
    @CheckForNull
    private final ElementConfigurator configurator;

    public ConfiguratorException(@CheckForNull ElementConfigurator configurator, @CheckForNull String message, @CheckForNull Throwable cause) {
        super(message, cause);
        this.configurator = configurator;
    }

    public ConfiguratorException(@CheckForNull String message, @CheckForNull Throwable cause) {
        this(null, message, cause);
    }

    public ConfiguratorException(@CheckForNull ElementConfigurator configurator, @CheckForNull String message) {
        this(configurator, message, null);
    }

    public ConfiguratorException(@CheckForNull String message) {
        this(null, message, null);
    }

    public ConfiguratorException(@CheckForNull Throwable cause) {
        this(null, null, cause);
    }

    @CheckForNull
    public ElementConfigurator getConfigurator() {
        return this.configurator;
    }

    @Override
    public String getMessage() {
        if (this.configurator != null) {
            return String.format("%s: %s", this.configurator.getName(), super.getMessage());
        }
        return super.getMessage();
    }
}

