/*
 * Decompiled with CFR 0.152.
 */
package org.jenkinsci.plugins.casc;

import hudson.model.Describable;
import hudson.util.PersistedList;
import java.lang.reflect.Field;
import java.lang.reflect.GenericArrayType;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.lang.reflect.Parameter;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.lang.reflect.TypeVariable;
import java.lang.reflect.WildcardType;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.annotation.Nonnull;
import org.apache.commons.lang.StringUtils;
import org.jenkinsci.plugins.casc.Attribute;
import org.jenkinsci.plugins.casc.ConfigurationAsCode;
import org.jenkinsci.plugins.casc.Configurator;
import org.jenkinsci.plugins.casc.ConfiguratorException;
import org.jenkinsci.plugins.casc.ObsoleteConfigurationMonitor;
import org.jenkinsci.plugins.casc.impl.attributes.DescribableAttribute;
import org.jenkinsci.plugins.casc.impl.attributes.PersistedListAttribute;
import org.jenkinsci.plugins.casc.model.CNode;
import org.jenkinsci.plugins.casc.model.Mapping;
import org.kohsuke.accmod.AccessRestriction;
import org.kohsuke.accmod.Restricted;
import org.kohsuke.accmod.restrictions.Beta;
import org.kohsuke.accmod.restrictions.None;

@Restricted(value={Beta.class})
public abstract class BaseConfigurator<T>
extends Configurator<T> {
    private static final Logger logger = Logger.getLogger(BaseConfigurator.class.getName());

    @Override
    public Set<Attribute> describe() {
        HashSet<Attribute> attributes = new HashSet<Attribute>();
        for (Field field : this.getTarget().getFields()) {
            if (!Modifier.isFinal(field.getModifiers()) || !PersistedList.class.isAssignableFrom(field.getType())) continue;
            Attribute attribute = this.detectActualType(field.getName(), TypePair.of(field));
            attributes.add(attribute);
        }
        Class target = this.getTarget();
        for (Method method : target.getMethods()) {
            TypePair type;
            String methodName = method.getName();
            if (method.getParameterCount() == 0 && methodName.startsWith("get") && PersistedList.class.isAssignableFrom(method.getReturnType())) {
                type = TypePair.ofReturnType(method);
            } else {
                if (method.getParameterCount() != 1 || !methodName.startsWith("set")) continue;
                type = TypePair.ofParameter(method, 0);
            }
            String name = StringUtils.uncapitalize((String)methodName.substring(3));
            logger.log(Level.FINER, "Processing {0} property", name);
            Attribute attribute = this.detectActualType(name, type);
            if (attribute == null) continue;
            attributes.add(attribute);
            attribute.deprecated(method.getAnnotation(Deprecated.class) != null);
            Restricted r = method.getAnnotation(Restricted.class);
            if (r == null) continue;
            attribute.restrictions(r.value());
        }
        return attributes;
    }

    protected Attribute detectActualType(String name, TypePair type) {
        Attribute attribute;
        Class c = this.introspectActualClass(type);
        if (c == null) {
            throw new IllegalStateException("Unable to detect type of attribute " + this.getTarget() + '#' + name);
        }
        if (PersistedList.class.isAssignableFrom(type.rawType)) {
            return new PersistedListAttribute(name, c);
        }
        if (!c.isPrimitive() && !c.isEnum() && Modifier.isAbstract(c.getModifiers())) {
            if (!Describable.class.isAssignableFrom(c)) {
                return null;
            }
            attribute = new DescribableAttribute(name, (Class<? extends Describable>)c);
        } else {
            attribute = new Attribute(name, c);
        }
        boolean multiple = type.rawType.isArray() || Collection.class.isAssignableFrom(type.rawType);
        attribute.multiple(multiple);
        return attribute;
    }

    private Class introspectActualClass(TypePair type) {
        Type superclass;
        Class c = null;
        Type t = type.type;
        Class raw = type.rawType;
        while (t instanceof Class) {
            superclass = ((Class)t).getGenericSuperclass();
            if (superclass == null) {
                t = raw;
                break;
            }
            t = superclass;
        }
        if (t instanceof GenericArrayType) {
            GenericArrayType at = (GenericArrayType)t;
            t = at.getGenericComponentType();
        }
        while (t instanceof ParameterizedType) {
            ParameterizedType pt = (ParameterizedType)t;
            if (!((t = pt.getActualTypeArguments()[0]) instanceof WildcardType) || (t = ((WildcardType)t).getUpperBounds()[0]) != Object.class) continue;
            t = pt.getRawType();
        }
        while (c == null) {
            if (t instanceof Class) {
                c = (Class)t;
                continue;
            }
            if (t instanceof TypeVariable) {
                superclass = this.getTarget().getGenericSuperclass();
                if (superclass instanceof ParameterizedType) {
                    ParameterizedType psc = (ParameterizedType)superclass;
                    t = psc.getActualTypeArguments()[0];
                    continue;
                }
                c = (Class)((TypeVariable)t).getBounds()[0];
                TypeVariable typeVariable = (TypeVariable)t;
                continue;
            }
            return null;
        }
        if (c.isArray()) {
            c = c.getComponentType();
        }
        return c;
    }

    protected abstract T instance(Mapping var1) throws ConfiguratorException;

    @Override
    @Nonnull
    public T configure(CNode c) throws ConfiguratorException {
        Mapping mapping = c != null ? c.asMapping() : Mapping.EMPTY;
        T instance = this.instance(mapping);
        this.configure(mapping, instance, false);
        return instance;
    }

    @Override
    public T check(CNode c) throws ConfiguratorException {
        Mapping mapping = c != null ? c.asMapping() : Mapping.EMPTY;
        T instance = this.instance(mapping);
        this.configure(mapping, instance, true);
        return instance;
    }

    protected final void configure(Mapping config, T instance, boolean dryrun) throws ConfiguratorException {
        Set<Attribute> attributes = this.describe();
        ConfigurationAsCode casc = ConfigurationAsCode.get();
        for (Attribute attribute : attributes) {
            Object valueToSet;
            String name = attribute.getName();
            CNode sub = this.removeIgnoreCase(config, name);
            if (sub == null) {
                for (String alias : attribute.aliases) {
                    sub = this.removeIgnoreCase(config, alias);
                    if (sub == null) continue;
                    ObsoleteConfigurationMonitor.get().record(sub, "'" + alias + "' is an obsolete attribute name, please use '" + name + "'");
                    break;
                }
            }
            if (sub == null) continue;
            if (attribute.isDeprecated()) {
                ObsoleteConfigurationMonitor.get().record(config, "'" + attribute.getName() + "' is deprecated");
                if (casc.getDeprecation() == ConfigurationAsCode.Deprecation.reject) {
                    throw new ConfiguratorException("'" + attribute.getName() + "' is deprecated");
                }
            }
            for (Class<AccessRestriction> r : attribute.getRestrictions()) {
                if (r == None.class || r == Beta.class && casc.getRestricted() == ConfigurationAsCode.Restricted.beta) continue;
                ObsoleteConfigurationMonitor.get().record(config, "'" + attribute.getName() + "' is restricted: " + r.getSimpleName());
                if (casc.getRestricted() != ConfigurationAsCode.Restricted.reject) continue;
                throw new ConfiguratorException("'" + attribute.getName() + "' is restricted: " + r.getSimpleName());
            }
            Class k = attribute.getType();
            Configurator configurator = Configurator.lookupOrFail(k);
            if (attribute.isMultiple()) {
                ArrayList values = new ArrayList();
                for (CNode o : sub.asSequence()) {
                    Object value = configurator.configure(o);
                    values.add(value);
                }
                valueToSet = values;
            } else {
                valueToSet = configurator.configure(sub);
            }
            if (dryrun) continue;
            try {
                logger.info("Setting " + instance + '.' + name + " = " + (sub.isSensitiveData() ? "****" : valueToSet));
                attribute.setValue(instance, valueToSet);
            }
            catch (Exception ex) {
                throw new ConfiguratorException(configurator, "Failed to set attribute " + attribute, ex);
            }
        }
        this.handleUnknown(config);
    }

    protected final void handleUnknown(Mapping config) throws ConfiguratorException {
        if (!config.isEmpty()) {
            String invalid = StringUtils.join(config.keySet(), (char)',');
            String message = "Invalid configuration elements for type " + this.getTarget() + " : " + invalid;
            ObsoleteConfigurationMonitor.get().record(config, message);
            switch (ConfigurationAsCode.get().getUnknown()) {
                case reject: {
                    throw new ConfiguratorException(message);
                }
                case warn: {
                    logger.warning(message);
                }
            }
        }
    }

    protected Mapping compare(T o1, T o2) throws Exception {
        Mapping mapping = new Mapping();
        for (Attribute attribute : this.describe()) {
            if (attribute.equals(o1, o2)) continue;
            mapping.put(attribute.getName(), attribute.describe(o1));
        }
        return mapping;
    }

    private CNode removeIgnoreCase(Mapping config, String name) {
        for (String k : config.keySet()) {
            if (!name.equalsIgnoreCase(k)) continue;
            return (CNode)config.remove(k);
        }
        return null;
    }

    @Restricted(value={Beta.class})
    public static final class TypePair {
        final Type type;
        final Class rawType;

        public TypePair(Type type, Class rawType) {
            this.rawType = rawType;
            this.type = type;
        }

        static TypePair ofReturnType(Method method) {
            return new TypePair(method.getGenericReturnType(), method.getReturnType());
        }

        static TypePair ofParameter(Method method, int index) {
            assert (method.getParameterCount() > index);
            return new TypePair(method.getGenericParameterTypes()[index], method.getParameterTypes()[index]);
        }

        public static TypePair of(Parameter parameter) {
            return new TypePair(parameter.getParameterizedType(), parameter.getType());
        }

        public static TypePair of(Field field) {
            return new TypePair(field.getGenericType(), field.getType());
        }
    }
}

