/*
 * Decompiled with CFR 0.152.
 */
package com.outsystems.plugins.barcode.controller.helper;

import android.graphics.Bitmap;
import android.graphics.Matrix;
import android.util.Log;
import androidx.compose.runtime.internal.StabilityInferred;
import com.google.zxing.Binarizer;
import com.google.zxing.BinaryBitmap;
import com.google.zxing.LuminanceSource;
import com.google.zxing.MultiFormatReader;
import com.google.zxing.NotFoundException;
import com.google.zxing.RGBLuminanceSource;
import com.google.zxing.Result;
import com.google.zxing.common.HybridBinarizer;
import com.outsystems.plugins.barcode.controller.helper.OSBARCZXingHelperInterface;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u00008\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u0015\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u0007\u0018\u0000 \u00132\u00020\u0001:\u0001\u0013B\u0005\u00a2\u0006\u0002\u0010\u0002JB\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\b2\u0012\u0010\n\u001a\u000e\u0012\u0004\u0012\u00020\f\u0012\u0004\u0012\u00020\u00040\u000b2\f\u0010\r\u001a\b\u0012\u0004\u0012\u00020\u00040\u000eH\u0016J\u0018\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u00102\u0006\u0010\u0012\u001a\u00020\bH\u0016\u00a8\u0006\u0014"}, d2={"Lcom/outsystems/plugins/barcode/controller/helper/OSBARCZXingHelper;", "Lcom/outsystems/plugins/barcode/controller/helper/OSBARCZXingHelperInterface;", "()V", "decodeImage", "", "pixels", "", "width", "", "height", "onSuccess", "Lkotlin/Function1;", "", "onError", "Lkotlin/Function0;", "rotateBitmap", "Landroid/graphics/Bitmap;", "bitmap", "rotationDegrees", "Companion", "OSBarcodeLib_release"})
@StabilityInferred(parameters=1)
@SourceDebugExtension(value={"SMAP\nOSBARCZXingHelper.kt\nKotlin\n*S Kotlin\n*F\n+ 1 OSBARCZXingHelper.kt\ncom/outsystems/plugins/barcode/controller/helper/OSBARCZXingHelper\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,72:1\n1#2:73\n*E\n"})
public final class OSBARCZXingHelper
implements OSBARCZXingHelperInterface {
    @NotNull
    public static final Companion Companion = new Companion(null);
    public static final int $stable;
    @NotNull
    private static final String LOG_TAG = "OSBARCZXingHelper";

    @Override
    @NotNull
    public Bitmap rotateBitmap(@NotNull Bitmap bitmap, int rotationDegrees) {
        Intrinsics.checkNotNullParameter((Object)bitmap, (String)"bitmap");
        Matrix matrix = new Matrix();
        matrix.postRotate((float)rotationDegrees);
        Bitmap bitmap2 = Bitmap.createBitmap((Bitmap)bitmap, (int)0, (int)0, (int)bitmap.getWidth(), (int)bitmap.getHeight(), (Matrix)matrix, (boolean)true);
        Intrinsics.checkNotNullExpressionValue((Object)bitmap2, (String)"createBitmap(...)");
        return bitmap2;
    }

    @Override
    public void decodeImage(@NotNull int[] pixels, int width, int height, @NotNull Function1<? super String, Unit> onSuccess, @NotNull Function0<Unit> onError) {
        Intrinsics.checkNotNullParameter((Object)pixels, (String)"pixels");
        Intrinsics.checkNotNullParameter(onSuccess, (String)"onSuccess");
        Intrinsics.checkNotNullParameter(onError, (String)"onError");
        try {
            RGBLuminanceSource source = new RGBLuminanceSource(width, height, pixels);
            BinaryBitmap binaryBitmap = new BinaryBitmap((Binarizer)new HybridBinarizer((LuminanceSource)source));
            Result result = new MultiFormatReader().decodeWithState(binaryBitmap);
            String string = result.getText();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getText(...)");
            onSuccess.invoke((Object)string);
        }
        catch (NotFoundException e) {
            String string = e.getMessage();
            if (string != null) {
                String it = string;
                boolean bl = false;
                Log.d((String)LOG_TAG, (String)it);
            }
        }
        catch (Exception e) {
            String string = e.getMessage();
            if (string != null) {
                String it = string;
                boolean bl = false;
                Log.e((String)LOG_TAG, (String)it);
            }
            onError.invoke();
        }
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0005"}, d2={"Lcom/outsystems/plugins/barcode/controller/helper/OSBARCZXingHelper$Companion;", "", "()V", "LOG_TAG", "", "OSBarcodeLib_release"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

