/*
 * Decompiled with CFR 0.152.
 */
package io.intercom.android.nexus;

import io.intercom.android.nexus.NexusEvent;
import java.util.List;
import java.util.UUID;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

public enum NexusEventType {
    NewComment{

        @Override
        protected JSONObject toJsonObject(NexusEvent nexusEvent) throws JSONException {
            JSONObject event = super.toJsonObject(nexusEvent);
            event.put("nx.ToUser", (Object)nexusEvent.getUserId());
            return event;
        }
    }
    ,
    NewContent{

        @Override
        protected JSONObject toJsonObject(NexusEvent nexusEvent) throws JSONException {
            JSONObject event = super.toJsonObject(nexusEvent);
            event.put("nx.ToUser", (Object)nexusEvent.getUserId());
            return event;
        }
    }
    ,
    ConversationSeen{

        @Override
        protected JSONObject toJsonObject(NexusEvent nexusEvent) throws JSONException {
            JSONObject event = super.toJsonObject(nexusEvent);
            event.put("nx.FromUser", (Object)nexusEvent.getUserId());
            return event;
        }
    }
    ,
    UserIsTyping{

        @Override
        protected JSONObject toJsonObject(NexusEvent nexusEvent) throws JSONException {
            JSONObject event = super.toJsonObject(nexusEvent);
            event.put("nx.FromUser", (Object)nexusEvent.getUserId());
            return event;
        }
    }
    ,
    AdminIsTyping{

        @Override
        protected JSONObject toJsonObject(NexusEvent nexusEvent) throws JSONException {
            JSONObject event = super.toJsonObject(nexusEvent);
            JSONObject eventData = event.optJSONObject("eventData");
            eventData.put("adminName", (Object)nexusEvent.getEventData().optString("adminName"));
            eventData.put("adminId", (Object)nexusEvent.getEventData().optString("adminId"));
            eventData.put("adminAvatar", (Object)nexusEvent.getEventData().optString("adminAvatar"));
            event.put("nx.ToUser", (Object)nexusEvent.getUserId());
            return event;
        }
    }
    ,
    AdminIsTypingANote{

        @Override
        protected JSONObject toJsonObject(NexusEvent nexusEvent) throws JSONException {
            JSONObject event = super.toJsonObject(nexusEvent);
            JSONObject eventData = event.optJSONObject("eventData");
            eventData.put("adminName", (Object)nexusEvent.getEventData().optString("adminName"));
            eventData.put("adminId", (Object)nexusEvent.getEventData().optString("adminId"));
            eventData.put("adminAvatar", (Object)nexusEvent.getEventData().optString("adminAvatar"));
            event.put("nx.ToUser", (Object)nexusEvent.getUserId());
            return event;
        }
    }
    ,
    NewNote{

        @Override
        protected JSONObject toJsonObject(NexusEvent nexusEvent) throws JSONException {
            JSONObject event = super.toJsonObject(nexusEvent);
            JSONObject eventData = event.optJSONObject("eventData");
            eventData.put("adminId", (Object)nexusEvent.getEventData().optString("adminId"));
            return event;
        }
    }
    ,
    ConversationAssigned{

        @Override
        protected JSONObject toJsonObject(NexusEvent nexusEvent) throws JSONException {
            JSONObject event = super.toJsonObject(nexusEvent);
            JSONObject eventData = event.optJSONObject("eventData");
            eventData.put("adminId", (Object)nexusEvent.getEventData().optString("adminId"));
            eventData.put("assigneeId", (Object)nexusEvent.getEventData().optString("assigneeId"));
            return event;
        }
    }
    ,
    ConversationClosed{

        @Override
        protected JSONObject toJsonObject(NexusEvent nexusEvent) throws JSONException {
            JSONObject event = super.toJsonObject(nexusEvent);
            JSONObject eventData = event.optJSONObject("eventData");
            eventData.put("adminId", (Object)nexusEvent.getEventData().optString("adminId"));
            return event;
        }
    }
    ,
    ConversationReopened{

        @Override
        protected JSONObject toJsonObject(NexusEvent nexusEvent) throws JSONException {
            JSONObject event = super.toJsonObject(nexusEvent);
            JSONObject eventData = event.getJSONObject("eventData");
            eventData.put("adminId", (Object)nexusEvent.getEventData().optString("adminId"));
            return event;
        }
    }
    ,
    ConversationTitleGenerated{

        @Override
        protected JSONObject toJsonObject(NexusEvent nexusEvent) throws JSONException {
            JSONObject event = super.toJsonObject(nexusEvent);
            JSONObject eventData = event.getJSONObject("eventData");
            eventData.put("title", (Object)nexusEvent.getEventData().optString("title"));
            event.put("nx.ToUser", (Object)nexusEvent.getUserId());
            return event;
        }
    }
    ,
    UserPresence{

        @Override
        protected JSONObject toJsonObject(NexusEvent nexusEvent) throws JSONException {
            JSONObject event = new JSONObject();
            JSONObject eventData = new JSONObject();
            event.put("eventGuid", (Object)UUID.randomUUID().toString());
            event.put("eventName", (Object)("nx." + this.name()));
            event.put("eventData", (Object)eventData);
            return event;
        }
    }
    ,
    Ping{

        @Override
        protected JSONObject toJsonObject(NexusEvent nexusEvent) throws JSONException {
            JSONObject event = new JSONObject();
            JSONObject eventData = new JSONObject();
            event.put("eventGuid", (Object)UUID.randomUUID().toString());
            event.put("eventName", (Object)("nx." + this.name()));
            event.put("eventData", (Object)eventData);
            return event;
        }
    }
    ,
    UserContentSeenByAdmin{

        @Override
        protected JSONObject toJsonObject(NexusEvent nexusEvent) throws JSONException {
            JSONObject event = super.toJsonObject(nexusEvent);
            event.put("nx.ToUser", (Object)nexusEvent.getUserId());
            return event;
        }
    }
    ,
    Subscribe{

        @Override
        protected JSONObject toJsonObject(NexusEvent nexusEvent) throws JSONException {
            JSONObject event = super.toJsonObject(nexusEvent);
            event.put("eventName", (Object)("nx." + this.name()));
            return event;
        }
    }
    ,
    Unsubscribe{

        @Override
        protected JSONObject toJsonObject(NexusEvent nexusEvent) throws JSONException {
            JSONObject event = super.toJsonObject(nexusEvent);
            event.put("eventName", (Object)("nx." + this.name()));
            return event;
        }
    }
    ,
    ThreadAssigned{

        @Override
        protected JSONObject toJsonObject(NexusEvent nexusEvent) throws JSONException {
            JSONObject event = super.toJsonObject(nexusEvent);
            JSONObject eventData = event.optJSONObject("eventData");
            eventData.put("adminId", (Object)nexusEvent.getEventData().optString("adminId"));
            eventData.put("assigneeId", (Object)nexusEvent.getEventData().optString("assigneeId"));
            return event;
        }
    }
    ,
    ThreadClosed{

        @Override
        protected JSONObject toJsonObject(NexusEvent nexusEvent) throws JSONException {
            JSONObject event = super.toJsonObject(nexusEvent);
            JSONObject eventData = event.optJSONObject("eventData");
            eventData.put("adminId", (Object)nexusEvent.getEventData().optString("adminId"));
            return event;
        }
    }
    ,
    ThreadReopened{

        @Override
        protected JSONObject toJsonObject(NexusEvent nexusEvent) throws JSONException {
            JSONObject event = super.toJsonObject(nexusEvent);
            JSONObject eventData = event.getJSONObject("eventData");
            eventData.put("adminId", (Object)nexusEvent.getEventData().optString("adminId"));
            return event;
        }
    }
    ,
    ThreadUpdated{

        @Override
        protected JSONObject toJsonObject(NexusEvent nexusEvent) throws JSONException {
            JSONObject event = super.toJsonObject(nexusEvent);
            JSONObject eventData = event.getJSONObject("eventData");
            eventData.put("adminId", (Object)nexusEvent.getEventData().optString("adminId"));
            return event;
        }
    }
    ,
    ThreadCreated{

        @Override
        protected JSONObject toJsonObject(NexusEvent nexusEvent) throws JSONException {
            JSONObject event = super.toJsonObject(nexusEvent);
            event.put("nx.ToUser", (Object)nexusEvent.getUserId());
            return event;
        }
    }
    ,
    ConversationPartToken{

        @Override
        protected JSONObject toJsonObject(NexusEvent nexusEvent) throws JSONException {
            JSONObject event = super.toJsonObject(nexusEvent);
            JSONObject eventData = event.getJSONObject("eventData");
            eventData.put("blocks", nexusEvent.getEventData().get("blocks"));
            eventData.put("partType", (Object)nexusEvent.getEventData().optString("partType"));
            eventData.put("clientAssignedUuid", (Object)nexusEvent.getEventData().optString("clientAssignedUuid"));
            eventData.put("tokenSequenceIndex", (Object)nexusEvent.getEventData().optString("tokenSequenceIndex"));
            return event;
        }
    }
    ,
    UNKNOWN{

        @Override
        protected String toStringEncodedJsonObject(NexusEvent nexusEvent) {
            return "";
        }
    };


    protected String toStringEncodedJsonObject(NexusEvent nexusEvent) {
        try {
            return this.toJsonObject(nexusEvent).toString();
        }
        catch (JSONException e) {
            return "";
        }
    }

    protected JSONObject toJsonObject(NexusEvent nexusEvent) throws JSONException {
        JSONObject event = new JSONObject();
        JSONObject eventData = new JSONObject();
        eventData.put("conversationId", (Object)nexusEvent.getEventData().optString("conversationId"));
        event.put("eventGuid", (Object)nexusEvent.getGuid());
        event.put("eventName", (Object)this.name());
        event.put("eventData", (Object)eventData);
        List<String> topics = nexusEvent.getTopics();
        if (!topics.isEmpty()) {
            event.put("nx.Topics", (Object)new JSONArray(topics));
        }
        return event;
    }

    public static NexusEventType safeValueOf(String name) {
        try {
            return NexusEventType.valueOf(name);
        }
        catch (Exception e) {
            return UNKNOWN;
        }
    }
}

