/*
 * Decompiled with CFR 0.152.
 */
package io.intercom.android.sdk.identity;

import android.content.Context;
import android.content.SharedPreferences;
import io.intercom.android.sdk.models.api.User;
import java.util.HashMap;
import java.util.Map;
import java.util.UUID;

public class UserIdentity {
    public static final String ANONYMOUS_ID = "INTERCOM_SDK_ANONYMOUS_ID";
    public static final String INTERCOM_ID = "INTERCOM_SDK_INTERCOM_ID";
    public static final String USER_ID = "INTERCOM_SDK_USER_ID";
    public static final String EMAIL_ID = "INTERCOM_SDK_EMAIL_ID";
    private static final String type = "user";
    private final SharedPreferences prefs;
    private String data;
    private String hmac;
    private String anonymousId;
    private String intercomId;
    private String userId;
    private String email;
    private String fingerprint = "";

    public UserIdentity(Context context) {
        this.prefs = context.getSharedPreferences("INTERCOM_SDK_USER_PREFS", 0);
        this.anonymousId = this.prefs.getString("intercomsdk-session-INTERCOM_SDK_ANONYMOUS_ID", "");
        this.intercomId = this.prefs.getString("intercomsdk-session-INTERCOM_SDK_INTERCOM_ID", "");
        this.userId = this.prefs.getString("intercomsdk-session-INTERCOM_SDK_USER_ID", "");
        this.email = this.prefs.getString("intercomsdk-session-INTERCOM_SDK_EMAIL_ID", "");
        this.data = this.prefs.getString("intercomsdk-session-SecureMode_Data", "");
        this.hmac = this.prefs.getString("intercomsdk-session-SecureMode_HMAC", "");
        if (this.identityExists()) {
            this.fingerprint = this.generateFingerprint();
        }
    }

    protected boolean register(String userId, String email, String intercomId) {
        boolean shouldRegisterUser;
        boolean bl = shouldRegisterUser = !this.isIdentifiedUser();
        if (shouldRegisterUser) {
            SharedPreferences.Editor editor = this.prefs.edit();
            this.intercomId = "";
            editor.putString("intercomsdk-session-INTERCOM_SDK_INTERCOM_ID", intercomId);
            if (!userId.isEmpty()) {
                this.userId = userId;
                editor.putString("intercomsdk-session-INTERCOM_SDK_USER_ID", userId);
            }
            if (!email.isEmpty()) {
                this.email = email;
                editor.putString("intercomsdk-session-INTERCOM_SDK_EMAIL_ID", email);
            }
            if (!intercomId.isEmpty()) {
                this.intercomId = intercomId;
                editor.putString("intercomsdk-session-INTERCOM_SDK_INTERCOM_ID", intercomId);
            }
            editor.apply();
            if (this.fingerprint.isEmpty()) {
                this.fingerprint = this.generateFingerprint();
            }
        }
        return shouldRegisterUser;
    }

    protected boolean registerUnidentified() {
        if (this.isEmpty()) {
            SharedPreferences.Editor editor = this.prefs.edit();
            this.anonymousId = UUID.randomUUID().toString();
            editor.putString("intercomsdk-session-INTERCOM_SDK_ANONYMOUS_ID", this.anonymousId);
            editor.apply();
            if (this.fingerprint.isEmpty()) {
                this.fingerprint = this.generateFingerprint();
            }
        }
        return !this.isEmpty();
    }

    protected void update(User user) {
        SharedPreferences.Editor editor = this.prefs.edit();
        this.userId = user.getUserId();
        editor.putString("intercomsdk-session-INTERCOM_SDK_USER_ID", this.userId);
        this.email = user.getEmail();
        editor.putString("intercomsdk-session-INTERCOM_SDK_EMAIL_ID", this.email);
        if (!user.getIntercomId().isEmpty()) {
            this.intercomId = user.getIntercomId();
            editor.putString("intercomsdk-session-INTERCOM_SDK_INTERCOM_ID", this.intercomId);
        }
        this.anonymousId = user.getAnonymousId();
        editor.putString("intercomsdk-session-INTERCOM_SDK_ANONYMOUS_ID", this.anonymousId);
        editor.apply();
    }

    protected void setSecureMode(String hmac, String data) {
        this.data = data;
        this.hmac = hmac;
        SharedPreferences.Editor editor = this.prefs.edit();
        editor.putString("intercomsdk-session-SecureMode_Data", data);
        editor.putString("intercomsdk-session-SecureMode_HMAC", hmac);
        editor.apply();
    }

    protected String getData() {
        return this.data;
    }

    protected String getHmac() {
        return this.hmac;
    }

    protected String getIntercomId() {
        return this.intercomId;
    }

    protected String getFingerprint() {
        return this.fingerprint;
    }

    protected boolean isEmpty() {
        return this.anonymousId.isEmpty() && this.email.isEmpty() && this.userId.isEmpty() && this.intercomId.isEmpty();
    }

    protected boolean identityExists() {
        return !this.email.isEmpty() || !this.userId.isEmpty() || !this.intercomId.isEmpty() || !this.anonymousId.isEmpty();
    }

    protected boolean isIdentifiedUser() {
        return this.identityExists() && !this.isAnonymous();
    }

    protected boolean isAnonymous() {
        return !this.anonymousId.isEmpty() && this.email.isEmpty() && this.userId.isEmpty();
    }

    protected void clear() {
        this.prefs.edit().clear().commit();
        this.anonymousId = "";
        this.intercomId = "";
        this.userId = "";
        this.email = "";
        this.data = "";
        this.hmac = "";
        this.fingerprint = "";
    }

    protected Map<String, Object> toMap() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        if (!this.anonymousId.isEmpty()) {
            map.put("anonymous_id", this.anonymousId);
        } else if (!this.intercomId.isEmpty()) {
            map.put("intercom_id", this.intercomId);
        }
        if (!this.userId.isEmpty()) {
            map.put("user_id", this.userId);
        }
        if (!this.email.isEmpty()) {
            map.put("email", this.email);
        }
        if (!type.isEmpty()) {
            map.put("type", type);
        }
        return map;
    }

    private String generateFingerprint() {
        return UUID.randomUUID().toString();
    }
}

