/*
 * Decompiled with CFR 0.152.
 */
package io.intercom.android.sdk.models.api.response;

import android.os.Parcel;
import android.os.Parcelable;
import android.widget.LinearLayout;
import io.intercom.android.blocks.models.Block;
import io.intercom.android.sdk.annotations.Exclude;
import io.intercom.android.sdk.models.Attachments;
import io.intercom.android.sdk.models.api.LWR;
import io.intercom.android.sdk.models.api.Participant;
import java.util.ArrayList;
import java.util.List;

public class Part
implements Parcelable {
    public static final String ANNOUNCEMENT_MESSAGE_STYLE = "announcement";
    public static final String SMALL_ANNOUNCEMENT_MESSAGE_STYLE = "small-announcement";
    public static final String CHAT_MESSAGE_STYLE = "chat";
    public static final String FAILED_MESSAGE_STYLE = "intercom_failed_message_style";
    public static final String SENDING_MESSAGE_STYLE = "intercom_sending_message_style";
    public static final String WELCOME_MESSAGE_STYLE = "intercom_welcome_message";
    public static final String POWERED_BY_STYLE = "intercom_powered_by";
    public static final String ADMIN_IS_TYPING_STYLE = "admin_is_typing_style";
    private String id;
    private String participantId;
    private boolean participantIsAdmin;
    private List<Block> blocks;
    private List<Attachments> attachments;
    private String messageStyle;
    private long createdAt;
    private String summary;
    private LWR lightweightReply;
    private Participant participant;
    private String footer;
    private boolean firstChatPart;
    private boolean displayDelivered;
    private boolean entranceAnimation;
    @Exclude
    private LinearLayout layout;
    public static final Parcelable.Creator<Part> CREATOR = new Parcelable.Creator<Part>(){

        public Part createFromParcel(Parcel in) {
            return new Part(in);
        }

        public Part[] newArray(int size) {
            return new Part[size];
        }
    };

    public Part() {
        this(new Builder());
    }

    private Part(Builder builder) {
        this.id = builder.id == null ? "" : builder.id;
        this.participant = new Participant.NullParticipant();
        this.participantId = builder.participant_id == null ? "" : builder.participant_id;
        this.participantIsAdmin = builder.participant_is_admin;
        this.summary = builder.summary == null ? "" : builder.summary;
        this.createdAt = builder.created_at;
        this.messageStyle = builder.message_style == null ? "" : builder.message_style;
        this.blocks = new ArrayList<Block>();
        if (builder.body != null) {
            for (Block.Builder blockBuilder : builder.body) {
                this.blocks.add(blockBuilder.build());
            }
        }
        this.lightweightReply = builder.lightweight_reply == null ? new LWR.NullLWR() : builder.lightweight_reply.build();
        this.attachments = builder.attachments == null ? new ArrayList() : builder.attachments;
        this.footer = "";
        this.displayDelivered = false;
        this.entranceAnimation = false;
        this.firstChatPart = false;
    }

    public String getId() {
        return this.id;
    }

    public void setId(String id2) {
        this.id = id2;
    }

    public String getParticipantId() {
        return this.participantId;
    }

    public boolean isAdmin() {
        return this.participantIsAdmin;
    }

    public List<Block> getBlocks() {
        return this.blocks;
    }

    public void setBlocks(List<Block> blocks) {
        this.blocks = blocks;
    }

    public List<Attachments> getAttachments() {
        return this.attachments;
    }

    public void setAttachments(List<Attachments> attachments) {
        this.attachments = attachments;
    }

    public String getMessageStyle() {
        return this.messageStyle;
    }

    public void setMessageStyle(String messageStyle) {
        this.messageStyle = messageStyle;
    }

    public long getCreatedAt() {
        return this.createdAt;
    }

    public void setCreatedAt(long createdAt) {
        this.createdAt = createdAt;
    }

    public String getSummary() {
        return this.summary;
    }

    public LWR getLightweightReply() {
        return this.lightweightReply;
    }

    public Participant getParticipant() {
        return this.participant;
    }

    public void setParticipant(Participant participant) {
        this.participant = participant;
        this.participantId = participant.getId();
    }

    public LinearLayout getLayout() {
        return this.layout;
    }

    public void setLayout(LinearLayout layout2) {
        this.layout = layout2;
    }

    public String getFooter() {
        return this.footer;
    }

    public void setFooter(String footer) {
        this.footer = footer;
    }

    public boolean isDisplayDelivered() {
        return this.displayDelivered;
    }

    public void setDisplayDelivered(boolean displayDelivered) {
        this.displayDelivered = displayDelivered;
    }

    public boolean hasEntranceAnimation() {
        return this.entranceAnimation;
    }

    public void setEntranceAnimation(boolean entranceAnimation) {
        this.entranceAnimation = entranceAnimation;
    }

    public boolean isFirstChatPart() {
        return this.firstChatPart;
    }

    public void setFirstChatPart(boolean firstChatPart) {
        this.firstChatPart = firstChatPart;
    }

    protected Part(Parcel in) {
        this.id = in.readString();
        this.participantId = in.readString();
        boolean bl = this.participantIsAdmin = in.readByte() != 0;
        if (in.readByte() == 1) {
            this.blocks = new ArrayList<Block>();
            in.readList(this.blocks, Block.class.getClassLoader());
        } else {
            this.blocks = null;
        }
        if (in.readByte() == 1) {
            this.attachments = new ArrayList<Attachments>();
            in.readList(this.attachments, Attachments.class.getClassLoader());
        } else {
            this.attachments = null;
        }
        this.messageStyle = in.readString();
        this.createdAt = in.readLong();
        this.summary = in.readString();
        boolean isNullLwr = in.readByte() == 0;
        this.lightweightReply = isNullLwr ? new LWR.NullLWR() : (LWR)in.readValue(LWR.class.getClassLoader());
        this.participant = (Participant)in.readValue(Participant.class.getClassLoader());
        this.footer = in.readString();
    }

    public int describeContents() {
        return 0;
    }

    public void writeToParcel(Parcel dest, int flags) {
        dest.writeString(this.id);
        dest.writeString(this.participantId);
        dest.writeByte((byte)(this.participantIsAdmin ? 1 : 0));
        if (this.blocks == null) {
            dest.writeByte((byte)0);
        } else {
            dest.writeByte((byte)1);
            dest.writeList(this.blocks);
        }
        if (this.attachments == null) {
            dest.writeByte((byte)0);
        } else {
            dest.writeByte((byte)1);
            dest.writeList(this.attachments);
        }
        dest.writeString(this.messageStyle);
        dest.writeLong(this.createdAt);
        dest.writeString(this.summary);
        if (this.lightweightReply instanceof LWR.NullLWR) {
            dest.writeByte((byte)0);
        } else {
            dest.writeByte((byte)1);
            dest.writeValue((Object)this.lightweightReply);
        }
        dest.writeValue((Object)this.participant);
        dest.writeString(this.footer);
    }

    public int hashCode() {
        return this.id.hashCode();
    }

    public boolean equals(Object o) {
        if (o instanceof Part) {
            Part otherPart = (Part)o;
            return this.id.equals(otherPart.id);
        }
        return false;
    }

    public static final class NullPart
    extends Part {
        public NullPart() {
            super(new Builder());
        }
    }

    public static final class Builder {
        private String id;
        private String participant_id;
        private boolean participant_is_admin;
        private List<Block.Builder> body;
        private List<Attachments> attachments;
        private String message_style;
        private long created_at;
        private String summary;
        private LWR.Builder lightweight_reply;

        public Part build() {
            return new Part(this);
        }
    }
}

