/*
 * Decompiled with CFR 0.152.
 */
package io.intercom.android.sdk.blocks;

import android.content.Context;
import android.graphics.Color;
import android.text.Html;
import android.text.method.MovementMethod;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.LinearLayout;
import android.widget.TextView;
import io.intercom.android.blocks.blockInterfaces.OrderedListBlock;
import io.intercom.android.sdk.Bridge;
import io.intercom.android.sdk.R;
import io.intercom.android.sdk.blocks.StyleType;
import io.intercom.android.sdk.utilities.BlockUtils;
import io.intercom.android.sdk.utilities.TrackingLinkMovementMethod;
import java.util.List;

public class OrderedList
implements OrderedListBlock {
    private final LayoutInflater inflater;
    private final StyleType style;
    private final Context context;

    public OrderedList(Context context, StyleType style) {
        this.context = context;
        this.style = style;
        this.inflater = LayoutInflater.from((Context)context);
    }

    public View addOrderedList(List<String> items, boolean isFirstObject, boolean isLastObject, ViewGroup parent) {
        TextView textview;
        LinearLayout layout2 = new LinearLayout(this.context);
        switch (this.style) {
            case ADMIN: 
            case ANNOUNCEMENT: {
                textview = (TextView)this.inflater.inflate(R.layout.intercomsdk_blocks_admin_orderedlist, parent, false);
                break;
            }
            case WELCOME: {
                layout2 = (LinearLayout)this.inflater.inflate(R.layout.intercomsdk_blocks_welcome_list, parent, false);
                textview = (TextView)layout2.findViewById(R.id.list);
                break;
            }
            default: {
                textview = (TextView)this.inflater.inflate(R.layout.intercomsdk_blocks_user_orderedlist, parent, false);
            }
        }
        String text = "";
        for (int i = 0; i < items.size(); ++i) {
            String item = items.get(i);
            text = text + (i + 1) + ". " + item + "<br/>";
        }
        textview.setClickable(true);
        textview.setMovementMethod((MovementMethod)new TrackingLinkMovementMethod());
        textview.setText((CharSequence)Html.fromHtml((String)text));
        BlockUtils.setLayoutMarginsAndGravity((View)textview, 3, isLastObject);
        if (StyleType.WELCOME == this.style) {
            return layout2;
        }
        textview.setLinkTextColor(Color.parseColor((String)Bridge.getIdentityStore().getAppConfig().getBaseColor()));
        return textview;
    }
}

