/*
 * Decompiled with CFR 0.152.
 */
package io.intercom.android.sdk.utilities;

import android.content.ActivityNotFoundException;
import android.content.Context;
import android.content.Intent;
import android.net.Uri;
import io.intercom.android.sdk.Bridge;
import io.intercom.android.sdk.logger.Logger;

public class LinkUtil {
    public static void openUrl(String trackingUrl, Context context) {
        Uri targetUri;
        if (Uri.parse((String)trackingUrl).getScheme() != null) {
            Bridge.getApi().hitTrackingUrl(trackingUrl);
        }
        Intent intent = "mailto".equals((targetUri = LinkUtil.getTargetUriFromTrackingUrl(trackingUrl)).getScheme()) ? new Intent("android.intent.action.SENDTO", targetUri) : new Intent("android.intent.action.VIEW", targetUri);
        try {
            intent.addFlags(0x10000000);
            context.startActivity(intent);
        }
        catch (ActivityNotFoundException e) {
            Logger.INTERNAL("intercomsdk-deep-linking-error", "No activity found to handle that link");
        }
    }

    public static Uri getTargetUriFromTrackingUrl(String trackingUrl) {
        Uri uri = Uri.parse((String)trackingUrl);
        String queryUrl = uri.isHierarchical() ? uri.getQueryParameter("url") : trackingUrl;
        String targetUrl = queryUrl == null ? trackingUrl : queryUrl;
        uri = Uri.parse((String)targetUrl);
        if (uri.getScheme() == null) {
            uri = Uri.parse((String)("http://" + targetUrl));
        }
        return uri;
    }
}

