/*
 * Decompiled with CFR 0.152.
 */
package io.intercom.android.sdk.activities;

import android.annotation.TargetApi;
import android.app.Activity;
import android.app.Fragment;
import android.app.FragmentTransaction;
import android.content.ComponentName;
import android.content.Context;
import android.content.Intent;
import android.content.ServiceConnection;
import android.os.Bundle;
import android.os.IBinder;
import com.squareup.otto.Subscribe;
import io.intercom.android.sdk.Bridge;
import io.intercom.android.sdk.Inbox.ConversationsListFragment;
import io.intercom.android.sdk.R;
import io.intercom.android.sdk.chathead.NotificationsService;
import io.intercom.android.sdk.fragment.ConversationFragment;
import io.intercom.android.sdk.fragment.SmallAnnouncementFragment;
import io.intercom.android.sdk.interfaces.OnConversationClickListener;
import io.intercom.android.sdk.interfaces.OnConversationInteractionListener;
import io.intercom.android.sdk.interfaces.OnSmallAnnouncementInteractionListener;
import io.intercom.android.sdk.logger.Logger;
import io.intercom.android.sdk.models.APIModels.Conversation;
import io.intercom.android.sdk.models.Events.CloseIAMEvent;

@TargetApi(value=15)
public class MainActivity
extends Activity
implements OnConversationClickListener,
OnConversationInteractionListener,
OnSmallAnnouncementInteractionListener {
    private static final String TAG_SMALL_ANNOUNCEMENT = "smallAnnouncementTag";
    private static final String TAG_INBOX = "inboxTag";
    private static final String TAG_CONVERSATION = "conversationTag";
    private IntercomServiceConnection mConnection;
    private boolean mBound;

    protected void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        this.setContentView(R.layout.intercomsdk_activity_main);
        Bridge.init(this.getApplicationContext());
        this.getFragmentManager().executePendingTransactions();
        this.initializeSDK();
        this.mConnection = new IntercomServiceConnection();
        this.mBound = false;
        Bridge.getBus().register((Object)this);
    }

    protected void onStart() {
        super.onStart();
        if (!this.mBound) {
            Intent bindServiceIntent = new Intent((Context)this, NotificationsService.class);
            this.bindService(bindServiceIntent, this.mConnection, 1);
            this.mBound = true;
        }
    }

    protected void onStop() {
        super.onStop();
        if (this.mBound) {
            this.unbindService(this.mConnection);
            this.mBound = false;
        }
    }

    private void initializeSDK() {
        Bundle data = this.getIntent().getExtras();
        Conversation conversation = new Conversation();
        boolean shouldShowInbox = false;
        boolean isRead = false;
        int unreadCount = 0;
        if (data != null) {
            if (data.containsKey("intercomsdk-unreadCount")) {
                unreadCount = data.getInt("intercomsdk-unreadCount");
            }
            if (data.containsKey("intercomsdk-isRead")) {
                isRead = data.getBoolean("intercomsdk-isRead", false);
            }
            if (data.containsKey("CreateConversation")) {
                conversation = (Conversation)data.getParcelable("CreateConversation");
            }
            if (data.containsKey("showInbox")) {
                shouldShowInbox = data.getBoolean("showInbox");
            }
        }
        this.displaySDK(shouldShowInbox, conversation, unreadCount, isRead);
    }

    private void displaySDK(boolean shouldShowInbox, Conversation conversation, int unreadCount, boolean isRead) {
        if (this.checkIfSmallAnnouncement(conversation)) {
            this.displayFragment(SmallAnnouncementFragment.newInstance(conversation.getId(), conversation.getLastPart()), TAG_SMALL_ANNOUNCEMENT, false);
        } else if (shouldShowInbox) {
            this.displayFragment(ConversationsListFragment.getInstance(), TAG_INBOX, false);
        } else {
            this.displayFragment(ConversationFragment.newInstance(conversation.getId(), unreadCount, isRead), TAG_CONVERSATION, false);
        }
    }

    private boolean checkIfSmallAnnouncement(Conversation conversation) {
        return "small-announcement".equals(conversation.getLastPart().getMessageStyle());
    }

    private void displayFragment(Fragment frag, String tag, boolean addToBackStack) {
        Logger.INTERNAL("frag", "displaying " + frag);
        FragmentTransaction transaction = this.getFragmentManager().beginTransaction();
        transaction.replace(R.id.content_fragment, frag, tag);
        if (addToBackStack) {
            Logger.INTERNAL("frag", "adding " + frag + " to the back stack");
            transaction.addToBackStack(null);
        }
        transaction.commit();
    }

    public void onBackPressed() {
        Logger.INTERNAL("frag", "back pressed");
        super.onBackPressed();
        this.overridePendingTransition(0, R.anim.intercomsdk_slide_down);
    }

    @Override
    public void loadConversation(String conversationId, int unreadCount, boolean isRead) {
        this.displayFragment(ConversationFragment.newInstance(conversationId, unreadCount, isRead), TAG_CONVERSATION, true);
    }

    @Override
    public void loadInbox() {
        this.displayFragment(ConversationsListFragment.getInstance(), TAG_INBOX, false);
    }

    @Override
    public void transitionToConversation(String conversationId) {
        this.displayFragment(ConversationFragment.newInstance(conversationId, 0, true), TAG_CONVERSATION, false);
    }

    @Subscribe
    public void closeSDK(CloseIAMEvent event) {
        this.finish();
    }

    private class IntercomServiceConnection
    implements ServiceConnection {
        private IntercomServiceConnection() {
        }

        public void onServiceConnected(ComponentName name, IBinder service) {
        }

        public void onServiceDisconnected(ComponentName name) {
        }
    }
}

